/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.sa.SchedulerThreadPoolExecutor;
import com.blixx.sa.ThreadGroup;
import com.blixx.server.AgentHB;
import com.blixx.shared.BM;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Scheduler
implements Runnable {
    private final AtomicBoolean m_isActive = new AtomicBoolean(true);
    private final AtomicBoolean m_isRunning = new AtomicBoolean(true);
    private AtomicBoolean m_isStopped = null;
    private final ThreadGroup serverInternal = new ThreadGroup("Other");
    private final SortedMap<String, SchedulerTask> tasks = Collections.synchronizedSortedMap(new TreeMap());
    private final Map<String, String> taskMap = new ConcurrentHashMap<String, String>();
    private final Object lock = new Object();
    private ThreadPoolExecutor executorForNonHeartbeats = new SchedulerThreadPoolExecutor(2, 20, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final ExecutorService hbExecutor = Executors.newVirtualThreadPerTaskExecutor();
    public Long systemTimeForTests = null;

    public Scheduler() {
    }

    public Scheduler(int maxAllowed) {
        this();
        this.serverInternal.setMaximum(500);
    }

    public boolean hasTask(String name) {
        boolean isExist = false;
        String curentKey = this.taskMap.get(name);
        if (curentKey != null) {
            isExist = this.tasks.containsKey(curentKey);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(SchedulerTask task) {
        int type = task.getIntervalObj().m_type.get();
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        cal.setTimeInMillis(this.getCurrentMilliseconds());
        boolean isDLT = tz.inDaylightTime(cal.getTime());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                cal.set(11, 0);
                break;
            }
            case 3: {
                cal.set(11, 0);
                cal.set(7, 2);
                break;
            }
            case 5: {
                cal.set(11, 0);
                cal.set(5, 1);
                break;
            }
        }
        boolean isDLT_2 = tz.inDaylightTime(cal.getTime());
        cal.add(13, task.getIntervalObj().getShiftSeconds());
        if (isDLT != isDLT_2) {
            if (isDLT_2) {
                cal.add(12, 60);
                isDLT_2 = false;
            } else {
                cal.add(12, -60);
                isDLT_2 = true;
            }
        }
        boolean isDLTplanned = tz.inDaylightTime(cal.getTime());
        this.setThreadGroup(task);
        long firstStart = cal.getTimeInMillis();
        while (firstStart < this.getCurrentMilliseconds()) {
            cal.setTimeInMillis(firstStart += task.getInterval());
            isDLTplanned = tz.inDaylightTime(cal.getTime());
        }
        if (type != 1 && isDLT_2 != isDLTplanned) {
            firstStart = !isDLTplanned ? (firstStart += 3600000L) : (firstStart -= 3600000L);
        }
        this.putTask(task, task.getInterval(), firstStart);
        if (RTLogger.getCurrentLevel() >= 3) {
            String msg = "Added new fixed time task " + String.valueOf(task) + " to the Scheduler, next run: " + String.valueOf(new Date(firstStart)) + " type=" + type;
            RTLogger.print(3, msg);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.notifyAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(SchedulerTask task, long vTime) {
        if (task.getIntervalObj().getType() != 0) {
            this.addTask(task);
        } else {
            long nextRun;
            long interval = task.getInterval();
            if (interval == 0L && vTime == 0L) {
                if (RTLogger.getCurrentLevel() >= 3) {
                    String msgT = String.valueOf(task) + " was not scheduled. Interval=" + interval;
                    RTLogger.print(3, msgT);
                }
                return;
            }
            if (vTime == 0L) {
                nextRun = this.getCurrentMilliseconds() + interval + 10L * (long)this.taskMap.size();
                if (RTLogger.getCurrentLevel() >= 3) {
                    Date d = new Date(nextRun);
                    String msg = "Add new " + String.valueOf(task) + " to the Scheduler, next run: " + BM.m_sdf.format(d) + ". Tasks: " + this.taskMap.size();
                    RTLogger.print(3, msg);
                }
            } else {
                for (nextRun = vTime + interval; nextRun < this.getCurrentMilliseconds(); nextRun += interval) {
                }
            }
            this.setThreadGroup(task);
            this.putTask(task, interval, nextRun);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.notifyAll();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void setThreadGroup(SchedulerTask task) {
        task.setThreadGroup(this.serverInternal);
    }

    public long getNextRunScheduled(String taskName) {
        String key = this.taskMap.get(taskName);
        if (key == null) {
            return 0L;
        }
        long res = -1L;
        try {
            res = Long.parseLong(key.substring(0, key.indexOf(95)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    private void putTask(SchedulerTask task, long interval, long nextRun) {
        String checkOldKey;
        if (interval > 0L) {
            task.clearStopFlag();
        }
        if ((checkOldKey = this.taskMap.get(task.getName())) != null) {
            this.tasks.remove(checkOldKey);
        }
        String key = nextRun + "_" + task.getName();
        this.tasks.put(key, task);
        this.taskMap.put(task.getName(), key);
        if (RTLogger.getCurrentLevel() > 6) {
            String msg = "next turn for " + task.getName() + " Interval=" + interval + " : " + String.valueOf(new Date(nextRun));
            RTLogger.print(9, msg);
        }
    }

    public boolean removeTask(String ID) {
        String currentKey = this.taskMap.remove(ID);
        if (currentKey == null) {
            return true;
        }
        SchedulerTask task = (SchedulerTask)this.tasks.remove(currentKey);
        if (task == null) {
            return true;
        }
        if (task.stopTask()) {
            RTLogger.print(3, "Task " + task.getName() + " was stopped.");
        } else {
            RTLogger.print(2, "Unable to stop task:" + task.getName());
        }
        if (RTLogger.getCurrentLevel() >= 3) {
            String msg = String.valueOf(task) + " was removed from Scheduler. Tasks: " + this.taskMap.size();
            RTLogger.print(3, msg);
        }
        return true;
    }

    public SchedulerTask getTask(String ID) {
        String currentKey = this.taskMap.get(ID);
        if (currentKey == null) {
            return null;
        }
        return (SchedulerTask)this.tasks.get(currentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_isStopped = new AtomicBoolean(false);
            this.m_isRunning.set(true);
            while (this.m_isRunning.get()) {
                String key;
                if (this.tasks.isEmpty()) {
                    this.wait(1000);
                    continue;
                }
                try {
                    key = this.tasks.firstKey();
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
                long first = Long.parseLong(key.substring(0, key.indexOf("_")));
                long deltaCurrent = first - this.getCurrentMilliseconds();
                if (deltaCurrent > 1L) {
                    this.wait(1000);
                    continue;
                }
                SchedulerTask task = (SchedulerTask)this.tasks.get(key);
                if (task == null || !this.taskMap.containsKey(task.getName())) {
                    this.tasks.remove(key);
                    continue;
                }
                if (task.isStopped() || task.getInterval() <= 0L) {
                    if (task.getInterval() == 0L) {
                        try {
                            this.runTask(task);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.removeTask(task.getName());
                    continue;
                }
                if (task.isRunning()) {
                    if (!task.iCanRunLongerThanScheduleInterval() && RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, String.valueOf(task) + " is busy. This turn skipped.");
                    }
                    this.tasks.remove(key);
                    this.addTask(task, first);
                    continue;
                }
                try {
                    this.runTask(task);
                    this.tasks.remove(key);
                    this.addTask(task, first);
                }
                catch (OutOfMemoryError e) {
                    RTLogger.print(2, "", e);
                    this.tasks.remove(key);
                    this.addTask(task, first);
                }
                catch (NoMoreSlots e) {
                    RTLogger.print(4, e.getMessage());
                    this.tasks.remove(key);
                    this.addTask(task, first + 33L);
                }
                catch (Throwable e) {
                    RTLogger.print(5, "", e);
                    this.tasks.remove(key);
                    this.addTask(task, first);
                }
            }
        }
        catch (Throwable tr) {
            if (this.m_isRunning.get()) {
                RTLogger.print(1, "Unexpected stop of Scheduler.", tr);
            }
        }
        finally {
            if (this.m_isStopped == null) {
                new AtomicBoolean(true);
            } else {
                this.m_isStopped.compareAndSet(false, true);
            }
            RTLogger.print(2, "Scheduler stopped");
        }
    }

    private void runTask(SchedulerTask task) {
        int tries;
        if (!this.m_isActive.get()) {
            return;
        }
        for (tries = 0; tries < 4 && this.serverInternal.getActiveCount() > this.serverInternal.getMaximum(); ++tries) {
            this.wait(100);
        }
        if (tries == 4) {
            throw new NoMoreSlots("All slots are busy. Maximum number of running processes: " + this.serverInternal.getMaximum());
        }
        boolean started = false;
        do {
            try {
                if (task instanceof AgentHB) {
                    this.hbExecutor.execute(task);
                } else {
                    this.executorForNonHeartbeats.execute(task);
                }
                started = true;
            }
            catch (RejectedExecutionException e) {
                this.wait(10);
            }
        } while (!started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(int timeoutMillis) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeoutMillis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void refresh() {
        ArrayList<SchedulerTask> tasks = new ArrayList<SchedulerTask>(this.tasks.values());
        for (SchedulerTask task : tasks) {
            task.refresh();
        }
    }

    public boolean isStopped() {
        return this.m_isStopped == null || this.m_isStopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScheduler() {
        this.m_isRunning.compareAndSet(true, false);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.notifyAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        while (!this.isStopped()) {
            this.wait(10);
        }
        RTLogger.print(2, "Scheduler main thread is stopped. Start stopping tasks...");
        while (!this.tasks.isEmpty()) {
            String key = this.tasks.firstKey();
            SchedulerTask task = (SchedulerTask)this.tasks.get(key);
            if (task.stopTask()) {
                RTLogger.print(2, "Task {" + task.getName() + "} was stopped by Scheduler.");
            } else {
                RTLogger.print(3, "Task {" + task.getName() + "} wasn't stopped by Scheduler.");
            }
            this.tasks.remove(key);
        }
        this.executorForNonHeartbeats.shutdownNow();
        RTLogger.print(2, "Scheduler stopped.");
    }

    public void clean() {
        this.taskMap.clear();
        this.tasks.clear();
    }

    public int getSize() {
        return this.taskMap.size();
    }

    public long getCurrentMilliseconds() {
        return this.systemTimeForTests == null ? System.currentTimeMillis() : this.systemTimeForTests;
    }

    public String toString() {
        return "Scheduler";
    }

    public void deactivate() {
        if (this.m_isActive.compareAndSet(true, false)) {
            RTLogger.print(1, "Scheduler is deactivated");
        }
    }

    public void activate() {
        if (this.m_isActive.compareAndSet(false, true)) {
            if (this.executorForNonHeartbeats == null || this.executorForNonHeartbeats.isTerminated()) {
                this.executorForNonHeartbeats = new SchedulerThreadPoolExecutor(0, 20, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            }
            RTLogger.print(1, "Scheduler is activated");
        }
    }

    public static class NoMoreSlots
    extends RuntimeException {
        public NoMoreSlots(String message) {
            super(message);
        }
    }
}

