/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.sa.ThreadGroup;
import com.blixx.shared.Cryptor;
import com.blixx.shared.Interval;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SchedulerTask
implements Runnable {
    public static final String BMMON_TRIGGER_start = "<$BOOMMON_TRIGGER(";
    public static final String BMMON_STOPPER_start = "<$BOOMMON_STOPPER(";
    public static final String BMMON_ONINIT_start = "<$BOOMMON_ONINIT(";
    public static final String BMMON_ONSTART_start = "<$BOOMMON_ONSTART(";
    public static final String BMMON_OBJECTS_start = "<$BOOMMON_OBJECTS(";
    public static final String BMMON_NODES_start = "<$BOOMMON_NODES(";
    public static final String MON_TRIGGER_start = "<$MON_TRIGGER(";
    public static final String MON_STOPPER_start = "<$MON_STOPPER(";
    public static final String MON_ONINIT_start = "<$MON_ONINIT(";
    public static final String MON_ONSTART_start = "<$MON_ONSTART(";
    public static final String MON_OBJECTS_start = "<$MON_OBJECTS(";
    public static final String MON_NODES_start = "<$MON_NODES(";
    public static final String FUNCTION_stop = ")>";
    public static final String TRIGGER = "trigger";
    public static final String STOPPER = "stopper";
    protected Interval m_intervalObj = Interval.getSimpleInterval(60);
    private String m_name = null;
    protected AtomicBoolean m_running = new AtomicBoolean(false);
    protected AtomicBoolean m_stopped = new AtomicBoolean(false);
    protected int m_type = 0;
    protected Map<String, String> m_stopperExec = new LinkedHashMap<String, String>(1);
    protected Map<String, String> m_triggerExec = new LinkedHashMap<String, String>(1);
    protected Map<String, String> m_onInitExec = new LinkedHashMap<String, String>(1);
    protected Map<String, String> m_onStartExec = new LinkedHashMap<String, String>(1);
    protected Map<String, String[]> m_onObjects = new LinkedHashMap<String, String[]>(1);
    protected Map<String, String[]> m_onNodes = new LinkedHashMap<String, String[]>(1);
    protected long m_startTime = 0L;
    protected ThreadGroup m_threadGroup = null;

    public SchedulerTask(String taskName) {
        this.m_name = taskName;
    }

    public void setThreadGroup(ThreadGroup tgroup) {
        this.m_threadGroup = tgroup;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getInterval() {
        return this.m_intervalObj.getIntervalMilliseconds();
    }

    public Interval getIntervalObj() {
        return this.m_intervalObj;
    }

    public void setInterval(Interval interval) {
        this.m_intervalObj = interval;
    }

    public boolean isRunning() {
        return this.m_running.get();
    }

    public boolean isStopped() {
        return this.m_stopped.get();
    }

    public void clearStopFlag() {
        this.m_stopped.set(false);
    }

    private void setRunning(boolean flag) {
        if (this.m_running.compareAndSet(!flag, flag) && this.m_threadGroup != null) {
            if (flag) {
                this.m_threadGroup.registerRun(this);
            } else {
                this.m_threadGroup.registerStop(this);
            }
        }
    }

    private void setStopped(boolean flag) {
        this.m_stopped.set(flag);
    }

    @Override
    public void run() {
        if (this.isRunning()) {
            return;
        }
        try {
            this.startRun();
            this.onGetData();
        }
        catch (Throwable e) {
            RTLogger.print(5, "task abnormal exited: " + this.getName(), e);
        }
        this.stopRun();
    }

    private void startRun() {
        this.m_startTime = System.currentTimeMillis();
        this.setRunning(true);
        this.onStartRun();
    }

    private void stopRun() {
        try {
            this.onStopRun();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.setRunning(false);
        }
    }

    public abstract boolean onInit() throws Exception;

    public abstract boolean onStartRun();

    public abstract boolean onGetData();

    public abstract boolean onStopRun();

    protected abstract boolean onStopTask();

    public boolean stopTask() {
        boolean onStopFlag = this.onStopTask();
        this.setStopped(onStopFlag);
        return this.isStopped();
    }

    public abstract boolean refresh();

    public String toString() {
        return "Task name=" + this.m_name + " Interval=" + this.getInterval() + ".";
    }

    protected int getPriority() {
        return 5;
    }

    protected int fillInitStartExecs(String param) throws Exception {
        String[] arr;
        String orig;
        int res = 0;
        this.extractFunctions(param, BMMON_ONINIT_start, FUNCTION_stop, this.m_onInitExec);
        this.extractFunctions(param, MON_ONINIT_start, FUNCTION_stop, this.m_onInitExec);
        if (!this.m_onInitExec.isEmpty()) {
            res |= 1;
        }
        this.extractFunctions(param, BMMON_ONSTART_start, FUNCTION_stop, this.m_onStartExec);
        this.extractFunctions(param, MON_ONSTART_start, FUNCTION_stop, this.m_onStartExec);
        if (!this.m_onStartExec.isEmpty()) {
            res |= 2;
        }
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        this.extractFunctions(param, BMMON_OBJECTS_start, FUNCTION_stop, temp);
        this.extractFunctions(param, MON_OBJECTS_start, FUNCTION_stop, temp);
        for (Map.Entry en : temp.entrySet()) {
            orig = (String)en.getKey();
            arr = this.readURLOrSplit((String)en.getValue(), orig);
            if (arr == null) {
                throw new Exception("Misconfigured " + orig + " in the policy.");
            }
            this.m_onObjects.put(orig, arr);
        }
        if (!this.m_onObjects.isEmpty()) {
            res |= 4;
        }
        temp = new LinkedHashMap();
        this.extractFunctions(param, BMMON_NODES_start, FUNCTION_stop, temp);
        this.extractFunctions(param, MON_NODES_start, FUNCTION_stop, temp);
        for (Map.Entry en : temp.entrySet()) {
            orig = (String)en.getKey();
            arr = this.readURLOrSplit((String)en.getValue(), orig);
            if (arr == null) {
                throw new Exception("Misconfigured " + orig + " in the policy.");
            }
            this.m_onNodes.put(orig, arr);
        }
        if (!this.m_onNodes.isEmpty()) {
            res |= 8;
        }
        this.extractFunctions(param, BMMON_TRIGGER_start, FUNCTION_stop, this.m_triggerExec);
        this.extractFunctions(param, MON_TRIGGER_start, FUNCTION_stop, this.m_triggerExec);
        if (!this.m_triggerExec.isEmpty()) {
            res |= 0x10;
        }
        this.extractFunctions(param, BMMON_STOPPER_start, FUNCTION_stop, this.m_stopperExec);
        this.extractFunctions(param, MON_STOPPER_start, FUNCTION_stop, this.m_stopperExec);
        if (!this.m_stopperExec.isEmpty()) {
            res |= 0x20;
        }
        return res;
    }

    public void extractFunctions(String text, String functBegin, String funcEnd, Map<String, String> cache) {
        Matcher m = Pattern.compile(Pattern.quote(functBegin)).matcher(text);
        while (m.find()) {
            int eof = text.indexOf(funcEnd, m.end());
            if (eof == -1) continue;
            String content = text.substring(m.end(), eof);
            String orig = text.substring(m.start(), eof + funcEnd.length());
            cache.put(orig, content);
        }
    }

    protected String[] readURLOrSplit(String content, String origText) throws Exception {
        String[] arr;
        block23: {
            arr = null;
            LinkedList instances = new LinkedList();
            if (content.startsWith("file:")) {
                File f = new File(content.replace("file:", ""));
                if (!f.exists()) {
                    throw new Exception("File not found for function: " + origText);
                }
                if (f.isDirectory()) {
                    throw new Exception("Directory can't be used for function: " + origText);
                }
                if (!f.canRead()) {
                    throw new Exception("Read file: access denied. function: " + origText);
                }
                try (FileInputStream in = new FileInputStream(f);
                     InputStreamReader reader = new InputStreamReader(in);
                     BufferedReader br = new BufferedReader(reader);){
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        arr = this.splitByCommaAndTrim(line);
                        if (arr == null) continue;
                        Collections.addAll(instances, arr);
                    }
                    br.close();
                    if (!instances.isEmpty()) {
                        arr = instances.toArray(new String[0]);
                    }
                    break block23;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Error read content of the file for function: " + origText, e);
                }
            }
            arr = this.splitByCommaAndTrim(content);
        }
        return arr;
    }

    public String[] splitByCommaAndTrim(String content) {
        String[] arr = null;
        if (content != null && !content.trim().isEmpty()) {
            arr = content.split("(?<![\\\\])(?:[,\n])");
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim().replace("\\,", ",");
            }
        }
        return arr;
    }

    protected Map<String, String> getOnInitExec() {
        return this.m_onInitExec;
    }

    protected Map<String, String> getTriggerExec() {
        return this.m_triggerExec;
    }

    protected Map<String, String> getStopperExec() {
        return this.m_stopperExec;
    }

    protected Map<String, String> getOnStartExec() {
        return this.m_onStartExec;
    }

    protected String resolvePreExecs(Map<String, String> params, String origExec, String type, File workingDir) throws IOException, Exception {
        String execRes = origExec;
        int seconds = 60;
        if (TRIGGER.equals(type) || STOPPER.equals(type)) {
            seconds = 3;
        }
        for (Map.Entry<String, String> en : params.entrySet()) {
            String orig = en.getKey();
            String exec = en.getValue();
            if (exec.startsWith("$$")) {
                String decr = Cryptor.decrypt(exec.substring(2));
                execRes = execRes.replace(orig, decr);
                continue;
            }
            ExecResult er = ExecUtils.exec2(exec, workingDir, seconds);
            if (TRIGGER.equals(type) || STOPPER.equals(type)) {
                execRes = execRes.replace(orig, "");
            }
            if (er.resultCode != 0) {
                RTLogger.print(1, "Nagin monitor failed: " + this.getName() + type + " exec failed: " + er.toStringOnError());
                throw new Exception(type + " exec failed for NAGIN: " + this.getName());
            }
            RTLogger.print(4, "Nagin monitor: " + this.getName() + " Exec: " + execRes);
            execRes = execRes.replace(orig, er.getOutputSingleLine());
            RTLogger.print(4, "Nagin monitor: " + this.getName() + " new Exec: " + execRes);
        }
        return execRes;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean iCanRunLongerThanScheduleInterval() {
        return false;
    }
}

