/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa.perf;

import com.blixx.sa.perf.DDFField;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class DDFTable {
    private static final String _TIME_FIELD = "_TIME";
    public String m_tableName = null;
    public SortedMap<Integer, DDFField> m_fields = new TreeMap<Integer, DDFField>();

    public DDFTable(String className) {
        this.m_tableName = className;
        DDFField timeField = new DDFField(_TIME_FIELD, 0);
        timeField.setType(DDFField.BIGINT);
        this.m_fields.put(0, timeField);
    }

    public void addField(DDFField field) {
        if (this.m_fields.containsKey(field.getPosition())) {
            throw new RuntimeException("Duplicate position found: " + field.getName() + " pos=" + field.getPosition());
        }
        this.m_fields.put(field.getPosition(), field);
    }

    public String getFieldNames() {
        StringBuffer fields = new StringBuffer();
        Iterator<Integer> it = this.m_fields.keySet().iterator();
        while (it.hasNext()) {
            Integer i = it.next();
            DDFField field = (DDFField)this.m_fields.get(i);
            fields.append(field.getName()).append("/*").append(field.getType()).append('|').append(field.getSize()).append("*/");
            if (!it.hasNext()) continue;
            fields.append(',');
        }
        return fields.toString();
    }

    public String toString() {
        return this.m_tableName;
    }

    public static String normalizeFields(String fieldSubmitted, boolean isOracle) {
        if (isOracle) {
            fieldSubmitted = "\"" + (String)fieldSubmitted;
            fieldSubmitted = ((String)fieldSubmitted).replace(",", ",\"");
            fieldSubmitted = ((String)fieldSubmitted).replace("/*", "\" ");
            fieldSubmitted = ((String)fieldSubmitted).replace("|0*/", " DEFAULT NULL");
            fieldSubmitted = ((String)fieldSubmitted).replace("|", " (");
            fieldSubmitted = ((String)fieldSubmitted).replace("*/", ") DEFAULT NULL");
            fieldSubmitted = ((String)fieldSubmitted).replace(" BIGINT ", " NUMBER ");
            fieldSubmitted = ((String)fieldSubmitted).replace(" DOUBLE ", " NUMBER ");
        } else {
            fieldSubmitted = "`" + (String)fieldSubmitted;
            fieldSubmitted = ((String)fieldSubmitted).replace(",", ",`");
            fieldSubmitted = ((String)fieldSubmitted).replace("/*", "` ");
            fieldSubmitted = ((String)fieldSubmitted).replace("|0*/", " DEFAULT NULL");
            fieldSubmitted = ((String)fieldSubmitted).replace("|", " (");
            fieldSubmitted = ((String)fieldSubmitted).replace("*/", ") DEFAULT NULL");
        }
        return fieldSubmitted;
    }

    public boolean checkTable() {
        boolean isOK = true;
        return isOK;
    }
}

