/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa.perf;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.sa.perf.DDFTable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PerfClassParser {
    public static void main(String[] args) {
        PerfClassParser pcp = new PerfClassParser();
        try {
            DDFTable table = pcp.parseFile("perf1.spec");
            System.out.println(table);
        }
        catch (IOException e) {
            RTLogger.print(4, "", e);
        }
    }

    public DDFTable parseFile(String file) throws IOException {
        StringBuilder sb = new StringBuilder();
        Object fis = null;
        sb.append(new String(Files.readAllBytes(Paths.get(file, new String[0]))));
        String[] lines = sb.toString().split("\n");
        DDFTable table = null;
        DDFField currField = null;
        for (int i = 0; i < lines.length; ++i) {
            String currLine = lines[i].replace("\r", "").trim();
            String[] words = currLine.split("\\s+");
            if (words[0].length() == 0) {
                if (currField == null || table == null) continue;
                table.addField(currField);
                currField = null;
                continue;
            }
            if (words[0].equalsIgnoreCase("CLASS") && words.length > 1) {
                table = new DDFTable(words[1]);
                continue;
            }
            if (currLine.indexOf(61) != -1) {
                if (currField != null) continue;
                String[] fieldparts = currLine.split("=");
                currField = new DDFField(fieldparts[0].trim(), Integer.parseInt(words[2]));
                continue;
            }
            if (words.length < 2) continue;
            if (words[0].equalsIgnoreCase("BOOM_DATATYPE") || words[0].equalsIgnoreCase("DATATYPE")) {
                if (currField != null) {
                    currField.setType(words[1]);
                }
                if (!words[1].equals(DDFField.VARCHAR) || words.length < 2) continue;
                try {
                    if (currField == null) continue;
                    currField.setSize(Integer.parseInt(words[2]));
                }
                catch (NumberFormatException fieldparts) {}
                continue;
            }
            if (words[0].equalsIgnoreCase("CODA_DATATYPE") || words[1].equalsIgnoreCase("CODA_DATATYPE")) {
                String type = words[words.length - 1];
                if (!type.startsWith("UTF") && !type.startsWith("TIME")) {
                    if (currField == null) continue;
                    currField.setType(DDFField.DOUBLE);
                    continue;
                }
                if (!type.equalsIgnoreCase("TIME") || currField == null) continue;
                currField.setType(DDFField.BIGINT);
                continue;
            }
            if (words[0].equalsIgnoreCase("CODA_CATEGORYTYPE") || words[1].equalsIgnoreCase("CODA_CATEGORYTYPE")) continue;
            if (words[0].equalsIgnoreCase("TYPE") && words[1].equalsIgnoreCase("TEXT") && words[2].equalsIgnoreCase("LENGTH")) {
                if (currField != null) {
                    currField.setType(DDFField.VARCHAR);
                }
                int size = 255;
                try {
                    size = Integer.parseInt(words[3].replace(";", ""));
                    if (currField == null) continue;
                    currField.setSize(size);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!words[0].equalsIgnoreCase("PRECISION") || currField == null) continue;
            currField.setType(DDFField.DOUBLE);
        }
        if (currField != null && table != null) {
            table.addField(currField);
        }
        if (table != null) {
            table.checkTable();
        }
        return table;
    }
}

