/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.utils.BkpFile;
import com.blixx.shared.Action;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class ActionsRepository {
    public static final String ACTIONS_DIR = "actions";
    private final Path actionsDirPath;
    private final Map<String, Action> knownActions = new ConcurrentHashMap<String, Action>(500, 0.95f, 3);
    private final Map<String, List<String>> fileToActionIDsMap = new ConcurrentHashMap<String, List<String>>(500, 0.95f, 3);

    public ActionsRepository(String dir) {
        this.actionsDirPath = Paths.get(dir, new String[0]);
        this.init();
    }

    private void init() {
        try (Stream<Path> list = Files.list(this.getActionsDirectory());){
            List<Path> actionFiles = list.filter(p -> p.toFile().getName().endsWith(".act.xml")).toList();
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            actionFiles.forEach(act -> this.loadFromFile(factory, act.toFile()));
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().warn("Error loading actions. Dir: {}", (Object)this.actionsDirPath, (Object)e);
        }
    }

    private void loadFromFile(XMLFactory factory, File file) {
        if (file.getName().endsWith(".act.xml")) {
            try {
                String filename = file.getName();
                String groupName = filename.replace(".act.xml", "");
                GroupTreeObject currentGroup = new GroupTreeObject(new TreeObject(groupName, "", null));
                ArrayList actionIds = new ArrayList();
                if (!this.fileToActionIDsMap.containsKey(filename)) {
                    this.fileToActionIDsMap.put(filename, actionIds);
                } else {
                    actionIds = (ArrayList)this.fileToActionIDsMap.get(filename);
                }
                List<Properties> actionPropList = factory.loadFile(file);
                actionIds.ensureCapacity(actionPropList.size());
                for (Properties p : actionPropList) {
                    Action a = new Action(p);
                    this.knownActions.put(a.m_ID, a);
                    actionIds.add(a.m_ID);
                    TreeObject to = new TreeObject(a.m_label, "act", a);
                    GroupTreeObjectLast gtol = new GroupTreeObjectLast(to, null, null);
                    try {
                        currentGroup.addElementNoSorting(gtol);
                    }
                    catch (Throwable e) {
                        RTLogger.print(3, "Error processing Action: " + a.m_label, e);
                    }
                }
                if (UserManager.getInstance().getActionID(filename) == -1) {
                    UserManager.getInstance().addAction(filename, true);
                }
            }
            catch (Throwable e) {
                RTLogger.print(2, "Error loading actions file: " + file.getName(), e);
            }
        }
    }

    public Path getActionsDirectory() {
        return this.actionsDirPath;
    }

    public Set<String> getFileNames() {
        return new HashSet<String>(this.fileToActionIDsMap.keySet());
    }

    public Iterator<String> getFilesIterator() {
        return this.fileToActionIDsMap.keySet().iterator();
    }

    public GroupTreeObject getTree() {
        return this.getTree("PRIMARY_SERVER");
    }

    @Deprecated
    public GroupTreeObject getTree2(String user) {
        GroupTreeObject actions = new GroupTreeObject(new TreeObject("Actions", "", null));
        Iterator<String> it = this.getFilesIterator();
        while (it.hasNext()) {
            String filename = it.next();
            int id = UserManager.getInstance().getActionID(filename);
            if (UserManager.getInstance().getRights(id, user) <= 1) continue;
            String groupName = filename.replace(".act.xml", "");
            GroupTreeObject currentGroup = new GroupTreeObject(new TreeObject(groupName, "", null));
            actions.addElement(currentGroup);
            List<String> actionsID = this.fileToActionIDsMap.get(filename);
            for (String actID : actionsID) {
                Action a = this.knownActions.get(actID);
                TreeObject to = new TreeObject(a.m_label, "act", a);
                GroupTreeObjectLast gtol = new GroupTreeObjectLast(to, null, null);
                currentGroup.addElement(gtol);
            }
        }
        return actions;
    }

    public GroupTreeObject getTree(String user) {
        GroupTreeObject actions = new GroupTreeObject(new TreeObject("Actions", "", null));
        this.fileToActionIDsMap.entrySet().stream().filter(en -> UserManager.getInstance().getRights(UserManager.getInstance().getActionID((String)en.getKey()), user) > 1).forEach(en -> {
            GroupTreeObject currentGroup = new GroupTreeObject(new TreeObject(((String)en.getKey()).replace(".act.xml", ""), "", null));
            actions.addElement(currentGroup);
            ((List)en.getValue()).forEach(actID -> {
                Action a = this.knownActions.get(actID);
                currentGroup.addElement(new GroupTreeObjectLast(new TreeObject(a.m_label, "act", a), null, null));
            });
        });
        return actions;
    }

    public void removeAction(String id) {
        this.knownActions.remove(id);
        for (String filename : this.fileToActionIDsMap.keySet()) {
            ArrayList actionIDs = (ArrayList)this.fileToActionIDsMap.get(filename);
            if (!actionIDs.contains(id)) continue;
            actionIDs.remove(id);
            ArrayList<Action> toStore = new ArrayList<Action>();
            for (String actionID : actionIDs) {
                Action a = this.knownActions.get(actionID);
                if (a == null) continue;
                toStore.add(a);
            }
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            factory.storeFile(this.getActionsDirectory().resolve(filename).toAbsolutePath().toString(), toStore);
            break;
        }
        this.notifyUI();
    }

    public void removeGroup(String name) {
        if (!((String)name).endsWith(".act.xml")) {
            name = (String)name + ".act.xml";
        }
        if (this.fileToActionIDsMap.containsKey(name)) {
            ArrayList actionIDs = (ArrayList)this.fileToActionIDsMap.get(name);
            for (String actionID : actionIDs) {
                this.knownActions.remove(actionID);
            }
            this.fileToActionIDsMap.remove(name);
            File f = this.getActionsDirectory().resolve((String)name).toFile();
            BkpFile.move(f);
            if (f.exists()) {
                if (!f.delete()) {
                    RTLogger.print(5, "Can't delete file " + f.getName());
                } else {
                    UserManager.getInstance().deleteActionItem((String)name);
                    RTLogger.print(5, "Action file " + f.getName() + " deleted");
                }
            } else {
                UserManager.getInstance().deleteActionItem((String)name);
            }
        }
        this.notifyUI();
    }

    public boolean renameGroup(String oldName, String newName) {
        File f;
        int exist;
        boolean isOK = false;
        if (!((String)oldName).endsWith(".act.xml")) {
            oldName = (String)oldName + ".act.xml";
        }
        if (!((String)newName).endsWith(".act.xml")) {
            newName = (String)newName + ".act.xml";
        }
        if ((exist = UserManager.getInstance().getActionID((String)newName)) != -1) {
            throw new RuntimeException("Operation denied");
        }
        if (this.fileToActionIDsMap.containsKey(oldName)) {
            ArrayList actionIDs = (ArrayList)this.fileToActionIDsMap.get(oldName);
            if (actionIDs != null) {
                this.fileToActionIDsMap.put((String)newName, actionIDs);
            }
            this.fileToActionIDsMap.remove(oldName);
        }
        if (!(f = this.getActionsDirectory().resolve((String)oldName).toFile()).renameTo(this.getActionsDirectory().resolve((String)newName).toFile())) {
            RTLogger.print(5, "Can't rename file " + f.getName());
            ArrayList actionIDs = (ArrayList)this.fileToActionIDsMap.get(newName);
            if (actionIDs != null) {
                this.fileToActionIDsMap.put((String)oldName, actionIDs);
            }
        } else {
            UserManager.getInstance().renameActionItem((String)oldName, (String)newName);
            RTLogger.print(5, "Action file " + String.valueOf(this.getActionsDirectory().resolve((String)oldName)) + " renamed to " + String.valueOf(this.getActionsDirectory().resolve((String)newName)));
            isOK = true;
        }
        this.notifyUI();
        return isOK;
    }

    public void addGroup(String group) {
        int exist;
        if (!((String)group).endsWith(".act.xml")) {
            group = (String)group + ".act.xml";
        }
        if ((exist = UserManager.getInstance().getActionID((String)group)) != -1) {
            throw new RuntimeException("Operation denied");
        }
        ArrayList empty = new ArrayList();
        XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
        Path actFilePath = this.getActionsDirectory().resolve((String)group);
        File newActionFile = actFilePath.toFile();
        try {
            if (newActionFile.createNewFile()) {
                factory.storeFile(actFilePath.toAbsolutePath().toString(), empty);
                this.fileToActionIDsMap.put((String)group, empty);
                UserManager.getInstance().addAction((String)group, true);
            }
        }
        catch (Exception e) {
            RTLogger.print(3, "", e);
        }
        this.notifyUI();
    }

    public void moveAction(String id, String newGroup) {
        Action a = this.knownActions.get(id);
        this.removeAction(id);
        this.updateAction(a, newGroup);
    }

    public void updateAction(Action act, String group) {
        Object filename = group;
        if (!((String)filename).endsWith(".act.xml")) {
            filename = (String)filename + ".act.xml";
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.fileToActionIDsMap.containsKey(filename)) {
            ArrayList actionIDs = (ArrayList)this.fileToActionIDsMap.get(filename);
            boolean replaced = false;
            actions.ensureCapacity(actionIDs.size() + 1);
            for (String old : actionIDs) {
                if (old.equals(act.m_ID)) {
                    actions.add(act);
                    replaced = true;
                    RTLogger.print(5, "Action replaced");
                    continue;
                }
                Action a = this.knownActions.get(old);
                if (a != null) {
                    actions.add(a);
                    continue;
                }
                this.knownActions.remove(old);
                actionIDs.remove(old);
            }
            if (!replaced) {
                actions.add(act);
            }
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            factory.storeFile(this.getActionsDirectory().resolve((String)filename).toAbsolutePath().toString(), actions);
            this.knownActions.put(act.m_ID, act);
            if (!actionIDs.contains(act.m_ID)) {
                actionIDs.add(act.m_ID);
            }
            RTLogger.print(5, "Action saved: " + act.m_label);
        } else {
            ArrayList<Action> al = new ArrayList<Action>(1);
            al.add(act);
            XMLFactory factory = new XMLFactory("ACTIONS", "ACTION");
            factory.storeFile(this.getActionsDirectory().resolve((String)filename).toAbsolutePath().toString(), al);
            this.knownActions.put(act.m_ID, act);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(act.m_ID);
            this.fileToActionIDsMap.put((String)filename, ids);
            RTLogger.print(5, "New action saved: " + act.m_label);
            try {
                UserManager.getInstance().addAction((String)filename, true);
            }
            catch (Exception e) {
                RTLogger.print(3, "", e);
            }
        }
        this.notifyUI();
    }

    public void notifyUI() {
        ServerEngine.getInstance().getEventsRouter().getClientProxyMgr().addPendingToALL(new CMD("GETACTIONS"));
    }
}

