/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.FA;
import com.blixx.server.AgentHB;
import com.blixx.server.DeployClient;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.NullAgentID;
import com.blixx.server.ReadFAs;
import com.blixx.server.ReadMessages;
import com.blixx.server.ReadMonitorValues;
import com.blixx.server.ReadPerf;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.RemoteInventoryAction;
import com.blixx.server.SMessage;
import com.blixx.server.Server;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerThreadPool;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Assignment;
import com.blixx.shared.IHeartbeatAccess;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.NameValue;
import com.boom.AgentInfo;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentCard
extends AbstractAgentCard
implements IHeartbeatAccess {
    public static final String ENABLE = "ENABLE";
    public static final String BOOM_AGENT_ENABLE_AGENT = "BOOM_AGENT ENABLE_AGENT";
    public static final String DISABLE = "DISABLE";
    public static final String BOOM_AGENT_DISABLE_AGENT = "BOOM_AGENT DISABLE_AGENT";
    public static final String BOOM_AGENT_ENABLE_TLS = "BOOM_AGENT ENABLE_AGENT_TLS";
    public static final String BOOM_AGENT_DISABLE_TLS = "BOOM_AGENT DISABLE_AGENT_TLS";
    public static final String BOOM_AGENT_STATUS = "BOOM_AGENT STATUS";
    protected AtomicInteger m_protocolUsed = new AtomicInteger(1);
    public final Map<IRemoteProcessing, Long> m_pending = Collections.synchronizedMap(new LinkedHashMap());
    public Map<String, String> m_assignedMonitorPolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public Map<String, String> m_assignedMessagePolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public Map<String, String> m_disabledPolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public long m_lastTimeUpdatedFromAgent = 0L;
    protected LinkedBlockingQueue<DeployClient> m_queue = new LinkedBlockingQueue();
    public DeployClient m_deploymentTask = null;
    private long m_lastTimeOnline = 0L;
    private long m_lastTimeOnlineFromServer = 0L;
    private AgentInventoryCard m_InventoryCard = null;
    private final AtomicBoolean m_AgentAllowsToSend = new AtomicBoolean(true);
    private final AtomicBoolean m_AgentAllowsToSendPERF = new AtomicBoolean(true);
    public String m_lastSpiDirDigest = null;
    public String m_lastSyncReport = null;
    public List<String> m_binpackagesUnsync = new LinkedList<String>();
    public List<String> m_monToUndeploy = new LinkedList<String>();
    public List<String> m_monToDeploy = new LinkedList<String>();
    public List<String> m_msgToUndeploy = new LinkedList<String>();
    public List<String> m_msgToDeploy = new LinkedList<String>();
    public WeakHashMap<SEventFwd, String> m_lastMonitorProcessedIDs = new WeakHashMap();
    public WeakHashMap<SEventFwd, String> m_lastMessageProcessedIDs = new WeakHashMap();
    public boolean m_isAgentDetailsNecessary = true;
    public boolean isRemoteActionRunningOnFirewalled = false;
    public String csr = null;
    private long lastPingFromAgentTimestamp = 0L;
    private long askAgentDetailsLast = 0L;
    private boolean isIPPPreferred = false;
    private boolean offlineSent = false;
    private boolean onlineSent = false;
    private boolean isReassigned = false;
    private static final String PERF_FIELDS = "_TIME/*BIGINT|20*/,BOOMAGENTID/*VARCHAR|50*/,HOSTNAME/*VARCHAR|255*/,STATUS/*DOUBLE|0*/";
    public Double m_statusLastStored = null;
    private static final Pattern IP4PATTERN = Pattern.compile("[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]+");
    private static final Pattern IP6PATTERN = Pattern.compile(".*:.*");

    public static AgentCard getDummyInstance(String ip) {
        AgentCard ac = new AgentCard(ip);
        ac.m_agentID = UUID.randomUUID().toString();
        return ac;
    }

    public AgentCard() {
    }

    public AgentCard(String host, String ip, String label, String description) {
        this(null, host, ip, label, description);
    }

    public AgentCard(String uuid, String host, String ip, String label, String description) {
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }
        this.m_agentID = uuid;
        this.m_port = 0;
        this.m_hostname = host == null ? "" : host;
        this.m_hostIP = ip == null ? "" : ip;
        this.m_label = label == null ? this.m_hostname : label;
        this.m_desc = description == null ? "" : description;
        this.m_os = "_External";
        this.setModeSilently(1);
    }

    AgentCard(String ip) {
        this.setHost(ip);
        this.setIP(ip);
        this.m_desc = "";
        this.m_label = this.getAgentHost();
        this.m_approved = true;
        this.m_disabled = false;
        this.m_agentID = UUID.randomUUID().toString();
        this.m_port = ServerEngine.getInstance().getServerProps().getAgentPort();
        int split = ip.lastIndexOf(58);
        boolean validIP = false;
        try {
            InetAddress.getByName(ip);
            validIP = true;
            this.setIP(InetAddress.getByName(ip).getHostAddress());
            this.setHostName(InetAddress.getByName(ip).getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (split != -1 && !validIP) {
            try {
                String port = ip.substring(split + 1);
                this.m_port = Integer.parseInt(port);
                String ipWithoutPort = ip.substring(0, split);
                if (ipWithoutPort.startsWith("[") && ipWithoutPort.endsWith("]")) {
                    ipWithoutPort = ipWithoutPort.substring(1, ipWithoutPort.length() - 1);
                }
                String nameResolved = null;
                try {
                    nameResolved = InetAddress.getByName(ipWithoutPort).getHostName();
                }
                catch (UnknownHostException ignored) {
                    RTLogger.print(6, "AgentCard: error resolving hostname for IP: " + ipWithoutPort);
                }
                this.setIP(ipWithoutPort);
                this.setHostName(ipWithoutPort);
                if (nameResolved != null) {
                    this.setHostName(nameResolved);
                    this.setIP(InetAddress.getByName(ipWithoutPort).getHostAddress());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.getAgentPort() > 0) {
            this.m_os = "Connecting...";
            this.setModeSilently(3);
            if (!this.getAgentInventoryCard().isDiscovered()) {
                this.triggerInventory();
            }
        } else {
            this.m_os = "_External";
            this.setModeSilently(1);
            this.setSingleFlagOFF(64);
        }
    }

    public AgentCard(Map<String, Object> m) {
        this.m_port = ServerEngine.getInstance().getServerProps().getAgentPort();
        Object port = m.get("PORT");
        if (port != null && !port.toString().isEmpty()) {
            try {
                this.m_port = Integer.parseInt(String.valueOf(port));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_hostname = (String)m.get("HOSTNAME");
        this.m_agentID = (String)m.get("ID");
        this.m_hostIP = (String)m.get("IP");
        int combinedModeAndFlags = Integer.parseInt(String.valueOf(m.get("MODE")));
        int tmode = combinedModeAndFlags & 0xF;
        this.m_agentFlags = combinedModeAndFlags & 0xFFF0;
        if (tmode >= 7) {
            this.setModeSilently(8);
        } else {
            this.setModeSilently(0);
        }
        this.m_desc = (String)m.get("DESCRIPTION");
        if (this.m_desc == null) {
            this.m_desc = "";
        }
        this.m_label = (String)m.get("LABEL");
        if (this.m_label == null) {
            this.m_label = "";
        }
        if (ServerEngine.getInstance().getServerProps().isUseAgentShortLabels()) {
            String shl = AgentCard.getShortName(this.m_hostname);
            this.m_label = this.m_label.isEmpty() ? shl : this.m_label.replace(this.m_hostname, shl);
        }
        this.m_os = (String)m.get("OS");
        if (this.m_os == null) {
            this.m_os = "";
        }
        this.m_os = this.m_os.intern();
        Object o = m.get("APPROVED");
        if (!(o instanceof Boolean)) {
            int apr = 0;
            try {
                apr = Integer.parseInt(String.valueOf(m.get("APPROVED")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_approved = apr & true;
            try {
                apr = Integer.parseInt(String.valueOf(m.get("DISABLED")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setDisabled((apr & 1) == 1);
        } else {
            this.m_approved = (Boolean)m.get("APPROVED");
            this.setDisabled((Boolean)m.get("DISABLED"));
        }
        if (!this.getAgentInventoryCard().isDiscovered()) {
            this.triggerInventory();
        }
    }

    public boolean isAgentAllowsToSend() {
        return this.m_approved && this.m_AgentAllowsToSend.get();
    }

    public void setAgentAllowToSend(boolean isAllow) {
        this.m_AgentAllowsToSend.compareAndSet(!isAllow, isAllow);
    }

    public boolean isAgentAllowsToSendPERF() {
        return this.m_approved && this.m_AgentAllowsToSendPERF.get();
    }

    public void setAgentAllowToSendPERF(boolean isAllow) {
        this.m_AgentAllowsToSendPERF.compareAndSet(!isAllow, isAllow);
    }

    void setHostName(String hostname) {
        if (ServerEngine.getInstance().getServerProps().isUseAgentShortLabels()) {
            String oldShort = AgentCard.getShortName(this.m_hostname);
            String newShort = AgentCard.getShortName(hostname);
            this.m_label = this.m_label.replace(this.m_hostname, newShort);
            this.m_label = this.m_label.replace(oldShort, newShort);
        } else {
            this.m_label = this.m_label.replace(this.m_hostname, hostname);
        }
        this.m_hostname = hostname;
    }

    void setHost(String hostname) {
        this.m_hostname = hostname;
    }

    void setIP(String IP) {
        this.m_hostIP = IP;
    }

    public void setModeSilently(int modeStatus) {
        this.setDefaultMode(modeStatus);
        super.setMode(modeStatus);
    }

    public synchronized void sendAgentOnline() {
        if (this.onlineSent) {
            return;
        }
        SEventFwd sm = SMessage.createMessage(1, 1, this.m_hostname, "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "Agent is online");
        sm.setNode(this.getAgentHost());
        sm.setMonitor("Availability");
        sm.setValue(1.0);
        sm.setT1(this.getAgentID());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
        this.onlineSent = true;
        this.offlineSent = false;
        this.isReassigned = false;
    }

    public synchronized void sendAgentOffline() {
        if (this.offlineSent) {
            return;
        }
        try {
            SEventFwd sm = SMessage.createMessage(5, 1, this.m_hostname, "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "Agent is offline");
            sm.setNode(this.getAgentHost());
            sm.setMonitor("Availability");
            sm.setValue(0.0);
            sm.setT1(this.getAgentID());
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            this.offlineSent = true;
            this.onlineSent = false;
            this.isReassigned = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void sendReassigned() {
        if (this.isReassigned) {
            return;
        }
        try {
            SEventFwd sm = SMessage.createMessage(2, 1, this.m_hostname, "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "Agent has been re-assigned to another server!");
            sm.setNode(this.getAgentHost());
            sm.setMonitor("Availability");
            sm.setValue(0.0);
            sm.setT1(this.getAgentID());
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            this.isReassigned = true;
            this.offlineSent = false;
            this.onlineSent = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void sendAgentCertificateError(String text) {
        try {
            SEventFwd sm = SMessage.createMessage(5, 1, this.m_hostname, "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", text);
            sm.setNode(this.getAgentHost());
            sm.setMonitor("Availability");
            sm.setValue(0.0);
            sm.setT1(this.getAgentID());
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            this.offlineSent = true;
            this.onlineSent = false;
            this.isReassigned = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void submitAgentStatusPerf() {
        boolean isDisabled = this.isDisabled();
        Double status = isDisabled ? Double.valueOf(0.5) : Double.valueOf(1.0);
        switch (this.getMode()) {
            case 3: 
            case 7: {
                status = isDisabled ? Double.valueOf(0.5) : Double.valueOf(0.0);
                break;
            }
            case 9: {
                status = -1.0;
                break;
            }
            case 1: 
            case 8: {
                break;
            }
        }
        if (this.m_statusLastStored == null || this.m_statusLastStored.intValue() != status.intValue()) {
            try {
                String hostname = this.getAgentHost();
                if (hostname.length() > 254) {
                    hostname = hostname.substring(0, 255);
                }
                String PERF_CLASS = "AGENT_STATUS";
                ServerEngine.getInstance().getPerfSubmitter().submitValues(System.currentTimeMillis(), PERF_FIELDS, PERF_CLASS, new String[]{this.m_agentID, hostname, status.toString()});
                this.m_statusLastStored = status;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void setMode(int modeStatus) {
        boolean sendPerfRecord = false;
        if (modeStatus != this.getMode()) {
            this.setAgentDetailsNecessary(true);
            if (this.getDefaultMode() >= 7 && modeStatus < 7 && !ServerEngine.getInstance().getScheduler().hasTask(AgentHB.getName(this.getAgentID()))) {
                return;
            }
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, this.m_hostname + " from:" + this.getMode() + " to:" + modeStatus);
            }
            switch (modeStatus) {
                case 3: 
                case 7: {
                    this.sendAgentOffline();
                    sendPerfRecord = true;
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS", this.getID(), null));
                    break;
                }
                case 1: 
                case 8: {
                    this.sendAgentOnline();
                    sendPerfRecord = true;
                    ServerEngine.getInstance().ensureLicense(this);
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS", this.getID(), null));
                    break;
                }
                case 9: {
                    this.sendReassigned();
                    sendPerfRecord = true;
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS", this.getID(), null));
                    break;
                }
            }
        } else if (this.getMode() == 7) {
            this.sendAgentOffline();
            sendPerfRecord = true;
        }
        super.setMode(modeStatus);
        if (sendPerfRecord) {
            this.submitAgentStatusPerf();
        }
    }

    @Override
    public boolean pendingUpdates() {
        return !this.m_pending.isEmpty();
    }

    public boolean pendingDeployments() {
        return !this.m_queue.isEmpty();
    }

    public boolean isPendingDeployments4Firewalled() {
        return this.isFirewalled() && this.pendingDeployments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRemoteUpdates(SDataInputStream in, SDataOutputStream out) {
        try {
            out.writeUTF("*");
            ReadMonitorValues rv = new ReadMonitorValues();
            ReadMessages rm = new ReadMessages();
            try {
                in.read();
                List<SEventFwd> resMon = rv.read(in, this);
                int size = resMon.size();
                Server.startThread();
                long tstart = System.currentTimeMillis();
                try {
                    ServerEngine.getInstance().getEventsRouter().submitNewMessage(resMon, this);
                }
                finally {
                    Server.stopThread(size, System.currentTimeMillis() - tstart);
                }
                out.write(84);
                in.read();
                List<SEventFwd> resMsg = rm.read(in, this);
                int size2 = resMsg.size();
                Server.startThread();
                tstart = System.currentTimeMillis();
                try {
                    ServerEngine.getInstance().getEventsRouter().submitNewMessage(resMsg, this);
                }
                finally {
                    Server.stopThread(size2, System.currentTimeMillis() - tstart);
                }
                out.write(84);
                in.read();
                ReadFAs rfa = new ReadFAs();
                List<FA> resFA = rfa.read(in, this);
                ServerEngine.getInstance().getEventsRouter().setAlertFinished(resFA);
                out.write(84);
                in.read();
                ReadPerf rp = new ReadPerf();
                rp.readAndSubmit(in, this);
                out.write(84);
            }
            catch (RuntimeException e) {
                RTLogger.print(1, String.valueOf(this) + " Socket error: " + e.getMessage());
                RTLogger.print(5, "Socket error FRU: ", e);
            }
        }
        catch (IOException e) {
            RTLogger.print(4, "AC: " + String.valueOf(this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdates(Socket socket, SDataOutputStream out, SDataInputStream in) throws IOException {
        block20: {
            ConcurrentHashMap<IRemoteProcessing, Long> map;
            out.setVersion(this.getProtocolVersion());
            Map<IRemoteProcessing, Long> map2 = this.m_pending;
            synchronized (map2) {
                map = new ConcurrentHashMap<IRemoteProcessing, Long>(this.m_pending);
                this.m_pending.clear();
            }
            Iterator it = map.keySet().iterator();
            try {
                while (it.hasNext() || this.isPendingDeployments4Firewalled()) {
                    IRemoteProcessing task = null;
                    IRemoteProcessing iRemoteProcessing = task = it.hasNext() ? (IRemoteProcessing)it.next() : (IRemoteProcessing)this.m_queue.peek();
                    if (task == null) break;
                    task.setInputOutput(in, out);
                    try {
                        if (this.isFirewalled()) {
                            this.isRemoteActionRunningOnFirewalled = true;
                        }
                        task.sendToFirewalled(socket);
                    }
                    finally {
                        this.isRemoteActionRunningOnFirewalled = false;
                        try {
                            it.remove();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (task instanceof DeployClient) {
                        this.m_queue.poll();
                    }
                    if (it.hasNext() || this.isPendingDeployments4Firewalled()) {
                        out.write(50);
                        if (in.read() == 51) {
                            continue;
                        }
                        break;
                    }
                    out.write(51);
                }
            }
            catch (Throwable e) {
                if (map.isEmpty()) break block20;
                Map<IRemoteProcessing, Long> map3 = this.m_pending;
                synchronized (map3) {
                    this.m_pending.putAll(map);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPending(IRemoteProcessing task) {
        if (this.isExternal()) {
            return;
        }
        Map<IRemoteProcessing, Long> map = this.m_pending;
        synchronized (map) {
            this.m_pending.put(task, System.currentTimeMillis());
        }
    }

    public void scheduleTask(RemoteCmdClient cmd) {
        this.schedule(cmd);
    }

    public void scheduleDeployClient(DeployClient dc) {
        this.schedule(dc);
    }

    private void schedule(IRemoteProcessing task) {
        if (this.isExternal()) {
            return;
        }
        if (this.getRelatedServer() != null) {
            if (task instanceof RemoteCmdClient) {
                ((RemoteCmdClient)task).forceFinish("Managed by other server", -812);
            } else if (task instanceof DeployClient) {
                DeployClient dc = (DeployClient)task;
                dc.failedToProcess(new RuntimeException("Managed by other server"));
            }
        } else {
            if (!this.isApproved() && this.m_os.contains("Connecting...")) {
                if (task instanceof DeployClient) {
                    DeployClient dc = (DeployClient)task;
                    dc.failedToProcess(new RuntimeException("Agent is not yet approved"));
                }
                return;
            }
            if (task instanceof DeployClient) {
                DeployClient dc = (DeployClient)task;
                List<NameValue<String>> assignments = dc.getAllObjects();
                for (NameValue<String> nv : assignments) {
                    Assignment asn = ServerEngine.getInstance().getAssignmentRepository().getAssignment(this.getAgentID(), nv.getName(), nv.getValue());
                    if (asn == null) continue;
                    asn.setLock(asn.getLock() + 100);
                }
                this.m_queue.offer(dc);
            } else if (this.isFirewalled()) {
                RTLogger.print(6, "Agent is firewalled. Task is added to pending queue. %s", this.m_agentID);
                this.addPending(task);
            } else if (this.getMode() != 1) {
                RTLogger.print(4, "Agent online state is not yet confirmed. %s", this.m_agentID);
                this.addPending(task);
            } else {
                this.startTask(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFirstPendingTask() {
        Map<IRemoteProcessing, Long> map = this.m_pending;
        synchronized (map) {
            Iterator<IRemoteProcessing> it = this.m_pending.keySet().iterator();
            if (it.hasNext()) {
                IRemoteProcessing task = it.next();
                this.startTask(task);
                it.remove();
            }
        }
    }

    public Map<IRemoteProcessing, Long> getPendingMap_Unsynchronized() {
        return this.m_pending;
    }

    public LinkedBlockingQueue<DeployClient> getDeploymentQueue() {
        return this.m_queue;
    }

    public void startTask(IRemoteProcessing task) {
        Thread tr = new Thread((Runnable)task, "RemoteProcessing");
        int i = 0;
        while (i < 3) {
            try {
                tr.start();
                break;
            }
            catch (Throwable e) {
                ++i;
                try {
                    Thread.sleep(333L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Map<String, String> getDeployedMonitorPolicies() throws Exception {
        if (!this.isOnline()) {
            throw new Exception("Agent is offline");
        }
        this.requestAgentPolicies();
        return this.m_assignedMonitorPolicies;
    }

    private void requestAgentPolicies() {
        RemoteCmdClient rc0 = new RemoteCmdClient('A', this, "BOOM_AGENT POLICIES", 20);
        this.scheduleTask(rc0);
        long start0 = System.currentTimeMillis();
        long hb_ms0 = 1000L * (long)(ServerProperties.getHB_Interval() + 2);
        while (!rc0.isReady() && System.currentTimeMillis() - start0 < hb_ms0) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
        boolean isNewSyntax = false;
        if (rc0.getResult().resultCode == 0) {
            String[] lines;
            this.m_assignedMonitorPolicies.clear();
            this.m_assignedMessagePolicies.clear();
            this.m_disabledPolicies.clear();
            Pattern p = Pattern.compile("\\s*(...\\S+)\\s+(.*)\\s+\\(([\\d\\.]+)\\)(.*)");
            for (String line : lines = rc0.getMessage().split("\r*\n")) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String status = m.group(1);
                String name = m.group(2);
                String ver = m.group(3);
                String typeAndOther = m.group(4);
                if (typeAndOther != null) {
                    String taot = typeAndOther.trim();
                    if (taot.startsWith("mon")) {
                        this.m_assignedMonitorPolicies.put(name, ver);
                        isNewSyntax = true;
                    } else if (taot.startsWith("msg")) {
                        this.m_assignedMessagePolicies.put(name, ver);
                        isNewSyntax = true;
                    }
                }
                if (status.charAt(0) != 'D') continue;
                this.m_disabledPolicies.put(name, status);
            }
        } else {
            this.m_assignedMonitorPolicies.clear();
            this.m_assignedMessagePolicies.clear();
            this.m_disabledPolicies.clear();
            throw new RuntimeException("Agent is offline");
        }
        if (!isNewSyntax) {
            RemoteCmdClient rc = new RemoteCmdClient('P', this, "will not be used", 0);
            this.scheduleTask(rc);
            long start = System.currentTimeMillis();
            long hb_ms = (long)(ServerProperties.getHB_Interval() + 2) * 1000L;
            while (!rc.isReady() && System.currentTimeMillis() - start < hb_ms) {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {}
            }
            if (rc.getResult().resultCode == 0) {
                this.m_lastTimeUpdatedFromAgent = System.currentTimeMillis();
            } else {
                throw new RuntimeException("Agent is offline");
            }
        }
    }

    public Map<String, String> getDeployedMessagePolicies() {
        return this.m_assignedMessagePolicies;
    }

    public Map<String, String> getDisabledPolicies() {
        return this.m_disabledPolicies;
    }

    @Override
    public boolean setDisabled(boolean disable) {
        boolean changed = super.setDisabled(disable);
        if (changed) {
            this.submitAgentStatusPerf();
        }
        return changed;
    }

    public void sendDisableAgent() {
        this.schedule(new RemoteCmdClient('C', this, DISABLE, 0));
        if (this.isExternal()) {
            this.setDisabled(true);
        }
    }

    public void sendEnableAgent() {
        this.schedule(new RemoteCmdClient('C', this, ENABLE, 0));
        if (this.isExternal()) {
            this.setDisabled(false);
        }
    }

    public void sendAgentID() {
        this.schedule(new RemoteCmdClient('C', this, "SETID=" + this.m_agentID, 0));
    }

    public RemoteCmdClient processSyncStatus() throws Exception {
        this.clearSyncBuffers();
        this.checkAssignedPolicies();
        RemoteCmdClient rcc = new RemoteCmdClient('C', this, "GETHASH=spi", 0);
        this.schedule(rcc);
        return rcc;
    }

    protected void checkAssignedPolicies() throws Exception {
        Map<Assignment, Object> asns = ServerEngine.getInstance().getAssignmentRepository().getAssignments(this.m_agentID);
        asns.putAll(ServerEngine.getInstance().getAssignmentRepository().getAssignmentsByNodeGroups(this.m_agentID));
        HashMap<CallSite, String> policyOnly = new HashMap<CallSite, String>();
        for (Assignment assignment : asns.keySet()) {
            AbstractPolicy p = null;
            if (assignment.getType().equals("mon")) {
                p = ServerEngine.getInstance().getPolicyRepository().getMonitorPolicy(assignment.getName());
            } else if (assignment.getType().equals("msg")) {
                p = ServerEngine.getInstance().getPolicyRepository().getMessagePolicy(assignment.getName());
            }
            if (p == null) continue;
            policyOnly.put((CallSite)((Object)(assignment.getName() + "|" + assignment.getType())), p.getVersion());
        }
        Map<String, String> monpol = this.getDeployedMonitorPolicies();
        Iterator<Map.Entry<String, String>> it = monpol.entrySet().iterator();
        String monSuff = "|mon";
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String polName = entry.getKey();
            String tkey = polName + monSuff;
            String ver = entry.getValue();
            String srvVer = (String)policyOnly.get(tkey);
            if (srvVer == null) {
                this.m_monToUndeploy.add(polName);
            } else if (!srvVer.equals(ver)) {
                this.m_monToDeploy.add(polName);
            }
            policyOnly.remove(tkey);
        }
        Map<String, String> msgpol = this.getDeployedMessagePolicies();
        it = msgpol.entrySet().iterator();
        String msgSuff = "|msg";
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String polName = entry.getKey();
            String tkey = polName + msgSuff;
            String ver = entry.getValue();
            String srvVer = (String)policyOnly.get(tkey);
            if (srvVer == null) {
                this.m_msgToUndeploy.add(polName);
            } else if (!srvVer.equals(ver)) {
                this.m_msgToDeploy.add(polName);
            }
            policyOnly.remove(tkey);
        }
        for (String tkey : policyOnly.keySet()) {
            String pname;
            if (tkey.endsWith(monSuff)) {
                pname = tkey.replace(monSuff, "");
                this.m_monToDeploy.add(pname);
                continue;
            }
            if (!tkey.endsWith(msgSuff)) continue;
            pname = tkey.replace(msgSuff, "");
            this.m_msgToDeploy.add(pname);
        }
    }

    public void clearSyncBuffers() {
        this.m_lastSpiDirDigest = null;
        this.m_lastSyncReport = null;
        this.m_binpackagesUnsync.clear();
        this.m_monToDeploy.clear();
        this.m_msgToDeploy.clear();
        this.m_monToUndeploy.clear();
        this.m_msgToUndeploy.clear();
    }

    public void processCommandResult(String cmd, ExecResult er) {
        switch (cmd) {
            case "GETHASH=spi": {
                this.processSpiDigest(er);
                break;
            }
            case "ENABLE": 
            case "BOOM_AGENT ENABLE_AGENT": {
                if (er.resultCode == 0 && this.setDisabled(false)) {
                    this.saveAndNotifySingleAgentChange();
                    break;
                }
                this.setAgentDetailsNecessary(true);
                break;
            }
            case "DISABLE": 
            case "BOOM_AGENT DISABLE_AGENT": {
                if (er.resultCode == 0 && this.setDisabled(true)) {
                    this.saveAndNotifySingleAgentChange();
                    break;
                }
                this.setAgentDetailsNecessary(true);
                break;
            }
            case "BOOM_AGENT STATUS": {
                if (er.resultCode != 0) break;
                if (er.getOutput().contains("Enabled: true")) {
                    if (!this.setDisabled(false)) break;
                    this.saveAndNotifySingleAgentChange();
                    break;
                }
                if (!er.getOutput().contains("Enabled: false") || !this.setDisabled(true)) break;
                this.saveAndNotifySingleAgentChange();
                break;
            }
            default: {
                if (!Pattern.matches("\\s*BOOM_AGENT\\s+\\w+ABLE_AGENT\\s*", cmd)) break;
                this.setAgentDetailsNecessary(true);
            }
        }
        if (er.resultCode == 0 && this.getMode() < 7) {
            if (cmd.startsWith(BOOM_AGENT_ENABLE_TLS)) {
                try {
                    Pattern portNumberInCmd = Pattern.compile(".*(\\d+)\\s*$");
                    Matcher m1 = portNumberInCmd.matcher(cmd);
                    if (m1.matches()) {
                        int port = Integer.parseInt(m1.group(1));
                        this.setAgentPort(port);
                        this.setSingleFlagON(64);
                        ServerEngine.getInstance().getScheduler().removeTask(AgentHB.getName(this.getAgentID()));
                        ServerEngine.getInstance().getScheduler().addTask(new AgentHB(this), 0L);
                        this.saveAndNotifySingleAgentChange();
                        RTLogger.print(2, "Processing TLS-ON: AgentCard port changed to " + this.getAgentPort() + " for " + this.getAgentID());
                    }
                }
                catch (Exception e) {
                    RTLogger.print(3, "Processing TLS-ON: AgentCard remains unchanged. Error parsing port number from command: " + cmd, e);
                }
            } else if (cmd.startsWith(BOOM_AGENT_DISABLE_TLS)) {
                try {
                    String agtportmarker = "AgentPort=";
                    int index = er.getOutput().indexOf(agtportmarker);
                    if (index != -1) {
                        String portStr = er.getOutput().substring(index + agtportmarker.length()).trim();
                        int port = Integer.parseInt(portStr);
                        this.setAgentPort(port);
                        this.setSingleFlagOFF(64);
                        ServerEngine.getInstance().getScheduler().removeTask(AgentHB.getName(this.getAgentID()));
                        ServerEngine.getInstance().getScheduler().addTask(new AgentHB(this), 0L);
                        ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(this);
                        RTLogger.print(2, "Processing TLS-ON: AgentCard port changed to " + this.getAgentPort() + " for " + this.getAgentID());
                    } else {
                        this.setSingleFlagOFF(64);
                        ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(this);
                        SEventFwd sm = SMessage.createMessage(2, 0, this.m_hostname, "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "Agent TLS is deactivated. Please adjust Agent Port in the configuration if necessary.");
                        sm.setNode(this.getAgentHost());
                        sm.setT1(this.getAgentID());
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                    }
                }
                catch (Exception e) {
                    RTLogger.print(3, "Processing TLS-OFF: failed. " + cmd, e);
                }
            }
        }
    }

    private void processSpiDigest(ExecResult er) {
        if (er.resultCode == 0) {
            this.m_lastSpiDirDigest = er.getOutput();
            HashMap<String, String> agentSide = FileSyncUtils.parseDigest(this.m_lastSpiDirDigest);
            StringBuilder sb = new StringBuilder();
            for (String pname : this.m_monToUndeploy) {
                sb.append("#[U]").append(pname).append(" mon\n");
            }
            for (String pname : this.m_msgToUndeploy) {
                sb.append("#[U]").append(pname).append(" msg\n");
            }
            for (String pname : this.m_monToDeploy) {
                sb.append("#[D]").append(pname).append(" mon\n");
            }
            for (String pname : this.m_msgToDeploy) {
                sb.append("#[D]").append(pname).append(" msg\n");
            }
            sb.append("Policies to undeploy: ").append(this.m_msgToUndeploy.size() + this.m_monToUndeploy.size()).append('\n');
            sb.append("Policies to deploy: ").append(this.m_msgToDeploy.size() + this.m_monToDeploy.size()).append('\n');
            Map<Assignment, Object> allAssignments = ServerEngine.getInstance().getAssignmentRepository().getAssignments(this.m_agentID);
            for (Assignment assignment : allAssignments.keySet()) {
                if (!"pkg".equals(assignment.getType())) continue;
                String binPkg = assignment.getName();
                sb.append("#Package: \"").append(binPkg).append("\"\n");
                File packages = ServerEngine.getInstance().getBinariesRepository().getPackageDirectory();
                try {
                    int okfiles = 0;
                    int agentMissed = 0;
                    int agentHasDifferentVersion = 0;
                    File pkgdir = new File(packages, binPkg);
                    HashMap<String, byte[]> m = FileSyncUtils.getDigestMap(pkgdir);
                    Map<String, String> serverSidePkg = FileSyncUtils.formatDigestMap(m);
                    for (Map.Entry<String, String> entry : serverSidePkg.entrySet()) {
                        String agentDigestSingle = agentSide.get(entry.getKey());
                        if (agentDigestSingle == null) {
                            sb.append("#[D]").append(entry.getKey()).append('\n');
                            ++agentMissed;
                            continue;
                        }
                        if (agentDigestSingle.equals(entry.getValue())) {
                            ++okfiles;
                            continue;
                        }
                        sb.append("#[D]").append(entry.getKey()).append('\n');
                        ++agentHasDifferentVersion;
                    }
                    int notOK = agentMissed + agentHasDifferentVersion;
                    if (notOK <= 0) continue;
                    this.m_binpackagesUnsync.add(binPkg);
                }
                catch (Throwable e) {
                    sb.append("# error: ").append(e.getMessage()).append('\n');
                }
            }
            sb.append("Packages to deploy: ").append(this.m_binpackagesUnsync.size()).append('\n');
            this.m_lastSyncReport = sb.toString();
        } else {
            this.m_lastSyncReport = "ERROR: " + er.getOutput();
        }
    }

    public long getLastTimeOnline() {
        long delta = System.currentTimeMillis() - this.m_lastTimeOnline;
        if (this.isRemoteActionRunningOnFirewalled && delta > (long)FIREWALLED_AGENT_PING_EXPIRATION) {
            this.setLastTimeOnlineSilently(System.currentTimeMillis());
        }
        return Math.max(this.m_lastTimeOnline, this.m_lastTimeOnlineFromServer);
    }

    public long getLastTimeOnlineFromServer() {
        return this.m_lastTimeOnlineFromServer;
    }

    public void setLastTimeOnlineFromServer(long time) {
        this.m_lastTimeOnlineFromServer = time;
    }

    public void setLastTimeOnline() {
        this.setLastTimeOnlineSilently(System.currentTimeMillis());
        if (this.getMode() >= 7) {
            this.setMode(8);
        }
    }

    public void setLastTimeOnlineSilently(long time) {
        this.m_lastTimeOnline = time;
    }

    public void setLastIndiTime(long milliseconds) {
        if (this.isExternal()) {
            this.setLastTimeOnlineSilently(milliseconds);
        }
    }

    @Override
    public boolean needsToBeChecked() {
        if (this.getRelatedServer() != null) {
            return false;
        }
        long delta = System.currentTimeMillis() - this.getLastTimeOnline();
        return delta > (long)FIREWALLED_AGENT_PING_EXPIRATION;
    }

    public boolean needsToBeCheckedFromServer() {
        if (this.getRelatedServer() != null) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        boolean pingExpired = currentTimeMillis - this.getLastTimeOnlineFromServer() > (long)FIREWALLED_AGENT_PING_EXPIRATION;
        boolean agentCanCommunicateToServer = currentTimeMillis - this.getLastPingFromAgentTimestamp() < (long)FIREWALLED_AGENT_PING_EXPIRATION;
        return pingExpired || !agentCanCommunicateToServer;
    }

    public AgentInventoryCard getAgentInventoryCard() {
        if (this.m_InventoryCard == null) {
            this.m_InventoryCard = new AgentInventoryCard(this.getAgentID());
            if (this.getAgentPort() > 0) {
                this.m_InventoryCard.loadSDIS(new File("srv/inventory"));
            }
        }
        return this.m_InventoryCard;
    }

    public void triggerInventory() {
        RemoteInventoryAction rcc = new RemoteInventoryAction('A', this, "BOOM_AGENT GET_DETAILS", 300);
        this.addPending(rcc);
    }

    public boolean isLocalAgent() {
        return this.getRelatedServer() == null && (this.m_os == null || !this.m_os.contains("(BS:"));
    }

    public boolean isExternal() {
        return this.m_port == 0;
    }

    public boolean isIoTHub() {
        return this.m_port == -1;
    }

    public static String getShortName(String hostname) {
        Matcher m = IP4PATTERN.matcher(hostname);
        if (m.matches()) {
            return hostname;
        }
        m = IP6PATTERN.matcher(hostname);
        if (m.matches()) {
            return hostname;
        }
        int ch = hostname.indexOf(46);
        if (ch == -1) {
            return hostname;
        }
        return hostname.substring(0, ch);
    }

    public int getProtocolVersion() {
        return this.m_protocolUsed.get();
    }

    public void setProtocolVersion(int version) {
        this.m_protocolUsed.set(version);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_label).append(" (").append(this.m_hostIP).append(") ").append(this.m_agentID);
        if (this.getAgentPort() == 0) {
            sb.append(" (virt)");
        }
        return sb.toString();
    }

    public boolean cancelDeployClient(DeployClient dc) {
        boolean removed = this.m_queue.remove(dc);
        dc.cancel();
        return removed;
    }

    public String toStringExt() {
        return AgentCard.getStringExt(this.getAgentIP(), this.getAgentID(), this.getAgentHost(), this.getOSName(), this.getAgentPort(), this.getAgentFlags());
    }

    public static String getStringExt(String ip, String id, String hostname, String os, int port, int flags) {
        return id + "\n" + ip + "\n" + hostname + "\n" + os + "\n" + port + "\n" + flags + "\n";
    }

    public boolean isAgentDetailsNeeded() {
        return this.m_isAgentDetailsNecessary || System.currentTimeMillis() - this.askAgentDetailsLast > 30000L;
    }

    public void askAgentDetails(SDataOutputStream out, SDataInputStream in, String remoteIP, String connectedVia) throws IOException, NullAgentID {
        String agentID;
        out.write(55);
        try {
            agentID = in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (agentID == null) {
            throw new NullAgentID();
        }
        if (agentID.startsWith("!")) {
            this.setMode(9);
            return;
        }
        String os = in.readUTF();
        String hostname = in.readUTF();
        AgentInfo agtInfo = AgentCard.getAgentInfo(hostname);
        if (agtInfo.enabled == null) {
            this.schedule(new RemoteCmdClient('A', this, BOOM_AGENT_STATUS, 10));
        }
        if (connectedVia != null && connectedVia.equals(this.getAgentHost())) {
            agtInfo.setHostname(this.getAgentHost());
        } else if ("localhost".equals(agtInfo.getHostname())) {
            agtInfo.setHostname(remoteIP);
        }
        agtInfo.setOs(os);
        agtInfo.setId(agentID);
        agtInfo.setRemoteIP(remoteIP);
        RTLogger.print(5, "  AgtInfo %s", agtInfo);
        boolean sendID = false;
        if (!agentID.equals(this.getAgentID())) {
            AgentCard probablyConflictAC = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
            if (probablyConflictAC != null) {
                if (probablyConflictAC.isOnline()) {
                    throw new IOException("ACID " + agentID + " got reached by another ACID: " + this.getAgentID());
                }
            } else {
                sendID = true;
            }
        } else if (agtInfo.enabled != null && this.setDisabled(agtInfo.enabled == false)) {
            this.saveAndNotifySingleAgentChange();
        }
        if (!sendID && !this.toStringExt().equals(AgentCard.getStringExt(remoteIP, agentID, agtInfo.getHostname(), agtInfo.getOs(), agtInfo.getPort(), agtInfo.isTLS() ? 64 : 0))) {
            ServerEngine.getInstance().getAgentRepository().addPendingIP(agtInfo);
        }
        if (agtInfo.certificate != null) {
            ServerEngine.getInstance().getAgentCertificates().processAgentCSR(this, agtInfo.certificate);
        }
        if (sendID) {
            this.sendAgentID();
        }
        this.setAgentDetailsNecessary(agtInfo.isTLSCapable() || agtInfo.isTLS() && agtInfo.getPort() != this.getAgentPort());
        this.askAgentDetailsLast = System.currentTimeMillis();
    }

    private void saveAndNotifySingleAgentChange() {
        ServerThreadPool.getInstance().submit(() -> {
            try {
                ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(this);
            }
            catch (Exception e) {
                RTLogger.print(5, "", e);
            }
        });
    }

    public static AgentInfo getAgentInfo(String extendedInfo) {
        AgentInfo agtInfo;
        int extendedInfoChar = extendedInfo.indexOf(123);
        String hostnameAndPort = extendedInfo;
        if (extendedInfoChar != -1) {
            String extInfo = extendedInfo.substring(extendedInfoChar);
            hostnameAndPort = extendedInfo.substring(0, extendedInfoChar);
            try {
                agtInfo = new GsonBuilder().create().fromJson(extInfo, AgentInfo.class);
            }
            catch (JsonSyntaxException e) {
                RTLogger.print(4, "error parsing extended agent info: " + extInfo, e);
                agtInfo = new AgentInfo(null, null, null, null);
            }
        } else {
            agtInfo = new AgentInfo(null, null, null, null);
        }
        if (ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
            hostnameAndPort = hostnameAndPort.toLowerCase();
        }
        String host = hostnameAndPort;
        int portNumber = ServerEngine.getInstance().getServerProps().getAgentPort();
        int split = host.lastIndexOf(58);
        if (split != -1) {
            host = hostnameAndPort.substring(0, split);
            String port = hostnameAndPort.substring(split + 1);
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        agtInfo.setHostname(host);
        agtInfo.setPort(portNumber);
        return agtInfo;
    }

    public void setAgentDetailsNecessary(boolean isNecessary) {
        this.m_isAgentDetailsNecessary = isNecessary;
    }

    public void setLastPingFromAgentTimestamp(long lastPingFromAgentTimestamp) {
        this.lastPingFromAgentTimestamp = lastPingFromAgentTimestamp;
    }

    public long getLastPingFromAgentTimestamp() {
        return this.lastPingFromAgentTimestamp;
    }

    public boolean isIPPPreferred() {
        return this.isIPPPreferred;
    }

    public void setIPPPreferred(boolean IPPPreferred) {
        this.isIPPPreferred = IPPPreferred;
    }
}

