/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.CSRStorage;
import com.blixx.server.CertificateStateIndicationHelper;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.ServerEngine;
import com.blixx.shared.utils.StrUtils;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.pki.PKI;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class AgentCertificates {
    private final PKI pki;
    private final CSRStorage csrStorage;

    public AgentCertificates(PKI pki, CSRStorage csrStorage) {
        this.pki = pki;
        this.csrStorage = csrStorage;
    }

    public Optional<Certificate> getAgentCert(String agentId) {
        Certificate result = null;
        TrustStoreClient tsc = ServerEngine.getInstance().getCertificateManager().getTsClient();
        if (tsc != null && tsc.getKeyStore() != null) {
            try {
                result = tsc.getKeyStore().getCertificate(agentId);
            }
            catch (KeyStoreException e) {
                RTLogger.print(3, "error lookup agt cert. AgentID: " + agentId, e);
            }
        } else {
            RTLogger.print(3, "error lookup agt cert. AgentID: " + agentId + " tsc: " + String.valueOf(tsc));
        }
        return Optional.ofNullable(result);
    }

    public void processAgentCSR(AgentCard ac, String csrFromAgent) {
        boolean sendToPKI = true;
        String agentID = ac.getAgentID();
        Optional<Certificate> agtSignedCert = this.getAgentCert(agentID);
        if (agtSignedCert.isPresent()) {
            if (KeyStoreUtils.csrMatchesCert(agtSignedCert.get(), csrFromAgent)) {
                Optional<String> csrResponse = this.csrStorage.getCSRResponse(agentID);
                try {
                    if (csrResponse.isPresent() && this.certRespMatchesCert(agtSignedCert.get(), csrResponse.get())) {
                        sendToPKI = false;
                        this.sendSignedCertToAgent(ac, csrResponse.get().getBytes());
                    }
                }
                catch (IOException | CertificateException e) {
                    RTLogger.print(3, "Could not compare certificate request with agent certificate. AgentID={}", agentID, e);
                }
            } else {
                try {
                    ServerEngine.getInstance().getCertificateManager().getTsClient().deleteCertificate(agentID);
                }
                catch (KeyStoreException e) {
                    RTLogger.print(3, "error ", e);
                }
            }
        }
        if (sendToPKI) {
            this.signAgtCert(ac, csrFromAgent);
        }
    }

    private boolean certRespMatchesCert(Certificate certificate, String csrResp) throws IOException, CertificateException {
        boolean result = false;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(csrResp.getBytes()));){
            if (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                result = Objects.equals(certificate, cert);
            }
        }
        return result;
    }

    private void signAgtCert(AgentCard ac, String csrFromAgent) {
        String agentID = ac.getAgentID();
        if (this.csrStorage.storeCertificateRequest(agentID, csrFromAgent)) {
            CertificateStateIndicationHelper.sendSendingAgentCSRtoPKI(ac);
            this.pki.processCSR(agentID, csrFromAgent.getBytes());
            ac.setOSName("CSR pending...");
        }
    }

    public void storeAndSendSignedCertToAgent(AgentCard ac, byte[] signed) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        String agentID = ac.getAgentID();
        this.storeSignedCertToTrustStore(agentID, signed);
        this.csrStorage.storeCSRResponse(agentID, signed);
        this.sendSignedCertToAgent(ac, signed);
    }

    public void sendSignedCertToAgent(AgentCard ac, byte[] signed) {
        String cmd = "BOOM_AGENT" + StrUtils.SEP + "STORE_SIGNED_CERT" + StrUtils.SEP + new String(signed) + StrUtils.SEP + ac.getAgentID();
        CertificateStateIndicationHelper.sendSendingSignedCertToAgent(ac);
        if (this.scheduleAgentCommand(ac, cmd)) {
            RTLogger.print(2, "Sending certificate to agent: %s", ac);
        } else {
            RTLogger.print(5, "pending outgoing agent certificate. Agent: %s", ac);
        }
    }

    private boolean scheduleAgentCommand(AgentCard ac, String cmd) {
        boolean scheduled = false;
        if (new ArrayList<IRemoteProcessing>(ac.getPendingMap_Unsynchronized().keySet()).stream().noneMatch(ir -> {
            if (ir instanceof RemoteCmdClient) {
                RemoteCmdClient rcc = (RemoteCmdClient)ir;
                return cmd.equals(rcc.m_cmd);
            }
            return false;
        })) {
            ac.scheduleTask(new RemoteCmdClient('A', ac, cmd, 30));
            scheduled = true;
        }
        return scheduled;
    }

    public void sendNewCACertToAgent(AgentCard ac) {
        try {
            Certificate latestCACertificate = ServerEngine.getInstance().getCertificateManager().getTsClient().getLatestCACertificate();
            byte[] bytes = CertificateSerializationHelper.serializeCertificate(latestCACertificate);
            CertificateStateIndicationHelper.sendSendingCACertToAgent(ac);
            String cmd = "BOOM_AGENT" + StrUtils.SEP + "UPDATE_CA_CERT" + StrUtils.SEP + new String(bytes) + StrUtils.SEP + ac.getAgentID();
            if (this.scheduleAgentCommand(ac, cmd)) {
                RTLogger.print(2, "Sending new CA certificate to agent: %s", ac);
            } else {
                RTLogger.print(5, "pending outgoing CA certificate. Agent: %s", ac);
            }
        }
        catch (KeyStoreException e) {
            RTLogger.print(1, "Could not get latest CA certificate from TS to send to agent: %s", ac, e);
        }
        catch (IOException | CertificateEncodingException e) {
            RTLogger.print(1, "Could not serialize latest CA certificate from TS to send to agent: %s", ac, e);
        }
    }

    public void storeSignedCertToTrustStore(String agentID, byte[] signed) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        TrustStoreClient tsClient = ServerEngine.getInstance().getCertificateManager().getTsClient();
        try {
            tsClient.importCertificate(agentID, signed);
            tsClient.saveKeyStore();
        }
        catch (Exception e) {
            RTLogger.print(1, "can't sign agent CSR, agentId " + agentID, e);
            if (RTLogger.getCurrentLevel() >= 4) {
                RTLogger.print(4, "agentId " + agentID + " CSR " + new String(signed), e);
            }
            throw e;
        }
    }

    public CSRStorage getCsrStorage() {
        return this.csrStorage;
    }

    public PKI getPki() {
        return this.pki;
    }
}

