/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.server.ServerAction;
import com.blixx.server.ServerEngine;
import com.blixx.shared.Annotation;
import java.io.File;

public class AutoActionLocalJob
extends ServerAction {
    String m_exec = null;
    String m_msgID = null;
    int m_timeoutSeconds = 300;
    boolean m_isSuccess = false;
    String m_result = null;

    public AutoActionLocalJob(String exec, String messageID, int timeoutSeconds) {
        this.m_exec = exec;
        this.m_msgID = messageID;
        this.m_timeoutSeconds = timeoutSeconds;
    }

    @Override
    public String getActionID() {
        return "AALJ|" + this.m_msgID;
    }

    @Override
    public void handleResult() {
        long time = System.currentTimeMillis();
        if (this.m_isSuccess) {
            Object text = this.m_result;
            if (text == null) {
                text = "<noOutput>";
            }
            text = "BOOM_SERVER\n" + (String)text;
            Annotation ann = new Annotation((String)text, time, "AAT");
            ServerEngine.getInstance().getEventsRouter().getEventOperations().markToSaveAnnotations(this.m_msgID, ann);
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Local action successed for message ID:" + this.m_msgID + " AAT");
            }
            ServerEngine.getInstance().getEventsRouter().getEventOperations().setAnnotationFlag(this.m_msgID);
        } else {
            String text = "BOOM_SERVER\n" + this.m_result;
            Annotation ann = new Annotation(text, time, "AAF");
            ServerEngine.getInstance().getEventsRouter().getEventOperations().markToSaveAnnotations(this.m_msgID, ann);
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Local action failed for message ID:" + this.m_msgID + " AAF");
            }
            ServerEngine.getInstance().getEventsRouter().getEventOperations().setAnnotationFlag(this.m_msgID);
        }
    }

    @Override
    public void onRun() {
        try {
            ExecResult er = ExecUtils.exec2(this.m_exec, new File("."), this.m_timeoutSeconds);
            if (er.resultCode == 0) {
                this.m_result = er.getOutput();
                this.m_isSuccess = true;
            } else {
                this.m_result = er.getOutput();
            }
        }
        catch (Throwable e) {
            this.m_result = e.getMessage();
        }
    }

    @Override
    public boolean isSuccess() {
        return this.m_isSuccess;
    }
}

