/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.utils.DeployType;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.Assignment;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.MD5;
import com.blixx.shared.utils.ShabalUtils;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.ZIP;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class BinariesRepository {
    public static final String BIN_DIR = "./srv/packages";
    public static final String BIN_XML = "boom_packages.xml";
    private File m_packages = null;
    private String m_packagesCanonicalPath = null;
    private File m_xml = null;
    private static volatile BinariesRepository m_br = null;
    private GroupTreeObject m_binaries;
    private GroupTreeObject m_packagesGTO;
    private Map<String, ArrayList<String>> m_binaryAssignments = new ConcurrentHashMap<String, ArrayList<String>>(10, 0.95f, 3);
    private Map<String, ArrayList<String>> m_binaryDeAssignments = new ConcurrentHashMap<String, ArrayList<String>>(10, 0.95f, 3);

    public static BinariesRepository getInstance(String mainDir) {
        return new BinariesRepository(mainDir);
    }

    private BinariesRepository(String mainDir) {
        this.m_packages = Paths.get(mainDir, new String[0]).resolve(BIN_DIR).toFile();
        File packageDirectory = this.getPackageDirectory();
        try {
            Files.createDirectories(packageDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            RTLogger.print(1, "error initializing binary repository: " + packageDirectory.getPath(), e);
        }
        File[] list = packageDirectory.listFiles(new FileFilter(this){
            final Pattern p = Pattern.compile(".*_\\d{12,}?\\.zip");

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    try {
                        Matcher m = this.p.matcher(pathname.getName());
                        return m.matches();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        if (list != null) {
            for (File f : list) {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    RTLogger.print(5, "can't delete tmp file: " + f.getPath(), e);
                }
            }
        }
        this.getXmlFile(true);
        RTLogger.print(1, "bin repo initialized. Dir: " + this.m_packages.getPath());
    }

    public GroupTreeObject getTree() {
        return this.m_packagesGTO;
    }

    public File getPackageDirectory() {
        return this.m_packages;
    }

    public String getPackageDirectoryPath() {
        if (this.m_packagesCanonicalPath == null) {
            try {
                this.m_packagesCanonicalPath = this.getPackageDirectory().getCanonicalPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_packagesCanonicalPath;
    }

    public synchronized File getXmlFile(boolean refresh) {
        if (refresh) {
            this.m_binaries = new GroupTreeObject(new TreeObject("root", "", null));
            this.m_packagesGTO = new GroupTreeObject(new TreeObject("Packages", "toplevel", this.getPackageDirectory()));
            this.m_binaries.addElement(this.m_packagesGTO);
            this.processFileTree(this.m_packagesGTO, true);
            XMLTree xt = new XMLTree();
            Document doc = xt.getXML(this.m_binaries);
            String xmlFilename = this.m_packages.toPath().resolve(BIN_XML).toString();
            XMLFactory.writeXml(doc, xmlFilename);
            this.m_xml = new File(xmlFilename);
        }
        return this.m_xml;
    }

    private void processFileTree(GroupTreeObject root, boolean isRoot) {
        File dir = (File)root.getTreeObject().getObject();
        File[] list = dir.listFiles();
        if (list != null) {
            for (File value : list) {
                if (value.isDirectory()) {
                    if (value.getName().equals("CVS")) continue;
                    String type = "";
                    if (root.equals(this.m_packagesGTO)) {
                        type = "pkg";
                    }
                    GroupTreeObject folder = new GroupTreeObject(new TreeObject(value.getName(), type, value));
                    root.addElement(folder);
                    this.processFileTree(folder, false);
                    continue;
                }
                if (isRoot) continue;
                GroupTreeObjectLast file = new GroupTreeObjectLast(new TreeObject(value.getName(), "file", value), null, null);
                root.addElement(file);
            }
        }
    }

    public void assignBinaryPackage(String pkgName, String agentID) {
        ArrayList<String> al = this.m_binaryAssignments.get(agentID);
        if (al == null) {
            al = new ArrayList();
            this.m_binaryAssignments.put(agentID, al);
        }
        if (!al.contains(pkgName)) {
            al.add(pkgName);
            RTLogger.print(3, "PKG " + pkgName + " assigned to " + agentID);
        }
    }

    public void deassignBinaryPackage(String pkgName, String agentID) {
        ArrayList<String> al = this.m_binaryDeAssignments.get(agentID);
        if (al == null) {
            al = new ArrayList();
            this.m_binaryDeAssignments.put(agentID, al);
        }
        if (!al.contains(pkgName)) {
            al.add(pkgName);
            RTLogger.print(3, "PKG " + pkgName + " deassigned from " + agentID);
        }
    }

    public void _triggerAllDeployments() {
        HashMap all = new HashMap();
        Iterator<String> iiit = this.m_binaryDeAssignments.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        iiit = this.m_binaryAssignments.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        for (String agentID : all.keySet()) {
            List<DeployClient> result = this._triggerDeployments(agentID);
            DeploymentManager.waitDeploymentsStarted(result);
        }
    }

    public List<DeployClient> _triggerDeployments(String agentID) {
        ArrayList<DeployClient> result = new ArrayList<DeployClient>();
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            if (agentID.length() == 32) {
                String nodeGroupID = agentID;
                GroupTreeObject nodeGroup = NodeGroupRepository.getInstance().getNodeGroupTree().findByOID(nodeGroupID);
                if (nodeGroup != null) {
                    ArrayList<String> toDeploy;
                    ArrayList<String> toUndeploy = this.m_binaryDeAssignments.get(nodeGroupID);
                    if (toUndeploy == null) {
                        toUndeploy = new ArrayList<String>(0);
                    }
                    if ((toDeploy = (ArrayList<String>)this.m_binaryAssignments.get(nodeGroupID)) == null) {
                        toDeploy = new ArrayList<String>(0);
                    }
                    List<GroupTreeObject> elements = nodeGroup.getAllElements();
                    for (GroupTreeObject gto : elements) {
                        if (!(gto instanceof GroupTreeObjectLast) || !"agt".equals(gto.getType())) continue;
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                        String agentIDinNG = gtol.getLinkedPath();
                        AgentCard ACbyNG = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentIDinNG, false);
                        if (ACbyNG == null) continue;
                        this.undeploy(ACbyNG, toUndeploy);
                        result.addAll(this.deploy(ACbyNG, toDeploy));
                    }
                    for (String assumeUndeployed : toUndeploy) {
                        ServerEngine.getInstance().getAssignmentRepository().setUndeployed(nodeGroupID, assumeUndeployed, "pkg");
                    }
                    for (String assumeDeployed : toDeploy) {
                        ServerEngine.getInstance().getAssignmentRepository().setUploaded(nodeGroupID, assumeDeployed, "pkg");
                    }
                }
            }
        } else {
            result.addAll(this.triggerBinaryDeployments(agentID));
            this.triggerBinaryUnDeployments(agentID);
        }
        return result;
    }

    private List<DeployClient> triggerBinaryDeployments(String agentID) {
        ArrayList<DeployClient> result = new ArrayList<DeployClient>(0);
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            return result;
        }
        ArrayList<String> pending = this.m_binaryAssignments.get(agentID);
        if (pending == null) {
            return result;
        }
        result.addAll(this.deploy(ac, pending));
        return result;
    }

    public List<DeployClient> deploy(AgentCard ac, List<String> pending) {
        LinkedList<DeployClient> clientsStarted = new LinkedList<DeployClient>();
        if (ac == null || pending == null) {
            return clientsStarted;
        }
        Iterator<String> it = pending.iterator();
        while (it.hasNext()) {
            String pkgName = it.next();
            DeployClient dc = new DeployClient(DeployType.DEPLOY_PACKAGES, ac, pkgName);
            DeploymentManager.getInstance().schedule(dc);
            it.remove();
            clientsStarted.add(dc);
            RTLogger.print(2, "Deployment is scheduled");
            SMessage.sendMessage(ac, "Deployment is scheduled. Package " + pkgName, 1, "DEPLOY", "PACKAGE", ac.getAgentHost(), 0);
        }
        return clientsStarted;
    }

    private void deleteLostAssignments(String packageName) {
        AsnDbUpdate adu = new AsnDbUpdate();
        ArrayList<Assignment> list = ServerEngine.getInstance().getAssignmentRepository().getAssignments(packageName, "pkg");
        for (Assignment assignment : list) {
            adu.addToDelete(assignment.getID());
            ServerEngine.getInstance().getAssignmentRepository().setUndeployed(assignment.getAgentID(), assignment.getName(), assignment.getType());
            try {
                this.m_binaryDeAssignments.get(assignment.getAgentID()).remove(assignment.getName());
            }
            catch (Throwable throwable) {}
        }
        adu.saveDB(ServerEngine.getInstance());
    }

    public File zipPackage(String packageName) throws FileNotFoundException, IOException {
        File pkg = new File(this.getPackageDirectory(), packageName);
        File zipF = null;
        if (!pkg.isDirectory()) {
            throw new FileNotFoundException("Specified name is not a directory: " + packageName);
        }
        ZIP zip = new ZIP();
        String zipTempFile = this.getPackageDirectory().getPath() + File.separator + packageName + "_" + System.currentTimeMillis() + ".zip";
        zip.zipDir(pkg.getPath(), zipTempFile);
        zipF = new File(zipTempFile);
        return zipF;
    }

    public void zipDeletedPackage(Assignment asn) {
        if (asn != null) {
            String zipTempFile = this.getPackageDirectory().getPath() + File.separator + asn.getName() + "_" + asn.getID() + ".zip";
            RTLogger.print(5, "Zip temp: " + zipTempFile);
            try {
                File pkg = new File(this.getPackageDirectory(), asn.getName());
                if (pkg.isDirectory()) {
                    ZIP zip = new ZIP();
                    zip.zipDirZero(pkg.getPath(), zipTempFile);
                }
            }
            catch (Throwable e) {
                RTLogger.print(2, "Error zip package.", e);
                AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(asn.getAgentID(), false);
                SMessage.sendMessage(ac, "Package '" + asn.getName() + "'.Server unable to compress content.", 4, "UNDEPLOY", asn.getName(), ac.getAgentHost(), 0);
                File temp = new File(zipTempFile);
                temp.delete();
            }
        }
    }

    private void triggerBinaryUnDeployments(String agentID) {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            return;
        }
        ArrayList<String> pending = this.m_binaryDeAssignments.get(agentID);
        if (pending == null) {
            return;
        }
        this.undeploy(ac, pending);
    }

    public List<DeployClient> undeploy(AgentCard ac, List<String> pending) {
        LinkedList<DeployClient> clientsStarted = new LinkedList<DeployClient>();
        if (ac == null || pending == null) {
            return clientsStarted;
        }
        Iterator<String> it = pending.iterator();
        while (it.hasNext()) {
            String pkgName = it.next();
            DeployClient dc = new DeployClient(DeployType.UNDEPLOY_PACKAGES, ac, pkgName);
            DeploymentManager.getInstance().schedule(dc);
            it.remove();
            clientsStarted.add(dc);
            RTLogger.print(2, "UnDeployment is scheduled");
            SMessage.sendMessage(ac, "UnDeployment is scheduled. Package " + pkgName, 1, "UNDEPLOY", "PACKAGE", ac.getAgentHost(), 0);
        }
        return clientsStarted;
    }

    public GroupTreeObject getBinaryTreeWithMD5() {
        GroupTreeObject rootClone = new GroupTreeObject(new TreeObject("root", "", null));
        try {
            rootClone = this.getTree().clone();
            List<GroupTreeObject> binPackages = rootClone.findElementsByType("pkg");
            for (GroupTreeObject gto : binPackages) {
                File dir = new File(this.getPackageDirectory(), gto.getName());
                try {
                    if (!dir.exists()) continue;
                    MD5 digest = new MD5();
                    FileSyncUtils.updateDigestRecursively(digest, dir);
                    String crc = ShabalUtils.getHex(digest);
                    gto.setAttribute("MD5", crc);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rootClone;
    }

    public List<String> getAllFiles(String binaryPackageName) {
        ArrayList<String> result = new ArrayList<String>();
        List<GroupTreeObject> groups = this.getTree().findGroups(binaryPackageName, "pkg");
        if (groups != null && groups.size() > 0) {
            GroupTreeObject prg = groups.get(0);
            List<GroupTreeObject> filesGtoList = prg.findElementsByType("file");
            for (GroupTreeObject gto : filesGtoList) {
                result.add(gto.getPath().replaceFirst("\\Q" + prg.getPath() + "/\\E", ""));
            }
        }
        return result;
    }

    public void notifyUI() {
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETBINARIES");
    }
}

