/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BruteForceDetector {
    private int maxFailedLoginsInARowBeforeLock;
    private long lockRetentionPeriodMs;
    private long failCountRetentionPeriodMs;
    private Map<String, UserLoginStats> userToLoginStatsMap = new ConcurrentHashMap<String, UserLoginStats>();

    public BruteForceDetector(int maxFailedLoginsInARowBeforeLock, long lockRetentionPeriodMs, long failCountRetentionPeriodMs) {
        this.maxFailedLoginsInARowBeforeLock = maxFailedLoginsInARowBeforeLock;
        this.lockRetentionPeriodMs = lockRetentionPeriodMs;
        this.failCountRetentionPeriodMs = failCountRetentionPeriodMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserLocked(String user) {
        UserLoginStats userLoginStats;
        boolean result = false;
        if (user != null && (userLoginStats = this.userToLoginStatsMap.get(user)) != null) {
            UserLoginStats userLoginStats2 = userLoginStats;
            synchronized (userLoginStats2) {
                if (userLoginStats.isLocked() && userLoginStats.getLockedSinceTimestamp() + this.lockRetentionPeriodMs < System.currentTimeMillis()) {
                    userLoginStats.unlock();
                }
                result = userLoginStats.isLocked();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoginFailed(String user) {
        if (user != null) {
            UserLoginStats userLoginStats;
            UserLoginStats userLoginStats2 = userLoginStats = this.userToLoginStatsMap.computeIfAbsent(user, u -> new UserLoginStats());
            synchronized (userLoginStats2) {
                long currentTimestamp = System.currentTimeMillis();
                if (userLoginStats.getLastFailTimestamp() + this.failCountRetentionPeriodMs < currentTimestamp) {
                    userLoginStats.resetFailedLoginCount();
                }
                if (!userLoginStats.isLocked() && userLoginStats.incrementFailedLoginCount() > this.maxFailedLoginsInARowBeforeLock) {
                    userLoginStats.lock();
                }
                userLoginStats.setLastFailTimestamp(currentTimestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoginSuccessful(String user) {
        if (user != null) {
            UserLoginStats userLoginStats;
            UserLoginStats userLoginStats2 = userLoginStats = this.userToLoginStatsMap.computeIfAbsent(user, u -> new UserLoginStats());
            synchronized (userLoginStats2) {
                userLoginStats.clear();
            }
        }
    }

    public int getMaxFailedLoginsInARowBeforeLock() {
        return this.maxFailedLoginsInARowBeforeLock;
    }

    public void setMaxFailedLoginsInARowBeforeLock(int maxFailedLoginsInARowBeforeLock) {
        this.maxFailedLoginsInARowBeforeLock = maxFailedLoginsInARowBeforeLock;
    }

    public long getLockRetentionPeriodMs() {
        return this.lockRetentionPeriodMs;
    }

    public void setLockRetentionPeriodMs(long lockRetentionPeriodMs) {
        this.lockRetentionPeriodMs = lockRetentionPeriodMs;
    }

    public long getFailCountRetentionPeriodMs() {
        return this.failCountRetentionPeriodMs;
    }

    public void setFailCountRetentionPeriodMs(long failCountRetentionPeriodMs) {
        this.failCountRetentionPeriodMs = failCountRetentionPeriodMs;
    }

    private static class UserLoginStats {
        private boolean locked = false;
        private long lockedSinceTimestamp = 0L;
        private long lastFailTimestamp = 0L;
        private int failedLoginCount = 0;

        private UserLoginStats() {
        }

        public void lock() {
            this.locked = true;
            this.lockedSinceTimestamp = System.currentTimeMillis();
        }

        public void unlock() {
            this.locked = false;
            this.lockedSinceTimestamp = 0L;
            this.failedLoginCount = 0;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public long getLockedSinceTimestamp() {
            return this.lockedSinceTimestamp;
        }

        public int getFailedLoginCount() {
            return this.failedLoginCount;
        }

        public void resetFailedLoginCount() {
            this.failedLoginCount = 0;
        }

        public int incrementFailedLoginCount() {
            return ++this.failedLoginCount;
        }

        public long getLastFailTimestamp() {
            return this.lastFailTimestamp;
        }

        public void setLastFailTimestamp(long lastFailTimestamp) {
            this.lastFailTimestamp = lastFailTimestamp;
        }

        public void clear() {
            this.locked = false;
            this.lockedSinceTimestamp = 0L;
            this.lastFailTimestamp = 0L;
            this.failedLoginCount = 0;
        }
    }
}

