/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.server.AgentCard;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.shared.SEventFwd;
import java.util.Date;

public class CertificateStateIndicationHelper {
    private CertificateStateIndicationHelper() {
    }

    public static void sendServerCertImported() {
        String serverId = ServerEngine.getInstance().getServerProps().getServerId();
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        String keystoreTypeString = KeyStoreType.SERVER_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_SERVER", keystoreTypeString, "BOOM Server", "Server certificate imported to server key store");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setT1(serverId);
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendTrustedCAImported() {
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        String keystoreTypeString = KeyStoreType.SERVER_TRUST_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_SERVER", keystoreTypeString, "BOOM Server", "New CA certificate imported to server trust store");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":ca");
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":ca");
        sm.setT1(ServerEngine.getInstance().getServerProps().getServerId());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendSendingServerCSRtoPKI() {
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        String serverId = ServerEngine.getInstance().getServerProps().getServerId();
        String keystoreTypeString = KeyStoreType.SERVER_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_SERVER", keystoreTypeString, "BOOM Server", "Sending server CSR to PKI interface");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setT1(serverId);
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendSendingAgentCSRtoPKI(AgentCard ac) {
        String hostname = ac.getAgentHost();
        String keystoreTypeString = KeyStoreType.AGENT_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_AGENT", keystoreTypeString, "BOOM_AGENT", "Sending agent CSR to PKI interface");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setT1(ac.getAgentID());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendAgentSignedCertificateCorrupt(AgentCard ac, String payload) {
        String hostname = ac.getAgentHost();
        String keystoreTypeString = KeyStoreType.AGENT_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(4, 1, hostname, "BOOM_AGENT", keystoreTypeString, "BOOM_AGENT", "PKI sent corrupt signed certificate.\nPayload:\n" + payload);
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setT1(ac.getAgentID());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendServerSignedCertificateCorrupt(String payload) {
        String serverId = ServerEngine.getInstance().getServerProps().getServerId();
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        String keystoreTypeString = KeyStoreType.SERVER_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(4, 1, hostname, "BOOM_SERVER", keystoreTypeString, "BOOM Server", "PKI sent corrupt signed certificate.\nPayload:\n" + payload);
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + serverId);
        sm.setT1(serverId);
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendFailedCSR(String agentId, String reason) {
        String keystoreTypeString = KeyStoreType.AGENT_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(5, 1, "", "BOOM_AGENT", keystoreTypeString, "BOOM_AGENT", "Failed process agent CSR. " + reason);
        sm.setObject(keystoreTypeString);
        sm.setKey("Certificate:" + keystoreTypeString + ":" + agentId);
        sm.setCloseMask("Certificate:" + keystoreTypeString + ":" + agentId);
        sm.setT1(agentId);
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendSendingSignedCertToAgent(AgentCard ac) {
        String hostname = ac.getAgentHost();
        String keystoreTypeString = KeyStoreType.AGENT_KEY_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_AGENT", keystoreTypeString, "BOOM_AGENT", "Sending signed agent certificate to agent");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setCloseMask(hostname + ":Certificate:" + keystoreTypeString + ":" + ac.getAgentID());
        sm.setT1(ac.getAgentID());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendSendingCACertToAgent(AgentCard ac) {
        String hostname = ac.getAgentHost();
        String keystoreTypeString = KeyStoreType.AGENT_TRUST_STORE.toString();
        SEventFwd sm = SMessage.createMessage(1, 1, hostname, "BOOM_AGENT", keystoreTypeString, "BOOM_AGENT", "Sending new CA certificate to agent");
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":CertificateExpiration:" + keystoreTypeString + ":ca");
        sm.setCloseMask(hostname + ":CertificateExpiration:" + keystoreTypeString + ":ca");
        sm.setT1(ac.getAgentID());
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    public static void sendCertificateExpirationIndication(int severity, String hostname, KeyStoreType keyStoreType, String alias, Date notAfter, long daysToExpiration) {
        String keystoreTypeString = keyStoreType.toString();
        SEventFwd sm = SMessage.createMessage(severity, 1, hostname, "BOOM_SERVER", keystoreTypeString, "BOOM Server", CertificateStateIndicationHelper.buildCertExpirationText(severity, keystoreTypeString, alias, notAfter, daysToExpiration));
        sm.setNode(hostname);
        sm.setObject(keystoreTypeString);
        sm.setKey(hostname + ":CertificateExpiration:" + keystoreTypeString + ":" + alias);
        sm.setCloseMask(hostname + ":CertificateExpiration:" + keystoreTypeString + ":" + alias);
        String relatedAgentOrServer = ServerEngine.getInstance().getServerProps().getServerId();
        if (ServerEngine.getInstance().getAgentRepository().getAgentCardByID(alias) != null) {
            relatedAgentOrServer = alias;
        }
        sm.setT1(relatedAgentOrServer);
        sm.setValue(daysToExpiration);
        if (1 == severity) {
            sm.setState('A');
        }
        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
    }

    private static String buildCertExpirationText(int severity, String keyStoreLabel, String alias, Date notAfter, long daysToExpiration) {
        if (severity == 1) {
            return "Certificate in " + keyStoreLabel + " with alias '" + alias + "' has expiration date: " + String.valueOf(notAfter);
        }
        if (daysToExpiration > 0L) {
            return "Certificate in " + keyStoreLabel + " with alias '" + alias + "' is about to expire.  Days to expire: " + daysToExpiration + ". Expiration date: " + String.valueOf(notAfter);
        }
        return "Certificate in " + keyStoreLabel + " with alias '" + alias + "' is expired since " + Math.abs(daysToExpiration) + " days. Expiration date: " + String.valueOf(notAfter);
    }

    public static enum KeyStoreType {
        SERVER_KEY_STORE,
        SERVER_TRUST_STORE,
        AGENT_TRUST_STORE,
        AGENT_KEY_STORE;

    }
}

