/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentZipFile;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerVirtualThreadPool;
import com.blixx.server.UserManager;
import com.blixx.server.jetty.json.DeployClientJson;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ZIP;
import com.google.gson.JsonArray;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class DeploymentManager {
    private static final long MAX_OLD = 3600000L;
    private ConcurrentSkipListSet<DeployClient> m_deployments = null;
    private static volatile DeploymentManager m_instance;
    private final ConcurrentHashMap<String, DeploymentZipFile> cachedDeploymentZipFiles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DeploymentZipFile> cachedUnDeploymentZipFiles = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeploymentManager getInstance() {
        if (m_instance != null) return m_instance;
        Class<DeploymentManager> clazz = DeploymentManager.class;
        synchronized (DeploymentManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new DeploymentManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    private DeploymentManager() {
        this.m_deployments = new ConcurrentSkipListSet<DeployClient>(new Comparator<DeployClient>(this){

            @Override
            public int compare(DeployClient o1, DeployClient o2) {
                return Long.compare(o1.getInitTime(), o2.getInitTime());
            }
        });
    }

    public boolean schedule(DeployClient dc) {
        boolean isScheduled = false;
        if (dc.getAgentCard() != null && !dc.getAgentCard().isExternal() && dc.getAgentCard().isLocalAgent()) {
            ServerVirtualThreadPool.getInstance().submit(() -> {
                try {
                    this.init(dc);
                    this.track(dc);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error DC init", e);
                    dc.cancel();
                }
            });
            isScheduled = true;
        } else {
            RTLogger.print(2, "Agent does not support deployments. " + String.valueOf(dc.getAgentCard()));
        }
        return isScheduled;
    }

    private void track(DeployClient dc) {
        if (dc.m_state == 0) {
            this.m_deployments.add(dc);
            dc.getAgentCard().scheduleDeployClient(dc);
            dc.m_state = dc.getAgentCard().isFirewalled() || !dc.getAgentCard().isOnline() ? 2 : 1;
        } else {
            RTLogger.print(3, "DC skipped " + String.valueOf(dc));
        }
    }

    public void cleanOld() {
        if (!this.m_deployments.isEmpty()) {
            Iterator<DeployClient> it = this.m_deployments.descendingIterator();
            while (it.hasNext()) {
                DeployClient dc = it.next();
                if (System.currentTimeMillis() - dc.getExpireTime() <= 3600000L) break;
                it.remove();
            }
        }
    }

    public void forgetFinished() {
        if (!this.m_deployments.isEmpty()) {
            Iterator<DeployClient> it = this.m_deployments.descendingIterator();
            while (it.hasNext()) {
                DeployClient dc = it.next();
                if (!dc.isReady()) continue;
                it.remove();
            }
        }
    }

    public JsonArray getListJsonArray(String user) {
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
        Iterator<DeployClient> it = this.m_deployments.descendingIterator();
        JsonArray array = new JsonArray();
        while (it.hasNext()) {
            DeployClient dc = it.next();
            if (!UserManager.getInstance().isAgentVisible(user, dc.getAgentCard().getAgentID(), nodeGroups)) continue;
            array.add(new DeployClientJson().serialize(dc, (Type)null, (JsonSerializationContext)null));
        }
        return array;
    }

    public void cancelDeployClient(String user, List<String> ids) {
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
        Iterator<DeployClient> it = this.m_deployments.descendingIterator();
        while (it.hasNext()) {
            DeployClient dc = it.next();
            if (!ids.contains(dc.getID())) continue;
            this.cancelDeployClient(dc, user, nodeGroups);
        }
    }

    public void cancelAll(String user) {
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
        Iterator<DeployClient> it = this.m_deployments.descendingIterator();
        while (it.hasNext()) {
            DeployClient dc = it.next();
            this.cancelDeployClient(dc, user, nodeGroups);
        }
    }

    private void cancelDeployClient(DeployClient dc, String user, GroupTreeObject nodeGroups) {
        if (UserManager.getInstance().isAgentVisible(user, dc.getAgentCard().getAgentID(), nodeGroups)) {
            dc.getAgentCard().cancelDeployClient(dc);
        }
    }

    public void init(DeployClient dc) {
        block12: {
            if (dc.getState() == 0 && dc.getFiles().isEmpty()) {
                DeploymentZipFile fileToShare = null;
                try {
                    switch (dc.getType()) {
                        case UNDEPLOY_PACKAGES: {
                            fileToShare = this.getCachedOrNew(dc, this.cachedUnDeploymentZipFiles);
                            fileToShare.trackDeployClient();
                            dc.getFiles().add(fileToShare);
                            break;
                        }
                        case DEPLOY_PACKAGES: {
                            fileToShare = this.getCachedOrNew(dc, this.cachedDeploymentZipFiles);
                            fileToShare.trackDeployClient();
                            dc.getFiles().add(fileToShare);
                            break;
                        }
                        case DEPLOY_POLICIES: {
                            break;
                        }
                        case UNDEPLOY_POLICIES: {
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    if ("Directory is empty".equals(e.getMessage())) {
                        dc.setFinished(30);
                    }
                    dc.setFinished(20);
                    RTLogger.print(2, "Error zip package: " + dc.getPackageName(), e);
                    dc.sendErrorMessage("Package '" + dc.getPackageName() + "'. Server unable to compress content.\n" + e.getMessage());
                    if (fileToShare == null) break block12;
                    try {
                        Files.deleteIfExists(fileToShare.toPath());
                    }
                    catch (IOException ex) {
                        RTLogger.print(3, "Error deleting temp file: " + fileToShare.getName(), ex);
                    }
                }
            }
        }
    }

    private synchronized DeploymentZipFile getCachedOrNew(DeployClient dc, ConcurrentHashMap<String, DeploymentZipFile> cache) throws FileNotFoundException, IOException {
        DeploymentZipFile fileToShare = cache.get(dc.getPackageName());
        if (fileToShare != null && dc.getInitTime() >= fileToShare.getMaxReuseTime()) {
            fileToShare = null;
        }
        if (fileToShare == null && !(fileToShare = this.getPackageZip(dc.getPackageName(), dc.getAgentCard().getAgentID(), true)).isAgentSpecificFileInside()) {
            cache.put(dc.getPackageName(), fileToShare);
        }
        return fileToShare;
    }

    public DeploymentZipFile getPackageZip(String boomPackageName, String agentID, boolean isDeploy) throws FileNotFoundException, IOException {
        File packageDirectory = ServerEngine.getInstance().getBinariesRepository().getPackageDirectory();
        File boomPackageDirectory = new File(packageDirectory, boomPackageName);
        if (!boomPackageDirectory.isDirectory()) {
            throw new FileNotFoundException("Binary package directory not found: " + boomPackageName);
        }
        ZIP zip = new ZIP();
        if (agentID != null && !agentID.isEmpty()) {
            zip.setForceAgentSpecificFilesProcessing(agentID);
        }
        String zipTempFile = packageDirectory.getPath() + File.separator + boomPackageName + "_" + System.nanoTime() + ".zip";
        RTLogger.print(5, "Zip temp: " + zipTempFile);
        DeploymentZipFile tmpFile = new DeploymentZipFile(zipTempFile);
        if (isDeploy) {
            zip.zipDir(boomPackageDirectory.getPath(), zipTempFile);
        } else {
            zip.zipDirZero(boomPackageDirectory.getPath(), zipTempFile);
        }
        tmpFile.touch();
        tmpFile.setAgentSpecificFileInside(zip.isAgentSpecificFileFound());
        return tmpFile;
    }

    public void checkExpiredDeployments(AgentCard ac) {
        try {
            boolean isExpired = true;
            while (isExpired) {
                DeployClient dc = ac.getDeploymentQueue().peek();
                if (dc != null) {
                    isExpired = dc.isExpired();
                    if (!isExpired) continue;
                    ac.getDeploymentQueue().poll();
                    dc.expire();
                    continue;
                }
                isExpired = false;
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "Cancel Deploy Task failed: ", e);
        }
    }

    public static void waitDeploymentsStarted(List<DeployClient> list) {
        long start = System.currentTimeMillis();
        boolean notStarted = true;
        while (notStarted) {
            notStarted = false;
            DeployClient dcNotReady = null;
            for (DeployClient dc : list) {
                if (dc.getState() != 0) continue;
                dcNotReady = dc;
                notStarted = true;
                break;
            }
            if (dcNotReady == null) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (System.currentTimeMillis() - start <= 600000L) continue;
            RTLogger.print(2, "Deployment not ready to start within 10 min: %s", dcNotReady);
            break;
        }
    }

    public Map<String, DeploymentZipFile> getCachedDeploymentZipFiles() {
        return this.cachedDeploymentZipFiles;
    }

    public Map<String, DeploymentZipFile> getCachedUnDeploymentZipFiles() {
        return this.cachedUnDeploymentZipFiles;
    }

    public Set<DeployClient> getDeployClients() {
        return this.m_deployments;
    }

    public void clean() {
        this.cachedDeploymentZipFiles.clear();
        this.cachedUnDeploymentZipFiles.clear();
    }
}

