/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.AgentCard;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.DeploymentZipFile;
import com.blixx.server.ServerEngine;
import com.blixx.shared.Interval;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DeploymentTrigger
extends SchedulerTask {
    private static AtomicInteger m_countRunning = new AtomicInteger();
    private static int m_maxDeploys = 10;
    private long nextStatusPrint = 0L;
    private ThreadPoolExecutor m_threadPool = new ThreadPoolExecutor(2, m_maxDeploys, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public DeploymentTrigger(String TaskName) {
        super(TaskName);
        this.setInterval(Interval.getSimpleInterval(2));
    }

    public static boolean canStartDeployClient() {
        return m_countRunning.get() < m_maxDeploys;
    }

    public static int getDeploymentsRunning() {
        return m_countRunning.get();
    }

    public static void increaseDeploymentsRunning() {
        m_countRunning.incrementAndGet();
    }

    public static void decreaseDeploymentsRunning() {
        m_countRunning.decrementAndGet();
    }

    @Override
    public boolean onGetData() {
        Map<String, AgentCard> map = ServerEngine.getInstance().getAgentRepository().getAgentCards();
        Iterator<Map.Entry<String, AgentCard>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            AgentCard ac = it.next().getValue();
            if (ac == null || (ac.isFirewalled() || ac.isExternal() || !ac.isLocalAgent()) && !ac.isIoTHub()) continue;
            this.checkTaskResult(ac);
            if (ac.m_deploymentTask == null || ac.m_deploymentTask.isReady()) {
                if (ac.pendingDeployments()) {
                    if (ac.isOnline()) {
                        this.startTask(ac);
                    } else {
                        DeploymentManager.getInstance().checkExpiredDeployments(ac);
                    }
                } else {
                    ac.m_deploymentTask = null;
                }
            }
            try {
                if ((ac.getMode() != 1 || !ac.pendingUpdates()) && !ac.isIoTHub()) continue;
                ac.startFirstPendingTask();
            }
            catch (Throwable e) {
                RTLogger.print(3, "Pending trigger failed." + String.valueOf(e));
            }
        }
        this.cleanCachedFiles(DeploymentManager.getInstance().getCachedDeploymentZipFiles());
        this.cleanCachedFiles(DeploymentManager.getInstance().getCachedUnDeploymentZipFiles());
        if (System.currentTimeMillis() > this.nextStatusPrint) {
            this.nextStatusPrint = System.currentTimeMillis() + 180000L;
            RTLogger.print(3, "temp deploy files (deploy/undeploy): %d/%d", DeploymentManager.getInstance().getCachedDeploymentZipFiles().size(), DeploymentManager.getInstance().getCachedUnDeploymentZipFiles().size());
        }
        return true;
    }

    public void cleanCachedFiles(Map<String, DeploymentZipFile> map) {
        try {
            LinkedHashMap<String, DeploymentZipFile> files = new LinkedHashMap<String, DeploymentZipFile>(map);
            for (Map.Entry en : files.entrySet()) {
                if (((DeploymentZipFile)en.getValue()).getMaxReuseTime() < System.currentTimeMillis() && ((DeploymentZipFile)en.getValue()).getTrackingCount() <= 0) {
                    map.remove(en.getKey());
                    ((DeploymentZipFile)en.getValue()).deleteForced();
                    RTLogger.print(4, "deployment tmp file deleted: " + ((DeploymentZipFile)en.getValue()).getName());
                    continue;
                }
                if (((DeploymentZipFile)en.getValue()).getMaxReuseTime() >= System.currentTimeMillis() || ((DeploymentZipFile)en.getValue()).getTrackingCount() <= 0 || System.currentTimeMillis() <= ((DeploymentZipFile)en.getValue()).getMaxReuseTime() + 600000L) continue;
                RTLogger.print(4, "deployment temp file is still used: " + ((DeploymentZipFile)en.getValue()).getName() + " count=" + ((DeploymentZipFile)en.getValue()).getTrackingCount());
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "", e);
        }
    }

    private void startTask(AgentCard ac) {
        if (DeploymentTrigger.canStartDeployClient()) {
            DeployClient dc = ac.getDeploymentQueue().peek();
            if (dc != null) {
                try {
                    ac.m_deploymentTask = dc;
                    this.m_threadPool.submit(dc);
                    ac.getDeploymentQueue().poll();
                    if (RTLogger.getCurrentLevel() >= 5) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Deployment task started. Agent ").append(ac.getAgentHost()).append(". ").append(dc);
                        RTLogger.print(5, sb);
                    }
                }
                catch (Throwable e) {
                    ac.m_deploymentTask = null;
                    if (RTLogger.getCurrentLevel() >= 3) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Deployment task failed get free thread. Agent ").append(ac.getAgentHost()).append(". ").append(dc);
                        RTLogger.print(3, sb);
                    }
                }
            }
        } else {
            this.shiftExpirationTimeForAllDeployments(ac);
        }
    }

    private void checkTaskResult(AgentCard ac) {
        if (ac.m_deploymentTask != null && !ac.m_deploymentTask.isReady() && ac.m_deploymentTask.isExpired()) {
            ac.m_deploymentTask.expire();
        }
    }

    public void shiftExpirationTimeForAllDeployments(AgentCard ac) {
        if (ac.pendingDeployments()) {
            if (RTLogger.getCurrentLevel() >= 5) {
                StringBuilder sb = new StringBuilder();
                sb.append("Deployment tasks delayed because all slot are busy. Agent: ").append(ac.getAgentHost());
                RTLogger.print(5, sb);
            }
            for (DeployClient dc : ac.getDeploymentQueue()) {
                dc.extendExpireTimePlus10Minutes();
            }
        }
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        m_maxDeploys = ServerEngine.getInstance().getServerProps().getMaxDeployThreads();
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        this.m_threadPool.shutdownNow();
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

