/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import java.io.File;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;

public class DeploymentZipFile
extends File {
    private static final long serialVersionUID = 1L;
    private String binPackageName = null;
    private boolean isAgentSpecificFileInside = false;
    private AtomicInteger deploymentTaskCount = new AtomicInteger(0);
    private long maxReuseTime = 0L;

    public DeploymentZipFile(File parent, String child) {
        super(parent, child);
    }

    public DeploymentZipFile(String parent, String child) {
        super(parent, child);
    }

    public DeploymentZipFile(String pathname) {
        super(pathname);
    }

    private DeploymentZipFile(URI uri) {
        super(uri);
    }

    public int trackDeployClient() {
        return this.deploymentTaskCount.incrementAndGet();
    }

    public int getTrackingCount() {
        return this.deploymentTaskCount.get();
    }

    @Override
    public boolean delete() {
        this.deploymentTaskCount.decrementAndGet();
        return true;
    }

    @Override
    public void deleteOnExit() {
    }

    public boolean deleteForced() {
        return super.delete();
    }

    public String getBinPackageName() {
        return this.binPackageName;
    }

    public void setBinPackageName(String binPackageName) {
        this.binPackageName = binPackageName;
    }

    public boolean isAgentSpecificFileInside() {
        return this.isAgentSpecificFileInside;
    }

    public void setAgentSpecificFileInside(boolean isAgentSpecificFileInside) {
        this.isAgentSpecificFileInside = isAgentSpecificFileInside;
    }

    public long getMaxReuseTime() {
        return this.maxReuseTime;
    }

    public void touch() {
        this.maxReuseTime = System.currentTimeMillis() + 60000L;
    }
}

