/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.db.AnnotationInsertTask;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBException;
import com.blixx.shared.Annotation;
import com.blixx.shared.IEvent;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EventOperationsOutage
extends EventOperations {
    public EventOperationsOutage(ServerEngine se, DB db, boolean init) {
        super(se, db, init);
    }

    @Override
    public void init() {
        if (this.m_db == null) {
            return;
        }
        long start = System.currentTimeMillis();
        HashMap<String, SEventFwd> idToDelete = new HashMap<String, SEventFwd>();
        this.m_failedToInsertOrUpdate = this.m_db.loadFromFile();
        for (SEventFwd sef : this.m_failedToInsertOrUpdate) {
            idToDelete.put(sef.getID(), sef);
            switch (sef.getState()) {
                case '-': {
                    this.m_activeAndInsertedAsClosed.put(sef.getID(), sef);
                    break;
                }
                case 'A': 
                case 'O': {
                    this.m_closed.put(sef.getID(), sef);
                    break;
                }
            }
        }
        this.m_db.deleteInDBSpecial(idToDelete);
        this.m_activeAndInsertedAsClosed = this.m_db.readActiveMessages(this.m_serverEngine.getForwardManager(), this, this.m_activeAndInsertedAsClosed);
        RTLogger.print(5, "{DBO}**KeysSize " + this.m_msgkeys.size() + " **ActiveInd " + this.m_activeAndInsertedAsClosed.size());
        RTLogger.print(3, "{DBO}EvReadActiveDBTime=" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.m_closed = this.m_db.readAcknowledgedMessages(this.m_serverEngine.getForwardManager(), this, this.m_closed);
        RTLogger.print(3, "{DBO}EvReadAcknDBTime=" + (System.currentTimeMillis() - start));
    }

    @Override
    public void changeMonHosts(int ch, SEventFwd se, boolean skipMsgKey) {
        super.changeMonHosts(ch, se, skipMsgKey);
    }

    public void submitNewMessage(SEventFwd sef, AgentCard ac) {
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(1);
        list.add(sef);
        if (this.m_serverEngine.getForwardManager() != null) {
            this.m_serverEngine.getForwardManager().checkAll(sef, true, false);
        }
        super.submitNewMessage(list, ac);
    }

    @Override
    public void submitNewMessage(List<SEventFwd> messages, AgentCard ac) {
        for (SEventFwd sef : messages) {
            this.m_serverEngine.getForwardManager().checkAll(sef, true, false);
        }
        super.submitNewMessage(messages, ac);
    }

    @Override
    public void submitFwdMessage(List<SEventFwd> messages, SlaveServerCard ssc) {
        boolean closeOnSlave = ssc.getScenario() <= 2;
        Collections.sort(messages, this.m_AscComparator);
        LinkedList<String> ids = new LinkedList<String>();
        for (int i = 0; i < messages.size(); ++i) {
            SEventFwd event = messages.get(i);
            boolean isClosed = this.submitFwdMessage(event);
            if (!closeOnSlave || !isClosed) continue;
            ids.add(event.getID());
        }
        try {
            if (ids.size() > 0) {
                try {
                    ssc.getServerClient().start("ACKN_MSG_O", null, ids.toArray(new String[0]));
                }
                catch (Throwable i) {
                    // empty catch block
                }
            }
        }
        catch (DBException e) {
            throw e;
        }
        finally {
            RTLogger.print(6, "Active message count = " + this.getActiveMessagesCount());
        }
    }

    public void cloneEvent(SEventFwd sef) {
        if (sef != null) {
            SEventFwd sef2 = new SEventFwd(sef);
            sef2.m_CustomAttributes.putAll(sef.m_CustomAttributes);
            sef2.setID(sef2.getID().replace('-', '.'));
            this.setNew(sef2);
            this.getClientProxyMgr().addToClientCachesNoForwardAction(sef2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveDBdata() {
        if (this.m_db == null) {
            this.m_DBnewORupdate.clear();
            this.m_DBnewORupdateEXT.clear();
            this.m_DBUpdateDuplicateCounts.clear();
            this.m_DBacknByNewMsg.clear();
            this.m_DBsetDeleted.clear();
            this.m_DBannotations.clear();
            this.m_DBOnlyDeleteNOArchive.clear();
            return;
        }
        LinkedHashMap<String, SEventFwd> setDeletedSnapshot = new LinkedHashMap<String, SEventFwd>(this.m_DBsetDeleted);
        setDeletedSnapshot.keySet().removeAll(this.m_DBnewORupdate.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBnewORupdateEXT.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBacknByNewMsg.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBUpdateDuplicateCounts.keySet());
        int ll = 5;
        if (this.m_DBnewORupdate.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO Active " + this.m_DBnewORupdate.size());
            }
            Map<String, SEventFwd> toExtProcessing = this.m_db.saveEvents(this.m_DBnewORupdate);
            this.markAsNewEXTInDB(toExtProcessing);
        }
        if (this.m_DBnewORupdateEXT.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO ActiveExt " + this.m_DBnewORupdateEXT.size());
            }
            this.m_db.saveEventsExt(this.m_DBnewORupdateEXT);
        }
        if (this.m_DBUpdateDuplicateCounts.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO dupl " + this.m_DBUpdateDuplicateCounts.size());
            }
            this.m_db.updateActiveDuplicates(this.m_DBUpdateDuplicateCounts);
        }
        if (this.m_DBacknByNewMsg.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO Closed " + this.m_DBacknByNewMsg.size());
            }
            this.m_db.acknowledgeMessagesByMsg(this.m_DBacknByNewMsg);
        }
        if (setDeletedSnapshot.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO set Deleted " + setDeletedSnapshot.size());
            }
            this.m_DBsetDeleted.keySet().removeAll(setDeletedSnapshot.keySet());
            try {
                this.m_db.archiveInDB(setDeletedSnapshot);
            }
            finally {
                if (setDeletedSnapshot.size() > 0) {
                    this.m_DBsetDeleted.putAll(setDeletedSnapshot);
                }
            }
        }
        if (this.m_DBOnlyDeleteNOArchive.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO Delete(proxy0) " + this.m_DBOnlyDeleteNOArchive.size());
            }
            this.m_db.deleteInDB(this.m_DBOnlyDeleteNOArchive);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DBO Delete(proxy0) done");
            }
        }
        if (this.m_failedToInsertOrUpdate.size() > 0 || this.m_failedToInsertOrUpdateSAVETrigger.get()) {
            this.m_db.tryInsertEvent(this.m_failedToInsertOrUpdate, this.m_failedToInsertOrUpdateSAVETrigger);
        }
        if (this.m_DBannotations.size() > 0 && !AnnotationInsertTask.m_lock.isWriteLocked()) {
            Thread annInsThread = new Thread((Runnable)this.m_annInsTask, "OAnnoIns");
            annInsThread.start();
        }
    }

    @Override
    void dBdown(DBException dbe) {
        if (this.m_DBConnectionOK.compareAndSet(true, false)) {
            SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "DBO", "RUNTIME", "DB Error: " + dbe.getMessage());
            sm.setKey("BOOM_SERVER:RUNTIME:DB:ERROR");
            sm.setCloseMask("BOOM_SERVER:RUNTIME:DB:<*>");
            this.submitNewMessageInternal(sm);
        }
    }

    @Override
    void dBup() {
        if (this.m_DBConnectionOK.compareAndSet(false, true)) {
            SEventFwd sm = SMessage.createMessage(1, 1, "BOOM_SERVER", "DBO", "RUNTIME", "Server DB is online");
            sm.setKey("BOOM_SERVER:RUNTIME:DB:CLEAR");
            sm.setCloseMask("BOOM_SERVER:RUNTIME:DB:<*>");
            this.submitNewMessageInternal(sm);
        }
    }

    public void archive2(List<String> messageIDs, boolean deleteOnly) {
        if (deleteOnly) {
            this.markToDelete(messageIDs);
        } else {
            this.markToSetDeleted(messageIDs);
        }
        this.updateClosed(messageIDs);
    }

    public void moveToActive(EventOperations targetRepo, List<SEventFwd> events) {
        for (SEventFwd sef : events) {
            targetRepo.acknowledgeLastBeforeOutage(sef);
            targetRepo.setNew(sef);
            targetRepo.getClientProxyMgr().addToClientCachesNoForwardAction(sef);
        }
    }

    public void moveToClosed(EventOperations targetRepo, List<SEventFwd> events) {
        for (SEventFwd sef : events) {
            targetRepo.acknowledgeLastBeforeOutage(sef);
            targetRepo.setClosedPublishedFromOutage(sef);
            targetRepo.getClientProxyMgr().addToClientCachesNoForwardAction(sef);
        }
    }

    public void archive3(String policyID) {
        try {
            List<String> ids = this.getActiveIDs(policyID, false);
            this.markToDelete(ids);
            this.updateClosed(ids);
            List<String> ids2 = this.getClosedIDs(policyID, false);
            this.markToDelete(ids2);
            this.updateClosed(ids2);
        }
        catch (Throwable e) {
            RTLogger.print(4, "", e);
        }
    }

    public List<String> getActiveIDs(String policyID, boolean markLocked) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Map.Entry entry : this.m_activeAndInsertedAsClosed.entrySet()) {
            String t8;
            if (((SEventFwd)entry.getValue()).getState() != '-' || (t8 = ((SEventFwd)entry.getValue()).getT8()) == null || !t8.contains(policyID)) continue;
            if (markLocked) {
                ((SEventFwd)entry.getValue()).setLockedFlag(true);
            }
            ids.add((String)entry.getKey());
        }
        return ids;
    }

    public List<String> getActiveAndInsertedAsClosedIDs(String policyID, boolean markLocked) {
        LinkedList<SEventFwd> events = new LinkedList<SEventFwd>();
        for (Map.Entry entry : this.m_activeAndInsertedAsClosed.entrySet()) {
            String t8 = ((SEventFwd)entry.getValue()).getT8();
            if (t8 == null || !t8.contains(policyID)) continue;
            if (markLocked) {
                ((SEventFwd)entry.getValue()).setLockedFlag(true);
            }
            events.add((SEventFwd)entry.getValue());
        }
        Collections.sort(events, this.m_AscComparator);
        ArrayList<String> ids = new ArrayList<String>(events.size());
        for (SEventFwd sef : events) {
            ids.add(sef.getID());
        }
        return ids;
    }

    public List<String> getClosedIDs(String policyID, boolean markLocked) {
        String t8;
        LinkedList<String> ids = new LinkedList<String>();
        for (Map.Entry entry : this.m_closed.entrySet()) {
            t8 = ((SEventFwd)entry.getValue()).getT8();
            if (t8 == null || !t8.contains(policyID)) continue;
            if (markLocked) {
                ((SEventFwd)entry.getValue()).setLockedFlag(true);
            }
            ids.add((String)entry.getKey());
        }
        for (Map.Entry entry : this.m_activeAndInsertedAsClosed.entrySet()) {
            if (((SEventFwd)entry.getValue()).getState() == '-' || (t8 = ((SEventFwd)entry.getValue()).getT8()) == null || !t8.contains(policyID)) continue;
            ids.add((String)entry.getKey());
        }
        return ids;
    }

    public List<String> getClosed_ButNoInsertedAsClosedIDs(String policyID, boolean markLocked) {
        LinkedList<SEventFwd> events = new LinkedList<SEventFwd>();
        for (Map.Entry entry : this.m_closed.entrySet()) {
            events.add((SEventFwd)entry.getValue());
            String t8 = ((SEventFwd)entry.getValue()).getT8();
            if (t8 == null || !t8.contains(policyID) || !markLocked) continue;
            ((SEventFwd)entry.getValue()).setLockedFlag(true);
        }
        Collections.sort(events, this.m_AscComparator);
        ArrayList<String> ids = new ArrayList<String>(events.size());
        for (SEventFwd sef : events) {
            ids.add(sef.getID());
        }
        return ids;
    }

    @Override
    protected void startAA(IEvent mv, AgentCard ac) {
        Annotation ann = new Annotation("Remote action can't be processed during Outage.", System.currentTimeMillis(), "AAF");
        this.markToSaveAnnotations(mv.getID(), ann);
        this.setAnnotationFlag(mv.getID());
    }
}

