/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.sa.FA;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.GUIClientProxy;
import com.blixx.server.GUIClientProxyMgr;
import com.blixx.server.IEventProcessor;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.correlation.AgentOutageManager;
import com.blixx.server.correlation.CorrelationEvents;
import com.blixx.server.correlation.ExternalHostsDropProcessor;
import com.blixx.server.correlation.IServerCorrelationProcessor;
import com.blixx.server.correlation.ModifyIndicationManager;
import com.blixx.server.correlation.OutageManager;
import com.blixx.server.db.DB;
import com.blixx.shared.Annotation;
import com.blixx.shared.IUiNotificator;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EventsRouter
implements IEventProcessor,
IUiNotificator {
    EventOperations eo = null;
    EventOperationsOutage eoOutage = null;
    ModifyIndicationManager modifyMgr = null;
    AgentOutageManager agentOutageMgr = null;
    OutageManager outageMgr = null;
    List<IServerCorrelationProcessor> processors = new ArrayList<IServerCorrelationProcessor>();
    private final Thread awaitServerPolicies;
    private String serverPoliciesDirectory = "srv/srv_policies";

    public EventsRouter(ServerEngine se, String serverPoliciesDirectory) {
        if (serverPoliciesDirectory != null) {
            this.serverPoliciesDirectory = serverPoliciesDirectory;
        }
        this.eo = new EventOperations(se, se.getDB(), true);
        try {
            this.modifyMgr = new ModifyIndicationManager(this, this.serverPoliciesDirectory);
            this.processors.add(this.modifyMgr);
        }
        catch (Exception e) {
            RTLogger.print(1, "ModifyIndication Mgr initialization error", e);
        }
        this.processors.add(new ExternalHostsDropProcessor(se.getAgentRepository()));
        DB dbOutage = se.getDB_OUTAGE();
        if (dbOutage != null) {
            this.eoOutage = new EventOperationsOutage(se, dbOutage, true);
            try {
                this.agentOutageMgr = new AgentOutageManager(this.eoOutage);
                this.processors.add(this.agentOutageMgr);
            }
            catch (Exception e) {
                RTLogger.print(1, "Agent Outage Mgr initialization error", e);
            }
            try {
                this.outageMgr = new OutageManager(this.eoOutage, this.serverPoliciesDirectory);
                this.processors.add(this.outageMgr);
            }
            catch (Exception e) {
                RTLogger.print(1, "Outage Mgr initialization error", e);
            }
        }
        this.awaitServerPolicies = new Thread((Runnable)this.modifyMgr, "AwaitPoliciesChecker");
        this.awaitServerPolicies.start();
    }

    public EventOperations getEventOperations() {
        return this.eo;
    }

    public EventOperationsOutage getEventOperationsOutage() {
        return this.eoOutage;
    }

    public OutageManager getOutageMgr() {
        return this.outageMgr;
    }

    public AgentOutageManager getAgentOutageMgr() {
        return this.agentOutageMgr;
    }

    public ModifyIndicationManager getModifyIndicationMgr() {
        return this.modifyMgr;
    }

    public void stop() {
        if (this.awaitServerPolicies != null && !this.awaitServerPolicies.isInterrupted()) {
            try {
                this.awaitServerPolicies.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.awaitServerPolicies.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void acknowledge2(List<String> messageIDs, String operator) {
        List<String> toOutage;
        if (messageIDs == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents(messageIDs)).isEmpty()) {
            this.eoOutage.acknowledge2(toOutage, operator);
        }
        if (!messageIDs.isEmpty()) {
            this.eo.acknowledge2(messageIDs, operator);
        }
    }

    protected List<String> splitOutageEvents(Collection<String> messageIDs) {
        LinkedList<String> toOutage = new LinkedList<String>();
        Iterator<String> it = messageIDs.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (this.eoOutage.getEvent(id) == null) continue;
            it.remove();
            toOutage.add(id);
        }
        return toOutage;
    }

    @Override
    public void acknowledgeFwd(String ID, char state, String t9Attr) {
        this.eo.acknowledgeFwd(ID, state, t9Attr);
        if (this.eoOutage != null) {
            this.eoOutage.acknowledgeFwd(ID, state, t9Attr);
        }
    }

    @Override
    public void acknowledgeFwd(List<SEventFwd> list, SlaveServerCard ssc) {
        List<SEventFwd> toOutage;
        if (list == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents2(list)).isEmpty()) {
            this.eoOutage.acknowledgeFwd(toOutage, ssc);
        }
        if (!list.isEmpty()) {
            this.eo.acknowledgeFwd(list, ssc);
        }
    }

    protected List<SEventFwd> splitOutageEvents2(List<SEventFwd> list) {
        LinkedList<SEventFwd> toOutage = new LinkedList<SEventFwd>();
        LinkedList<String> toArchiveOutage = new LinkedList<String>();
        Iterator<SEventFwd> it = list.iterator();
        while (it.hasNext()) {
            SEventFwd sef = it.next();
            if ("R".equals(sef.getT8())) {
                sef.m_CustomAttributes.remove("T8");
                toArchiveOutage.add(sef.getID());
                continue;
            }
            if (this.eoOutage.getEvent(sef.getID()) == null) continue;
            toOutage.add(sef);
            it.remove();
        }
        this.getEventOperationsOutage().archive2((List<String>)toArchiveOutage, true);
        return toOutage;
    }

    @Override
    public void archive2(Collection<String> messageIDs, boolean deleteOnly) {
        List<String> toOutage;
        if (messageIDs == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents(messageIDs)).isEmpty()) {
            this.eoOutage.archive2(toOutage, deleteOnly);
        }
        if (!messageIDs.isEmpty()) {
            this.eo.archive2(messageIDs, deleteOnly);
        }
    }

    @Override
    public SEventFwd getAcknowledged(String id) {
        SEventFwd sef = this.eo.getAcknowledged(id);
        if (sef == null) {
            sef = this.eoOutage.getAcknowledged(id);
        }
        return sef;
    }

    @Override
    public SEventFwd getActive(String id) {
        SEventFwd sef = this.eo.getActive(id);
        if (sef == null) {
            sef = this.eoOutage.getActive(id);
        }
        return sef;
    }

    @Override
    public SEventFwd getEvent(String id) {
        SEventFwd sef = this.eo.getEvent(id);
        if (sef == null) {
            sef = this.eoOutage.getEvent(id);
        }
        return sef;
    }

    @Override
    public boolean isAvailable() {
        return this.getEventOperations().isAvailable();
    }

    @Override
    public void reopenIndi(List<String> ids, String user) {
        List<String> toOutage;
        if (ids == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents(ids)).isEmpty()) {
            this.eoOutage.reopenIndi(toOutage, user);
        }
        if (!ids.isEmpty()) {
            this.eo.reopenIndi(ids, user);
        }
    }

    @Override
    public void setAlertFinished(List<FA> fas) {
        List<FA> toOutage;
        if (fas == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents3(fas)).isEmpty()) {
            this.eoOutage.setAlertFinished(fas);
        }
        if (!fas.isEmpty()) {
            this.eo.setAlertFinished(fas);
        }
    }

    protected List<FA> splitOutageEvents3(List<FA> fas) {
        LinkedList<FA> toOutage = new LinkedList<FA>();
        Iterator<FA> it = fas.iterator();
        while (it.hasNext()) {
            FA fa = it.next();
            if (this.eoOutage.getEvent(fa.m_uuid) == null) continue;
            toOutage.add(fa);
            it.remove();
        }
        return toOutage;
    }

    @Override
    public void submitFwdMessage(List<SEventFwd> messages, SlaveServerCard ssc) {
        List<SEventFwd> toOutage;
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents2(messages)).isEmpty()) {
            this.eoOutage.updateEvents(toOutage, true);
        }
        Iterator<SEventFwd> it = messages.iterator();
        block0: while (it.hasNext()) {
            SEventFwd sEventFwd = it.next();
            for (IServerCorrelationProcessor processor : this.processors) {
                if (processor == null || !processor.checkAndProcessInternal(sEventFwd) || !processor.isStopProcessing() && sEventFwd.getState() != 'D') continue;
                it.remove();
                continue block0;
            }
        }
        if (ssc.getScenario() <= 2) {
            ssc.scheduleArchiveIndiCMD();
        }
        this.eo.submitFwdMessage(messages, ssc);
    }

    @Override
    public void submitNewMessage(List<SEventFwd> messages, AgentCard ac) {
        long tstart = System.currentTimeMillis();
        Iterator<SEventFwd> it = messages.iterator();
        block0: while (it.hasNext()) {
            SEventFwd sEventFwd = it.next();
            for (IServerCorrelationProcessor processor : this.processors) {
                if (processor == null || !processor.checkAndProcess(sEventFwd, ac) || !processor.isStopProcessing() && sEventFwd.getState() != 'D') continue;
                it.remove();
                continue block0;
            }
        }
        this.eo.submitNewMessage(messages, ac, tstart);
    }

    @Override
    public void submitNewMessageInternal(SEventFwd mv) {
        if (!mv.getDeduplication() && !mv.getDeDuplicationKeyOnly()) {
            mv.setDeduplication(true);
        }
        for (IServerCorrelationProcessor processor : this.processors) {
            if (processor == null || !processor.checkAndProcessInternal(mv) || !processor.isStopProcessing() && mv.getState() != 'D') continue;
            return;
        }
        this.eo.submitNewMessageInternal(mv);
    }

    @Override
    public List<String> updateEvents(List<SEventFwd> events, boolean fromSlave) {
        List<String> ids2;
        List<SEventFwd> toOutage;
        List<String> ids = new ArrayList<String>();
        if (events == null) {
            return new ArrayList<String>(1);
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents2(events)).isEmpty()) {
            ids = this.eoOutage.updateEvents(toOutage, fromSlave);
        }
        if (!events.isEmpty() && (ids2 = this.eo.updateEvents(events, fromSlave)) != null) {
            ids.addAll(ids2);
        }
        return ids;
    }

    @Override
    public void updateEventsManual(List<SEventFwd> events, String user) {
        List<SEventFwd> toOutage;
        if (events == null) {
            return;
        }
        if (this.eoOutage != null && this.eoOutage.getMessagesCount() > 0 && !(toOutage = this.splitOutageEvents2(events)).isEmpty()) {
            this.eoOutage.updateEventsManual(toOutage, user);
        }
        if (!events.isEmpty()) {
            this.eo.updateEventsManual(events, user);
        }
    }

    @Override
    public void addPendingToALL(CMD cmd) {
        this.getClientProxyMgr().addPendingToALL(cmd);
    }

    public GUIClientProxyMgr getClientProxyMgr() {
        return this.eo.getClientProxyMgr();
    }

    @Override
    public void addPendingToALL(String cmdsCommand) {
        CMD cmd = new CMD(cmdsCommand, null, null);
        this.getClientProxyMgr().addPendingToALL(cmd);
    }

    @Override
    public boolean addPendingToUser(CMD cmd, String user) {
        boolean foundUser = false;
        GUIClientProxy clientCache = this.getClientProxyMgr().getClientCache(user);
        if (clientCache != null) {
            clientCache.addPending(cmd);
            foundUser = true;
        }
        return foundUser;
    }

    @Override
    public boolean addPendingToUser(String cmdsCommand, String user) {
        boolean foundUser = false;
        CMD cmd = new CMD(cmdsCommand, null, null);
        GUIClientProxy clientCache = this.getClientProxyMgr().getClientCache(user);
        if (clientCache != null) {
            clientCache.addPending(cmd);
            foundUser = true;
        }
        return foundUser;
    }

    public EventOperations detectEventOperations(String messageID) {
        if (this.getEventOperations().getEvent(messageID) != null) {
            return this.getEventOperations();
        }
        if (this.getEventOperationsOutage() != null && this.getEventOperationsOutage().getEvent(messageID) != null) {
            return this.getEventOperationsOutage();
        }
        return null;
    }

    @Override
    public List<String> getAnnotations(String messageID) {
        EventOperations eventsOp = this.detectEventOperations(messageID);
        if (eventsOp != null) {
            return eventsOp.getAnnotations(messageID);
        }
        return this.getEventOperations().getAnnotations(messageID);
    }

    @Override
    public void markToSaveAnnotations(String messageID, Annotation ann) {
        EventOperations eventsOp = this.detectEventOperations(messageID);
        if (eventsOp != null) {
            eventsOp.markToSaveAnnotations(messageID, ann);
        }
    }

    @Override
    public void markToSaveAnnotations(String messageID, List<Annotation> listOfAnnotations) {
        EventOperations eventsOp = this.detectEventOperations(messageID);
        if (eventsOp != null) {
            eventsOp.markToSaveAnnotations(messageID, listOfAnnotations);
        }
    }

    @Override
    public void setAnnotationFlag(String messageID) {
        EventOperations eventsOp = this.detectEventOperations(messageID);
        if (eventsOp != null) {
            eventsOp.setAnnotationFlag(messageID);
        }
    }

    public void notifyNodeGroupChange() {
        for (IServerCorrelationProcessor processor : this.processors) {
            processor.onEvent(CorrelationEvents.NODEGROUP_CHANGE);
        }
        ServerEngine.getInstance().getSlaveServerFactory().pushNodeGroupsToSlaves();
    }
}

