/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentCloseSocket;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.ServerEngine;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Objects;

public class FileTransfer
extends RemoteCmdClient {
    public String m_remoteFile = null;
    public String m_localFile = null;

    public FileTransfer(AgentCard ac, String command, String source, String target, int timeoutSeconds) {
        super('C', ac, command, timeoutSeconds);
        if (command.startsWith("GET")) {
            this.m_remoteFile = source;
            this.m_localFile = target;
        } else {
            this.m_localFile = source;
            this.m_remoteFile = target;
        }
    }

    @Override
    public AgentCard getAgentCard() {
        return this.m_card;
    }

    @Override
    public void processRemote(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
        block16: {
            File local = new File(this.m_localFile);
            this.er.resultCode = -1;
            os.write(67);
            os.writeUTF(this.m_cmd + "=" + this.m_remoteFile);
            if (this.m_cmd.equals("GETFILE")) {
                long size = is.readLong();
                if (size == -1L) {
                    this.er.resultCode = 404;
                    this.er.m_errorMessages.add("Remote file not found: " + this.m_remoteFile);
                } else {
                    try {
                        if (Files.exists(local.toPath(), new LinkOption[0])) {
                            throw new IOException("Local file already exist: " + this.m_localFile);
                        }
                        if (is.readFile(this.m_localFile)) {
                            this.er.m_outMessages.add(this.m_localFile);
                            this.er.resultCode = 0;
                            break block16;
                        }
                        this.er.resultCode = 1;
                        this.er.m_errorMessages.add("Error getting remote file: " + this.m_remoteFile);
                    }
                    catch (Throwable e) {
                        this.er.resultCode = 2;
                        String message = e.getMessage();
                        this.er.m_errorMessages.add(Objects.requireNonNullElseGet(message, () -> e.getClass().toString()));
                    }
                }
            } else if (this.m_cmd.equals("PUTFILE")) {
                try (FileInputStream fis = new FileInputStream(local);){
                    os.writeFile(fis);
                    this.er.resultCode = is.read();
                    this.er.m_outMessages.add(this.m_localFile);
                }
                catch (Throwable e) {
                    this.er.resultCode = 1;
                    String message = e.getMessage();
                    this.er.m_errorMessages.add(Objects.requireNonNullElseGet(message, () -> e.getClass().toString()));
                }
            }
        }
        this.isReady = true;
    }

    @Override
    public void sendToFirewalled(Socket socket) {
        try {
            socket.setSoTimeout(this.m_timeoutSeconds * 1000 + 3000);
            this.m_closeSocketAtTheEnd = false;
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 1);
        }
        catch (Throwable e) {
            RTLogger.print(5, "error setting timeout for remote action.", e);
        }
        try {
            this.processRemote(this.m_is, this.m_os, this.m_card);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void openStreams() throws IOException, AgentCloseSocket {
        this.m_socket = SocketUtils.getNewSocket(this.m_timeoutSeconds * 1000 + 3000);
        try {
            InetSocketAddress agentAddrByHost = new InetSocketAddress(this.m_card.getAgentHost(), this.m_card.getAgentPort());
            if (agentAddrByHost.isUnresolved()) {
                throw new RuntimeException("Change to IP");
            }
            this.m_socket.connect(agentAddrByHost, 10000);
        }
        catch (Throwable e) {
            SocketUtils.closeSocket(this.m_socket, new AutoCloseable[0]);
            this.m_socket = SocketUtils.getNewSocket(this.m_timeoutSeconds * 1000 + 3000);
            this.m_socket.connect(new InetSocketAddress(this.m_card.getAgentIP(), this.m_card.getAgentPort()), 10000);
        }
        try {
            if (this.m_card.isTlsAgent()) {
                this.m_socket = TlsUtils.upgradeClientSocket(this.m_socket, ServerEngine.getInstance().getCertificateManager());
            }
            this.m_is = new SDataInputStream(this.m_socket.getInputStream());
            this.m_os = new SDataOutputStream(this.m_socket.getOutputStream(), this.m_card.getProtocolVersion());
        }
        catch (Exception e) {
            throw new AgentCloseSocket();
        }
    }

    private void closeStreams() {
        SocketUtils.closeSocket(this.m_socket, this.m_os, this.m_is);
    }

    @Override
    public void setInputOutput(SDataInputStream is, SDataOutputStream os) {
        this.m_os = os;
        this.m_is = is;
    }

    @Override
    public void run() {
        try {
            if (this.m_is == null) {
                this.openStreams();
            }
            this.processRemote(this.m_is, this.m_os, this.m_card);
        }
        catch (Throwable e) {
            this.er.resultCode = -2;
            this.er.m_errorMessages.add("Communication error: " + e.getMessage());
            RTLogger.print(1, "Comminication error.", e);
        }
        finally {
            this.closeStreams();
            this.isReady = true;
        }
    }
}

