/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.EventOperations;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.SAssignmentRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.correlation.AgentOutageManager;
import com.blixx.server.correlation.ModifyIndicationManager;
import com.blixx.server.correlation.OutageManager;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.Assignment;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.SEventFwdCompare;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.Diff;
import com.boom.server.AgentAfoB2BList;
import com.boom.server.AgentCardB2B;
import com.boom.server.AgentCardB2BList;
import com.boom.server.AgentOutagesB2B;
import com.boom.server.AssignmentsB2B;
import com.boom.server.ModifyServerPoliciesB2B;
import com.boom.server.ServerOutagesB2B;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GUIBackupSlaveMethods {
    public static final int AGENTS = 1;
    public static final int AGENT_OUTAGES = 2;
    public static final int SERVER_OUTAGES = 3;
    public static final int MODIFY_POLICIES = 4;
    public static final int AGENTS_FIREWALLED_ONLINE = 5;
    public static final int ASSIGNMENTS = 10;
    public static final int INDICATIONS = 20;
    public static final int INDICATIONS_UPDATES = 21;

    public static void processOutages(SDataInputStream in, SDataOutputStream out, String user) throws IOException {
        try {
            int typeOfData = in.readInt();
            switch (typeOfData) {
                case 20: {
                    GUIBackupSlaveMethods.processFullIndiSync(in, out, ServerEngine.getInstance().getEventsRouter().getEventOperations(), ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 21: {
                    GUIBackupSlaveMethods.processIndiUpdates(out, in, ServerEngine.getInstance().getEventsRouter().getEventOperations());
                    GUIBackupSlaveMethods.processIndiUpdates(out, in, ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 1: {
                    String json = in.readUTF();
                    GUIBackupSlaveMethods.processAgents(json, user);
                    out.writeUTF("T");
                    break;
                }
                case 5: {
                    String jsonAfo = in.readUTF();
                    GUIBackupSlaveMethods.processAfo(jsonAfo);
                    out.writeUTF("T");
                    break;
                }
                case 10: {
                    String json1 = in.readUTF();
                    GUIBackupSlaveMethods.processAssignments(json1, user);
                    out.writeUTF("T");
                    break;
                }
                default: {
                    String json2 = in.readUTF();
                    boolean isUnknownType = GUIBackupSlaveMethods.processOutages(typeOfData, json2, user);
                    if (isUnknownType) {
                        out.writeUTF("Unknown type=" + typeOfData);
                        break;
                    }
                    out.writeUTF("T");
                    break;
                }
            }
        }
        catch (Exception e) {
            out.writeUTF(e.getMessage() == null ? "F" : e.getMessage());
        }
    }

    public static void processFullIndiSync(SDataInputStream in, SDataOutputStream out, EventOperations eventOperations, EventOperationsOutage eventOperationsOutage) throws IOException {
        Set<String> processedIDs = GUIBackupSlaveMethods.processIndis(in, out, eventOperations::getEvent, eventOperations::submitFromPrimaryActive, true);
        Set<String> processedClosedIDs = GUIBackupSlaveMethods.processIndis(in, out, eventOperations::getEvent, eventOperations::submitFromPrimaryClosed, true);
        Set<String> notProcessed = Stream.concat(eventOperations.getActiveAndInsertedAsClosedStream(), eventOperations.getClosedStream()).filter(s -> "P".equals(s.getSrvtype())).map(SEvent::getID).filter(id -> !processedIDs.contains(id) && !processedClosedIDs.contains(id)).collect(Collectors.toSet());
        eventOperations.archive2(notProcessed, true);
        Set<String> processedIDsOutage = GUIBackupSlaveMethods.processIndis(in, out, eventOperationsOutage::getEvent, eventOperationsOutage::submitFromPrimaryActive, true);
        Set<String> processedClosedIDsOutage = GUIBackupSlaveMethods.processIndis(in, out, eventOperationsOutage::getEvent, eventOperationsOutage::submitFromPrimaryClosed, true);
        Set<String> notProcessedOutage = Stream.concat(eventOperationsOutage.getActiveAndInsertedAsClosedStream(), eventOperationsOutage.getClosedStream()).filter(s -> "P".equals(s.getSrvtype())).map(SEvent::getID).filter(id -> !processedIDsOutage.contains(id) && !processedClosedIDsOutage.contains(id)).collect(Collectors.toSet());
        eventOperationsOutage.archive2(notProcessedOutage, true);
    }

    public static void processIndiUpdates(SDataOutputStream os, SDataInputStream is, EventOperations eo) throws Exception {
        SEventFwd sef;
        String serverName = is.readUTF();
        int placeholderCount = is.readInt();
        while (is.readBoolean()) {
            sef = new SEventFwd();
            sef.readSv2(is);
            eo.submitFromPrimaryActive(sef, serverName);
        }
        os.writeUTF("T");
        placeholderCount = is.readInt();
        while (is.readBoolean()) {
            sef = new SEventFwd();
            sef.readSv2(is);
            eo.submitFromPrimaryActive(sef, serverName);
        }
        os.writeUTF("T");
        placeholderCount = is.readInt();
        while (is.readBoolean()) {
            String id = null;
            String input = is.readUTF();
            char state = 'A';
            String t9Attr = null;
            if (input.length() > 36) {
                id = input.substring(0, 36);
                state = input.charAt(36);
                if (input.length() > 37) {
                    t9Attr = input.substring(37);
                }
            } else {
                id = input;
            }
            eo.acknowledgeFwd(id, state, t9Attr);
        }
        os.writeUTF("T");
        ArrayList<String> idsToArchive = new ArrayList<String>(500);
        placeholderCount = is.readInt();
        while (is.readBoolean()) {
            idsToArchive.add(is.readUTF());
        }
        os.writeUTF("T");
        eo.archive2(idsToArchive, false);
    }

    public static boolean processOutages(int typeOfData, String json, String user) {
        boolean isUnknownType = false;
        switch (typeOfData) {
            case 2: {
                GUIBackupSlaveMethods.processAgentOutages(json, user);
                break;
            }
            case 3: {
                GUIBackupSlaveMethods.processServerOutages(json, user);
                break;
            }
            case 4: {
                GUIBackupSlaveMethods.processModifyPolicies(json, user);
                break;
            }
            default: {
                isUnknownType = true;
            }
        }
        return isUnknownType;
    }

    public static void processAgents(String json, String user) throws Exception {
        AgentCardB2BList agents = new GsonBuilder().create().fromJson(json, AgentCardB2BList.class);
        List localList = ServerEngine.getInstance().getAgentRepository().getAgentCards().values().stream().map(AgentCardB2B::new).collect(Collectors.toList());
        Diff<AgentCardB2B> diff = new Diff<AgentCardB2B>(agents.getAgents(), localList);
        diff.newObjects.values().forEach(acb -> {
            try {
                if (acb.getCertificate() != null) {
                    ServerEngine.getInstance().getAgentCertificates().storeSignedCertToTrustStore(acb.getAgentID(), acb.getCertificate().getBytes());
                }
                ServerEngine.getInstance().getAgentRepository().createAgentCard(GUIBackupSlaveMethods.getAsAgentCard(acb), user);
                if (acb.getAttributes() != null) {
                    GUIBackupSlaveMethods.updateACM(acb);
                }
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().warn("Error creating Agent card {}", acb, (Object)e);
            }
        });
        diff.updated.keySet().forEach(acb -> {
            try {
                if (acb.getCertificate() != null) {
                    ServerEngine.getInstance().getAgentCertificates().storeSignedCertToTrustStore(acb.getAgentID(), acb.getCertificate().getBytes());
                }
                ServerEngine.getInstance().getAgentRepository().updateFrom(GUIBackupSlaveMethods.getAsAgentCard(acb), "PRIMARY_SERVER");
                if (acb.getAttributes() != null) {
                    GUIBackupSlaveMethods.updateACM(acb);
                }
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().warn("Error update Agent card {}", acb, (Object)e);
            }
        });
        diff.deletedObjects.keySet().forEach(id -> ServerEngine.getInstance().getAgentRepository().deleteAgent((String)id));
        agents.getAgents().stream().filter(AbstractAgentCard::isFirewalled).filter(AbstractAgentCard::isOnline).map(agentCardB2B -> ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentCardB2B.getAgentID())).filter(Objects::nonNull).forEach(AgentCard::setLastTimeOnline);
    }

    private static void updateACM(AgentCardB2B acb) throws Exception {
        AgentCardCM acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(acb.getAgentID());
        if (acm != null) {
            acm.getAttributes().clear();
            acm.getAttributes().putAll(acm.getAttributes());
        } else {
            acm = new AgentCardCM(acb.getAgentID());
            acm.getAttributes().putAll(acb.getAttributes());
            ServerEngine.getInstance().getAgentRepository().saveAgentCardCM(acm);
        }
    }

    private static void processAgentOutages(String json, String user) {
        AgentOutagesB2B agtOutages = new GsonBuilder().create().fromJson(json, AgentOutagesB2B.class);
        if (agtOutages != null && agtOutages.getAgtOutages() != null) {
            AgentOutageManager agentOutageMgr = ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr();
            ArrayList policies = new ArrayList(agentOutageMgr.getAllPolicies().values());
            Diff<AgentOutagePolicy> diff = new Diff<AgentOutagePolicy>(agtOutages.getAgtOutages(), policies);
            agtOutages.getAgtOutages().stream().filter(pol -> !diff.deletedObjects.containsKey(pol.getID())).forEach(pol -> {
                try {
                    agentOutageMgr.replaceServerPolicy((AgentOutagePolicy)pol);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().warn("Error delete outage id: {}", (Object)pol.getID(), (Object)e);
                }
            });
            diff.deletedObjects.forEach((id, pol) -> {
                try {
                    agentOutageMgr.deletePolicy((String)id);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().warn("Error delete outage id: {}", id, (Object)e);
                }
            });
        }
    }

    private static void processServerOutages(String json, String user) {
        ServerOutagesB2B outages = new GsonBuilder().create().fromJson(json, ServerOutagesB2B.class);
        if (outages != null && outages.getSrvOutages() != null) {
            OutageManager outageMgr = ServerEngine.getInstance().getEventsRouter().getOutageMgr();
            ArrayList policies = new ArrayList(outageMgr.getAllPolicies().values());
            Diff<OutagePolicy> diff = new Diff<OutagePolicy>(outages.getSrvOutages(), policies);
            outages.getSrvOutages().stream().filter(pol -> !diff.deletedObjects.containsKey(pol.getID())).forEach(pol -> {
                try {
                    outageMgr.replaceServerPolicy((OutagePolicy)pol);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().debug("Error add outage policy {}", (Object)pol.getID(), (Object)e);
                }
            });
            diff.deletedObjects.forEach((id, pol) -> {
                try {
                    outageMgr.deletePolicy((String)id);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().debug("Error update outage policy {}", id, (Object)e);
                }
            });
        }
    }

    public static void processModifyPolicies(String json, String user) {
        ModifyServerPoliciesB2B outages = new GsonBuilder().create().fromJson(json, ModifyServerPoliciesB2B.class);
        if (outages != null && outages.getModPolicies() != null) {
            ModifyIndicationManager modifyIndicationMgr = ServerEngine.getInstance().getEventsRouter().getModifyIndicationMgr();
            ArrayList policies = new ArrayList(modifyIndicationMgr.getAllPolicies().values());
            Diff<ExtendedServerPolicy> diff = new Diff<ExtendedServerPolicy>(outages.getModPolicies(), policies);
            outages.getModPolicies().stream().filter(pol -> !diff.deletedObjects.containsKey(pol.getID())).forEach(pol -> {
                try {
                    modifyIndicationMgr.replaceServerPolicy((ExtendedServerPolicy)pol);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().debug("Error add outage policy {}", (Object)pol.getID(), (Object)e);
                }
            });
            diff.deletedObjects.forEach((id, pol) -> {
                try {
                    modifyIndicationMgr.deletePolicy((String)id);
                }
                catch (Exception e) {
                    RTLogger.getStaticLogger().debug("Error update outage policy {}", id, (Object)e);
                }
            });
        }
    }

    public static void processAssignments(String json, String user) {
        AssignmentsB2B payload = new GsonBuilder().create().fromJson(json, AssignmentsB2B.class);
        if (payload != null && payload.getAssignments() != null) {
            SAssignmentRepository repo = ServerEngine.getInstance().getAssignmentRepository();
            List<Assignment> asns = repo.getAssignments();
            Diff<Assignment> diff = new Diff<Assignment>(payload.getAssignments(), asns);
            diff.newObjects.values().forEach(asn -> repo.addAssignment((Assignment)asn, true));
            diff.updated.values().forEach(asn -> repo.addAssignment((Assignment)asn, true));
            AsnDbUpdate adu = new AsnDbUpdate();
            diff.deletedObjects.values().forEach(asn -> repo.deleteAssignment(adu, "PRIMARY_SERVER", asn.getName(), asn.getType(), asn.getAgentID(), true));
            adu.saveDB(ServerEngine.getInstance());
        }
    }

    public static Set<String> processIndis(SDataInputStream is, SDataOutputStream os, Function<String, SEventFwd> eventLookup, BiConsumer<SEventFwd, String> newEventConsumer, boolean isInitSync) throws IOException {
        String serverName = is.readUTF();
        os.writeLong(0L);
        HashSet<String> knownIDs = new HashSet<String>();
        while (is.readBoolean()) {
            HashMap<String, String> idToHash = new HashMap<String, String>();
            while (is.readBoolean()) {
                String id = is.readUTF();
                knownIDs.add(id);
                String hash = is.readUTF();
                idToHash.put(id, hash);
            }
            List idsToRequest = idToHash.entrySet().stream().filter(en -> {
                SEventFwd sef = (SEventFwd)eventLookup.apply((String)en.getKey());
                return sef == null || !SEventFwdCompare.hash(sef).equals(en.getValue());
            }).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!idsToRequest.isEmpty()) {
                RTLogger.getStaticLogger().debug(" Changes in {} indications according to hash", (Object)idsToRequest.size());
                os.writeBoolean(true);
                boolean isRequestAll = 100 * idsToRequest.size() / idToHash.size() > 80;
                os.writeBoolean(isRequestAll);
                if (!isRequestAll) {
                    for (String id : idsToRequest) {
                        os.writeBoolean(true);
                        os.writeUTF(id);
                    }
                    RTLogger.getStaticLogger().trace("asked: {}", (Object)idsToRequest);
                    os.writeBoolean(false);
                }
                while (is.readBoolean()) {
                    SEventFwd sef = new SEventFwd();
                    sef.readSv2(is);
                    newEventConsumer.accept(sef, serverName);
                }
                continue;
            }
            RTLogger.getStaticLogger().trace("Backup need no events");
            os.writeBoolean(false);
        }
        return knownIDs;
    }

    private static void processAfo(String afoJson) {
        AgentAfoB2BList agentsFirewalledOnline = new GsonBuilder().create().fromJson(afoJson, AgentAfoB2BList.class);
        agentsFirewalledOnline.afo.forEach(afo -> {
            AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(afo.id);
            if (ac != null) {
                ac.setModeSilently(8);
                ac.setLastPingFromAgentTimestamp(ac.m_lastTimeUpdatedFromAgent);
            }
        });
    }

    private static AgentCard getAsAgentCard(AgentCardB2B acb) {
        AgentCard ac = new AgentCard(acb.getAgentID(), acb.getAgentHost(), acb.getAgentIP(), acb.getLabel(), acb.getDescription());
        ac.setDisabled(acb.isDisabled());
        ac.setModeSilently(acb.getMode());
        ac.setAgentFlags(acb.getAgentFlags());
        if (acb.isApproved()) {
            ac.setApproved();
        } else {
            ac.setUnApproved();
        }
        ac.setOSName(acb.getOSName());
        ac.setAgentPort(acb.getAgentPort());
        ac.setDefaultMode(acb.getDefaultMode());
        return ac;
    }
}

