/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.GUIWorker;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GUIClientProxy {
    protected ConcurrentLinkedQueue<SEventFwd> m_newQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<String> m_closedQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<SEventFwd> m_updQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<String> m_arcQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<CMD> m_pending = new ConcurrentLinkedQueue();
    protected String m_userLogin = null;
    protected boolean m_isFilteredIndications = false;
    protected Set<String> m_restricted = new HashSet<String>();
    protected UserRole m_userRole = null;
    protected String m_userRoleNameForFilters = "[]";
    protected long m_connectionTime = 0L;
    protected String m_IP = null;

    protected GUIClientProxy() {
    }

    public GUIClientProxy(String login, String IP) {
        this.m_IP = IP;
        this.m_connectionTime = System.currentTimeMillis();
        this.m_userLogin = login;
        this.m_userRole = UserManager.getInstance().getRoleForUser(login);
        if (this.m_userRole != null && !this.m_userRole.getName().equalsIgnoreCase("Administrator")) {
            List<UserRight> list = this.m_userRole.getRights();
            block11: for (int i = 0; i < list.size(); ++i) {
                UserRight ur = list.get(i);
                int item = ur.getItemID();
                int level = ur.getLevel();
                if (level != 1) continue;
                switch (item) {
                    case 1000: {
                        this.m_restricted.add("REFRESH_ACKNMESSAGES");
                        continue block11;
                    }
                    case 1001: {
                        continue block11;
                    }
                    case 1002: {
                        this.m_restricted.add("GETAGENTCARDS");
                        this.m_restricted.add("GETASSIGNED");
                        this.m_restricted.add("GET_AGENT_VERSIONS");
                        this.m_restricted.add("GET_AGENT_INVENTORY_CARD");
                        continue block11;
                    }
                    case 1003: {
                        continue block11;
                    }
                    case 1004: {
                        this.m_restricted.add("GET_USERS");
                        continue block11;
                    }
                    case 1005: {
                        this.m_restricted.add("GETACTIONS");
                        continue block11;
                    }
                    case 1006: {
                        continue block11;
                    }
                    case 1007: {
                        this.m_restricted.add("GETACTIONS");
                        continue block11;
                    }
                    case 1008: {
                        this.m_restricted.add("GET_ALL_ASSIGNMENTS");
                        continue block11;
                    }
                }
            }
        }
        this.m_userRoleNameForFilters = this.m_userRole.getNameInBrackets();
        this.m_isFilteredIndications = ServerEngine.getInstance().getForwardManager().isUserIndicationsFiltered(login) || UserManager.getInstance().isUserNodeGroupFiltered(login);
    }

    public String getUserRoleNameForFilters() {
        return this.m_userRoleNameForFilters;
    }

    public String getUserRoleName() {
        return this.m_userRole.getName();
    }

    public String getUserLogin() {
        return this.m_userLogin;
    }

    public boolean isUserIndicationsFiltered() {
        return this.m_isFilteredIndications;
    }

    public long getConnectionTime() {
        return this.m_connectionTime;
    }

    public String getConnectionTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(this.m_connectionTime));
    }

    public void addPending(CMD cmd) {
        if (cmd == null || this.m_restricted.contains(cmd.m_command)) {
            return;
        }
        try {
            long pt;
            CMD peek = this.m_pending.peek();
            if (peek != null && (pt = peek.getPendingTime()) > 1800000L) {
                GUIWorker.disconnectUser(this.m_userLogin);
                RTLogger.print(4, "30 min no activity. UI session has been disconnected. User:" + this.m_userLogin);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.m_pending.contains(cmd)) {
            this.m_pending.offer(cmd);
        }
    }

    public Queue<CMD> getPending() {
        return this.m_pending;
    }

    public void addNew(SEventFwd e) {
        this.m_newQueue.add(e);
    }

    public void addNew(List<SEventFwd> list) {
        this.m_newQueue.addAll(list);
    }

    public void addDeleted(String ID) {
        this.m_closedQueue.add(ID);
    }

    public void addDeleted(List<String> IDs) {
        this.m_closedQueue.addAll(IDs);
        RTLogger.print(5, "GCD " + IDs.size());
    }

    public void addArchived(Collection<String> archived) {
        this.m_arcQueue.addAll(archived);
    }

    public void addUpdated(SEventFwd e) {
        this.m_updQueue.add(e);
    }

    public void addUpdated(List<SEventFwd> list) {
        try {
            this.m_updQueue.addAll(list);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void cleanAll() {
        this.m_newQueue.clear();
        this.m_updQueue.clear();
        this.m_closedQueue.clear();
        this.m_arcQueue.clear();
        this.m_pending.clear();
    }

    public Queue<SEventFwd> getNew() {
        return this.m_newQueue;
    }

    public Queue<String> getDeleted() {
        return this.m_closedQueue;
    }

    public Queue<SEventFwd> getUpdated() {
        return this.m_updQueue;
    }

    public Queue<String> getArchived() {
        return this.m_arcQueue;
    }

    public String getIP() {
        return this.m_IP;
    }
}

