/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.GUIClientProxy;
import com.blixx.server.ext.ForwardManager;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public class GUIClientProxyMgr {
    protected ConcurrentHashMap<String, GUIClientProxy> clients = new ConcurrentHashMap(10, 0.85f, 100);
    protected ForwardManager m_forwardManager;

    public GUIClientProxyMgr(ForwardManager fm) {
        this.setForwardManager(fm);
    }

    public void setForwardManager(ForwardManager fm) {
        this.m_forwardManager = fm;
    }

    public void addPendingToALL(CMD cmd) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy gcp : clients) {
            gcp.addPending(cmd);
        }
    }

    public void addPendingToUser(CMD cmd, String user) {
        GUIClientProxy clientCache = this.getClientCache(user);
        if (clientCache != null) {
            clientCache.addPending(cmd);
        }
    }

    public GUIClientProxy getClientCache(String user) {
        return this.clients.get(user);
    }

    public Map<String, GUIClientProxy> getClientCaches() {
        return this.clients;
    }

    public void removeClientCache(String user) {
        if (user != null) {
            try {
                GUIClientProxy clientCache = this.getClientCache(user);
                if (clientCache != null) {
                    clientCache.cleanAll();
                }
            }
            catch (Exception e) {
                RTLogger.print(6, "", e);
            }
            this.clients.remove(user);
        }
    }

    public GUIClientProxy createClientCache(String user, String IP) {
        this.removeClientCache(user);
        GUIClientProxy gcc = new GUIClientProxy(user, IP);
        this.clients.put(user, gcc);
        return gcc;
    }

    public Queue<SEventFwd> getActualNewQ(String user) {
        GUIClientProxy cp = this.getClientCache(user);
        return cp != null ? cp.getNew() : null;
    }

    public Queue<String> getActualClosedQ(String user) {
        GUIClientProxy cp = this.getClientCache(user);
        return cp != null ? cp.getDeleted() : null;
    }

    public Queue<SEventFwd> getActualUpdatedQ(String user) {
        GUIClientProxy cp = this.getClientCache(user);
        return cp != null ? cp.getUpdated() : null;
    }

    public Queue<String> getActualArchivedQ(String user) {
        GUIClientProxy cp = this.getClientCache(user);
        return cp != null ? cp.getArchived() : null;
    }

    protected void addArchivedToClients(Collection<String> messageIDs) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            try {
                cp.addArchived(messageIDs);
            }
            catch (Exception exception) {}
        }
    }

    protected void addDeletedToClients(List<String> messageIDs) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            cp.addDeleted(messageIDs);
        }
    }

    protected void addDeletedToClients(SEvent e) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            cp.addDeleted(e.getID());
        }
    }

    protected void addToClientCaches(List<SEventFwd> newEvents) {
        for (SEventFwd sef : newEvents) {
            this.addToClientCachesNoForwardAction(sef);
        }
    }

    protected void addToClientCaches(SEventFwd e) {
        Collection<String> roles = null;
        if (this.m_forwardManager != null) {
            roles = this.m_forwardManager.checkAll(e, false, true);
        }
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            if (roles != null && cp.isUserIndicationsFiltered()) {
                if (!roles.contains(cp.getUserRoleNameForFilters())) continue;
                cp.addNew(e);
                continue;
            }
            cp.addNew(e);
        }
    }

    protected void addToClientCachesNoForwardAction(SEventFwd e) {
        List roles = this.m_forwardManager == null ? Collections.emptyList() : this.m_forwardManager.checkAll(e, true, false);
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            if (cp.isUserIndicationsFiltered()) {
                if (!roles.contains(cp.getUserRoleNameForFilters())) continue;
                cp.addNew(e);
                continue;
            }
            cp.addNew(e);
        }
    }

    public void addUpdatedToClients(List<SEventFwd> list) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            cp.addUpdated(list);
        }
    }

    protected void addUpdatedToClients(SEventFwd eOld) {
        ArrayList<GUIClientProxy> clients = new ArrayList<GUIClientProxy>(this.clients.values());
        for (GUIClientProxy cp : clients) {
            cp.addUpdated(eOld);
        }
    }
}

