/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.BMThreadFactory;
import com.blixx.server.GUIWorker;
import com.blixx.server.Server;
import com.blixx.shared.BM;
import com.boom.SocketUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GUIServer
extends Server {
    public static int TIMEOUTGUI = 30000;
    private int m_port = BM.CLIENT_PORT;
    private static boolean m_allowConnections = true;
    private ThreadPoolExecutor m_executor = null;

    public static void setAllowConnections(boolean allow) {
        m_allowConnections = allow;
    }

    public GUIServer(int port, int maxUIThreads) {
        this.m_executor = new ThreadPoolExecutor(0, maxUIThreads, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.m_executor.setThreadFactory(new BMThreadFactory("ui_"));
        this.m_port = port;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    public void setUILimit(int limit) {
        this.m_executor.setMaximumPoolSize(limit);
    }

    public int getUILimit() {
        return this.m_executor.getMaximumPoolSize();
    }

    public int getActiveUIThreads() {
        return this.m_executor.getActiveCount();
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.getPort());
            serverSocket.setReuseAddress(true);
        }
        catch (Throwable e) {
            RTLogger.print(0, "Error creation Server Socket for port " + this.getPort());
            RTLogger.print(0, "Server stopped.");
            System.exit(3);
        }
        Socket clientSocket = null;
        boolean isRun = true;
        while (isRun) {
            try {
                clientSocket = serverSocket.accept();
                clientSocket.setSoTimeout(TIMEOUTGUI);
                clientSocket.setTcpNoDelay(true);
                clientSocket.setSoLinger(true, 1);
                if (m_allowConnections) {
                    this.runClient(clientSocket);
                    continue;
                }
                SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                }
            }
            catch (IOException e) {
                RTLogger.print(1, "Error creation Client Socket", e);
                try {
                    if (!serverSocket.isClosed() && serverSocket.isBound()) continue;
                    try {
                        serverSocket = new ServerSocket(this.getPort());
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void runClient(Socket clientSocket) {
        try {
            GUIWorker worker = new GUIWorker(clientSocket);
            boolean started = false;
            int count = 10;
            while (true) {
                try {
                    this.m_executor.execute(worker);
                    started = true;
                }
                catch (RejectedExecutionException e) {
                    --count;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (count < 1) continue;
                }
                break;
            }
            if (!started) {
                throw new RuntimeException("Failed to create client socket.");
            }
        }
        catch (Throwable e) {
            SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
        }
    }
}

