/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.utils.BkpFile;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.ext.AgentIDForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.ext.INodeGroupRepository;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.pg.INodeGroupTree;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;

public class NodeGroupRepository
implements INodeGroupRepository,
INodeGroupTree {
    public static final String _GROUPS = "_Groups";
    public static final String ROOT__GROUPS = "/root/_Groups";
    public static final String ROOT__EXTERNAL = "_External";
    private static volatile NodeGroupRepository m_nodeGroupRepository = null;
    public static final String NODE_GROUPS_XML = "nodeGroups.xml";
    private String NODEGROUP_FILENAME = "srv/groups/nodeGroups.xml";
    private GroupTreeObject m_nodeGroups = null;
    private ConcurrentHashMapMap<String, String> m_pathToID = new ConcurrentHashMapMap();
    private ConcurrentHashMapMap<String, String> m_IDToPath = new ConcurrentHashMapMap();

    public static NodeGroupRepository getMockInstance() {
        m_nodeGroupRepository = new NodeGroupRepository();
        NodeGroupForwardFilter.m_NGR = m_nodeGroupRepository;
        NodeGroupRepository.m_nodeGroupRepository.m_nodeGroups = new GroupTreeObject(new TreeObject("root", "", null));
        NodeGroupRepository.m_nodeGroupRepository.m_nodeGroups.addElement(new GroupTreeObject(new TreeObject(_GROUPS, "", null)));
        return m_nodeGroupRepository;
    }

    public static NodeGroupRepository getMockInstance(String nodeGroupFilePath) {
        m_nodeGroupRepository = NodeGroupRepository.getMockInstance();
        NodeGroupRepository.m_nodeGroupRepository.NODEGROUP_FILENAME = nodeGroupFilePath;
        try {
            Files.createDirectories(Paths.get(nodeGroupFilePath, new String[0]).getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m_nodeGroupRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeGroupRepository getInstance() {
        if (m_nodeGroupRepository != null) return m_nodeGroupRepository;
        Class<NodeGroupRepository> clazz = NodeGroupRepository.class;
        synchronized (NodeGroupRepository.class) {
            if (m_nodeGroupRepository != null) return m_nodeGroupRepository;
            NodeGroupRepository nodeGroupRepository = new NodeGroupRepository();
            try {
                nodeGroupRepository.loadFile();
            }
            catch (Throwable e) {
                RTLogger.print(1, "can't load nodegroup xml file", e);
                File lastbkp = BkpFile.getLastBkp(new File(nodeGroupRepository.getNodeGroupXMLFile()));
                if (lastbkp != null && lastbkp.canRead()) {
                    try {
                        nodeGroupRepository.loadFile(lastbkp.getAbsolutePath());
                        nodeGroupRepository.saveTree(nodeGroupRepository.getNodeGroupXMLFile());
                        RTLogger.print(2, "NodeGroup xml file was restored from the backup");
                    }
                    catch (Throwable e1) {
                        RTLogger.print(1, "NodeGroup xml file corrupted and can't be restored from tha backup. Creating an empty.", e1);
                        NodeGroupRepository.emergencyCreateEmptyNodeGroupsFile(nodeGroupRepository);
                    }
                }
                NodeGroupRepository.emergencyCreateEmptyNodeGroupsFile(nodeGroupRepository);
            }
            m_nodeGroupRepository = nodeGroupRepository;
            NodeGroupForwardFilter.m_NGR = nodeGroupRepository;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_nodeGroupRepository;
        }
    }

    private static void emergencyCreateEmptyNodeGroupsFile(NodeGroupRepository ngr) {
        ngr.m_nodeGroups = new GroupTreeObject(new TreeObject("root", "", null));
        ngr.m_nodeGroups.addElement(new GroupTreeObject(new TreeObject(_GROUPS, "", null)));
        XMLTree xt = new XMLTree();
        Document d = xt.getXML(ngr.m_nodeGroups);
        XMLFactory.writeXml(d, ngr.getNodeGroupXMLFile());
    }

    public String getNodeGroupXMLFile() {
        return this.NODEGROUP_FILENAME;
    }

    private void loadFile() throws IOException {
        if (this.loadFile(this.getNodeGroupXMLFile()) && this.getNodeGroupTree().getAllElements().size() > 1) {
            this.saveTree(this.getNodeGroupXMLFile());
        }
    }

    public synchronized boolean loadFile(String relativePathToNGFile) throws IOException {
        boolean xmlModified = false;
        try (FileInputStream fis = new FileInputStream(relativePathToNGFile);){
            RTLogger.print(6, "NodeGroupParsing  start - " + relativePathToNGFile);
            XMLTree xt = new XMLTree();
            this.m_nodeGroups = xt.parseXML(fis, true);
            xmlModified = this.processNodeGroupTree(this.m_nodeGroups);
            RTLogger.print(6, "NodeGroupParsing  end");
        }
        return xmlModified;
    }

    public boolean processNodeGroupTree(GroupTreeObject nodeGroupsGTO) {
        LinkedList<String> processedPathes = new LinkedList<String>();
        HashMap<String, String> processedAgentIDs = new HashMap<String, String>();
        boolean resave = false;
        List<GroupTreeObject> groups = GroupTreeObject.collectGroups(nodeGroupsGTO);
        groups.remove(nodeGroupsGTO);
        groups.remove(nodeGroupsGTO.getChild(_GROUPS, ""));
        for (GroupTreeObject groupTreeObject : groups) {
            processedPathes.add(groupTreeObject.getPath());
            if (!"".equals(groupTreeObject.getType()) || groupTreeObject.getTreeObject() == null || groupTreeObject.getTreeObject().getOID() != null && groupTreeObject.getTreeObject().getOID().length() != 0) continue;
            groupTreeObject.getTreeObject().setOID(this.getRandomNodeGroupOID());
            resave = true;
        }
        ((ConcurrentHashMap.CollectionView)((Object)this.m_pathToID.keySet())).retainAll(processedPathes);
        RTLogger.print(6, "NodeGroupParsing  1");
        List<GroupTreeObjectLast> list = nodeGroupsGTO.getAllGTOLs();
        RTLogger.print(6, "NodeGroupParsing  2");
        ConcurrentHashMapMap<String, String> path2ID = new ConcurrentHashMapMap<String, String>();
        ConcurrentHashMapMap<String, String> ID2path = new ConcurrentHashMapMap<String, String>();
        for (GroupTreeObjectLast gtol : list) {
            String agentID = gtol.getLinkedPath();
            processedAgentIDs.put(agentID, agentID);
            ITreeObject to = gtol.getTreeObject();
            if (to != null && !to.getName().equals(agentID)) {
                to.setName(agentID);
                resave = true;
            }
            for (GroupTreeObject parent = gtol.getParent(); parent != nodeGroupsGTO; parent = parent.getParent()) {
                String path = parent.getPath();
                this.m_pathToID.putV(path, agentID);
                path2ID.putV(path, agentID);
                this.m_IDToPath.putV(agentID, path);
                ID2path.putV(agentID, path);
            }
        }
        ((ConcurrentHashMap.CollectionView)((Object)this.m_IDToPath.keySet())).retainAll(processedAgentIDs.keySet());
        for (Map.Entry en : path2ID.entrySet()) {
            this.m_pathToID.retainFromMap((String)en.getKey(), ((Map)en.getValue()).keySet());
        }
        for (Map.Entry en : ID2path.entrySet()) {
            this.m_IDToPath.retainFromMap((String)en.getKey(), ((Map)en.getValue()).keySet());
        }
        return resave;
    }

    public String getRandomNodeGroupOID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String normalizeNgPath(String path) {
        if (((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        if (((String)path).startsWith("/_Groups")) {
            path = "/root" + (String)path;
        }
        if (!((String)path).startsWith(ROOT__GROUPS)) {
            path = ROOT__GROUPS + (String)path;
        }
        return path;
    }

    @Override
    public synchronized GroupTreeObject addNodeGroup(String path) throws INodeGroupRepository.NodeGroupException {
        GroupTreeObject ngNew;
        if (!(path = this.normalizeNgPath(path)).startsWith("/root/_Groups/")) {
            throw new INodeGroupRepository.NodeGroupException("Invalid path: " + path);
        }
        GroupTreeObject checkGrp = ngNew = GroupTreeObject.createPath(path, this.m_nodeGroups);
        while (!ROOT__GROUPS.equals(checkGrp.getPath())) {
            ITreeObject treeObject = checkGrp.getTreeObject();
            if (treeObject.getOID() == null || treeObject.getOID().length() == 0) {
                treeObject.setOID(this.getRandomNodeGroupOID());
            }
            checkGrp = checkGrp.getParent();
        }
        this.saveTree();
        return ngNew;
    }

    @Override
    public synchronized List<String> deleteNodeGroup(List<String> paths) throws INodeGroupRepository.NodeGroupException {
        ArrayList<String> foundAndDeleted = new ArrayList<String>(paths.size());
        for (String path : paths) {
            String normalizedPath = this.normalizeNgPath(path);
            GroupTreeObject ng = this.m_nodeGroups.searchPath(normalizedPath, "");
            if (ng == null) continue;
            if (ROOT__GROUPS.equals(ng.getPath()) || "/root".equals(ng.getPath())) {
                throw new INodeGroupRepository.NodeGroupException("Path: " + ng.getPath() + " can't be deleted");
            }
            String pathToClean = ng.getPath();
            ng.getParent().removeElement(ng);
            this.m_pathToID.remove(pathToClean);
            Iterator it = this.m_IDToPath.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                ((Map)en.getValue()).remove(pathToClean);
                if (((Map)en.getValue()).size() != 0) continue;
                it.remove();
            }
            foundAndDeleted.add(path);
        }
        if (!foundAndDeleted.isEmpty()) {
            this.saveTree();
        }
        ArrayList<String> notfound = new ArrayList<String>(paths);
        notfound.removeAll(foundAndDeleted);
        return notfound;
    }

    @Override
    public synchronized void renameNodeGroup(String oldName, String newName) throws INodeGroupRepository.NodeGroupException {
        oldName = this.normalizeNgPath(oldName);
        newName = this.normalizeNgPath(newName);
        GroupTreeObject ngOld = this.m_nodeGroups.searchPath(oldName, "");
        if (ngOld != null) {
            if (ROOT__GROUPS.equals(ngOld.getPath()) || "/root".equals(ngOld.getPath())) {
                throw new INodeGroupRepository.NodeGroupException("Path: " + ngOld.getPath() + " can't be renamed");
            }
            String pathToClean = ngOld.getPath();
            GroupTreeObject parent = ngOld.getParent();
            parent.removeElement(ngOld);
            GroupTreeObject ngNew = GroupTreeObject.createPath(newName, this.m_nodeGroups);
            ngNew.getTreeObject().setOID(ngOld.getTreeObject().getOID());
            ngNew.addElements(ngOld.getElements());
            String pathNew = ngNew.getPath();
            Map agentIDs = (Map)this.m_pathToID.remove(pathToClean);
            if (agentIDs != null) {
                this.m_pathToID.put(pathNew, agentIDs);
                for (String agentID : agentIDs.keySet()) {
                    this.m_IDToPath.removeElement(agentID, pathToClean);
                    this.m_IDToPath.putV(agentID, pathNew);
                }
            }
        } else {
            throw new INodeGroupRepository.NodeGroupException("Nodegroup path not found: " + oldName);
        }
        this.saveTree();
        UserManager.getInstance().renamePowerGroupNGPath(oldName, newName);
    }

    @Override
    public synchronized void linkAgent(String path, List<String> agentIDs) throws INodeGroupRepository.NodeGroupException {
        GroupTreeObject gto = this.m_nodeGroups.searchPath(path = this.normalizeNgPath(path), "");
        if (gto != null) {
            if ("/root".equals(gto.getPath()) || "/".equals(gto.getPath())) {
                throw new INodeGroupRepository.NodeGroupException("Path: " + gto.getPath() + " can't be used to link Agents");
            }
            boolean changed = false;
            for (String agentID : agentIDs) {
                AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
                GroupTreeObjectLast newGTO = new GroupTreeObjectLast(new TreeObject(agentID, "agt", ac == null ? "" : ac.getLabel()), agentID, null);
                try {
                    gto.addElement(newGTO);
                    changed = true;
                    this.m_pathToID.putV(gto.getPath(), agentID);
                    this.m_IDToPath.putV(agentID, gto.getPath());
                }
                catch (Exception e) {
                    RTLogger.print(5, "error link Agent", e);
                }
            }
            if (changed) {
                this.saveTree();
            }
        } else {
            throw new INodeGroupRepository.NodeGroupException("Server can't link the Agent to unknown path: " + path);
        }
    }

    @Override
    public synchronized boolean unlinkAgent(List<String> paths, StringBuilder errors) {
        boolean unlinked = false;
        for (String path : paths) {
            GroupTreeObject agent = this.m_nodeGroups.searchPath(path = this.normalizeNgPath(path), "agt");
            if (agent != null) {
                GroupTreeObject parent = agent.getParent();
                parent.removeElement(agent);
                unlinked = true;
                this.m_pathToID.removeElement(parent.getPath(), agent.getName());
                this.m_IDToPath.removeElement(agent.getName(), parent.getPath());
                continue;
            }
            if (errors == null) continue;
            if (errors.length() > 0 && errors.charAt(errors.length() - 1) != '\n') {
                errors.append('\n');
            }
            errors.append("Path not found: ").append(path);
        }
        if (unlinked) {
            this.saveTree();
        }
        return unlinked;
    }

    public synchronized void saveTree() {
        this.saveTree(this.getNodeGroupXMLFile());
        UserManager.getInstance().onNodeGroupChange();
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("REFRESH_NODEGROUPS");
    }

    public synchronized void saveTree(String xmlFile) {
        try {
            XMLTree xt1 = new XMLTree();
            Document doc = xt1.getXML(this.m_nodeGroups);
            XMLFactory.writeXml(doc, xmlFile);
            RTLogger.print(2, "NodeGroup xml file saved.");
            BkpFile.backup(this.getNodeGroupXMLFile());
        }
        catch (Exception e) {
            RTLogger.print(5, "Error saving nodegroup tree", e);
        }
    }

    public boolean resolve(AgentCard ac) {
        boolean found = false;
        String hostname = ac.getAgentHost();
        List<GroupTreeObjectLast> brokenLinks = this.m_nodeGroups.findLinksByName(hostname, "agt");
        for (GroupTreeObjectLast gtol : brokenLinks) {
            if (!"agt".equals(gtol.getType())) continue;
            gtol.setLinkedPath(ac.getAgentID());
            gtol.setTreeObject(new TreeObject(ac.getAgentID(), "agt", ac));
            found = true;
        }
        return found;
    }

    public ArrayList<String> getAssociatedAgentIDs(NodeGroupForwardFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        if (filter instanceof AgentIDForwardFilter) {
            list.addAll(filter.getPaths());
        } else {
            for (String pat : filter.getPaths()) {
                Map<String, Object> array = this.m_pathToID.getHashMap(pat);
                if (array == null || array.size() <= 0) continue;
                list.addAll(array.keySet());
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> getAssociatedAgentIDsMap(NodeGroupForwardFilter filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (filter instanceof AgentIDForwardFilter) {
            Set<String> set = filter.getPaths();
            for (String id : set) {
                map.put(id, null);
            }
        } else {
            for (String pat : filter.getPaths()) {
                Map<String, Object> array = this.m_pathToID.getHashMap(pat);
                if (array == null || array.size() <= 0) continue;
                map.putAll(array);
            }
        }
        return map;
    }

    public String getNodeGroupPath(String oid) {
        GroupTreeObject ng = this.m_nodeGroups.findByOID(oid);
        if (ng != null) {
            return ng.getPath().replace("/root/_Groups/", "");
        }
        return null;
    }

    public ArrayList<String> getAssociatedAgentIDsByNGOID(String oid) {
        String[] oidArr;
        ArrayList<String> agentIDs = new ArrayList<String>();
        for (String s : oidArr = oid.split("\\Q|\\E")) {
            try {
                Map<String, Object> array;
                GroupTreeObject ng = this.m_nodeGroups.findByOID(s);
                if (ng == null || (array = this.m_pathToID.getHashMap(ng.getPath())) == null) continue;
                agentIDs.addAll(array.keySet());
            }
            catch (Exception e) {
                RTLogger.print(6, "", e);
            }
        }
        return agentIDs;
    }

    @Override
    public Map<String, Object> getAssociatedAgentIDsByNGOIDMap(String oid) {
        String[] oidArr;
        HashMap<String, Object> agentIDs = new HashMap<String, Object>();
        for (String s : oidArr = oid.split("\\Q|\\E")) {
            try {
                Map<String, Object> array;
                GroupTreeObject ng = this.m_nodeGroups.findByOID(s);
                if (ng == null || (array = this.m_pathToID.getHashMap(ng.getPath())) == null) continue;
                agentIDs.putAll(array);
            }
            catch (Exception e) {
                RTLogger.print(6, "", e);
            }
        }
        return agentIDs;
    }

    @Override
    public List<String> getNodeGroupPathes(String agentID) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, Object> array = this.m_IDToPath.getHashMap(agentID);
        if (array != null && array.size() > 0) {
            list.addAll(array.keySet());
        }
        return list;
    }

    public List<String> getNodeGroupOIDs(String agentID) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> parentPathes = this.getNodeGroupPathes(agentID);
        if (parentPathes != null && !parentPathes.isEmpty()) {
            list.ensureCapacity(parentPathes.size());
            for (String path : parentPathes) {
                try {
                    String oid;
                    ITreeObject treeObject;
                    GroupTreeObject parentGroup = this.m_nodeGroups.searchPath(path, "");
                    if (parentGroup == null || (treeObject = parentGroup.getTreeObject()) == null || (oid = treeObject.getOID()) == null || oid.length() < 32 || list.contains(oid)) continue;
                    list.add(oid);
                }
                catch (Exception e) {
                    RTLogger.print(6, "", e);
                }
            }
        }
        return list;
    }

    public synchronized boolean deleteLinked(String agentID) {
        boolean treeUpdated = false;
        List<GroupTreeObjectLast> al = this.m_nodeGroups.findLinksByName(agentID);
        for (GroupTreeObjectLast gto : al) {
            for (GroupTreeObject parentGto = gto.getParent(); parentGto != null; parentGto = parentGto.getParent()) {
                String parentPath = parentGto.getPath();
                Map map = (Map)this.m_pathToID.get(parentPath);
                if (map == null) continue;
                map.remove(agentID);
            }
            this.m_IDToPath.remove(agentID);
            gto.getParent().removeElement(gto);
            treeUpdated = true;
        }
        if (treeUpdated) {
            XMLTree xt = new XMLTree();
            Document updated = xt.getXML(this.m_nodeGroups);
            XMLFactory.writeXml(updated, this.getNodeGroupXMLFile());
        }
        return treeUpdated;
    }

    public boolean containsNodeGroupOrAgentIDFilter(ForwardPolicy fp) {
        return fp.hasType(21) || fp.hasType(26);
    }

    public List<String> getAllOIDs() {
        LinkedList<String> list = new LinkedList<String>();
        for (GroupTreeObject gto : this.m_nodeGroups.getAllElements()) {
            try {
                String oid = gto.getTreeObject().getOID();
                list.add(oid);
            }
            catch (Exception e) {
                RTLogger.print(6, "", e);
            }
        }
        return list;
    }

    @Override
    public GroupTreeObject getNodeGroupTree() {
        return this.m_nodeGroups;
    }

    public boolean isAgentLinkedToNodeGroupTree(String id) {
        return this.m_IDToPath.containsKey(id);
    }

    public Set<String> getAgetIDsLinkedToNodeGroupTree() {
        return new HashSet<String>(this.m_IDToPath.keySet());
    }
}

