/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.server.AgentCard;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import com.boom.crt.CertificateManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class RemoteCmdClient
implements IRemoteProcessing {
    public static final SocketException SKIP_BAD_HOSTNAME = new SocketException("skip bad hostname");
    private final CertificateManager certificateManager;
    protected AgentCard m_card = null;
    protected String m_cmd = null;
    protected String m_output = null;
    protected boolean isReady = false;
    protected Socket m_socket = null;
    protected SDataInputStream m_is = null;
    protected SDataOutputStream m_os = null;
    protected ExecResult er = new ExecResult();
    protected char m_char = (char)65;
    private long m_initTime = System.currentTimeMillis();
    protected int m_timeoutSeconds = 120;
    protected boolean m_closeSocketAtTheEnd = true;

    public RemoteCmdClient(char type, AgentCard card, String cmd, int timeoutSeconds) {
        this.m_card = card;
        this.m_cmd = cmd;
        this.m_char = type;
        this.m_timeoutSeconds = timeoutSeconds;
        if (this.m_timeoutSeconds <= 0) {
            this.m_timeoutSeconds = 120;
        }
        this.certificateManager = ServerEngine.getInstance().getCertificateManager();
    }

    @Override
    public long getInitTime() {
        return this.m_initTime;
    }

    public void forceFinish(String result, int rescode) {
        this.er.m_errorMessages.add(result);
        this.er.resultCode = rescode;
        this.isReady = true;
    }

    @Override
    public void sendToFirewalled(Socket socket) {
        try {
            socket.setSoTimeout(this.m_timeoutSeconds * 1000 + 3000);
            this.m_closeSocketAtTheEnd = false;
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 1);
        }
        catch (Throwable e) {
            RTLogger.print(5, "error setting timeout for remote action.", e);
        }
        this.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            if (this.m_card.getMode() == 3) {
                throw new RuntimeException("Offline");
            }
            if (this.m_is == null && this.m_card.getAgentPort() != -1) {
                try {
                    if (this.getAgentCard().isIPPPreferred()) {
                        throw SKIP_BAD_HOSTNAME;
                    }
                    this.m_socket = SocketUtils.getNewSocket(this.m_timeoutSeconds * 1000);
                    InetSocketAddress agentAddrByHost = new InetSocketAddress(this.m_card.getAgentHost(), this.m_card.getAgentPort());
                    if (agentAddrByHost.isUnresolved()) {
                        throw new RuntimeException("Change to IP");
                    }
                    this.m_socket.connect(agentAddrByHost, ServerProperties.getHB_Ctimeout());
                }
                catch (Throwable e) {
                    if (this.m_socket != null) {
                        SocketUtils.closeSocketServerSide(this.m_socket, new AutoCloseable[0]);
                    }
                    this.m_socket = SocketUtils.getNewSocket(this.m_timeoutSeconds * 1000);
                    this.m_socket.connect(new InetSocketAddress(this.m_card.getAgentIP(), this.m_card.getAgentPort()), ServerProperties.getHB_Ctimeout());
                }
                if (this.m_card.isTlsAgent()) {
                    this.m_socket = TlsUtils.upgradeClientSocket(this.m_socket, this.certificateManager, true);
                }
                this.m_is = new SDataInputStream(this.m_socket.getInputStream());
                this.m_os = new SDataOutputStream(this.m_socket.getOutputStream(), this.m_card.getProtocolVersion());
            }
            if (this.m_char == 'A') {
                this.processRemote(this.m_is, this.m_os, this.m_card);
            } else if (this.m_char == 'P') {
                this.processGetAssignedPolicies(this.m_is, this.m_os, this.m_card);
            } else if (this.m_char == 'Y') {
                this.m_os.write(this.m_char);
            } else {
                this.processAgentAction(this.m_is, this.m_os);
            }
            this.isReady = true;
            if (!this.m_closeSocketAtTheEnd) return;
        }
        catch (Throwable e) {
            try {
                RTLogger.print(2, "Agent " + this.m_card.getAgentHost() + " is offline. CMD failed: " + this.m_cmd);
                this.er.resultCode = -1;
                this.er.m_errorMessages.add(e.getMessage());
                this.m_closeSocketAtTheEnd = true;
                if (this.m_char == 'P') {
                    this.m_card.m_assignedMessagePolicies.clear();
                    this.m_card.m_assignedMonitorPolicies.clear();
                }
                this.isReady = true;
                if (!this.m_closeSocketAtTheEnd) return;
            }
            catch (Throwable throwable) {
                this.isReady = true;
                if (!this.m_closeSocketAtTheEnd) throw throwable;
                SocketUtils.closeSocket(this.m_socket, this.m_os, this.m_is);
                throw throwable;
            }
            SocketUtils.closeSocket(this.m_socket, this.m_os, this.m_is);
            return;
        }
        SocketUtils.closeSocket(this.m_socket, this.m_os, this.m_is);
        return;
    }

    public void processAgentAction(SDataInputStream is, SDataOutputStream os) throws IOException {
        char response;
        os.write(this.m_char);
        os.writeUTF(this.m_cmd);
        if (this.m_cmd.startsWith("GETHASH=")) {
            String result = is.readUTF();
            this.er.m_outMessages.add(result);
        }
        this.er.resultCode = (response = (char)is.read()) != 'T' ? -1 : 0;
        this.m_card.processCommandResult(this.m_cmd, this.er);
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    public String getMessage() {
        return this.m_output;
    }

    @Override
    public AgentCard getAgentCard() {
        return this.m_card;
    }

    public void processRemote(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
        os.write(65);
        RTLogger.print(4, "Remote CMD: " + this.m_cmd);
        os.writeUTF(this.m_cmd);
        os.writeInt(this.m_timeoutSeconds);
        this.er.resultCode = is.readInt();
        this.m_output = is.readUTF();
        if (this.er.resultCode != 0) {
            this.er.m_errorMessages.add(this.m_output);
        } else {
            this.er.m_outMessages.add(this.m_output);
        }
        ac.processCommandResult(this.m_cmd, this.er);
    }

    public void processGetAssignedPolicies(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
        this.er.resultCode = 1;
        try {
            String version;
            String monitor;
            int i;
            os.write(80);
            String type = is.readUTF();
            int size = is.readInt();
            RTLogger.print(5, "Assigned mons expected :" + size);
            this.m_card.m_assignedMonitorPolicies.clear();
            for (i = 0; i < size; ++i) {
                monitor = is.readUTF();
                version = is.readUTF();
                this.m_card.m_assignedMonitorPolicies.put(monitor, version);
            }
            type = is.readUTF();
            size = is.readInt();
            RTLogger.print(5, "Assigned msgs expected :" + size);
            this.m_card.m_assignedMessagePolicies.clear();
            for (i = 0; i < size; ++i) {
                monitor = is.readUTF();
                version = is.readUTF();
                this.m_card.m_assignedMessagePolicies.put(monitor, version);
            }
            this.er.resultCode = 0;
            this.m_card.m_lastTimeUpdatedFromAgent = System.currentTimeMillis();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "processGetAssignedPolicies ", e);
        }
        if (this.er.resultCode != 0) {
            this.er.m_errorMessages.add("Failed to fetch data from the S");
        } else {
            this.er.m_outMessages.add("Success");
        }
    }

    @Override
    public void setInputOutput(SDataInputStream is, SDataOutputStream os) {
        this.m_is = is;
        this.m_os = os;
    }

    @Override
    public ExecResult getResult() {
        return this.er;
    }

    @Override
    public void failedToProcess(Throwable e) {
        this.er.resultCode = -2;
        this.er.m_errorMessages.add("Communication error: " + e.getMessage());
        RTLogger.print(4, this.m_card.getAgentHost() + " comminication error.", e);
        this.isReady = true;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void extendExpireTimePlus10Minutes() {
    }

    @Override
    public long getExpireTime() {
        return 0L;
    }
}

