/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.SEventFwd;
import java.io.File;

public class RemoteInventoryAction
extends RemoteCmdClient {
    public RemoteInventoryAction(char type, AgentCard card, String cmd, int timeoutSeconds) {
        super(type, card, cmd, timeoutSeconds);
    }

    @Override
    public void run() {
        try {
            RTLogger.print(4, "Inventory started for " + this.m_card.getAgentID());
            super.run();
            RTLogger.print(4, "Inventory parsing... " + this.m_card.getAgentID());
            this.handleResult();
            RTLogger.print(4, "Inventory finished for " + this.m_card.getAgentID());
        }
        catch (Throwable e) {
            RTLogger.print(4, "Inventory run failed.", e);
        }
    }

    public void handleResult() {
        if (this.m_output != null) {
            String data = this.m_output;
            this.processInventoryTextBlock(data);
        }
    }

    public void processInventoryTextBlock(String data) {
        try {
            AgentInventoryCard agentInventoryCard = this.m_card.getAgentInventoryCard();
            boolean isFirstDiscovery = !agentInventoryCard.isDiscovered();
            boolean changed = agentInventoryCard.parseGET_DETAILS(data);
            if (changed) {
                String nVersion = PolicyFactory.getNextVersion(agentInventoryCard.getAttribute(AgentInventoryCard.getPath("_VERSION")));
                agentInventoryCard.saveSDIS(new File("srv/inventory"), nVersion);
                RTLogger.print(4, "Inventory change detected for " + this.m_card.getAgentID());
                SEventFwd sm = SMessage.createMessage(2, 0, this.m_card.getAgentHost(), "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "BOOM Agent Inventory change detected");
                sm.setT1(this.m_card.getAgentID());
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                CMD cmd = new CMD("GET_AGENT_INVENTORY_CARD", this.m_card.getAgentID(), null);
                ServerEngine.getInstance().getEventsRouter().addPendingToALL(cmd);
            } else if (isFirstDiscovery) {
                agentInventoryCard.saveSDIS(new File("srv/inventory"));
                RTLogger.print(4, "Inventory saved for " + this.m_card.getAgentID());
                CMD cmd = new CMD("GET_AGENT_INVENTORY_CARD", this.m_card.getAgentID(), null);
                ServerEngine.getInstance().getEventsRouter().addPendingToALL(cmd);
            }
        }
        catch (Throwable e) {
            RTLogger.print(4, "Inventory processing failed.", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RemoteInventoryAction) {
            RemoteInventoryAction ria = (RemoteInventoryAction)obj;
            return this.m_card.getAgentID().equals(ria.m_card.getAgentID());
        }
        return false;
    }

    public int hashCode() {
        return this.m_cmd.hashCode();
    }
}

