/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ext.ILookup;
import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.shared.IEnv;
import com.blixx.shared.SupportedVariablesS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SEnv
implements IEnv {
    public static String ENVFILE = "global.props";
    private static volatile SEnv m_env = null;
    private final Map<String, String> m_vars = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEnv getInstance() {
        if (m_env != null) return m_env;
        Class<SEnv> clazz = SEnv.class;
        synchronized (SEnv.class) {
            if (m_env != null) return m_env;
            SEnv env = new SEnv();
            env.load();
            m_env = env;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_env;
        }
    }

    private void load() {
        File dir = new File(ServerEngine.getInstance().getMainDir());
        if (dir.exists()) {
            File conf = new File(dir, ENVFILE);
            if (conf.exists() && conf.canRead()) {
                try (FileInputStream fis = new FileInputStream(conf);){
                    Properties p = new Properties();
                    p.load(fis);
                    fis.close();
                    this.m_vars.clear();
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.m_vars.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    RTLogger.print(1, "Loaded global.props");
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Error reading global.props");
                }
            } else {
                RTLogger.print(1, "global.props not found or unreadable");
            }
        }
    }

    private void store() {
        File dir = new File(ServerEngine.getInstance().getMainDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File conf = new File(dir, ENVFILE);
        try (FileOutputStream fos = new FileOutputStream(conf);){
            Properties p = new Properties();
            p.putAll(this.m_vars);
            p.store(fos, "");
            fos.close();
            RTLogger.print(3, "Stored global.props");
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error writing global.props");
        }
    }

    @Override
    public void addVariable(String varName, String value) {
        this.m_vars.put(varName, value);
        this.store();
    }

    @Override
    public void addVariables(Map<String, String> vars) {
        this.m_vars.putAll(vars);
        this.store();
    }

    @Override
    public Map<String, String> getVariables() {
        return this.m_vars;
    }

    @Override
    public String getVariable(String name) {
        if (name == null) {
            return null;
        }
        String value = this.m_vars.get(name);
        if (value == null && name.contains("<$") && (value = SupportedVariablesS.replaceOptVars(name, this.m_vars)).equals(name)) {
            value = null;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>(this.m_vars.keySet());
        Collections.sort(names);
        for (String string : names) {
            sb.append(string).append('=').append(this.getVariable(string)).append('\n');
        }
        return sb.toString();
    }

    @Override
    public ILookup getLookupService(String name) {
        return null;
    }

    @Override
    public List<String> getLookupServices() {
        return null;
    }

    @Override
    public void registerLookupService(ILookup service) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ILookup unregisterLookupService(String name) {
        return null;
    }
}

