/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.utils.BkpFile;
import com.blixx.server.utils.DeployType;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Condition;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.pg.IPolicyTree;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.IResolveConditionID;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;

public class SPolicyRepository
implements IResolveConditionID,
IPolicyTree {
    public static final String POLICIES_TREE_NAME = "Policies";
    public static final String LOST_AND_FOUND = "/root/Policies/__Lost and Found";
    public static final String POLICIES_DIR = "policies";
    public static final String POLICYGROUP_XML = "policyGroups.xml";
    private static volatile SPolicyRepository m_instance = null;
    private Map<String, Policy> m_knownMonitors = new ConcurrentHashMap<String, Policy>(500, 0.95f, 3);
    private Map<String, Object> m_damagedMonitors = new ConcurrentHashMap<String, Object>(10, 0.95f, 3);
    private Map<String, MsgPolicy> m_knownMsgPolicies = new ConcurrentHashMap<String, MsgPolicy>(500, 0.95f, 3);
    private Map<String, Object> m_damagedMsgPolicies = new ConcurrentHashMap<String, Object>(10, 0.95f, 3);
    private Map<String, List<String>> m_agentAssignmentsMonitors = new ConcurrentHashMap<String, List<String>>(10, 0.95f, 3);
    private Map<String, List<String>> m_agentDeAssignmentsMonitors = new ConcurrentHashMap<String, List<String>>(10, 0.95f, 3);
    private Map<String, List<String>> m_agentAssignmentsMsgs = new ConcurrentHashMap<String, List<String>>(10, 0.95f, 3);
    private Map<String, List<String>> m_agentDeAssignmentsMsgs = new ConcurrentHashMap<String, List<String>>(10, 0.95f, 3);
    private Map<String, String> m_files = new ConcurrentHashMap<String, String>(500, 0.95f, 3);
    private Map<String, String> m_helps = new ConcurrentHashMap<String, String>(500, 0.95f, 3);
    private static Object NULL = new Object();
    private static String m_policyDirectory = null;
    private File m_srvPolicyDir;
    private PolicyFactory m_policy_factory;
    private GroupTreeObject m_treeRoot = null;

    public static SPolicyRepository getInstance(boolean isTest) {
        m_instance = new SPolicyRepository();
        if (!isTest) {
            m_policyDirectory = ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + POLICIES_DIR;
            SPolicyRepository.m_instance.m_policy_factory = new PolicyFactory();
            SPolicyRepository.m_instance.m_srvPolicyDir = new File(m_policyDirectory);
            long start = System.currentTimeMillis();
            m_instance.init();
            RTLogger.print(5, "Policy repository init " + (System.currentTimeMillis() - start));
        }
        return m_instance;
    }

    public synchronized void init() {
        LinkedList<String> processedNames = new LinkedList<String>();
        if (this.m_srvPolicyDir.isDirectory()) {
            File[] farr = this.m_srvPolicyDir.listFiles(new FilenameFilter(this){

                @Override
                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    return name.endsWith(".mon.xml") || name.endsWith(".msg.xml");
                }
            });
            for (int i = 0; i < farr.length; ++i) {
                File file = farr[i];
                this.processFile(file, processedNames);
            }
            RTLogger.print(3, "Policies loaded");
        } else {
            RTLogger.print(1, "Directory not found: " + SPolicyRepository.getPolicyDir());
            this.m_srvPolicyDir.mkdirs();
        }
        this.initPolicyGroupTreeFile();
        if (!this.m_treeRoot.getFirstChild(POLICIES_TREE_NAME).getTreeObject().getType().equals("toplevel")) {
            this.m_treeRoot.getFirstChild(POLICIES_TREE_NAME).getTreeObject().setType("toplevel");
            this.saveTree();
        }
        this.removeUnExistingPolicies();
        this.checkLostAndFound(processedNames);
        this.m_damagedMonitors.keySet().retainAll(processedNames);
        this.m_damagedMsgPolicies.keySet().retainAll(processedNames);
        this.m_knownMonitors.keySet().retainAll(processedNames);
        this.m_knownMsgPolicies.keySet().retainAll(processedNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPolicyGroupTreeFile() {
        block20: {
            String policyGroupsFile = SPolicyRepository.getPolicyGroupsFile();
            File pf = new File(policyGroupsFile);
            FileInputStream fio = null;
            try {
                fio = new FileInputStream(pf);
                XMLTree xmlTools = new XMLTree();
                this.m_treeRoot = xmlTools.parseXML(fio, true);
            }
            catch (Throwable e) {
                try {
                    if (fio != null) {
                        fio.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                RTLogger.print(1, "Error loading " + policyGroupsFile);
                File bkp = BkpFile.getLastBkp(pf);
                if (bkp != null) {
                    RTLogger.print(1, "Bkp found. restoring... " + policyGroupsFile);
                    try {
                        fio = new FileInputStream(bkp);
                        XMLTree xmlTools = new XMLTree();
                        this.m_treeRoot = xmlTools.parseXML(fio, true);
                        RTLogger.print(1, "Bkp file loaded. " + policyGroupsFile);
                        try {
                            fio.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        FileUtils.copyFile(bkp, pf);
                        RTLogger.print(1, "Bkp file restored. " + policyGroupsFile);
                    }
                    catch (Throwable e1) {
                        RTLogger.print(1, "Bkp restore failed! " + policyGroupsFile);
                        this.emergencyCreateEmptyTree();
                    }
                    break block20;
                }
                RTLogger.print(1, "Required file: " + policyGroupsFile + " not found. Creating new.");
                this.emergencyCreateEmptyTree();
            }
            finally {
                try {
                    if (fio != null) {
                        fio.close();
                    }
                }
                catch (Throwable xmlTools) {}
            }
        }
    }

    public void removeUnExistingPolicies() {
        boolean isUpdated = false;
        LinkedList<String> knownInTree = new LinkedList<String>();
        List<GroupTreeObjectLast> allElements = this.m_treeRoot.getAllGTOLs();
        for (int i = 0; i < allElements.size(); ++i) {
            AbstractPolicy o;
            GroupTreeObjectLast gtol = allElements.get(i);
            if (gtol == null) continue;
            if (knownInTree.contains(gtol.getName())) {
                gtol.getParent().removeElement(gtol);
                isUpdated = true;
                continue;
            }
            if (gtol.getTreeObject().getType().equals("mon")) {
                o = this.getMonitorPolicy(gtol.getName());
                if (o == null) {
                    if (!this.isDamagedMonitorPolicy(gtol.getName())) {
                        RTLogger.print(2, "Monitor Policy " + gtol.getName() + " has not been found on the server. Broken link.");
                        gtol.getParent().removeElement(gtol);
                        isUpdated = true;
                    }
                } else {
                    knownInTree.add(gtol.getName());
                }
                if (gtol.getTreeObject().getObject().equals("")) continue;
                gtol.getTreeObject().setObject("");
                isUpdated = true;
                continue;
            }
            if (gtol.getTreeObject().getType().equals("msg")) {
                o = this.getMessagePolicy(gtol.getName());
                if (o == null) {
                    if (!this.isDamagedMessagePolicy(gtol.getName())) {
                        RTLogger.print(2, "Message Policy " + gtol.getName() + " has not been found on the server. Broken link.");
                        gtol.getParent().removeElement(gtol);
                        isUpdated = true;
                    }
                } else {
                    knownInTree.add(gtol.getName());
                }
                if (gtol.getTreeObject().getObject().equals("")) continue;
                gtol.getTreeObject().setObject("");
                isUpdated = true;
                continue;
            }
            gtol.getParent().removeElement(gtol);
            RTLogger.print(3, "removed damaged xml element. nametype=" + gtol.getNameType());
            isUpdated = true;
        }
        if (isUpdated) {
            this.saveTree();
            RTLogger.print(2, "Policy groups tree file was corrected and saved on the disk.");
        }
    }

    private void processFile(File file, List<String> processedNames) {
        if (file.getName().endsWith(".mon.xml")) {
            Policy p = null;
            try {
                p = this.m_policy_factory.initPolicy(file);
                if (!p.getName().equals(file.getName().subSequence(0, file.getName().length() - ".mon.xml".length()))) {
                    p = null;
                }
            }
            catch (PolicyParsingException e) {
                String pnameBasedOnFilename = file.getName().replace(".mon.xml", "");
                this.m_damagedMonitors.put(pnameBasedOnFilename, NULL);
                processedNames.add(pnameBasedOnFilename);
            }
            if (p != null) {
                this.addPolicy(p, file.getName());
                processedNames.add(p.getName());
            }
        } else if (file.getName().endsWith(".msg.xml")) {
            MsgPolicy mp = null;
            try {
                mp = this.m_policy_factory.initMsgPolicy(file);
                if (!mp.getName().equals(file.getName().subSequence(0, file.getName().length() - ".msg.xml".length()))) {
                    mp = null;
                }
            }
            catch (PolicyParsingException e) {
                String pnameBasedOnFilename = file.getName().replace(".msg.xml", "");
                this.m_damagedMsgPolicies.put(pnameBasedOnFilename, NULL);
                processedNames.add(pnameBasedOnFilename);
            }
            if (mp != null) {
                this.addPolicy(mp, file.getName());
                processedNames.add(mp.getName());
            }
        }
    }

    public String checkLostAndFound(List<String> processedNames) {
        StringBuffer sb = new StringBuffer();
        boolean isUpdated = false;
        File[] farr = this.m_srvPolicyDir.listFiles(new FilenameFilter(this){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                return name.endsWith(".mon.xml") || name.endsWith(".msg.xml");
            }
        });
        for (int i = 0; i < farr.length; ++i) {
            if (farr[i].getName().endsWith(".mon.xml")) {
                String monPolicyName = farr[i].getName().replace(".mon.xml", "");
                if (this.m_knownMonitors.get(monPolicyName) == null && !this.isDamagedMonitorPolicy(monPolicyName)) {
                    this.processFile(farr[i], processedNames);
                }
                isUpdated = this.addToLostAndFound(sb, isUpdated, monPolicyName, "mon");
                continue;
            }
            if (!farr[i].getName().endsWith(".msg.xml")) continue;
            String msgPolicyName = farr[i].getName().replace(".msg.xml", "");
            if (this.m_knownMsgPolicies.get(msgPolicyName) == null && !this.isDamagedMessagePolicy(msgPolicyName)) {
                this.processFile(farr[i], processedNames);
            }
            isUpdated = this.addToLostAndFound(sb, isUpdated, msgPolicyName, "msg");
        }
        if (isUpdated) {
            this.saveTree();
            RTLogger.print(2, "Policy groups tree file was corrected and saved on the disk.");
        }
        return sb.toString();
    }

    private boolean addToLostAndFound(StringBuffer sb, boolean isUpdated, String msgPolicyName, String type) {
        GroupTreeObjectLast el = this.m_treeRoot.findElement(msgPolicyName, type);
        if (el == null) {
            GroupTreeObject lostAndFound = GroupTreeObject.createPath(LOST_AND_FOUND, this.m_treeRoot);
            GroupTreeObjectLast pol = new GroupTreeObjectLast(new TreeObject(msgPolicyName, type, null), null, null);
            try {
                lostAndFound.addElement(pol);
                sb.append("Policy ").append(msgPolicyName).append(" found\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            isUpdated = true;
        }
        return isUpdated;
    }

    public void repairNames(String filename, AbstractPolicy policy) {
        policy.setName(filename);
        this.m_policy_factory.storePolicy(SPolicyRepository.getPolicyDir(), policy);
    }

    private void emergencyCreateEmptyTree() {
        this.m_treeRoot = new GroupTreeObject(new TreeObject("root", "", null));
        GroupTreeObject Policies = new GroupTreeObject(new TreeObject(POLICIES_TREE_NAME, "toplevel", null));
        this.m_treeRoot.addElement(Policies);
        this.saveTree();
    }

    private void addPolicy(AbstractPolicy p, String file) {
        if (p == null || file == null) {
            return;
        }
        for (AbstractCondition c : p.getConditions().getConditionList()) {
            if (c.getHelptext() == null || c.getHelptext().length() <= 0) continue;
            this.m_helps.put(c.getHelptextId(), c.getHelptext());
        }
        this.m_files.put(p.getName(), file);
        if (p instanceof Policy) {
            this.m_knownMonitors.put(p.getName(), (Policy)p);
        } else if (p instanceof MsgPolicy) {
            this.m_knownMsgPolicies.put(p.getName(), (MsgPolicy)p);
        }
    }

    public Policy getMonitorPolicy(String name) {
        Policy p = this.m_knownMonitors.get(name);
        if (p != null) {
            this.checkFile(name, "mon");
        }
        return p;
    }

    public boolean isDamagedMonitorPolicy(String name) {
        return this.m_damagedMonitors.keySet().contains(name);
    }

    public MsgPolicy getMessagePolicy(String name) {
        MsgPolicy p = this.m_knownMsgPolicies.get(name);
        if (p != null) {
            this.checkFile(name, "msg");
        }
        return p;
    }

    public boolean isDamagedMessagePolicy(String name) {
        return this.m_damagedMsgPolicies.keySet().contains(name);
    }

    public Set<String> getMonitorPolicyList() {
        return this.m_knownMonitors.keySet();
    }

    public Set<String> getMessagePolicyList() {
        return this.m_knownMsgPolicies.keySet();
    }

    public Map<String, AbstractPolicy> getAllPolicyMap() {
        HashMap<String, AbstractPolicy> known = new HashMap<String, AbstractPolicy>();
        known.putAll(this.m_knownMonitors);
        known.putAll(this.m_knownMsgPolicies);
        return known;
    }

    public void checkFile(String name, String type) {
        File polFile;
        if (type.equals("mon")) {
            File polFile2 = new File(this.m_srvPolicyDir, name + ".mon.xml");
            if (!polFile2.exists()) {
                try {
                    this.m_policy_factory.storePolicy(this.m_knownMonitors.get(name), polFile2);
                }
                catch (Throwable e) {
                    RTLogger.print(2, "Can not restore Policy " + name, e);
                }
            }
        } else if (type.equals("msg") && !(polFile = new File(this.m_srvPolicyDir, name + ".msg.xml")).exists()) {
            try {
                this.m_policy_factory.storePolicy(this.m_knownMsgPolicies.get(name), polFile);
            }
            catch (Throwable e) {
                RTLogger.print(2, "Can not restore Policy " + name, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipContent(String tempFileName) {
        long t = System.currentTimeMillis();
        File zip = new File(tempFileName);
        if (zip.exists()) {
            zip.delete();
        }
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zip));
            File[] filenames = new File(m_policyDirectory).listFiles();
            byte[] buf = new byte[64000];
            for (int i = 0; i < filenames.length; ++i) {
                int len;
                if (!filenames[i].getName().endsWith(".xml")) continue;
                in = new FileInputStream(filenames[i]);
                out.putNextEntry(new ZipEntry(filenames[i].getName()));
                CRC32 crc = new CRC32();
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                    crc.update(buf);
                }
                RTLogger.print(3, filenames[i].getName() + "=" + crc.getValue());
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            RTLogger.print(4, "", e);
        }
        catch (IOException e) {
            RTLogger.print(4, "", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable e) {}
            }
        }
        RTLogger.print(3, "Policies zip time: " + (System.currentTimeMillis() - t));
    }

    public static String getPolicyDir() {
        return m_policyDirectory;
    }

    public static void setPolicyDir(String dir) {
        m_policyDirectory = dir;
    }

    public static String getPolicyGroupsFile() {
        return m_policyDirectory + File.separator + POLICYGROUP_XML;
    }

    public String getFilename(String policyOrMonitorName) {
        File toTest;
        String fname = this.m_files.get(policyOrMonitorName);
        if (fname != null && !(toTest = new File(this.m_srvPolicyDir, fname)).exists()) {
            toTest = new File(this.m_srvPolicyDir, policyOrMonitorName + ".mon.xml");
            if (toTest.exists()) {
                this.m_files.put(policyOrMonitorName, toTest.getName());
                fname = toTest.getName();
            } else {
                toTest = new File(this.m_srvPolicyDir, policyOrMonitorName + ".msg.xml");
                if (toTest.exists()) {
                    this.m_files.put(policyOrMonitorName, toTest.getName());
                    fname = toTest.getName();
                }
            }
        }
        return fname;
    }

    public void createMonitorPolicy(Policy p, String filename, String treePath) {
        Policy old = this.getMonitorPolicy(p.getName());
        if (old != null) {
            if (PolicyFactory.getVersionAsInt(old.getVersion()) < PolicyFactory.getVersionAsInt(p.getVersion())) {
                File bkp = new File(this.m_srvPolicyDir, this.getFilename(old.getName()) + "." + old.getVersion());
                this.m_policy_factory.storePolicy(old, bkp);
            } else {
                RTLogger.print(4, "Policy:" + p.getName() + " backup not enforced");
            }
        }
        if (this.m_treeRoot.findElement(p.getName(), "mon") == null) {
            GroupTreeObject gtoParent = this.m_treeRoot.searchPath(treePath, "");
            if (gtoParent == null) {
                gtoParent = GroupTreeObject.createPath(treePath, this.m_treeRoot);
            }
            if (gtoParent == null || gtoParent.getPath().equals(this.m_treeRoot.getPath())) {
                gtoParent = this.m_treeRoot.getFirstChild(POLICIES_TREE_NAME);
                treePath = "/root/Policies";
            }
            if (gtoParent != null) {
                RTLogger.print(4, "Found tree path:" + treePath);
                gtoParent.addElement(new GroupTreeObjectLast(new TreeObject(p.getName(), "mon", p), null, null));
                this.saveTree();
            } else {
                RTLogger.print(2, "Error creating new policy: " + p.getName() + " Can't find or create a tree path: " + treePath);
                return;
            }
        }
        File newPolicy = new File(this.m_srvPolicyDir, filename);
        this.m_policy_factory.storePolicy(p, newPolicy);
        this.addPolicy(p, newPolicy.getName());
    }

    public void createMessagePolicy(MsgPolicy p, String filename, String treePath) {
        MsgPolicy old = this.getMessagePolicy(p.getName());
        if (old != null) {
            if (PolicyFactory.getVersionAsInt(old.getVersion()) < PolicyFactory.getVersionAsInt(p.getVersion())) {
                File bkp = new File(this.m_srvPolicyDir, this.getFilename(old.getName()) + "." + old.getVersion());
                this.m_policy_factory.storePolicy(old, bkp);
            } else {
                RTLogger.print(4, "MsgPolicy:" + p.getName() + " backup not enforced");
            }
        }
        if (this.m_treeRoot.findElement(p.getName(), "msg") == null) {
            GroupTreeObject gtoParent = this.m_treeRoot.searchPath(treePath, "");
            if (gtoParent == null) {
                gtoParent = GroupTreeObject.createPath(treePath, this.m_treeRoot);
            }
            if (gtoParent == null || gtoParent.getPath().equals(this.m_treeRoot.getPath())) {
                gtoParent = this.m_treeRoot.getFirstChild(POLICIES_TREE_NAME);
                treePath = "/root/Policies";
            }
            if (gtoParent != null) {
                RTLogger.print(4, "Found tree path:" + treePath);
                gtoParent.addElement(new GroupTreeObjectLast(new TreeObject(p.getName(), "msg", p), null, null));
                this.saveTree();
            } else {
                RTLogger.print(2, "Error creating new policy: " + p.getName() + " Can't find or create a tree path: " + treePath);
                return;
            }
        }
        File newPolicy = new File(this.m_srvPolicyDir, filename);
        this.m_policy_factory.storePolicy(p, newPolicy);
        this.addPolicy(p, newPolicy.getName());
    }

    public void _assignMonitorPolicy(String policyName, String agentID, String login) {
        List<String> al = this.m_agentAssignmentsMonitors.get(agentID);
        if (al == null) {
            al = new ArrayList<String>();
            this.m_agentAssignmentsMonitors.put(agentID, al);
        }
        if (!al.contains(policyName)) {
            al.add(policyName);
            RTLogger.print(3, "Policy " + policyName + " assigned to " + agentID);
        }
    }

    public void _deassignMonitorPolicy(String policyName, String agentID) {
        List<String> ala;
        List<String> al = this.m_agentDeAssignmentsMonitors.get(agentID);
        if (al == null) {
            al = new ArrayList<String>();
            this.m_agentDeAssignmentsMonitors.put(agentID, al);
        }
        if (!al.contains(policyName)) {
            al.add(policyName);
            RTLogger.print(5, "Monitor Policy " + policyName + " will be de-assigned from Agent" + agentID);
        }
        if ((ala = this.m_agentAssignmentsMonitors.get(agentID)) != null && ala.contains(policyName)) {
            ala.remove(policyName);
        }
    }

    public void _assignMessagePolicy(String policyName, String agentID, String login) {
        List<String> al = this.m_agentAssignmentsMsgs.get(agentID);
        if (al == null) {
            al = new ArrayList<String>();
            this.m_agentAssignmentsMsgs.put(agentID, al);
        }
        if (!al.contains(policyName)) {
            al.add(policyName);
            this.m_agentAssignmentsMsgs.put(agentID, al);
            RTLogger.print(3, "Policy " + policyName + " assigned to " + agentID);
        }
    }

    public void _deassignMessagePolicy(String policyName, String agentID) {
        List<String> ala;
        List<String> al = this.m_agentDeAssignmentsMsgs.get(agentID);
        if (al == null) {
            al = new ArrayList<String>();
            this.m_agentDeAssignmentsMsgs.put(agentID, al);
        }
        if (!al.contains(policyName)) {
            al.add(policyName);
            RTLogger.print(5, "Message Policy " + policyName + " will be de-assigned from Agent" + agentID);
        }
        if ((ala = this.m_agentAssignmentsMsgs.get(agentID)) != null && ala.contains(policyName)) {
            ala.remove(policyName);
        }
    }

    public void removeFromKnownMonitors(String policyName, boolean saveTree) {
        this.m_knownMonitors.remove(policyName);
        this.m_files.remove(policyName);
        GroupTreeObjectLast gto = this.m_treeRoot.findElement(policyName, "mon");
        if (gto != null) {
            gto.getParent().removeElement(gto);
        }
        if (saveTree) {
            this.saveTree();
        }
    }

    public void removeFromKnownMsgPolicies(String policyName, boolean saveTree) {
        this.m_knownMsgPolicies.remove(policyName);
        this.m_files.remove(policyName);
        GroupTreeObjectLast gto = this.m_treeRoot.findElement(policyName, "msg");
        if (gto != null) {
            gto.getParent().removeElement(gto);
        }
        if (saveTree) {
            this.saveTree();
        }
    }

    public PolicyFactory getPolicyFactory() {
        return this.m_policy_factory;
    }

    @Override
    public GroupTreeObject getPolicyTree() {
        return this.m_treeRoot;
    }

    public Map<String, String> getHelps() {
        return this.m_helps;
    }

    public synchronized void saveTree() {
        XMLTree xmlTools = new XMLTree();
        Document doc = xmlTools.getXML(this.m_treeRoot);
        File bkpFile = BkpFile.backup(SPolicyRepository.getPolicyGroupsFile());
        File gt = new File(SPolicyRepository.getPolicyGroupsFile());
        try {
            XMLFactory.writeXml(doc, SPolicyRepository.getPolicyGroupsFile());
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error saving " + SPolicyRepository.getPolicyGroupsFile(), e);
        }
        if (gt.length() == 0L) {
            try {
                XMLFactory.writeXml(doc, SPolicyRepository.getPolicyGroupsFile());
            }
            catch (Throwable e) {
                RTLogger.print(1, "2xError saving " + SPolicyRepository.getPolicyGroupsFile(), e);
            }
        }
    }

    private void triggerDeployment(String agentID) {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            return;
        }
        List<String> mons = this.m_agentAssignmentsMonitors.get(ac.getAgentID());
        List<String> msgs = this.m_agentAssignmentsMsgs.get(ac.getAgentID());
        this.deploy(ac, mons, msgs);
    }

    public DeployClient deploy(AgentCard ac, List<String> mons, List<String> msgs) {
        DeployClient dc = null;
        ArrayList<String> allPolicies = new ArrayList<String>();
        if (mons != null) {
            allPolicies.addAll(mons);
        }
        if (msgs != null) {
            allPolicies.addAll(msgs);
        }
        if (allPolicies.size() > 0) {
            dc = new DeployClient(ac, allPolicies);
            DeploymentManager.getInstance().schedule(dc);
            this.m_agentAssignmentsMonitors.remove(ac.getAgentID());
            this.m_agentAssignmentsMsgs.remove(ac.getAgentID());
            RTLogger.print(2, "Deployment is scheduled: " + ac.getAgentID());
            SMessage.sendMessage(ac, "Deployment is scheduled for Agent: " + ac.getLabel() + "\nPolicies: " + String.valueOf(allPolicies), 1, "DEPLOY", DeployType.DEPLOY_POLICIES.toString(), ac.getAgentHost(), 0);
        }
        return dc;
    }

    void triggerUnDeployment(String agentID) {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            return;
        }
        List<String> mons = this.m_agentDeAssignmentsMonitors.get(ac.getAgentID());
        List<String> msgs = this.m_agentDeAssignmentsMsgs.get(ac.getAgentID());
        this.undeploy(ac, mons, msgs);
    }

    public DeployClient undeploy(AgentCard ac, List<String> mons, List<String> msgs) {
        int total;
        DeployClient dc = null;
        ArrayList<String> allPolicies = new ArrayList<String>();
        if (mons == null) {
            mons = new ArrayList<String>();
        }
        if (msgs == null) {
            msgs = new ArrayList<String>();
        }
        if ((total = mons.size() + msgs.size()) > 0) {
            try {
                allPolicies.addAll(mons);
                allPolicies.addAll(msgs);
                dc = new DeployClient(ac, mons, msgs);
                DeploymentManager.getInstance().schedule(dc);
                this.m_agentDeAssignmentsMonitors.remove(ac.getAgentID());
                this.m_agentDeAssignmentsMsgs.remove(ac.getAgentID());
                RTLogger.print(2, "UnDeployment is scheduled: " + ac.getAgentID());
                SMessage.sendMessage(ac, "UnDeploy task is scheduled for Agent: " + ac.getLabel() + "\nPolicies: " + String.valueOf(allPolicies), 1, "UNDEPLOY", DeployType.DEPLOY_POLICIES.toString(), ac.getAgentHost(), 0);
            }
            catch (Throwable e) {
                RTLogger.print(2, "UnDeploy of Policies failed", e);
            }
        }
        return dc;
    }

    public void _triggerAllDeployments() {
        HashMap all = new HashMap();
        Iterator<String> iiit = this.m_agentDeAssignmentsMsgs.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        iiit = this.m_agentDeAssignmentsMonitors.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        iiit = this.m_agentAssignmentsMsgs.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        iiit = this.m_agentAssignmentsMonitors.keySet().iterator();
        while (iiit.hasNext()) {
            all.put(iiit.next(), null);
        }
        for (String agentID : all.keySet()) {
            this._triggerDeployments(agentID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _triggerDeployments(String agentID) {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentID, false);
        if (ac == null) {
            GroupTreeObject nodeGroup;
            List<String> toAssign_mons;
            List<String> toAssign_msgs;
            List<String> toDEAssign_mons;
            if (agentID.length() != 32) return;
            String nodeGroupID = agentID;
            List<String> toDEAssign_msgs = this.m_agentDeAssignmentsMsgs.get(nodeGroupID);
            if (toDEAssign_msgs == null) {
                toDEAssign_msgs = new ArrayList<String>(0);
            }
            if ((toDEAssign_mons = this.m_agentDeAssignmentsMonitors.get(nodeGroupID)) == null) {
                toDEAssign_mons = new ArrayList<String>(0);
            }
            if ((toAssign_msgs = this.m_agentAssignmentsMsgs.get(nodeGroupID)) == null) {
                toAssign_msgs = new ArrayList<String>(0);
            }
            if ((toAssign_mons = this.m_agentAssignmentsMonitors.get(nodeGroupID)) == null) {
                toAssign_mons = new ArrayList<String>(0);
            }
            if ((nodeGroup = NodeGroupRepository.getInstance().getNodeGroupTree().findByOID(nodeGroupID)) != null) {
                List<GroupTreeObject> elements = nodeGroup.getAllElements();
                for (GroupTreeObject gto : elements) {
                    if (!(gto instanceof GroupTreeObjectLast) || !"agt".equals(gto.getType())) continue;
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
                    String agentIDinNG = gtol.getLinkedPath();
                    AgentCard ACbyNG = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agentIDinNG, false);
                    if (ACbyNG == null) continue;
                    this.undeploy(ACbyNG, toDEAssign_mons, toDEAssign_msgs);
                    this.deploy(ACbyNG, toAssign_mons, toAssign_msgs);
                }
                this.cleanPendingStates(nodeGroupID, toDEAssign_msgs, toDEAssign_mons, toAssign_msgs, toAssign_mons);
                return;
            } else {
                RTLogger.print(4, "Trigger deployment canceled. NodeGroup OID unknown: " + nodeGroupID);
                this.cleanPendingStates(nodeGroupID, toDEAssign_msgs, toDEAssign_mons, toAssign_msgs, toAssign_mons);
            }
            return;
        } else {
            this.triggerUnDeployment(agentID);
            this.triggerDeployment(agentID);
        }
    }

    private void cleanPendingStates(String nodeGroupID, List<String> toDEAssign_msgs, List<String> toDEAssign_mons, List<String> toAssign_msgs, List<String> toAssign_mons) {
        this.m_agentDeAssignmentsMonitors.remove(nodeGroupID);
        this.m_agentDeAssignmentsMsgs.remove(nodeGroupID);
        this.m_agentAssignmentsMonitors.remove(nodeGroupID);
        this.m_agentAssignmentsMsgs.remove(nodeGroupID);
        for (String assumeUndeployed : toDEAssign_mons) {
            ServerEngine.getInstance().getAssignmentRepository().setUndeployed(nodeGroupID, assumeUndeployed, "mon");
        }
        for (String assumeUndeployed : toDEAssign_msgs) {
            ServerEngine.getInstance().getAssignmentRepository().setUndeployed(nodeGroupID, assumeUndeployed, "msg");
        }
        for (String assumeDeployed : toAssign_mons) {
            ServerEngine.getInstance().getAssignmentRepository().setUploaded(nodeGroupID, assumeDeployed, "mon");
        }
        for (String assumeDeployed : toAssign_msgs) {
            ServerEngine.getInstance().getAssignmentRepository().setUploaded(nodeGroupID, assumeDeployed, "msg");
        }
    }

    public int getPoliciesCount() {
        return this.m_knownMonitors.size() + this.m_knownMsgPolicies.size();
    }

    @Override
    public String resolve(String policyName, String conditionID) {
        String retVal = conditionID;
        Policy p = this.getMonitorPolicy(policyName);
        if (p != null) {
            Condition c = (Condition)p.getConditions().getCondition(conditionID);
            if (c != null) {
                retVal = c.getDescription();
            }
        } else {
            MsgCondition mc;
            MsgPolicy mp = this.getMessagePolicy(policyName);
            if (mp != null && (mc = (MsgCondition)mp.getConditions().getCondition(conditionID)) != null) {
                retVal = mc.getDescription();
            }
        }
        if (retVal.length() == 0) {
            retVal = "<empty>";
        }
        return retVal;
    }

    public GroupTreeObject getPolicyTreeWithMD5() {
        GroupTreeObject rootClone = new GroupTreeObject(new TreeObject("root", "", null));
        try {
            rootClone = this.getPolicyTree().clone();
            List<GroupTreeObjectLast> policies = rootClone.getAllGTOLs();
            for (GroupTreeObjectLast gtol : policies) {
                try {
                    File polFile = this.m_policy_factory.getPolicyFile(SPolicyRepository.getPolicyDir(), gtol.getName(), gtol.getType());
                    if (!polFile.exists()) continue;
                    String crc = AbstractPolicy.doChecksum(polFile);
                    gtol.setAttribute("MD5", crc);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rootClone;
    }
}

