/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.ServerVirtualThreadPool;
import com.blixx.server.ServerWorker;
import com.blixx.shared.BM;
import com.blixx.shared.SEventFwd;
import com.boom.SocketUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Server
implements Runnable {
    private static volatile Server server = null;
    private boolean isRun = true;
    private int listeningPort = 0;
    private static Semaphore inFlight;
    private static final AtomicInteger currentThreadsCount;
    private static long countGlobal;
    private static long startTime;
    private static double averageW;
    private static double averageWCount;
    private static final AtomicInteger maxConcurrentThreads;
    private static final AtomicLong processedTime;
    private InetAddress inetAddress = null;
    private static final ReadWriteLock rwLock;
    private ServerSocket srvSocket = null;

    protected Server() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Server getInstance(int port, String listenIP, int maxThreads) {
        if (server != null) return server;
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            if (server != null) return server;
            Server tmpInstance = new Server();
            tmpInstance.listeningPort = port;
            if (maxThreads == 0) {
                maxThreads = 1000;
            }
            inFlight = new Semaphore(maxThreads);
            try {
                if (listenIP != null) {
                    tmpInstance.inetAddress = InetAddress.getByName(listenIP);
                }
            }
            catch (Exception e) {
                RTLogger.print(1, "error creating ServerSocket", e);
            }
            server = tmpInstance;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return server;
        }
    }

    @Override
    public void run() {
        try {
            this.createServerSocket();
        }
        catch (Exception e) {
            RTLogger.print(0, "Error creation Server Socket for port " + this.getPort());
            RTLogger.print(0, "Server stopped.");
            System.exit(2);
        }
        Socket clientSocket = null;
        Runtime r = Runtime.getRuntime();
        double minFree = (double)r.maxMemory() / 100.0;
        double minFreeToactivate = 2.0 * minFree;
        while (this.isRun) {
            try {
                SEventFwd se;
                String host;
                boolean sent = false;
                while (sent && (double)(r.maxMemory() - r.totalMemory() + r.freeMemory()) < minFreeToactivate || (double)(r.maxMemory() - r.totalMemory() + r.freeMemory()) < minFree) {
                    if (!sent) {
                        RTLogger.print(1, "!!! Server runs OutOfMemory !!! Less than 1% free memory available");
                        RTLogger.print(1, "!!! Server port: " + BM.AGENT_PORT + " is now disabled !!!");
                        host = ServerEngine.getInstance().getServerProps().getHostname();
                        se = SMessage.createMessage(5, 1, "BOOM Server", host, "BOOM Server", "!!! Server runs OutOfMemory !!! Less than 1% free memory available. (" + (r.maxMemory() - r.totalMemory() + r.freeMemory()) / 0x100000L + " MB free)");
                        se.setKey("BOOM Server:" + host + ":OUTOFMEMORY");
                        se.setCloseMask("BOOM Server:" + host + ":<*>");
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(se);
                        sent = true;
                        this.closeServerSocket();
                        ServerEngine.getInstance().setOutOfMemory(true);
                    }
                    Thread.sleep(1000L);
                }
                if (sent) {
                    RTLogger.print(1, "Free memory is now ok, Server port is activated. (" + (r.maxMemory() - r.totalMemory() + r.freeMemory()) / 0x100000L + " MB free)");
                    host = ServerEngine.getInstance().getServerProps().getHostname();
                    se = SMessage.createMessage(1, 1, "BOOM Server", host, "BOOM Server", "Free memory is now ok, Server port is activated.");
                    se.setKey("BOOM Server:" + host + ":OKMEMORY");
                    se.setCloseMask("BOOM Server:" + host + ":<*>");
                    ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(se);
                    ServerEngine.getInstance().setOutOfMemory(false);
                }
                clientSocket = this.srvSocket.accept();
                try {
                    if (!inFlight.tryAcquire()) {
                        try {
                            clientSocket.close();
                        }
                        catch (IOException host2) {
                            // empty catch block
                        }
                        RTLogger.print(2, "Backpressure: max in-flight reached");
                        continue;
                    }
                    ServerWorker sw = new ServerWorker();
                    sw.setSocket(clientSocket);
                    ServerVirtualThreadPool.getInstance().submit(() -> {
                        try {
                            sw.runAndCloseSocket();
                        }
                        catch (Throwable e) {
                            RTLogger.print(1, "Error in ServerWorker", e);
                        }
                        finally {
                            inFlight.release();
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    RTLogger.print(2, "RejectedExecution for ServerClient Socket.", e);
                }
                catch (Throwable ignore) {
                    if (clientSocket == null) continue;
                    SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
                }
            }
            catch (Throwable e) {
                try {
                    if (this.srvSocket == null || this.srvSocket.isClosed() || !this.srvSocket.isBound()) {
                        try {
                            this.closeServerSocket();
                            this.createServerSocket();
                        }
                        catch (Exception e1) {
                            RTLogger.print(1, "Error creation Server Socket", e);
                        }
                        continue;
                    }
                    RTLogger.print(1, "Error creation Client Socket", e);
                }
                catch (Exception exception) {}
            }
        }
        if (clientSocket != null) {
            SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
        }
        this.closeServerSocket();
        ServerThreadPool.stop();
    }

    private void closeServerSocket() {
        if (this.srvSocket != null) {
            try {
                this.srvSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (Server.getCurrentThreads() > 0) {
                RTLogger.print(1, "Stopping. Not yet stopped server workers: " + Server.getCurrentThreads());
            }
        }
    }

    public void createServerSocket() throws IOException {
        this.srvSocket = this.inetAddress != null ? new ServerSocket(this.getPort(), 100, this.inetAddress) : new ServerSocket(this.getPort(), 100);
        this.srvSocket.setReuseAddress(true);
    }

    public int getPort() {
        return this.listeningPort;
    }

    public static void startThread() {
        currentThreadsCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopThread(long count, long processingTime) {
        currentThreadsCount.decrementAndGet();
        if (count <= 0L) {
            return;
        }
        rwLock.writeLock().lock();
        try {
            int max = maxConcurrentThreads.incrementAndGet();
            long totalPT = 0L;
            totalPT = processedTime.addAndGet(processingTime);
            long delta = System.currentTimeMillis() - startTime;
            if (delta > 10000L && (countGlobal += count) > 0L) {
                max = Math.min(Runtime.getRuntime().availableProcessors(), max);
                averageW = (averageW * averageWCount + (double)totalPT / (double)max) / (averageWCount + (double)countGlobal);
                averageWCount += (double)countGlobal;
                if (RTLogger.getCurrentLevel() >= 4) {
                    RTLogger.print(4, "AVGRNew =" + averageW + " tpt=" + totalPT + " maxt=" + max + " co=" + countGlobal);
                }
                countGlobal = 0L;
                processedTime.set(0L);
                maxConcurrentThreads.set(0);
                startTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            RTLogger.print(5, "warning", e);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    public static int getCurrentThreads() {
        return currentThreadsCount.get();
    }

    public static double getConcurAverage() {
        double res = 0.0;
        rwLock.readLock().lock();
        try {
            res = averageW;
        }
        finally {
            rwLock.readLock().unlock();
        }
        return res;
    }

    public void stop() {
        this.isRun = false;
        this.closeServerSocket();
        server = null;
    }

    static {
        currentThreadsCount = new AtomicInteger();
        countGlobal = 0L;
        startTime = 0L;
        averageW = 0.0;
        averageWCount = 0.0;
        maxConcurrentThreads = new AtomicInteger(1);
        processedTime = new AtomicLong(0L);
        rwLock = new ReentrantReadWriteLock();
    }
}

