/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DBProperties;
import com.blixx.server.utils.BkpFile;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.SortedProperties;
import com.boom.pki.PKI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;

public class ServerProperties {
    private static final String HTTP_PORT = "HTTP_PORT";
    private static final String GUI_PORT = "GUI_PORT";
    public static final String MAIN_SERVER_PORT = "MAIN_SERVER_PORT";
    public static final String AGENT_PORT = "AGENT_PORT";
    private static final String PERF_TABLE_MAX_SIZE_MB = "PERF_TABLE_MAX_SIZE_MB";
    private static final String LOGLEVEL = "LOGLEVEL";
    private static final String LOGDIR = "LOGDIR";
    private static final String VERSION = "VERSION";
    public static final String CLUSTER_NODES = "CLUSTER_NODES";
    private static final String LISTEN_IP = "LISTEN_IP";
    private static final String AUTO_BACKUP = "AUTO_BACKUP";
    private static final String AUTO_CLOSE_DAYS = "AUTO_CLOSE_DAYS";
    private static final String AUTO_ARCHIVE_DAYS = "AUTO_ARCHIVE_DAYS";
    private static final String AUTO_DELETE_DAYS = "AUTO_DELETE_DAYS";
    private static final String MAX_AGENT_THREADS = "MAX_AGENT_THREADS";
    private static final String MAX_DEPLOY_THREADS = "MAX_DEPLOY_THREADS";
    private static final String MAX_UI_THREADS = "MAX_UI_THREADS";
    private static final String USE_SHORT_AGENT_LABELS = "SHORT_LABELS";
    private static final String USE_LOWER_CASE_HOSTNAMES = "HOSTNAMES_LOWERCASE";
    static final String LIC_HOSTS = "LH";
    static final String LIC_USERS = "LU";
    static final String LIC_AGENTS = "LA";
    static final String LIC_B2B = "BB";
    static final String LIC_SM = "SM";
    public static final String HB_INTERVAL = "HB_INTERVAL";
    public static final String HB_CTIMEOUT = "HB_CTIMEOUT";
    public static final String HB_RTIMEOUT = "HB_RTIMEOUT";
    public static final String FW_AGENTS_OFFLINE_TIMEOUT = "FW_AGENTS_OFFLINE_TIMEOUT";
    public static final String AUTO_APPROVAL = "AUTO_APPROVAL";
    private static final String NUM_FAILED_LOGINS_BEFORE_USER_LOCK = "NUM_FAILED_LOGINS_BEFORE_USER_LOCK";
    private static final String USER_LOCK_RETENTION_MS = "USER_LOCK_RETENTION_MS";
    private static final String FAILED_LOGINS_COUNT_RETENTION_MS = "FAILED_LOGINS_COUNT_RETENTION_MS";
    private static final String KS_PASS = "KS_PASS";
    private static final String KS_PASS_ENCODED = "KS_PASS_ENCODED";
    private static final String KS_FILE = "KS_FILE";
    private static final String TS_FILE = "TS_FILE";
    private static final String TS_PASS = "TS_PASS";
    private static final String TS_PASS_ENCODED = "TS_PASS_ENCODED";
    private static final String AGENT_TS_FILE = "AGENT_TS_FILE";
    private static final String AGENT_TS_PASS = "AGENT_TS_PASS";
    private static final String AGENT_TS_PASS_ENCODED = "AGENT_TS_PASS_ENCODED";
    private static final String CERT_EXPIRATION_THRESHOLD_DAYS = "CERT_EXPIRATION_THRESHOLD_DAYS";
    private static final int DEFAULT_CERT_EXPIRATION_THRESHOLD_DAYS = 30;
    private static final String SERVER_ID = "SERVER_ID";
    private static final String CSR_TTL_MS = "CSR_TTL_MS";
    private static final String CSR_STORAGE_DIR = "CSR_STORAGE_DIR";
    private static final String PKI_CONFIG_FILE = "PKI_CONFIG_FILE";
    private static final String PKI_CLASS = "PKI_CLASS";
    public static final String INSTRUCTION_SERVER = "INSTRUCTION_SERVER";
    public static final String IGNORE_PERF_DATA = "IGNORE_PERF_DATA";
    public static final String AUTOCLOSE_FINISHED_ALERTS = "AUTOCLOSE_FINISHED_ALERTS";
    public static final String AUTODETECT_EXTERNAL_HOSTS = "AUTODETECT_EXTERNAL_HOSTS";
    public static final String AUTODETECT_EXTERNAL_HOSTS_FROM_SLAVES = "AUTODETECT_EXTERNAL_HOSTS_FROM_SLAVES";
    public static final String DISABLE_HTTP_USERAUTH = "DISABLE_HTTP_USERAUTH";
    public static final String MAIN_SERVER_IP = "MAIN_SERVER_IP";
    public static final String MAIN_SERVER_NAME = "MAIN_SERVER_NAME";
    public static final String AGENT_ID = "AGENT_ID";
    public static final String AZURE_LISTENER = "AZURE_LISTENER";
    public static final String IOTHUB_CONNECTION = "IOTHUB_CONNECTION";
    public static final String BLOBSTORE_CONNECTION = "BLOBSTORE_CONNECTION";
    public static final String EVENTHUB_CONNECTION = "EVENTHUB_CONNECTION";
    public static final String USE_LAST_DUPLICATE_TEXT = "USE_LAST_DUPLICATE_TEXT";
    public static final String LOAD_BALANCING_IP = "LOAD_BALANCING_IP";
    protected static ServerProperties m_sp = null;
    public static String SERVER_PROP_FILENAME = BM.PRODUCT_lowercase + ".props";
    public static String SERVER_PROP_FILENAME_OLD = "BOOM".toLowerCase() + ".props";
    public static String DB_PROP_FILENAME = "db.props";
    public static String DB_PERF_PROP_FILENAME = "db_perf.props";
    public static final String AUDITLOGDIR = "AUDITLOGDIR";
    public static final String AUDITLOGSIZE = "AUDITLOGSIZE";
    public static final String AUDITLOGCOUNT = "AUDITLOGCOUNT";
    public static final String AUDITENABLE = "AUDITENABLE";
    private static String m_thisHostName = "localhost";
    private String m_thisHostIP = "127.0.0.1";
    private final List<String> hostIPs = new ArrayList<String>(2);
    private int m_serverPort = BM.SERVER_PORT;
    private int m_agentPort = BM.AGENT_PORT;
    private int m_clientPort = BM.CLIENT_PORT;
    private int m_httpPort = 8888;
    private long m_maxPerfTableSizeMB = 50L;
    static String m_lic_users = "";
    static String m_lic_hosts = "";
    static String m_lic_agents = "";
    static String m_lic_b2b = "";
    static String m_lic_sm = "";
    private String m_clusterNodes = "";
    protected SortedProperties m_props = new SortedProperties();
    protected Properties m_DBprops = null;
    protected Properties m_DBPerfprops = null;
    private static int MAX_CONNECTED_USERS = 0;
    private static int MAX_ENABLED_AGENTS = 0;
    private static int MAX_ENABLED_HOSTS = 0;
    private static int MAX_ENABLED_BB = 0;
    private static int m_runtime_maxLA = -1;
    private static int m_runtime_maxLU = -1;
    private static int m_runtime_maxLH = -1;
    private static int m_runtime_maxBB = -1;
    private static int m_runtime_SM = -1;
    private static int m_runtime_ARCH = -1;
    private int m_maxAgentThreads = 0;
    private int m_maxDeployThreads = 10;
    private int m_maxUIThreads = 500;
    private int m_HB_interval = 10;
    private boolean m_autoApproval = false;
    private long csrTTLMs = TimeUnit.DAYS.toMillis(7L);
    private String csrStorageDir;
    private Path pkiConfigFile = null;
    private String pkiClass = null;
    private final AtomicInteger m_logLevel = new AtomicInteger(1);
    private String m_logDir = ".";
    static Map<String, Integer> m_mpiLicenses = new HashMap<String, Integer>();
    private static final int[] bb = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 2, 20, 22, 10, 1, 1, 22, 3, 4, 2};
    private String m_listenIP = null;
    private static int m_autoClose = -1;
    private static int m_autoArchive = -1;
    private static int m_autoDelete = -1;
    private boolean m_useAgentShortLabels = false;
    private boolean m_useHostLowercase = false;
    private String m_instruction_server = null;
    public static final String PRODUCT_VERSION = "5.11.0";
    private int m_hb_ctimeout = 3000;
    private int m_hb_rtimeout = 10000;
    private int m_fw_agent_offline_timeout = 60000;
    private String m_auditLogDir = ".";
    private int m_auditLogSizeMB = 10;
    private int m_auditLogCount = 5;
    private boolean m_auditEnabled = false;
    private Boolean m_autocloseFinishedAlert = null;
    private Boolean m_autoDetectExternalHosts = null;
    private Boolean m_autoDetectExternalHostsFromSlaves = null;
    private Boolean m_disableHttpUserAuth = null;
    private Boolean m_azure_listener = null;
    private String iotHubConnectionString = null;
    private String blobStorageConnectionString = null;
    private String eventHubConnectionString = null;
    private String tsPassEncoded = null;
    private String tsFile = null;
    private String agentTsPassEncoded = null;
    private String agentTsFile = null;
    private String ksPassEncoded = null;
    private String ksFile = null;
    private int certExpirationThresholdDays = 30;
    private int maxFailedLoginsInARawBeforeLock = 9;
    private long userLockRetentionPeriodMs = TimeUnit.MINUTES.toMillis(10L);
    private long failedLoginCountRetentionPeriodMs = TimeUnit.HOURS.toMillis(1L);
    private boolean useLastDuplicateText = false;
    private final Set<String> allHostnames = new LinkedHashSet<String>();
    private final Set<String> allIPs = new LinkedHashSet<String>();
    private String serverID = null;
    private final AtomicBoolean m_ignorePerfData = new AtomicBoolean(false);
    private List<String> loadBlancingIPs = new ArrayList<String>();

    private ServerProperties() {
        ServerProperties.setMAX_CONNECTED_USERS(1, "booff00123");
        ServerProperties.setMAX_ENABLED_AGENTS(1, "booff00124");
    }

    public static void testLic(Object o) {
        ServerProperties.getMAX_ENABLED_HOSTS(o, true);
    }

    public static synchronized ServerProperties getMockInstance() {
        return new ServerProperties();
    }

    public static synchronized ServerProperties load(String dir) {
        String lockRetentionPeriodStr;
        String maxNumFailedLoginsStr;
        String auditLogdir;
        File ald;
        String disableHttpUAuth;
        String adehFromSlaves;
        String adeh;
        String acfa;
        String ipd;
        String uhl;
        String autoDelete;
        String autoArchive;
        String lic_SM;
        String lic_BB;
        String lic_hosts;
        String lic_users;
        String loglevel;
        String maxPerfTblSize;
        String defaultHTTPPort;
        String defaultClientPort;
        String defaultAgentPort;
        String defaultServerPort;
        LinkedList<String> exceptionsDuringLoadProperties = new LinkedList<String>();
        m_sp = new ServerProperties();
        try {
            String mainAddr;
            InetAddress[] all;
            try {
                m_thisHostName = InetAddress.getLocalHost().getCanonicalHostName();
                String hostaddress = InetAddress.getLocalHost().getHostAddress();
                if (hostaddress != null && hostaddress.equals(m_thisHostName)) {
                    throw new RuntimeException("Unresolved IP: " + hostaddress);
                }
            }
            catch (Throwable e) {
                try {
                    m_thisHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (InetAddress addr : all = InetAddress.getAllByName(m_thisHostName)) {
                if (addr == null || addr.isAnyLocalAddress() || addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress() || addr.isMulticastAddress()) continue;
                ServerProperties.m_sp.hostIPs.add(addr.getHostAddress());
            }
            try {
                Enumeration<NetworkInterface> nises = NetworkInterface.getNetworkInterfaces();
                while (nises.hasMoreElements()) {
                    NetworkInterface nic = nises.nextElement();
                    if (!nic.isUp()) continue;
                    Enumeration<InetAddress> en = nic.getInetAddresses();
                    while (en.hasMoreElements()) {
                        String hostAddress = en.nextElement().getHostAddress();
                        int pt = hostAddress.indexOf(37);
                        if (pt != -1) {
                            hostAddress = hostAddress.substring(0, pt);
                        }
                        if (hostAddress.startsWith("127.") || hostAddress.equals("::1") || hostAddress.equals("0:0:0:0:0:0:0:1") || ServerProperties.m_sp.hostIPs.contains(hostAddress)) continue;
                        ServerProperties.m_sp.hostIPs.add(hostAddress);
                    }
                }
                Collections.sort(ServerProperties.m_sp.hostIPs);
            }
            catch (Throwable nises) {
                // empty catch block
            }
            InetAddress main = InetAddress.getByName(m_thisHostName);
            ServerProperties.m_sp.m_thisHostIP = mainAddr = main.getHostAddress();
            if (mainAddr.startsWith("127.") || mainAddr.equals("::1") || mainAddr.equals("0:0:0:0:0:0:0:1")) {
                for (InetAddress inetAddress : all) {
                    String addr = inetAddress.getHostAddress();
                    if (addr.startsWith("127.") || addr.equals("::1") || addr.equals("0:0:0:0:0:0:0:1")) continue;
                    ServerProperties.m_sp.m_thisHostIP = addr;
                    break;
                }
            }
            System.out.println("Server starting. Hostname:" + m_thisHostName + " IP:" + ServerProperties.m_sp.m_thisHostIP);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(401);
        }
        File m_propsFile = new File(dir + File.separator + SERVER_PROP_FILENAME);
        if (!m_propsFile.exists()) {
            File old = new File(dir + File.separator + SERVER_PROP_FILENAME_OLD);
            if (old.exists()) {
                ServerProperties.m_sp.m_props = ServerProperties.readProps(old);
                if (ServerProperties.m_sp.m_props != null) {
                    ServerProperties.saveProps();
                    old.delete();
                }
            }
        } else {
            ServerProperties.m_sp.m_props = ServerProperties.readProps(m_propsFile);
        }
        if (ServerProperties.m_sp.m_props == null) {
            throw new RuntimeException("Cannot read server properties from " + m_propsFile.getAbsolutePath());
        }
        String logdir = ServerProperties.m_sp.m_props.getProperty(LOGDIR, "./logs");
        String exception = null;
        if (logdir != null) {
            try {
                logdir = FileUtils.resolveEnvVars(logdir);
                m_sp.setLogDir(logdir);
            }
            catch (Exception e) {
                exception = e.getMessage();
                try {
                    m_sp.setLogDir(".");
                }
                catch (Exception hostAddress) {}
            }
        } else {
            try {
                m_sp.setLogDir(".");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        RTLogger.storeConfig();
        RTLogger.print(0, "----------------- server start -----------------");
        if (exception != null) {
            RTLogger.print(1, "Error setting new LOGDIR: " + logdir + " (" + exception + ")");
        }
        if ((defaultServerPort = ServerProperties.m_sp.m_props.getProperty(MAIN_SERVER_PORT)) != null) {
            try {
                ServerProperties.m_sp.m_serverPort = Integer.parseInt(defaultServerPort);
            }
            catch (NumberFormatException hostAddress) {
                // empty catch block
            }
        }
        if ((defaultAgentPort = ServerProperties.m_sp.m_props.getProperty(AGENT_PORT)) != null) {
            try {
                ServerProperties.m_sp.m_agentPort = Integer.parseInt(defaultAgentPort);
            }
            catch (NumberFormatException pt) {
                // empty catch block
            }
        }
        if ((defaultClientPort = ServerProperties.m_sp.m_props.getProperty(GUI_PORT)) != null) {
            try {
                ServerProperties.m_sp.m_clientPort = Integer.parseInt(defaultClientPort);
            }
            catch (NumberFormatException inetAddress) {
                // empty catch block
            }
        }
        if ((defaultHTTPPort = ServerProperties.m_sp.m_props.getProperty(HTTP_PORT)) != null) {
            try {
                ServerProperties.m_sp.m_httpPort = Integer.parseInt(defaultHTTPPort);
            }
            catch (NumberFormatException addr) {
                // empty catch block
            }
        }
        if ((maxPerfTblSize = ServerProperties.m_sp.m_props.getProperty(PERF_TABLE_MAX_SIZE_MB)) != null) {
            try {
                ServerProperties.m_sp.m_maxPerfTableSizeMB = Long.parseLong(maxPerfTblSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((loglevel = ServerProperties.m_sp.m_props.getProperty(LOGLEVEL)) == null || loglevel.trim().isEmpty()) {
            m_sp.setLogLevel(1);
        } else {
            try {
                int level = Integer.parseInt(loglevel);
                m_sp.setLogLevel(level);
            }
            catch (NumberFormatException e) {
                m_sp.setLogLevel(1);
            }
        }
        RTLogger.storeConfig();
        String maxat = ServerProperties.m_sp.m_props.getProperty(MAX_AGENT_THREADS);
        try {
            ServerProperties.m_sp.m_maxAgentThreads = Integer.parseInt(maxat);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String maxdt = ServerProperties.m_sp.m_props.getProperty(MAX_DEPLOY_THREADS);
        try {
            int parseInt = Integer.parseInt(maxdt);
            if (parseInt > 5) {
                ServerProperties.m_sp.m_maxDeployThreads = parseInt;
            }
        }
        catch (Throwable parseInt) {
            // empty catch block
        }
        String maxui = ServerProperties.m_sp.m_props.getProperty(MAX_UI_THREADS);
        try {
            int parseInt = Integer.parseInt(maxui);
            if (parseInt > 5) {
                ServerProperties.m_sp.m_maxUIThreads = parseInt;
            }
        }
        catch (Throwable parseInt) {
            // empty catch block
        }
        String lic_agents = ServerProperties.m_sp.m_props.getProperty(LIC_AGENTS);
        if (lic_agents != null) {
            m_lic_agents = lic_agents;
        }
        if ((lic_users = ServerProperties.m_sp.m_props.getProperty(LIC_USERS)) != null) {
            m_lic_users = lic_users;
        }
        if ((lic_hosts = ServerProperties.m_sp.m_props.getProperty(LIC_HOSTS)) != null) {
            m_lic_hosts = lic_hosts;
        }
        if ((lic_BB = ServerProperties.m_sp.m_props.getProperty(LIC_B2B)) != null) {
            m_lic_b2b = lic_BB;
        }
        if ((lic_SM = ServerProperties.m_sp.m_props.getProperty(LIC_SM)) != null) {
            m_lic_sm = lic_SM;
        }
        for (Object o : ServerProperties.m_sp.m_props.keySet()) {
            String key = String.valueOf(o);
            if (!key.startsWith("LIC_")) continue;
            m_mpiLicenses.put(key + "=" + ServerProperties.m_sp.m_props.getProperty(key), null);
        }
        String hbInterval = ServerProperties.m_sp.m_props.getProperty(HB_INTERVAL, "5");
        try {
            ServerProperties.m_sp.m_HB_interval = Integer.parseInt(hbInterval);
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect HB_INTERVAL");
        }
        String hbcto = ServerProperties.m_sp.m_props.getProperty(HB_CTIMEOUT, "10000");
        try {
            ServerProperties.m_sp.m_hb_ctimeout = Integer.parseInt(hbcto);
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect value for HB_CTIMEOUT");
        }
        String hbrto = ServerProperties.m_sp.m_props.getProperty(HB_RTIMEOUT, "10000");
        try {
            ServerProperties.m_sp.m_hb_rtimeout = Integer.parseInt(hbrto);
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect value for HB_RTIMEOUT");
        }
        String fwaoflineto = ServerProperties.m_sp.m_props.getProperty(FW_AGENTS_OFFLINE_TIMEOUT, "60000");
        try {
            m_sp.setFw_agent_offline_timeout(Integer.parseInt(fwaoflineto));
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect value for FW_AGENTS_OFFLINE_TIMEOUT");
        }
        String autoapproval = ServerProperties.m_sp.m_props.getProperty(AUTO_APPROVAL, "false");
        try {
            ServerProperties.m_sp.m_autoApproval = Boolean.parseBoolean(autoapproval);
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect AUTO_APPROVAL");
        }
        String csrTTLStr = ServerProperties.m_sp.m_props.getProperty(CSR_TTL_MS, "604800000");
        try {
            ServerProperties.m_sp.csrTTLMs = Long.parseLong(csrTTLStr);
        }
        catch (Throwable e) {
            exceptionsDuringLoadProperties.add("Incorrect CSR_TTL_MS");
        }
        ServerProperties.m_sp.csrStorageDir = ServerProperties.m_sp.m_props.getProperty(CSR_STORAGE_DIR, "./srv/etc/agtcerts");
        String pkiConfigFile = ServerProperties.m_sp.m_props.getProperty(PKI_CONFIG_FILE);
        if (pkiConfigFile != null) {
            ServerProperties.m_sp.pkiConfigFile = Paths.get(pkiConfigFile, new String[0]);
        }
        ServerProperties.m_sp.pkiClass = ServerProperties.m_sp.m_props.getProperty(PKI_CLASS, "com.blixx.server.pki.BoomPKI");
        String abe = ServerProperties.m_sp.m_props.getProperty(AUTO_BACKUP, "true");
        try {
            boolean isAutoBackupEnabled = Boolean.parseBoolean(abe);
            if (!isAutoBackupEnabled) {
                BkpFile.isEnabled = false;
            }
        }
        catch (Throwable isAutoBackupEnabled) {
            // empty catch block
        }
        String autoClose = ServerProperties.m_sp.m_props.getProperty(AUTO_CLOSE_DAYS);
        if (autoClose != null) {
            try {
                m_autoClose = Integer.parseInt(autoClose);
                if (m_autoClose < 1) {
                    m_autoClose = -1;
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTO_CLOSE_DAYS");
            }
        }
        if ((autoArchive = ServerProperties.m_sp.m_props.getProperty(AUTO_ARCHIVE_DAYS)) != null) {
            try {
                m_autoArchive = Integer.parseInt(autoArchive);
                if (m_autoArchive < 1) {
                    m_autoArchive = -1;
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTO_ARCHIVE_DAYS");
            }
        }
        if ((autoDelete = ServerProperties.m_sp.m_props.getProperty(AUTO_DELETE_DAYS)) != null) {
            try {
                m_autoDelete = Integer.parseInt(autoDelete);
                if (m_autoDelete < 1) {
                    m_autoDelete = -1;
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTO_DELETE_DAYS");
            }
        }
        ServerProperties.m_sp.m_listenIP = ServerProperties.m_sp.m_props.getProperty(LISTEN_IP);
        ServerProperties.m_sp.m_clusterNodes = ServerProperties.m_sp.m_props.getProperty(CLUSTER_NODES, "");
        String uasl = ServerProperties.m_sp.m_props.getProperty(USE_SHORT_AGENT_LABELS);
        if (uasl != null) {
            try {
                ServerProperties.m_sp.m_useAgentShortLabels = Boolean.parseBoolean(uasl);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect SHORT_LABELS");
            }
        }
        if ((uhl = ServerProperties.m_sp.m_props.getProperty(USE_LOWER_CASE_HOSTNAMES)) != null) {
            try {
                ServerProperties.m_sp.m_useHostLowercase = Boolean.parseBoolean(uhl);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect HOSTNAMES_LOWERCASE");
            }
        }
        if ((ipd = ServerProperties.m_sp.m_props.getProperty(IGNORE_PERF_DATA)) != null) {
            try {
                ServerProperties.m_sp.m_ignorePerfData.set(Boolean.parseBoolean(ipd));
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect IGNORE_PERF_DATA");
            }
        }
        if ((acfa = ServerProperties.m_sp.m_props.getProperty(AUTOCLOSE_FINISHED_ALERTS)) != null) {
            try {
                ServerProperties.m_sp.m_autocloseFinishedAlert = Boolean.parseBoolean(acfa);
                if (ServerProperties.m_sp.m_autocloseFinishedAlert.booleanValue()) {
                    RTLogger.print(1, "Autoclose finished alerts enabled.");
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTOCLOSE_FINISHED_ALERTS");
            }
        }
        if ((adeh = ServerProperties.m_sp.m_props.getProperty(AUTODETECT_EXTERNAL_HOSTS)) != null) {
            try {
                ServerProperties.m_sp.m_autoDetectExternalHosts = Boolean.parseBoolean(adeh);
                if (ServerProperties.m_sp.m_autoDetectExternalHosts.booleanValue()) {
                    RTLogger.print(1, "AutoDetect External hosts enabled.");
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTODETECT_EXTERNAL_HOSTS");
            }
        }
        if ((adehFromSlaves = ServerProperties.m_sp.m_props.getProperty(AUTODETECT_EXTERNAL_HOSTS_FROM_SLAVES)) != null) {
            try {
                ServerProperties.m_sp.m_autoDetectExternalHostsFromSlaves = Boolean.parseBoolean(adehFromSlaves);
                if (ServerProperties.m_sp.m_autoDetectExternalHostsFromSlaves.booleanValue()) {
                    RTLogger.print(1, "AutoDetect External hosts from slaves enabled.");
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect AUTODETECT_EXTERNAL_HOSTS_FROM_SLAVES");
            }
        }
        if ((disableHttpUAuth = ServerProperties.m_sp.m_props.getProperty(DISABLE_HTTP_USERAUTH)) != null) {
            try {
                ServerProperties.m_sp.m_disableHttpUserAuth = Boolean.parseBoolean(disableHttpUAuth);
                if (ServerProperties.m_sp.m_disableHttpUserAuth.booleanValue()) {
                    RTLogger.print(1, "Http User Auth disabled!");
                }
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect DISABLE_HTTP_USERAUTH");
            }
        }
        if (!(ald = new File(auditLogdir = ServerProperties.m_sp.m_props.getProperty(AUDITLOGDIR, "."))).exists() && !ald.mkdirs()) {
            RTLogger.print(1, "Error making audit log directory: " + auditLogdir);
            auditLogdir = ".";
            RTLogger.print(1, "Audit log directory set to default: \".\"");
        }
        ServerProperties.m_sp.m_auditLogDir = auditLogdir;
        try {
            ServerProperties.m_sp.m_auditLogCount = Integer.parseInt(ServerProperties.m_sp.m_props.getProperty(AUDITLOGCOUNT, "5"));
        }
        catch (Throwable e1) {
            RTLogger.print(1, "Error parsing audit log count: " + ServerProperties.m_sp.m_props.getProperty(AUDITLOGCOUNT));
            RTLogger.print(1, "Audit log count set to default: 5");
        }
        try {
            ServerProperties.m_sp.m_auditLogSizeMB = Integer.parseInt(ServerProperties.m_sp.m_props.getProperty(AUDITLOGSIZE, "10"));
        }
        catch (Throwable e1) {
            RTLogger.print(1, "Error parsing audit log size: " + ServerProperties.m_sp.m_props.getProperty(AUDITLOGSIZE));
            RTLogger.print(1, "Audit log count set to default: 10MB");
        }
        try {
            ServerProperties.m_sp.m_auditEnabled = Boolean.parseBoolean(ServerProperties.m_sp.m_props.getProperty(AUDITENABLE, "false"));
        }
        catch (Throwable e1) {
            RTLogger.print(1, "Error parsing audit enable flag: " + ServerProperties.m_sp.m_props.getProperty(AUDITENABLE));
            RTLogger.print(1, "Audit log disabled");
        }
        ServerProperties.m_sp.ksFile = ServerProperties.m_sp.m_props.getProperty(KS_FILE);
        String ksP = ServerProperties.m_sp.m_props.getProperty(KS_PASS);
        if (ksP == null || ksP.isEmpty()) {
            ServerProperties.m_sp.ksPassEncoded = ServerProperties.m_sp.m_props.getProperty(KS_PASS_ENCODED);
        } else {
            ServerProperties.m_sp.ksPassEncoded = Cryptor.encrypt4(ksP);
            ServerProperties.m_sp.m_props.remove(KS_PASS);
        }
        ServerProperties.m_sp.tsFile = ServerProperties.m_sp.m_props.getProperty(TS_FILE);
        String tsP = ServerProperties.m_sp.m_props.getProperty(TS_PASS);
        if (tsP == null || tsP.isEmpty()) {
            ServerProperties.m_sp.tsPassEncoded = ServerProperties.m_sp.m_props.getProperty(TS_PASS_ENCODED);
        } else {
            ServerProperties.m_sp.tsPassEncoded = Cryptor.encrypt4(tsP);
            ServerProperties.m_sp.m_props.remove(TS_PASS);
            ServerProperties.saveProps();
        }
        ServerProperties.m_sp.agentTsFile = ServerProperties.m_sp.m_props.getProperty(AGENT_TS_FILE, "srv/deploy/agent/truststore.p12");
        String agentTsPass = ServerProperties.m_sp.m_props.getProperty(AGENT_TS_PASS);
        if (agentTsPass == null || agentTsPass.isEmpty()) {
            ServerProperties.m_sp.agentTsPassEncoded = ServerProperties.m_sp.m_props.getProperty(AGENT_TS_PASS_ENCODED);
        } else {
            ServerProperties.m_sp.agentTsPassEncoded = Cryptor.encrypt4(agentTsPass);
            ServerProperties.m_sp.m_props.remove(AGENT_TS_PASS);
            ServerProperties.saveProps();
        }
        ServerProperties.m_sp.serverID = ServerProperties.m_sp.m_props.getProperty(SERVER_ID);
        String agentCertExpirationThresholdDaysStr = ServerProperties.m_sp.m_props.getProperty(CERT_EXPIRATION_THRESHOLD_DAYS);
        if (agentCertExpirationThresholdDaysStr != null) {
            try {
                ServerProperties.m_sp.certExpirationThresholdDays = Integer.parseInt(agentCertExpirationThresholdDaysStr);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect CERT_EXPIRATION_THRESHOLD_DAYS");
            }
        }
        if ((maxNumFailedLoginsStr = ServerProperties.m_sp.m_props.getProperty(NUM_FAILED_LOGINS_BEFORE_USER_LOCK)) != null) {
            try {
                ServerProperties.m_sp.maxFailedLoginsInARawBeforeLock = Integer.parseInt(maxNumFailedLoginsStr);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect NUM_FAILED_LOGINS_BEFORE_USER_LOCK");
            }
        }
        if ((lockRetentionPeriodStr = ServerProperties.m_sp.m_props.getProperty(USER_LOCK_RETENTION_MS)) != null) {
            try {
                ServerProperties.m_sp.userLockRetentionPeriodMs = Long.parseLong(lockRetentionPeriodStr);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect USER_LOCK_RETENTION_MS");
            }
        }
        String failLoginCountRetentionPeriodMsStr = ServerProperties.m_sp.m_props.getProperty(FAILED_LOGINS_COUNT_RETENTION_MS);
        if (lockRetentionPeriodStr != null) {
            try {
                ServerProperties.m_sp.failedLoginCountRetentionPeriodMs = Long.parseLong(failLoginCountRetentionPeriodMsStr);
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Incorrect FAILED_LOGINS_COUNT_RETENTION_MS");
            }
        }
        StringBuilder local = new StringBuilder();
        if (ServerProperties.m_sp.ksFile != null) {
            local.append("https://");
        } else {
            local.append("http://");
        }
        local.append(m_sp.getHostname()).append(':').append(m_sp.getHTTPPort()).append("/instructions");
        ServerProperties.m_sp.m_instruction_server = ServerProperties.m_sp.m_props.getProperty(INSTRUCTION_SERVER, local.toString());
        File dBprops = new File(dir + File.separator + DB_PROP_FILENAME);
        File dBPerfprops = new File(dir + File.separator + DB_PERF_PROP_FILENAME);
        ServerProperties.m_sp.m_DBprops = ServerProperties.readProps(dBprops);
        ServerProperties.checkIfPasswordEncrypted(ServerProperties.m_sp.m_DBprops, dBprops, exceptionsDuringLoadProperties);
        ServerProperties.m_sp.m_DBPerfprops = ServerProperties.readProps(dBPerfprops);
        if (ServerProperties.m_sp.m_DBPerfprops == null) {
            ServerProperties.m_sp.m_DBPerfprops = (Properties)ServerProperties.m_sp.m_DBprops.clone();
            String driver = ServerProperties.m_sp.m_DBPerfprops.getProperty("Driver");
            if (driver != null && driver.contains("mysql")) {
                ServerProperties.m_sp.m_DBPerfprops.setProperty(DBProperties.M_DB_NAME, ServerProperties.m_sp.m_DBprops.getProperty(DBProperties.M_DB_NAME) + "_PERF");
            } else {
                ServerProperties.m_sp.m_DBPerfprops.setProperty(DBProperties.M_LOGIN, ServerProperties.m_sp.m_DBprops.getProperty(DBProperties.M_LOGIN) + "_perf");
                ServerProperties.m_sp.m_DBPerfprops.setProperty(DBProperties.M_DB_NAME, ServerProperties.m_sp.m_DBprops.getProperty(DBProperties.M_DB_NAME) + "_PERF");
            }
            try (FileOutputStream fos = new FileOutputStream(dBPerfprops);){
                ServerProperties.m_sp.m_DBPerfprops.store(fos, "");
            }
            catch (Throwable e) {
                exceptionsDuringLoadProperties.add("Error saving DB Perf property file: " + e.getMessage());
            }
        }
        ServerProperties.checkIfPasswordEncrypted(ServerProperties.m_sp.m_DBPerfprops, dBPerfprops, exceptionsDuringLoadProperties);
        for (String err : exceptionsDuringLoadProperties) {
            RTLogger.print(1, err);
        }
        String azureListener = ServerProperties.m_sp.m_props.getProperty(AZURE_LISTENER);
        if (azureListener != null) {
            try {
                ServerProperties.m_sp.m_azure_listener = Boolean.parseBoolean(azureListener);
            }
            catch (Exception e) {
                RTLogger.print(1, "Error flag AZURE_LISTENER value: " + ServerProperties.m_sp.m_props.getProperty(AZURE_LISTENER));
            }
        }
        ServerProperties.m_sp.iotHubConnectionString = ServerProperties.m_sp.m_props.getProperty(IOTHUB_CONNECTION);
        ServerProperties.m_sp.blobStorageConnectionString = ServerProperties.m_sp.m_props.getProperty(BLOBSTORE_CONNECTION);
        ServerProperties.m_sp.eventHubConnectionString = ServerProperties.m_sp.m_props.getProperty(EVENTHUB_CONNECTION);
        for (int i = 1; i < 10; ++i) {
            String lbI = ServerProperties.m_sp.m_props.getProperty(LOAD_BALANCING_IP + i);
            if (lbI == null || lbI.trim().isEmpty()) continue;
            ServerProperties.m_sp.loadBlancingIPs.add(lbI.trim());
        }
        String useLDT = ServerProperties.m_sp.m_props.getProperty(USE_LAST_DUPLICATE_TEXT, "false");
        if (useLDT != null) {
            try {
                ServerProperties.m_sp.useLastDuplicateText = Boolean.parseBoolean(useLDT);
                RTLogger.print(1, "USE_LAST_DUPLICATE_TEXT=" + ServerProperties.m_sp.useLastDuplicateText);
            }
            catch (Exception e) {
                RTLogger.print(1, "Error flag USE_LAST_DUPLICATE_TEXT value: " + ServerProperties.m_sp.m_props.getProperty(USE_LAST_DUPLICATE_TEXT));
            }
        }
        m_sp.checkNetworkInterfaces();
        return m_sp;
    }

    private static void checkIfPasswordEncrypted(Properties p, File f, List<String> errors) {
        String pass = p.getProperty(DBProperties.M_PASSWORD);
        if (pass != null && !pass.trim().isEmpty()) {
            String crpass = Cryptor.encrypt2(pass);
            p.setProperty(DBProperties.M_ENCRYPTED_PASSWORD, crpass);
            try (FileOutputStream out = new FileOutputStream(f);){
                p.setProperty(DBProperties.M_PASSWORD, "");
                p.store(out, "");
            }
            catch (Throwable e) {
                errors.add("Failed to store updated " + f.getName());
            }
        }
    }

    public String getInstruction_server() {
        return this.m_instruction_server;
    }

    public void setInstruction_server(String instructionServer) {
        this.m_instruction_server = instructionServer;
    }

    @Deprecated
    public static long getCloseTime() {
        if (m_autoClose <= 0) {
            return -1L;
        }
        return 86400000L * (long)m_autoClose;
    }

    @Deprecated
    public static long getArchiveTime() {
        if (m_autoArchive <= 0) {
            return -1L;
        }
        return 86400000L * (long)m_autoArchive;
    }

    @Deprecated
    public static long getDeleteTime() {
        if (m_autoDelete <= 0) {
            return -1L;
        }
        return 86400000L * (long)m_autoDelete;
    }

    public static int getCloseDays() {
        if (m_autoClose <= 0) {
            m_autoClose = -1;
        }
        return m_autoClose;
    }

    public static int getArchiveDays() {
        if (m_autoArchive <= 0) {
            m_autoArchive = -1;
        }
        return m_autoArchive;
    }

    public static int getDeleteDays() {
        if (m_autoDelete <= 0) {
            m_autoDelete = -1;
        }
        return m_autoDelete;
    }

    public static void setCloseDays(int days) {
        m_autoClose = days <= 0 ? -1 : days;
    }

    public static void setArchiveDays(int days) {
        m_autoArchive = days <= 0 ? -1 : days;
    }

    public static void setDeleteDays(int days) {
        m_autoDelete = days <= 0 ? -1 : days;
    }

    static int getMAX_CONNECTED_USERS(Object o, boolean force) {
        return Integer.MAX_VALUE;
    }

    static int getMAX_B2B(Object o, boolean force) {
        if (!force && m_runtime_maxBB > 0) {
            return m_runtime_maxBB;
        }
        byte[] arr = o.getClass().getCanonicalName().getBytes();
        int total = 0;
        for (int i = bb[0]; i < 9; ++i) {
            total += arr[i];
        }
        int total1 = (int)((double)(total + 98 + 222 + 109) / 7.7) & MAX_ENABLED_BB;
        if (total1 - MAX_ENABLED_BB != bb[3]) {
            return 0;
        }
        Object[] arr2 = ServerProperties.checkAll(m_thisHostName, "BB=" + m_lic_b2b);
        if ((Integer)arr2[0] > 0 && (Long)arr2[1] > 0L) {
            long daysToExpire = (Long)arr2[1];
            if (daysToExpire >= 0L && daysToExpire < 14L) {
                SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "B2B", "LICENSE", "Your license will expire in " + daysToExpire + " days");
                sm.setKey("BOOM_SERVER:LICENSE:BB:EXPIRE:" + daysToExpire);
                sm.setCloseMask("BOOM_SERVER:LICENSE:BB:EXPIRE:<*>");
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
        } else {
            long daysToExpire = (Long)arr2[1];
            if (daysToExpire < 0L && (Integer)arr2[0] > 0) {
                SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "B2B", "LICENSE", "Your license is expired or invalid " + daysToExpire + " days");
                sm.setKey("BOOM_SERVER:LICENSE:BB:EXPIRE:" + daysToExpire);
                sm.setCloseMask("BOOM_SERVER:LICENSE:BB:EXPIRE:<*>");
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
            arr2[0] = 0;
        }
        m_runtime_maxBB = MAX_ENABLED_BB + (Integer)arr2[0];
        return m_runtime_maxBB;
    }

    static int getMAX_ENABLED_HOSTS(Object o, boolean force) {
        if (!force && m_runtime_maxLH > 0) {
            return m_runtime_maxLH;
        }
        byte[] arr = o.getClass().getCanonicalName().getBytes();
        int total = 0;
        for (int i = 0; i < 9; ++i) {
            if (total > 200) {
                total += arr[i];
                continue;
            }
            total -= arr[i];
        }
        int total1 = (int)((double)(total + 98 + 222 + 109) / 7.1) & MAX_ENABLED_HOSTS;
        MAX_ENABLED_HOSTS = 100;
        Object[] arr2 = ServerProperties.checkAll(m_thisHostName, "LH=" + m_lic_hosts);
        if ((Integer)arr2[0] > 0 && (Long)arr2[1] > 0L) {
            long daysToExpire = (Long)arr2[1];
            if (daysToExpire < 14L) {
                SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", LIC_HOSTS, "LICENSE", "Your license will expire in " + daysToExpire + " days");
                sm.setKey("BOOM_SERVER:LICENSE:LH:EXPIRE:" + daysToExpire);
                sm.setCloseMask("BOOM_SERVER:LICENSE:LH:EXPIRE:<*>");
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
        } else {
            arr2[0] = 0;
        }
        int hostsInLic = (Integer)arr2[0];
        arr2 = ServerProperties.checkAll(m_thisHostName, "LA=" + m_lic_agents);
        if ((Integer)arr2[0] > 0 && (Long)arr2[1] > 0L) {
            long daysToExpire = (Long)arr2[1];
            if (daysToExpire < 14L) {
                SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", LIC_AGENTS, "LICENSE", "Your license will expire in " + daysToExpire + " days");
                sm.setKey("BOOM_SERVER:LICENSE:LA:EXPIRE:" + daysToExpire);
                sm.setCloseMask("BOOM_SERVER:LICENSE:LA:EXPIRE:<*>");
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
        } else {
            arr2[0] = 0;
        }
        int agentsInLic = (Integer)arr2[0];
        int res = Math.max(hostsInLic, 0) + Math.max(agentsInLic, 0) * 10;
        m_runtime_maxLH = res = Math.max(MAX_ENABLED_HOSTS, res);
        return m_runtime_maxLH;
    }

    static void setMAX_CONNECTED_USERS(int n, String in) {
        MAX_CONNECTED_USERS = bb[15] << n;
    }

    static void setMAX_ENABLED_AGENTS(int n, String in) {
        MAX_ENABLED_AGENTS = bb[14] << n | 8;
    }

    private static SortedProperties readProps(File props) {
        SortedProperties p = new SortedProperties();
        if (!props.exists() || !props.canRead()) {
            RTLogger.print(1, "Can't read properties file: " + String.valueOf(props));
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(props);){
                p = new SortedProperties();
                p.load(fileInputStream);
            }
            catch (Exception e) {
                RTLogger.print(1, "Can't read properties file: " + String.valueOf(props), e);
            }
        }
        return p;
    }

    public static void saveProps() {
        if (m_lic_agents != null && m_lic_agents.length() > 30) {
            ServerProperties.m_sp.m_props.setProperty(LIC_AGENTS, m_lic_agents);
        }
        if (m_lic_hosts != null && m_lic_hosts.length() > 30) {
            ServerProperties.m_sp.m_props.setProperty(LIC_HOSTS, m_lic_hosts);
        }
        if (m_lic_users != null && m_lic_users.length() > 30) {
            ServerProperties.m_sp.m_props.setProperty(LIC_USERS, m_lic_users);
        }
        if (m_lic_b2b != null && m_lic_b2b.length() > 30) {
            ServerProperties.m_sp.m_props.setProperty(LIC_B2B, m_lic_b2b);
        }
        if (m_lic_sm != null && m_lic_sm.length() > 30) {
            ServerProperties.m_sp.m_props.setProperty(LIC_SM, m_lic_sm);
        }
        for (String lic : m_mpiLicenses.keySet()) {
            String[] arr = lic.split("[=]");
            if (arr.length != 2) continue;
            ServerProperties.m_sp.m_props.setProperty(arr[0], arr[1]);
        }
        ServerProperties.m_sp.m_props.setProperty(LOGLEVEL, String.valueOf(ServerProperties.m_sp.m_logLevel));
        ServerProperties.m_sp.m_props.setProperty(LOGDIR, ServerProperties.m_sp.m_logDir);
        ServerProperties.m_sp.m_props.remove("Version");
        ServerProperties.m_sp.m_props.setProperty(VERSION, PRODUCT_VERSION);
        ServerProperties.m_sp.m_props.setProperty(HB_INTERVAL, "" + ServerProperties.m_sp.m_HB_interval);
        ServerProperties.m_sp.m_props.setProperty(HB_CTIMEOUT, "" + ServerProperties.m_sp.m_hb_ctimeout);
        ServerProperties.m_sp.m_props.setProperty(HB_RTIMEOUT, "" + ServerProperties.m_sp.m_hb_rtimeout);
        ServerProperties.m_sp.m_props.setProperty(FW_AGENTS_OFFLINE_TIMEOUT, "" + m_sp.getFw_agent_offline_timeout());
        if (ServerProperties.m_sp.m_maxAgentThreads != 0) {
            ServerProperties.m_sp.m_props.setProperty(MAX_AGENT_THREADS, "" + ServerProperties.m_sp.m_maxAgentThreads);
        }
        if (ServerProperties.m_sp.m_maxDeployThreads != 10) {
            ServerProperties.m_sp.m_props.setProperty(MAX_DEPLOY_THREADS, "" + ServerProperties.m_sp.m_maxDeployThreads);
        }
        if (ServerProperties.m_sp.m_maxUIThreads != 200) {
            ServerProperties.m_sp.m_props.setProperty(MAX_DEPLOY_THREADS, "" + ServerProperties.m_sp.m_maxUIThreads);
        }
        if (m_autoClose > 0) {
            ServerProperties.m_sp.m_props.setProperty(AUTO_CLOSE_DAYS, "" + m_autoClose);
        } else {
            ServerProperties.m_sp.m_props.remove(AUTO_CLOSE_DAYS);
        }
        if (m_autoArchive > 0) {
            ServerProperties.m_sp.m_props.setProperty(AUTO_ARCHIVE_DAYS, "" + m_autoArchive);
        } else {
            ServerProperties.m_sp.m_props.remove(AUTO_ARCHIVE_DAYS);
        }
        if (m_autoDelete > 0) {
            ServerProperties.m_sp.m_props.setProperty(AUTO_DELETE_DAYS, "" + m_autoDelete);
        } else {
            ServerProperties.m_sp.m_props.remove(AUTO_DELETE_DAYS);
        }
        if (ServerProperties.m_sp.m_useAgentShortLabels) {
            ServerProperties.m_sp.m_props.setProperty(USE_SHORT_AGENT_LABELS, "" + ServerProperties.m_sp.m_useAgentShortLabels);
        }
        if (ServerProperties.m_sp.m_useHostLowercase) {
            ServerProperties.m_sp.m_props.setProperty(USE_LOWER_CASE_HOSTNAMES, "" + ServerProperties.m_sp.m_useHostLowercase);
        }
        if (ServerProperties.m_sp.m_ignorePerfData.get()) {
            ServerProperties.m_sp.m_props.setProperty(IGNORE_PERF_DATA, "" + ServerProperties.m_sp.m_ignorePerfData.get());
        }
        if (!BkpFile.isEnabled) {
            ServerProperties.m_sp.m_props.setProperty(AUTO_BACKUP, "false");
        }
        if (ServerProperties.m_sp.m_instruction_server != null && !ServerProperties.m_sp.m_instruction_server.isEmpty()) {
            ServerProperties.m_sp.m_props.setProperty(INSTRUCTION_SERVER, ServerProperties.m_sp.m_instruction_server);
        }
        ServerProperties.m_sp.m_props.setProperty(AUDITLOGDIR, ServerProperties.m_sp.m_auditLogDir);
        ServerProperties.m_sp.m_props.setProperty(AUDITLOGSIZE, "" + ServerProperties.m_sp.m_auditLogSizeMB);
        ServerProperties.m_sp.m_props.setProperty(AUDITLOGCOUNT, "" + ServerProperties.m_sp.m_auditLogCount);
        ServerProperties.m_sp.m_props.setProperty(AUDITENABLE, "" + ServerProperties.m_sp.m_auditEnabled);
        if (ServerProperties.m_sp.m_autocloseFinishedAlert != null) {
            ServerProperties.m_sp.m_props.setProperty(AUTOCLOSE_FINISHED_ALERTS, "" + ServerProperties.m_sp.m_autocloseFinishedAlert);
        }
        if (ServerProperties.m_sp.m_autoDetectExternalHosts != null) {
            ServerProperties.m_sp.m_props.setProperty(AUTODETECT_EXTERNAL_HOSTS, "" + ServerProperties.m_sp.m_autoDetectExternalHosts);
        }
        if (ServerProperties.m_sp.m_autoDetectExternalHostsFromSlaves != null) {
            ServerProperties.m_sp.m_props.setProperty(AUTODETECT_EXTERNAL_HOSTS_FROM_SLAVES, "" + ServerProperties.m_sp.m_autoDetectExternalHostsFromSlaves);
        }
        if (ServerProperties.m_sp.m_disableHttpUserAuth != null) {
            ServerProperties.m_sp.m_props.setProperty(DISABLE_HTTP_USERAUTH, "" + ServerProperties.m_sp.m_disableHttpUserAuth);
        }
        if (ServerProperties.m_sp.m_azure_listener != null) {
            ServerProperties.m_sp.m_props.setProperty(AZURE_LISTENER, ServerProperties.m_sp.m_azure_listener.toString());
        }
        if (ServerProperties.m_sp.iotHubConnectionString != null) {
            ServerProperties.m_sp.m_props.setProperty(IOTHUB_CONNECTION, ServerProperties.m_sp.iotHubConnectionString);
        }
        if (ServerProperties.m_sp.blobStorageConnectionString != null) {
            ServerProperties.m_sp.m_props.setProperty(BLOBSTORE_CONNECTION, ServerProperties.m_sp.blobStorageConnectionString);
        }
        if (ServerProperties.m_sp.eventHubConnectionString != null) {
            ServerProperties.m_sp.m_props.setProperty(EVENTHUB_CONNECTION, ServerProperties.m_sp.eventHubConnectionString);
        }
        if (!ServerProperties.m_sp.loadBlancingIPs.isEmpty()) {
            for (int i = 1; i < 10; ++i) {
                String ip;
                String string = ip = ServerProperties.m_sp.loadBlancingIPs.size() >= i ? ServerProperties.m_sp.loadBlancingIPs.get(i - 1) : null;
                if (ip != null && !ip.trim().isEmpty()) {
                    ServerProperties.m_sp.m_props.setProperty(LOAD_BALANCING_IP + i, ip.trim());
                    continue;
                }
                ServerProperties.m_sp.m_props.remove(LOAD_BALANCING_IP + i);
            }
        }
        if (ServerProperties.m_sp.tsFile != null) {
            ServerProperties.m_sp.m_props.setProperty(TS_FILE, ServerProperties.m_sp.tsFile);
        }
        if (ServerProperties.m_sp.tsPassEncoded != null) {
            ServerProperties.m_sp.m_props.setProperty(TS_PASS_ENCODED, ServerProperties.m_sp.tsPassEncoded);
        }
        if (ServerProperties.m_sp.ksFile != null) {
            ServerProperties.m_sp.m_props.setProperty(KS_FILE, ServerProperties.m_sp.ksFile);
        }
        if (ServerProperties.m_sp.ksPassEncoded != null) {
            ServerProperties.m_sp.m_props.setProperty(KS_PASS_ENCODED, ServerProperties.m_sp.ksPassEncoded);
        }
        if (ServerProperties.m_sp.agentTsFile != null) {
            ServerProperties.m_sp.m_props.setProperty(AGENT_TS_FILE, ServerProperties.m_sp.agentTsFile);
        }
        if (ServerProperties.m_sp.agentTsPassEncoded != null) {
            ServerProperties.m_sp.m_props.setProperty(AGENT_TS_PASS_ENCODED, ServerProperties.m_sp.agentTsPassEncoded);
        }
        if (ServerProperties.m_sp.serverID != null) {
            ServerProperties.m_sp.m_props.setProperty(SERVER_ID, ServerProperties.m_sp.serverID);
        }
        if (ServerProperties.m_sp.m_props.containsKey(USE_LAST_DUPLICATE_TEXT)) {
            ServerProperties.m_sp.m_props.setProperty(USE_LAST_DUPLICATE_TEXT, "" + ServerProperties.m_sp.useLastDuplicateText);
        }
        try {
            File props = new File(ServerEngine.getInstance().getMainDir() + File.separator + SERVER_PROP_FILENAME);
            FileOutputStream fos = new FileOutputStream(props);
            ServerProperties.m_sp.m_props.store(fos, "");
            fos.close();
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error saving property file", e);
        }
    }

    public static int getHB_Ctimeout() {
        return ServerProperties.m_sp.m_hb_ctimeout;
    }

    public static void setHB_Ctimeout(int hbCtimeout) {
        ServerProperties.m_sp.m_hb_ctimeout = hbCtimeout;
    }

    public static int getHB_Rtimeout() {
        return ServerProperties.m_sp.m_hb_rtimeout;
    }

    public static void setHB_Rtimeout(int hbRtimeout) {
        ServerProperties.m_sp.m_hb_rtimeout = hbRtimeout;
    }

    public static void setHB_Interval(int sec) {
        ServerProperties.m_sp.m_HB_interval = sec;
    }

    public void setLogLevel(int level) {
        ServerProperties.m_sp.m_logLevel.set(level);
        RTLogger.setLevel(ServerProperties.m_sp.m_logLevel.get());
    }

    public void setLogDir(String logdir) throws Exception {
        File dir = new File(logdir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Can't create LOGDIR: " + logdir);
        }
        ServerProperties.m_sp.m_logDir = logdir;
        RTLogger.setDir(ServerProperties.m_sp.m_logDir, "BOOMServer_");
    }

    public String getLogDir() {
        return this.m_logDir;
    }

    public static int getHB_Interval() {
        return ServerProperties.m_sp.m_HB_interval;
    }

    public Properties getDBProperties() {
        return this.m_DBprops;
    }

    public Properties getDB_PERF_Properties() {
        return this.m_DBPerfprops;
    }

    public String getHostname() {
        return m_thisHostName;
    }

    public String getIP() {
        return ServerProperties.m_sp.m_thisHostIP;
    }

    public int getServerPort() {
        return this.m_serverPort;
    }

    public int getAgentPort() {
        return this.m_agentPort;
    }

    public int getGUIPort() {
        return this.m_clientPort;
    }

    public int getHTTPPort() {
        return this.m_httpPort;
    }

    public long getMaxPerfTblSize() {
        return this.m_maxPerfTableSizeMB;
    }

    public String getListenIP() {
        return this.m_listenIP;
    }

    public int getMaxAgentThreads() {
        return this.m_maxAgentThreads;
    }

    public int getMaxDeployThreads() {
        return this.m_maxDeployThreads;
    }

    public void setMaxAgentThreads(int maxAgentThreads) {
        this.m_maxAgentThreads = maxAgentThreads;
    }

    public void setMaxDeployThreads(int maxDeployThreads) {
        this.m_maxDeployThreads = maxDeployThreads;
    }

    public boolean getAutocloseFinishedAlerts() {
        return this.m_autocloseFinishedAlert != null && this.m_autocloseFinishedAlert != false;
    }

    public boolean getAutoDetectExternalHosts() {
        return this.m_autoDetectExternalHosts != null && this.m_autoDetectExternalHosts != false;
    }

    public boolean getAutoDetectExternalHostsFromSlaves() {
        return this.m_autoDetectExternalHostsFromSlaves != null && this.m_autoDetectExternalHostsFromSlaves != false;
    }

    public boolean isDisableHttpUserAuth() {
        return this.m_disableHttpUserAuth != null && this.m_disableHttpUserAuth != false;
    }

    public static Object[] checkAll(String host, String fullWithPrefix) {
        String lx;
        int number = 0;
        long days = 0L;
        host = host.toLowerCase();
        Object[] res = new Object[]{number, days};
        if (fullWithPrefix == null || fullWithPrefix.length() < 40) {
            return res;
        }
        String[] arr = fullWithPrefix.split("[=]");
        String fullLic = arr[1];
        if (ServerProperties.checkHost(host, fullLic, lx = arr[0])) {
            switch (lx) {
                case "LA": {
                    res[0] = ServerProperties.getNumber(fullLic, 'L');
                    break;
                }
                case "LU": {
                    res[0] = ServerProperties.getNumber(fullLic, 'M');
                    break;
                }
                case "LH": {
                    res[0] = ServerProperties.getNumber(fullLic, 'K');
                    break;
                }
                case "BB": {
                    res[0] = ServerProperties.getNumber(fullLic, 'X');
                    break;
                }
                case "BO": {
                    res[0] = ServerProperties.getNumber(fullLic, 'Y');
                    break;
                }
                default: {
                    res[0] = ServerProperties.getNumber(fullLic, 'N');
                }
            }
            if ((Integer)res[0] > 0) {
                try {
                    long etime = Long.parseLong(ServerProperties.getExpDate(fullLic));
                    long delta = System.currentTimeMillis() / 1000L * 1000L - etime;
                    res[1] = -1L * (delta /= 86400000L);
                }
                catch (NumberFormatException e) {
                    res[0] = 0;
                }
            }
        }
        return res;
    }

    public static String getExpDate(String fullLic) {
        String ed = fullLic.substring(26);
        byte[] aa = ed.getBytes();
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i] <= 70) continue;
            aa[i] = (byte)(aa[i] - 10);
        }
        ed = new String(aa);
        long decoded = Long.decode("0x" + ed.substring(2).toLowerCase());
        long crc = ServerProperties.getCRC2(fullLic.substring(0, 26));
        long toTest = decoded - crc;
        String end = "";
        if (!("" + toTest).endsWith("775")) {
            end = "-";
        }
        return end + toTest;
    }

    public static long getCRC2(String host) {
        Adler32 adler = new Adler32();
        adler.reset();
        adler.update(host.getBytes());
        return adler.getValue();
    }

    public static boolean checkHost(String host, String lic, String lx) {
        boolean isOK = false;
        try {
            char ch;
            long value = ServerProperties.getCRC2(host);
            Object aa = "1";
            for (int i = 11; i < lic.length() && (ch = lic.charAt(i)) <= '9'; i += 2) {
                aa = (String)aa + ch;
            }
            int d = Integer.parseInt((String)aa);
            long sum = value + (long)d + (long)lx.charAt(1);
            if (lx.length() > 2) {
                for (int i = 2; i < lx.length(); ++i) {
                    sum += (long)lx.charAt(i);
                }
            }
            String stringSum = "" + sum;
            isOK = isOK || stringSum.endsWith("775807");
            return isOK;
        }
        catch (NumberFormatException numberFormatException) {
            return isOK;
        }
    }

    public static int getNumber(String lic, char type) {
        int index;
        int res = 0;
        byte[] arr = lic.getBytes();
        if (res != -7) {
            res = 10000 * (arr[1] - 79);
        }
        if (res != -2) {
            res += 1000 * (arr[3] - 80);
        }
        if (res != -6) {
            res += 100 * (arr[5] - 79);
        }
        if (res != -99) {
            res += 10 * (arr[7] - 80);
        }
        if ((index = lic.indexOf(type)) >= 0 && index < 19) {
            res += (index + 2) / 2;
        }
        return res;
    }

    private void checkNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            return;
        }
        catch (Exception e) {
            RTLogger.print(1, "network interfaces check failed", e);
            return;
        }
    }

    public static String getBoomProperty(Properties props, String propertyName, String defaultValue) {
        String envVar = System.getenv(propertyName);
        if (envVar != null) {
            return envVar;
        }
        String boomPropsValue = props.getProperty(propertyName);
        if (boomPropsValue != null) {
            return boomPropsValue;
        }
        return defaultValue;
    }

    private void addInterfaceInfo(InetAddress addr) {
        try {
            if (!addr.isLoopbackAddress()) {
                if (addr instanceof Inet6Address) {
                    Inet6Address addrIPv6 = (Inet6Address)addr;
                    byte[] iip = addrIPv6.getAddress();
                    Inet6Address addrIPv6c = (Inet6Address)Inet6Address.getByAddress(iip);
                    String hAddr = addrIPv6c.getHostAddress();
                    this.allIPs.add(hAddr);
                    String hostN = addrIPv6c.getCanonicalHostName();
                    if (!hostN.equals(hAddr)) {
                        this.allHostnames.add(hostN);
                    }
                } else {
                    String hAddr = addr.getHostAddress();
                    this.allIPs.add(hAddr);
                    String hostN = addr.getCanonicalHostName();
                    if (!hostN.equals(hAddr)) {
                        this.allHostnames.add(hostN);
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            RTLogger.print(3, "error inet addr " + String.valueOf(addr), e);
        }
    }

    public String getClusterName() {
        return this.m_props.getProperty(MAIN_SERVER_NAME);
    }

    public String getClusterIP() {
        return this.m_props.getProperty(MAIN_SERVER_IP);
    }

    public String getClusterNodes() {
        return this.m_clusterNodes;
    }

    public void setClusterNodes(String clusterNodes) {
        this.m_clusterNodes = clusterNodes;
    }

    public boolean isAutoApproval() {
        return this.m_autoApproval;
    }

    public long getCsrTTLMs() {
        return this.csrTTLMs;
    }

    public Path getPkiConfigFile() {
        return this.pkiConfigFile;
    }

    public String getPkiClass() {
        return this.pkiClass;
    }

    void setPkiClass(Class<? extends PKI> clazz) {
        this.pkiClass = clazz == null ? null : clazz.getCanonicalName();
    }

    public void setAutoApproval(boolean autoApproval) {
        this.m_autoApproval = autoApproval;
    }

    public boolean isUseAgentShortLabels() {
        return this.m_useAgentShortLabels;
    }

    public boolean isUseHostLowercase() {
        return this.m_useHostLowercase;
    }

    public void setUseLowerCaseHostnames(boolean lowerCaseHostnames) {
        this.m_useHostLowercase = lowerCaseHostnames;
    }

    public void setUseAgentShortLabels(boolean useAgentShortLabels) {
        this.m_useAgentShortLabels = useAgentShortLabels;
    }

    public int getMaxUIThreads() {
        return this.m_maxUIThreads;
    }

    public void setMaxUIThreads(int maxUIThreads) {
        this.m_maxUIThreads = maxUIThreads;
    }

    public boolean isIgnorePerfData() {
        return this.m_ignorePerfData.get();
    }

    public void setIgnorePerfData(boolean ignorePerfData) {
        this.m_ignorePerfData.set(ignorePerfData);
    }

    public int getFw_agent_offline_timeout() {
        return this.m_fw_agent_offline_timeout;
    }

    public void setFw_agent_offline_timeout(int fwAgentOfflineTimeout) {
        AbstractAgentCard.FIREWALLED_AGENT_PING_EXPIRATION = this.m_fw_agent_offline_timeout = fwAgentOfflineTimeout;
    }

    public String getAuditLogDir() {
        return this.m_auditLogDir;
    }

    public void setAuditLogDir(String auditLogDir) {
        this.m_auditLogDir = auditLogDir;
    }

    public int getAuditLogSizeMB() {
        return this.m_auditLogSizeMB;
    }

    public void setAuditLogSizeMB(int auditLogSizeMB) {
        this.m_auditLogSizeMB = auditLogSizeMB;
    }

    public int getAuditLogCount() {
        return this.m_auditLogCount;
    }

    public void setAuditLogCount(int auditLogCount) {
        this.m_auditLogCount = auditLogCount;
    }

    public boolean getAuditEnabled() {
        return this.m_auditEnabled;
    }

    public void setAuditEnabled(boolean enable) {
        this.m_auditEnabled = enable;
    }

    public List<String> getAllServerIPs() {
        return this.hostIPs;
    }

    public boolean getAzureListenerEnabled() {
        return this.m_azure_listener != null && this.m_azure_listener != false;
    }

    public String getIotHubConnectionString() {
        return this.iotHubConnectionString;
    }

    public String getBlobStorageConnectionString() {
        return this.blobStorageConnectionString;
    }

    public String getEventHubConnectionString() {
        return this.eventHubConnectionString;
    }

    public List<String> getLoadBlancingIPs() {
        return this.loadBlancingIPs;
    }

    public void setLoadBlancingIPs(List<String> loadBlancingIPs) {
        this.loadBlancingIPs = loadBlancingIPs;
    }

    public String getKsFile() {
        return this.ksFile;
    }

    public String getKsPassEncoded() {
        return this.ksPassEncoded;
    }

    public String getTsFile() {
        return this.tsFile;
    }

    public String getTsPassEncoded() {
        return this.tsPassEncoded;
    }

    public String getAgentTsPassEncoded() {
        return this.agentTsPassEncoded;
    }

    public String getAgentTsFile() {
        return this.agentTsFile;
    }

    public Set<String> getAllHostnames() {
        return this.allHostnames;
    }

    public Set<String> getAllIPs() {
        return this.allIPs;
    }

    public String getServerId() {
        return this.serverID == null ? this.getHostname() : this.serverID;
    }

    public String getCSRStorageDir() {
        return this.csrStorageDir;
    }

    public int getCertExpirationThresholdDays() {
        return this.certExpirationThresholdDays;
    }

    public void setCertExpirationThresholdDays(int certExpirationThresholdDays) {
        this.certExpirationThresholdDays = certExpirationThresholdDays;
    }

    public int getMaxFailedLoginsInARawBeforeLock() {
        return this.maxFailedLoginsInARawBeforeLock;
    }

    public long getUserLockRetentionPeriodMs() {
        return this.userLockRetentionPeriodMs;
    }

    public long getFailedLoginCountRetentionPeriodMs() {
        return this.failedLoginCountRetentionPeriodMs;
    }

    public boolean isUseLastDuplicateText() {
        return this.useLastDuplicateText;
    }

    public void setUseLastDuplicateText(boolean useLastDuplicateText) {
        this.useLastDuplicateText = useLastDuplicateText;
    }
}

