/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.FA;
import com.blixx.server.AgentCard;
import com.blixx.server.IEventProcessor;
import com.blixx.server.NullAgentID;
import com.blixx.server.ReadFAs;
import com.blixx.server.ReadMessages;
import com.blixx.server.ReadMonitorValues;
import com.blixx.server.ReadPerf;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.RemoteInventoryAction;
import com.blixx.server.Server;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DBException;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.AgentInfo;
import com.boom.SocketUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

public class ServerWorker {
    public static final String CMD_STOPOUTAGE = "STOPOUTAGE";
    public static final String CMD_STARTOUTAGE = "STARTOUTAGE";
    public static final String CMD_INVENTORY = "INVENTORY";
    private static final int MB50 = 0x3200000;
    public static final int CMD_STOPOUTAGE_INT = 1;
    public static final int CMD_STARTOUTAGE_INT = 2;
    public static final int CMD_INVENTORY_INT = 3;
    private static final String AGENT_ABORTED_CAN_T_GET_IO_STREAMS = "Agent aborted. Can't get IO streams";
    private static final String AGENT_ABORTED_DETAILS = "Agent aborted. Details: ";
    private static final String AGENT_ABORTED_CAN_T_PROCESS_DATA = "Agent aborted. Can't process data ";
    private static final String AGENT_WAS_ABORTED_DUE_TO_SOCKET_EXCEPTION = "Agent was aborted due to socket exception.";
    private static final String ERROR_GETTING_AGENT_ID = "Error getting Agent ID.";
    private static final String ERROR_GETTING_HANDSHAKE_INFO = "Error getting Handshake Info.";
    private static final String NEW_AGENT_ID = "new Agent ID.";
    private static final String REQUEST_DATA_FOR_A_NEW_AGENT = "Request data for a new Agent. ";
    static final String ERROR_PARSING_TIME_FOR_RRD = "Error parsing time for rrd";
    static final String PERFDATA_SUBMIT_FAILING = "perfdata submit failing";
    private static final String SOCKET_ERROR = "Socket error: ";
    private static final String INDICATION_ENGINE_HAS_NO_CONNECTION_TO_THE_DB = "IndicationEngine has no connection to the DB";
    private static final String COMMUNICATION_ABORTED_DUE_TO_UNKNOWN_IP_THE_AGENT_MUST_SEND_HB_FIRST = "Communication aborted due to unknown IP. The Agent must send HB first.";
    Socket m_socket = null;
    private AgentCard m_ac;
    private final long m_createTime = System.currentTimeMillis();
    private boolean m_agentStaticSocketDetected = false;
    private String connectedViaHostOrIP = null;
    private static final Map<String, Integer> COMMANDS = new HashMap<String, Integer>();
    private static final ConcurrentHashMap<AgentCard, Object> runningPings;

    public ServerWorker() {
    }

    public ServerWorker(AgentCard ac) {
        this.m_ac = ac;
    }

    public void setSocket(Socket socket) {
        this.m_socket = socket;
    }

    public void setConnectedVia(String hostOrIP) {
        this.connectedViaHostOrIP = hostOrIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAndCloseSocket() {
        if (this.m_socket != null) {
            try {
                this.m_socket.setSoTimeout(60000);
                this.m_socket.setReuseAddress(true);
                this.m_socket.setTcpNoDelay(true);
                this.m_socket.setSoLinger(true, 1);
                Thread.currentThread().setPriority(9);
            }
            catch (SocketException socketException) {}
        } else {
            return;
        }
        SDataOutputStream out = null;
        SDataInputStream in = null;
        String remoteIP = null;
        try {
            out = new SDataOutputStream(this.m_socket.getOutputStream());
            in = new SDataInputStream(this.m_socket.getInputStream());
            try {
                remoteIP = this.m_socket.getInetAddress().getHostAddress();
                this.processIncomingData(out, in, remoteIP);
            }
            catch (Throwable tr) {
                if (this.m_ac != null) {
                    RTLogger.print(2, AGENT_ABORTED_CAN_T_PROCESS_DATA + tr.getMessage() + " " + this.m_ac.getAgentID());
                } else {
                    RTLogger.print(2, AGENT_ABORTED_CAN_T_PROCESS_DATA + tr.getMessage() + " RemoteIP: " + remoteIP);
                }
                RTLogger.print(5, AGENT_ABORTED_DETAILS, tr);
            }
        }
        catch (Throwable tr) {
            try {
                RTLogger.print(0, AGENT_ABORTED_CAN_T_GET_IO_STREAMS + tr.getMessage());
            }
            catch (Throwable throwable) {
                SocketUtils.closeSocketServerSide(this.m_socket, out, in);
                throw throwable;
            }
            SocketUtils.closeSocketServerSide(this.m_socket, out, in);
        }
        SocketUtils.closeSocketServerSide(this.m_socket, out, in);
    }

    /*
     * Exception decompiling
     */
    public char processIncomingData(SDataOutputStream out, SDataInputStream in, String remoteIP) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCsrNeeded() throws SSLPeerUnverifiedException {
        boolean csrNeeded = false;
        if (this.m_socket instanceof SSLSocket) {
            Certificate agentCert;
            Certificate[] peerCertificates = ((SSLSocket)this.m_socket).getSession().getPeerCertificates();
            if (peerCertificates.length == 1) {
                csrNeeded = true;
            } else if (peerCertificates.length > 1 && (agentCert = peerCertificates[0]) instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)agentCert;
                Date notAfter = x509Certificate.getNotAfter();
                csrNeeded = notAfter.getTime() - TimeUnit.DAYS.toMillis(ServerEngine.getInstance().getServerProps().getCertExpirationThresholdDays()) < System.currentTimeMillis();
            }
        }
        return csrNeeded;
    }

    private void setLTO(AgentCard ac) {
        long wtime;
        if (ac != null) {
            ac.setLastTimeOnline();
        }
        if (!this.m_agentStaticSocketDetected && (wtime = System.currentTimeMillis() - this.m_createTime) > 1000L) {
            RTLogger.print(5, "srvw waittime=" + wtime + " " + (this.m_ac == null || this.m_ac.getAgentHost() == null ? "" : this.m_ac.getAgentHost()));
        }
    }

    public void processOtherCommands(SDataInputStream in, SDataOutputStream out, AgentCard ac) throws IOException {
        int countBytes;
        String command = in.readUTF();
        if (!COMMANDS.containsKey(command)) {
            int countBytes2;
            while ((countBytes2 = in.readInt()) != -1) {
                for (int i = 0; i < countBytes2; ++i) {
                    in.read();
                }
            }
            if (!"P".equals(command)) {
                out.writeUTF("N");
                RTLogger.print(2, "Unsupported command " + command + " from Agent: " + String.valueOf(ac));
            } else {
                out.writeUTF("T");
                this.m_agentStaticSocketDetected = true;
            }
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((countBytes = in.readInt()) != -1) {
            byte[] arr = new byte[countBytes];
            in.readFully(arr);
            baos.write(arr);
        }
        int commandNumber = COMMANDS.get(command);
        switch (commandNumber) {
            case 2: {
                SDataInputStream temp = new SDataInputStream(new ByteArrayInputStream(baos.toByteArray()));
                while (temp.readBoolean()) {
                    String id = temp.readUTF();
                    long duration = temp.readLong();
                    long interval = temp.readLong();
                    int action = temp.readInt();
                    int postaction = temp.readInt();
                    String multiLineString_filters = temp.readUTF();
                    List<ForwardFilter> flist = AgentOutagePolicy.parseFilters(multiLineString_filters);
                    try {
                        AgentOutagePolicy ap = new AgentOutagePolicy(id, ac.getAgentID(), System.currentTimeMillis(), duration, interval, true, flist);
                        ap.setAction(action);
                        ap.setPostAction(postaction);
                        RTLogger.print(3, "Outage " + String.valueOf(ap));
                        ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr().addServerPolicy(ap);
                    }
                    catch (Exception e) {
                        RTLogger.print(2, "AOP failed " + id, e);
                    }
                }
                out.writeUTF("T");
                break;
            }
            case 1: {
                SDataInputStream temp2 = new SDataInputStream(new ByteArrayInputStream(baos.toByteArray()));
                while (temp2.readBoolean()) {
                    String id = temp2.readUTF();
                    AgentOutagePolicy ap = ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr().getServerPolicy(id);
                    if (ap == null) continue;
                    ap.setDisabledByAgent();
                }
                out.writeUTF("T");
                break;
            }
            case 3: {
                SDataInputStream temp3 = new SDataInputStream(new ByteArrayInputStream(baos.toByteArray()));
                RemoteInventoryAction ria = new RemoteInventoryAction('x', this.m_ac, "", 0);
                ria.processInventoryTextBlock(temp3.readUTF());
                out.writeUTF("T");
                break;
            }
        }
    }

    private void processPendingAgent(SDataOutputStream out, SDataInputStream in, String remoteIP, boolean removeConcurrentIP) throws IOException {
        if (removeConcurrentIP) {
            ServerEngine.getInstance().getAgentRepository().getConcurrentIPs().remove(remoteIP);
        }
        out.write(50);
        char ch0 = (char)in.read();
        if (ch0 != '3') {
            if (RTLogger.getCurrentLevel() >= 4) {
                RTLogger.print(4, "getting agentID failed. Agent is not ready");
            }
            try {
                out.write(48);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        out.write(55);
        RTLogger.print(3, new StringBuffer(REQUEST_DATA_FOR_A_NEW_AGENT).append(in.available()));
        this.processAgentInfo(out, in, remoteIP);
        try {
            Thread.sleep(10L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processAgentInfo(SDataOutputStream out, SDataInputStream in, String remoteIP) throws IOException {
        String agentID = null;
        try {
            agentID = in.readUTF();
            out.setVersion(2);
            RTLogger.print(3, new StringBuffer(NEW_AGENT_ID).append(agentID));
        }
        catch (Throwable e) {
            RTLogger.print(3, new StringBuffer(ERROR_GETTING_AGENT_ID).append(e.getMessage()));
        }
        String os = "";
        String host = "";
        try {
            os = in.readUTF();
            host = in.readUTF();
            RTLogger.print(5, "Read host name : " + host);
        }
        catch (Throwable e) {
            RTLogger.print(3, new StringBuffer(ERROR_GETTING_HANDSHAKE_INFO).append(e.getMessage()));
        }
        AgentInfo agtInfo = AgentCard.getAgentInfo(host);
        if (this.connectedViaHostOrIP != null && this.connectedViaHostOrIP.equals(this.m_ac.getAgentHost())) {
            agtInfo.setHostname(this.m_ac.getAgentHost());
        } else if ("localhost".equals(agtInfo.getHostname())) {
            agtInfo.setHostname(remoteIP);
        }
        agtInfo.setRemoteIP(remoteIP);
        agtInfo.setId(agentID);
        agtInfo.setOs(os);
        int supportedProtocol = agtInfo.isTLS() ? 1 : 2;
        AgentCard ac = null;
        List<AgentCard> list = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(agtInfo.getHostname(), agtInfo.getPort());
        if (list.size() > 1) {
            for (AgentCard acc : list) {
                if (agentID == null || !agentID.equals(acc.getAgentID())) continue;
                ac = acc;
                ac.setProtocolVersion(supportedProtocol);
                break;
            }
            if (RTLogger.getCurrentLevel() >= 2) {
                RTLogger.print(2, "multiple Agent cards found for hostname: " + agtInfo.getHostname() + " port: " + agtInfo.getPort());
            }
        } else if (list.size() == 1) {
            ac = list.getFirst();
            ac.setProtocolVersion(supportedProtocol);
        }
        if (ac != null && agtInfo.enabled == null) {
            ac.scheduleTask(new RemoteCmdClient('A', ac, "BOOM_AGENT STATUS", 10));
        }
        if (ac != null && ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID) == null) {
            out.write(50);
            char ch2 = (char)in.read();
            if (ch2 == '3') {
                RemoteCmdClient rcc = new RemoteCmdClient('C', ac, "SETID=" + ac.getAgentID(), 0);
                rcc.processAgentAction(in, out);
            }
            if (agtInfo.isTLS()) {
                ac.setSingleFlagON(64);
            }
        } else {
            ServerEngine.getInstance().getAgentRepository().addPendingIP(agtInfo);
        }
        try {
            out.write(48);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPerfData(SDataInputStream in, SDataOutputStream out, AgentCard ac) throws IOException {
        if (!ac.isAgentAllowsToSendPERF()) {
            return;
        }
        ac.setAgentAllowToSendPERF(false);
        boolean ignorePerfData = ServerEngine.getInstance().getServerProps().isIgnorePerfData();
        try {
            this.setLTO(ac);
            int size = in.readInt();
            ReadPerf pr = new ReadPerf();
            HashMap<String, Integer> incomingNow = new HashMap<String, Integer>();
            for (int k = 0; k < size; ++k) {
                String values = in.readUTF();
                if (ignorePerfData) continue;
                incomingNow.put(values, 1);
            }
            try {
                out.write(84);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (String values : incomingNow.keySet()) {
                pr.submitPerfRow(ac, values);
            }
        }
        finally {
            ac.setAgentAllowToSendPERF(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFAs(SDataOutputStream out, SDataInputStream in, AgentCard ac, IEventProcessor eventOperations) throws IOException {
        this.setLTO(ac);
        if (!eventOperations.isAvailable()) {
            throw new RuntimeException(INDICATION_ENGINE_HAS_NO_CONNECTION_TO_THE_DB);
        }
        if (ac == null || !ac.isAgentAllowsToSend()) {
            return;
        }
        ac.setAgentAllowToSend(false);
        ReadFAs rm = new ReadFAs();
        try {
            List<FA> res = rm.read(in, ac);
            try {
                eventOperations.setAlertFinished(res);
                out.write(84);
            }
            catch (DBException e) {
                out.write(70);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(1, SOCKET_ERROR + e.getMessage());
            RTLogger.print(5, "Socket error: FA ", e);
            out.write(70);
        }
        finally {
            ac.setAgentAllowToSend(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessages(SDataOutputStream out, SDataInputStream in, AgentCard ac, IEventProcessor eventOperations) throws IOException {
        this.setLTO(ac);
        if (!eventOperations.isAvailable()) {
            throw new RuntimeException(INDICATION_ENGINE_HAS_NO_CONNECTION_TO_THE_DB);
        }
        if (ac == null || !ac.isAgentAllowsToSend()) {
            return;
        }
        ac.setAgentAllowToSend(false);
        ReadMessages rm = new ReadMessages();
        try {
            List<SEventFwd> res = rm.read(in, ac);
            int countProcessedMessages = res.size();
            Server.startThread();
            long tstart = System.currentTimeMillis();
            try {
                eventOperations.submitNewMessage(res, ac);
                out.write(84);
            }
            catch (DBException e) {
                RTLogger.print(2, "Error submitting indications", e);
                countProcessedMessages = 0;
                out.write(70);
            }
            finally {
                Server.stopThread(countProcessedMessages, System.currentTimeMillis() - tstart);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(1, SOCKET_ERROR + e.getMessage());
            RTLogger.print(5, "Socket error: SM ", e);
            out.write(70);
        }
        finally {
            ac.setAgentAllowToSend(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMonitorValues(SDataOutputStream out, SDataInputStream in, AgentCard ac, IEventProcessor eventOperations) {
        this.setLTO(ac);
        if (!eventOperations.isAvailable()) {
            throw new RuntimeException(INDICATION_ENGINE_HAS_NO_CONNECTION_TO_THE_DB);
        }
        if (ac == null || !ac.isAgentAllowsToSend()) {
            return;
        }
        ac.setAgentAllowToSend(false);
        ReadMonitorValues rmv = new ReadMonitorValues();
        try {
            List<SEventFwd> res = rmv.read(in, ac);
            int countProcessedMessages = res.size();
            if (res.size() > 1000) {
                Thread.currentThread().setPriority(10);
            }
            Server.startThread();
            long tstart = System.currentTimeMillis();
            try {
                eventOperations.submitNewMessage(res, ac);
                out.write(84);
            }
            catch (DBException e) {
                countProcessedMessages = 0;
                out.write(70);
            }
            finally {
                Server.stopThread(countProcessedMessages, System.currentTimeMillis() - tstart);
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, SOCKET_ERROR + e.getMessage());
            RTLogger.print(5, "Socket error: SMV ", e);
            try {
                out.write(70);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            ac.setAgentAllowToSend(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPing(SDataOutputStream out, SDataInputStream in, String remoteIP, AgentCard ac) throws IOException {
        block15: {
            if (ac == null) {
                throw new IOException("processPing can't work with AC=null");
            }
            if (runningPings.containsKey(ac)) {
                out.write(48);
            } else {
                ac.setLastPingFromAgentTimestamp(System.currentTimeMillis());
                runningPings.put(ac, ac);
                try {
                    char ch;
                    if (ac.getRelatedServer() != null || ac.needsToBeChecked()) {
                        ac.setRelatedServer(null);
                        try {
                            ac.askAgentDetails(out, in, remoteIP, this.connectedViaHostOrIP);
                            break block15;
                        }
                        catch (NullAgentID nullAgentID) {
                            throw new IOException("not able to read agentID");
                        }
                    }
                    this.setLTO(ac);
                    if (ac.isAgentDetailsNeeded()) {
                        out.write(50);
                        ch = (char)in.read();
                        if (ch == '3') {
                            try {
                                ac.askAgentDetails(out, in, remoteIP, this.connectedViaHostOrIP);
                            }
                            catch (NullAgentID nullAgentID) {
                                throw new IOException("not able to read agentID");
                            }
                        }
                    }
                    if (ac.pendingUpdates() || ac.isPendingDeployments4Firewalled()) {
                        out.write(50);
                        ch = (char)in.read();
                        if (ch == '3') {
                            ac.sendUpdates(this.m_socket, out, in);
                        }
                    }
                    out.write(48);
                }
                finally {
                    runningPings.remove(ac);
                }
            }
        }
    }

    private void processIncomingFiles(SDataInputStream in, SDataOutputStream out, AgentCard ac) throws IOException {
        File filetransferFolder = new File("./srv/ft");
        if (filetransferFolder.exists() && filetransferFolder.isDirectory()) {
            out.write(84);
            long time = System.currentTimeMillis();
            while (in.readBoolean()) {
                long freeOnDisk;
                String name = in.readUTF();
                long size = in.readLong();
                long lmt = in.readLong();
                File agentDirL1 = new File(filetransferFolder, "" + ac.getAgentID().charAt(0));
                File agentDirL2 = new File(agentDirL1, "" + ac.getAgentID().charAt(1));
                File agentDir = new File(agentDirL2, ac.getAgentID());
                if (!agentDir.exists() && !agentDir.mkdirs()) {
                    out.write(70);
                    RTLogger.print(1, "FT failed to create the agent directory: {}", agentDir.getAbsolutePath());
                    return;
                }
                File fl = new File(agentDir, name + "_" + lmt);
                try {
                    freeOnDisk = fl.getParentFile().getUsableSpace();
                }
                catch (Throwable e1) {
                    RTLogger.print(1, "Error getting free disk", e1);
                    freeOnDisk = Long.MAX_VALUE;
                }
                if (fl.exists() && fl.length() == size) {
                    out.write(68);
                    continue;
                }
                if (System.currentTimeMillis() - time > 10000L) {
                    out.write(83);
                    continue;
                }
                long position = 0L;
                if (fl.exists() && fl.length() < size) {
                    position = fl.length();
                }
                if (size - position > freeOnDisk) {
                    out.write(83);
                    RTLogger.print(1, "Not enough disk space to receive file");
                    continue;
                }
                out.write(84);
                out.writeLong(position);
                out.writeLong(0x3200000L);
                try {
                    if (in.readFileEncoded(fl.getAbsolutePath(), position != 0L)) {
                        boolean isEOF = in.readBoolean();
                        if (isEOF) {
                            RTLogger.print(1, "File recieved from agent : " + ac.getAgentID() + " file name :" + fl.getName());
                        }
                        out.write(84);
                        continue;
                    }
                    out.write(70);
                }
                catch (IOException e) {
                    RTLogger.print(1, "FT error ", e);
                    out.write(70);
                }
            }
        } else {
            out.write(70);
            RTLogger.print(1, "FT directory does not exist: {}", filetransferFolder.getAbsolutePath());
        }
    }

    static {
        COMMANDS.put(CMD_STARTOUTAGE, 2);
        COMMANDS.put(CMD_STOPOUTAGE, 1);
        COMMANDS.put(CMD_INVENTORY, 3);
        runningPings = new ConcurrentHashMap(100);
    }

    public static class AgentMustSendHBFirst
    extends IOException {
        public AgentMustSendHBFirst() {
            super(ServerWorker.COMMUNICATION_ABORTED_DUE_TO_UNKNOWN_IP_THE_AGENT_MUST_SEND_HB_FIRST);
        }
    }

    public static class DbOffline
    extends IOException {
        public DbOffline() {
            super(ServerWorker.INDICATION_ENGINE_HAS_NO_CONNECTION_TO_THE_DB);
        }
    }
}

