/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScGetAgentServerPolicies;
import com.blixx.ctrl.sc.in.ScGetExtendedServerPolicies;
import com.blixx.ctrl.sc.in.ScGetJson;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicies;
import com.blixx.ctrl.sc.in.ScGetServerPolicies;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.Asn;
import com.blixx.server.BackupSlaveServerClient;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerClientQ;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerClient;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.SSCLite;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class SlaveServerCard
extends SSCLite
implements IServerAuth {
    protected String m_passEncrypted;
    public SlaveServerClient m_bc;
    private int m_running = 0;
    public List<String> m_slavesOfSlave = new ArrayList<String>();
    private String m_slaveDirectory = null;
    private Map<Asn, Asn> m_assignmentsToDeploy = new ConcurrentHashMap<Asn, Asn>();
    private Map<Asn, Asn> m_assignmentsToUnDeploy = new ConcurrentHashMap<Asn, Asn>();
    private Map<Asn, Asn> m_assignmentsToDeployDelayed = new ConcurrentHashMap<Asn, Asn>();
    private Map<Asn, Asn> m_assignmentsToUnDeployDelayed = new ConcurrentHashMap<Asn, Asn>();
    protected Map<String, String> m_indicationIDs2Close = new ConcurrentHashMap<String, String>();
    protected Map<String, String> m_indicationIDs2Archive = new ConcurrentHashMap<String, String>();
    public Queue<Object> m_commands = new ConcurrentLinkedQueue<Object>();
    public ServerClientQ m_mainClient = null;
    public String m_lastAgentVersions = "";
    protected Integer m_detectedServerProtocolVersion = 1;
    protected AtomicLong m_topTime = new AtomicLong(0L);
    protected Map<String, AgentOutagePolicy> m_agentOutages = new LinkedHashMap<String, AgentOutagePolicy>();
    protected Map<String, ServerPolicyStatus> m_agentOutagesStatuses = new LinkedHashMap<String, ServerPolicyStatus>();
    protected Map<String, OutagePolicy> m_outages = new LinkedHashMap<String, OutagePolicy>();
    protected Map<String, ServerPolicyStatus> m_outagesStatuses = new LinkedHashMap<String, ServerPolicyStatus>();
    protected Map<String, ExtendedServerPolicy> m_modifyPolicies = new LinkedHashMap<String, ExtendedServerPolicy>();
    protected Map<String, ServerPolicyStatus> m_modifyPoliciesStatuses = new LinkedHashMap<String, ServerPolicyStatus>();
    protected AgentCard dummyPendingAgentCard = null;
    protected Map<String, AgentCard> m_agents = new ConcurrentHashMap<String, AgentCard>();
    private ConcurrentHashMap<String, AgentCardCM> m_agentsCM = new ConcurrentHashMap();
    protected String m_requestingStatus = null;
    protected boolean isAgentsRequested = false;
    protected ScGetJson runningDeploymentsJson = null;
    protected long runningDeploymentsJsonTime = 0L;
    private File loadedFrom = null;
    private boolean isTLS = false;

    @Deprecated
    public SlaveServerCard() {
        super("testHost", BM.CLIENT_PORT, "test", 0);
        this.m_passEncrypted = Cryptor.encrypt2("test");
        this.m_bc = new SlaveServerClient(this, "SlaveBC");
        this.m_running = 0;
    }

    public SlaveServerCard(String hostname, int port, String user, String pass, int scenario, boolean isTLS) throws IOException {
        super(hostname, port, user, scenario);
        if (scenario > 3 && scenario < 8) {
            this.isTLS = true;
            this.m_scenario = scenario - 4;
        } else {
            this.isTLS = isTLS;
        }
        this.m_passEncrypted = Cryptor.encrypt2(pass);
        if (8 == scenario) {
            this.m_bc = new BackupSlaveServerClient(this, "BackupServerClient");
            this.setAgentsRequested(true);
            this.dummyPendingAgentCard = AgentCard.getDummyInstance("\u2658");
            this.dummyPendingAgentCard.setOSName("(BS:" + this.getScenario() + ":" + this.getHostName() + ") Backup server");
            this.dummyPendingAgentCard.setLabel("\u2658");
            this.dummyPendingAgentCard.setApproved();
            this.dummyPendingAgentCard.setDescription("This is a dummy agent.\n Please ignore this agent card.");
            this.dummyPendingAgentCard.setModeSilently(1);
            this.dummyPendingAgentCard.setAgentPort(0);
            this.dummyPendingAgentCard.setRelatedServer(this.getHostName());
            this.m_requestingStatus = "(BS:" + this.getScenario() + ":" + this.getHostName() + ") Backup server";
        } else {
            this.detectTopTime();
            this.m_bc = new SlaveServerClient(this, "SlaveBC");
            this.dummyPendingAgentCard = AgentCard.getDummyInstance(this.getHostName());
            this.dummyPendingAgentCard.setOSName("(BS:" + this.getScenario() + ":" + this.getHostName() + ") Requesting Agents...");
            this.dummyPendingAgentCard.setLabel("Requesting Agents...");
            this.dummyPendingAgentCard.setApproved();
            this.dummyPendingAgentCard.setRelatedServer(this.getHostName());
            this.m_requestingStatus = "(BS:" + this.getScenario() + ":" + this.getHostName() + ") Requesting Agents...";
        }
        Path slaveDir = Paths.get(ServerEngine.getInstance().getMainDir(), new String[0]).resolve("srv").resolve("slaves").resolve(this.getFilename());
        Files.createDirectories(slaveDir, new FileAttribute[0]);
    }

    public String getFilename() {
        return FileUtils.getValidFileName(this.m_hostname + "_" + this.m_port + "_" + this.m_user);
    }

    public AgentCard getDummyPendingAgentCard() {
        return this.dummyPendingAgentCard;
    }

    public void setScenario(int scenario) {
        this.m_scenario = scenario;
    }

    public void addIndicationIdToClose(String id) {
        this.m_indicationIDs2Close.put(id, id);
    }

    public void addIndicationIdToClose(List<String> ids) {
        for (String id : ids) {
            this.addIndicationIdToClose(id);
        }
        this.scheduleCloseIndiCMD();
    }

    public void addIndicationIdToArchive(String id) {
        this.m_indicationIDs2Archive.put(id, id);
    }

    public void addIndicationIdToArchive(List<String> ids) {
        for (String id : ids) {
            this.addIndicationIdToArchive(id);
        }
        this.scheduleArchiveIndiCMD();
    }

    public void scheduleArchiveIndiCMD() {
        ArrayList<String> al = new ArrayList<String>(this.m_indicationIDs2Archive.keySet());
        if (al.size() > 0) {
            this.getServerClient().start("ARCH_MSG", null, al.toArray(new String[0]));
            this.m_indicationIDs2Archive.keySet().removeAll(al);
        }
    }

    public void scheduleCloseIndiCMD() {
        ArrayList<String> al = new ArrayList<String>(this.m_indicationIDs2Close.keySet());
        if (al.size() > 0) {
            this.getServerClient().start("ACKN_MSG", null, al.toArray(new String[0]));
            this.m_indicationIDs2Close.keySet().removeAll(al);
        }
    }

    protected void detectTopTime() {
        for (SEventFwd sEventFwd : ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false)) {
            if (!this.m_hostname.equalsIgnoreCase(sEventFwd.getSrv())) continue;
            this.compareAndSetTopTime(sEventFwd.getSTime());
            break;
        }
        for (SEventFwd sEventFwd : ServerEngine.getInstance().getEventsRouter().getEventOperations().getAcknowledgedIndications(false)) {
            if (!this.m_hostname.equalsIgnoreCase(sEventFwd.getSrv())) continue;
            this.compareAndSetTopTime(sEventFwd.getSTime());
            break;
        }
    }

    public Integer getDetectedServerProtocolVersion() {
        return this.m_detectedServerProtocolVersion;
    }

    public void setDetectedServerProtocolVersion(Integer version) {
        this.m_detectedServerProtocolVersion = version;
    }

    public String getSlaveDir() {
        return this.m_slaveDirectory;
    }

    public void start() {
        this.m_bc.start();
        this.m_running = 1;
        RTLogger.print(2, "Slave server initialized: " + this.m_hostname + " u:" + this.m_user);
        this.startServerClientQ();
    }

    private void startServerClientQ() {
        this.m_mainClient = new ServerClientQ(this);
        this.m_mainClient.start();
    }

    public SlaveServerClient getSlaveServerClient() {
        return this.m_bc;
    }

    public ServerClientQ getServerClient() {
        if (this.m_mainClient == null || !this.m_mainClient.isRunning() || !this.m_mainClient.isAlive()) {
            if (this.m_mainClient != null) {
                this.stopServerClientQ();
            }
            this.startServerClientQ();
        }
        return this.m_mainClient;
    }

    public ServerClient getServerClientStandAlone() {
        ServerClient sc = new ServerClient(this);
        return sc;
    }

    public String getAgentVersions() {
        return this.m_lastAgentVersions;
    }

    public void setAgentVersions(String agentVersions) {
        this.m_lastAgentVersions = agentVersions;
    }

    public void addSlave(String slaveHostanme) {
        if (!(slaveHostanme == null || slaveHostanme.equalsIgnoreCase(ServerEngine.getInstance().getServerProps().getHostname()) || slaveHostanme.equalsIgnoreCase(this.m_hostname) || this.m_slavesOfSlave.contains(slaveHostanme))) {
            this.m_slavesOfSlave.add(slaveHostanme);
        }
    }

    public boolean isMasterOfSlave(String slaveHostname) {
        return this.m_slavesOfSlave.contains(slaveHostname);
    }

    public void putFailedAsnDeploy(String agentIDs, String[] pairs) {
        for (int i = 0; i < pairs.length; i += 2) {
            String type = pairs[i];
            String name = pairs[i + 1];
            try {
                Asn asn = new Asn(name, type, agentIDs);
                this.remove(asn, this.m_assignmentsToUnDeploy);
                this.remove(asn, this.m_assignmentsToDeployDelayed);
                this.remove(asn, this.m_assignmentsToUnDeployDelayed);
                Asn cached = this.m_assignmentsToDeploy.get(asn);
                if (cached != null) {
                    cached.addAgentIDs(asn);
                    continue;
                }
                this.m_assignmentsToDeploy.put(asn, asn);
                continue;
            }
            catch (Exception e) {
                RTLogger.print(4, name + "_" + type, e);
            }
        }
    }

    public void putFailedAsnDeployDelayed(String agentIDs, String[] pairs) {
        for (int i = 0; i < pairs.length; i += 2) {
            String type = pairs[i];
            String name = pairs[i + 1];
            try {
                Asn asn = new Asn(name, type, agentIDs);
                this.remove(asn, this.m_assignmentsToUnDeployDelayed);
                Asn cached = this.m_assignmentsToDeployDelayed.get(asn);
                if (cached != null) {
                    cached.addAgentIDs(asn);
                    continue;
                }
                this.m_assignmentsToDeployDelayed.put(asn, asn);
                continue;
            }
            catch (Exception e) {
                RTLogger.print(4, name + "_" + type, e);
            }
        }
    }

    public void putFailedAsnUndeploy(String agentIDs, String[] pairs) {
        for (int i = 0; i < pairs.length; i += 2) {
            String type = pairs[i];
            String name = pairs[i + 1];
            try {
                Asn asn = new Asn(name, type, agentIDs);
                this.remove(asn, this.m_assignmentsToDeploy);
                this.remove(asn, this.m_assignmentsToDeployDelayed);
                this.remove(asn, this.m_assignmentsToUnDeployDelayed);
                Asn cached = this.m_assignmentsToUnDeploy.get(asn);
                if (cached != null) {
                    cached.addAgentIDs(asn);
                    continue;
                }
                this.m_assignmentsToUnDeploy.put(asn, asn);
                continue;
            }
            catch (Exception e) {
                RTLogger.print(4, name + "_" + type, e);
            }
        }
    }

    public void putFailedAsnUndeployDelayed(String agentIDs, String[] pairs) {
        for (int i = 0; i < pairs.length; i += 2) {
            String type = pairs[i];
            String name = pairs[i + 1];
            try {
                Asn asn = new Asn(name, type, agentIDs);
                this.remove(asn, this.m_assignmentsToDeployDelayed);
                Asn cached = this.m_assignmentsToUnDeployDelayed.get(asn);
                if (cached != null) {
                    cached.addAgentIDs(asn);
                    continue;
                }
                this.m_assignmentsToUnDeployDelayed.put(asn, asn);
                continue;
            }
            catch (Exception e) {
                RTLogger.print(4, name + "_" + type, e);
            }
        }
    }

    public void putAsnCancel(String agentIDs, String[] IDs) {
    }

    private void remove(Asn asn, Map<Asn, Asn> map) {
        Asn cached1 = map.get(asn);
        if (cached1 != null) {
            cached1.removeAgentIDs(asn);
            if (cached1.isEmpty()) {
                map.remove(cached1);
            }
        }
    }

    public void handleFailedCommand(ServerClient sc) {
        if (sc.m_command == null) {
            return;
        }
        if (this.m_scenario <= 1) {
            Integer codeI = CMDS.m_acceptable.get(sc.m_command);
            int code = -1;
            if (codeI != null) {
                code = codeI;
            }
            switch (code) {
                case 47: {
                    this.putFailedAsnDeploy(sc.m_action, sc.m_parameters);
                    break;
                }
                case 49: {
                    this.putFailedAsnDeployDelayed(sc.m_action, sc.m_parameters);
                    break;
                }
                case 48: {
                    this.putFailedAsnUndeploy(sc.m_action, sc.m_parameters);
                    break;
                }
                case 50: {
                    this.putFailedAsnUndeployDelayed(sc.m_action, sc.m_parameters);
                    break;
                }
                case 52: {
                    this.putAsnCancel(sc.m_action, sc.m_parameters);
                }
            }
        }
    }

    public void handleSucessCommands(ServerClient sc) {
        Integer codeI = CMDS.m_acceptable.get(sc.m_command);
        int code = -1;
        if (codeI != null) {
            code = codeI;
        }
        switch (code) {
            case 113: {
                this.setAgentVersions((String)sc.getResultObject());
                break;
            }
            case 139: {
                break;
            }
            case 143: {
                ScGetAgentServerPolicies sc2 = (ScGetAgentServerPolicies)sc.getResultObject();
                LinkedHashMap<String, AgentOutagePolicy> map = new LinkedHashMap<String, AgentOutagePolicy>();
                for (AgentOutagePolicy agentOutagePolicy : sc2.getServerPolicies()) {
                    ServerPolicyStatus sps = sc2.getStatuses().get(agentOutagePolicy.getID());
                    map.put(agentOutagePolicy.getID(), agentOutagePolicy);
                    agentOutagePolicy.setEnabledFORCE(sps.m_enabled);
                    agentOutagePolicy.setActiveFORCE(sps.m_active);
                    agentOutagePolicy.setEnabledByFORCE(sps.m_enabledBy);
                    agentOutagePolicy.setDisabledByFORCE(sps.m_disabledBy);
                }
                this.m_agentOutages = map;
                this.m_agentOutagesStatuses = sc2.getStatuses();
                ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr().updatePoliciesFromSlave(this);
                ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GET_SERVER_POLICIES_STATUS_AOP", null, new String[0]));
                break;
            }
            case 134: {
                break;
            }
            case 138: {
                ScGetServerPolicies sc4 = (ScGetServerPolicies)sc.getResultObject();
                LinkedHashMap<String, OutagePolicy> mapOP = new LinkedHashMap<String, OutagePolicy>();
                for (OutagePolicy outagePolicy : sc4.getServerPolicies()) {
                    ServerPolicyStatus sps = sc4.getStatuses().get(outagePolicy.getID());
                    mapOP.put(outagePolicy.getID(), outagePolicy);
                    outagePolicy.setEnabledFORCE(sps.m_enabled);
                    outagePolicy.setActiveFORCE(sps.m_active);
                    outagePolicy.setEnabledByFORCE(sps.m_enabledBy);
                    outagePolicy.setDisabledByFORCE(sps.m_disabledBy);
                }
                this.m_outages = mapOP;
                this.m_outagesStatuses = sc4.getStatuses();
                ServerEngine.getInstance().getEventsRouter().getOutageMgr().updatePoliciesFromSlave(this);
                ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GET_SERVER_POLICIES_STATUS", null, new String[0]));
                break;
            }
            case 144: {
                break;
            }
            case 148: {
                ScGetModifyServerPolicies sc6 = (ScGetModifyServerPolicies)sc.getResultObject();
                LinkedHashMap<String, ExtendedServerPolicy> mapMP = new LinkedHashMap<String, ExtendedServerPolicy>();
                for (ModifyServerPolicy mp : sc6.getServerPolicies()) {
                    ExtendedServerPolicy ep = new ExtendedServerPolicy(mp);
                    ServerPolicyStatus sps = sc6.getStatuses().get(mp.getID());
                    mapMP.put(ep.getID(), ep);
                    ep.setEnabledFORCE(sps.m_enabled);
                    ep.setActiveFORCE(sps.m_active);
                    ep.setEnabledByFORCE(sps.m_enabledBy);
                    ep.setDisabledByFORCE(sps.m_disabledBy);
                }
                this.m_modifyPolicies = mapMP;
                this.m_modifyPoliciesStatuses = sc6.getStatuses();
                ServerEngine.getInstance().getEventsRouter().getModifyIndicationMgr().updatePoliciesFromSlave(this);
                ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GET_SERVER_POLICIES_STATUS_EXT", null, new String[0]));
                break;
            }
            case 234: {
                ScGetExtendedServerPolicies sc7 = (ScGetExtendedServerPolicies)sc.getResultObject();
                LinkedHashMap<String, ExtendedServerPolicy> mapMPe = new LinkedHashMap<String, ExtendedServerPolicy>();
                for (ExtendedServerPolicy mp : sc7.getExtServerPolicies()) {
                    ServerPolicyStatus sps = sc7.getStatuses().get(mp.getID());
                    mapMPe.put(mp.getID(), mp);
                    mp.setEnabledFORCE(sps.m_enabled);
                    mp.setActiveFORCE(sps.m_active);
                    mp.setEnabledByFORCE(sps.m_enabledBy);
                    mp.setDisabledByFORCE(sps.m_disabledBy);
                }
                this.m_modifyPolicies = mapMPe;
                this.m_modifyPoliciesStatuses = sc7.getStatuses();
                ServerEngine.getInstance().getEventsRouter().getModifyIndicationMgr().updatePoliciesFromSlave(this);
                ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GET_SERVER_POLICIES_STATUS_EXT", null, new String[0]));
                break;
            }
        }
    }

    public void pushCachedDeployments() {
        if (this.m_scenario <= 1 && this.getSlaveServerClient().isOnline()) {
            Map<Asn, Asn> map = this.m_assignmentsToUnDeploy;
            String command = "UNDEPLOY";
            this.upload(map, command);
            map = this.m_assignmentsToDeploy;
            command = "DEPLOY";
            this.upload(map, command);
            map = this.m_assignmentsToUnDeployDelayed;
            command = "UNDEPLOY_DELAYED";
            this.upload(map, command);
            map = this.m_assignmentsToDeployDelayed;
            command = "DEPLOY_DELAYED";
            this.upload(map, command);
        }
    }

    private void upload(Map<Asn, Asn> map, String command) {
        Iterator<Asn> it = map.keySet().iterator();
        while (it.hasNext()) {
            Asn asn = it.next();
            this.getServerClient().start(command, asn.getAgentIDsString(), new String[]{asn.getType(), asn.getName()});
            it.remove();
        }
    }

    public Map<Asn, Asn> getToDeploy() {
        return this.m_assignmentsToDeploy;
    }

    public Map<Asn, Asn> getToUnDeploy() {
        return this.m_assignmentsToUnDeploy;
    }

    public Map<Asn, Asn> getToDeployDelayed() {
        return this.m_assignmentsToDeployDelayed;
    }

    public Map<Asn, Asn> getToUnDeployDelayed() {
        return this.m_assignmentsToUnDeployDelayed;
    }

    synchronized void detectProtocolVersion(SDataOutputStream os, SDataInputStream is) {
        try {
            os.writeUTF("VALIDATE_CMD");
            os.writeUTF("GPV");
            String status = is.readUTF();
            if (status.equals("T")) {
                os.writeUTF("GPV");
                this.setDetectedServerProtocolVersion(is.readInt());
            } else {
                this.setDetectedServerProtocolVersion(1);
            }
            RTLogger.print(1, "Protocol version detected. " + this.getDetectedServerProtocolVersion() + this.m_hostname);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error protocol version detection. own ver: " + os.getVersion() + " remote ver: " + is.getLastProtocolVersion(), e);
        }
    }

    public void stopClients() {
        try {
            this.stopServerClientQ();
            this.m_bc.m_running.set(false);
            for (int count = 50; !this.m_bc.m_stopped.get() && count > 0; --count) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error stopping slave clients.", e);
        }
    }

    public void stopServerClientQ() {
        this.m_mainClient.stopClient();
    }

    public long getTopTime() {
        return this.m_topTime.get();
    }

    public void compareAndSetTopTime(long topTime) {
        if (topTime > this.m_topTime.get()) {
            this.m_topTime.set(topTime);
        }
    }

    public void requestAgentOutagesStatus() {
        this.getServerClient().start("GET_SERVER_POLICIES_STATUS_AOP", null, (String[])null);
    }

    public void requestServerOutagesStatus() {
        this.getServerClient().start("GET_SERVER_POLICIES_STATUS", null, (String[])null);
    }

    public void requestModifyPoliciesStatus() {
        this.getServerClient().start("GET_SERVER_POLICIES_STATUS_MOD", null, (String[])null);
    }

    public void requestExtendedPoliciesStatus() {
        this.getServerClient().start("GET_SERVER_POLICIES_STATUS_EXT", null, (String[])null);
    }

    public Map<String, AgentOutagePolicy> getAgentOutages() {
        return this.m_agentOutages;
    }

    public Map<String, ServerPolicyStatus> getAgentOutagesStatuses() {
        return this.m_agentOutagesStatuses;
    }

    public Map<String, OutagePolicy> getOutages() {
        return this.m_outages;
    }

    public Map<String, ServerPolicyStatus> getOutagesStatuses() {
        return this.m_outagesStatuses;
    }

    public Map<String, ExtendedServerPolicy> getModifyPolicies() {
        return this.m_modifyPolicies;
    }

    public Map<String, ServerPolicyStatus> getModifyPoliciesStatuses() {
        return this.m_modifyPoliciesStatuses;
    }

    @Override
    public String getPasswordEncrypted() {
        return this.m_passEncrypted;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public int getProtocolVersion() {
        return this.getDetectedServerProtocolVersion();
    }

    @Override
    public String getSessionID() {
        return null;
    }

    @Override
    public void setProtocolVersion(int detectedVersion) {
    }

    @Override
    public void setVersionUnknown() {
    }

    public Map<String, AgentCard> getAgents() {
        return this.m_agents;
    }

    public void updateAgent(AgentCard ac) {
        this.m_agents.put(ac.getAgentID(), ac);
    }

    public void removeAgent(AgentCard ac) {
        this.m_agents.remove(ac.getAgentID());
    }

    public void setAgentsAsRequesting() {
        for (AgentCard ac : this.m_agents.values()) {
            ac.setOSName(this.m_requestingStatus);
        }
    }

    public Map<String, AgentCardCM> getAgentCMs() {
        return this.m_agentsCM;
    }

    public boolean isAgentsRequested() {
        return this.isAgentsRequested;
    }

    public void setAgentsRequested(boolean isAgentsRequested) {
        this.isAgentsRequested = isAgentsRequested;
    }

    public ScGetJson getRunningDeployments() {
        if (this.runningDeploymentsJson == null || System.currentTimeMillis() > this.runningDeploymentsJsonTime + 3000L) {
            this.runningDeploymentsJson = new ScGetJson(this, "/json/dc", null);
            this.runningDeploymentsJson.start();
            this.runningDeploymentsJson.addCmdPostProcess(new ICmdPostProcess<ScGetJson>(){

                @Override
                public void postProcess(ScGetJson sc) {
                    SlaveServerCard.this.runningDeploymentsJson = sc;
                }
            });
        }
        return this.runningDeploymentsJson;
    }

    public boolean isRunning() {
        return this.m_running > 0;
    }

    public File getLoadedFrom() {
        return this.loadedFrom;
    }

    public void setLoadedFrom(File loadedFrom) {
        block4: {
            try {
                String baseName = loadedFrom.getName().replace(".slp", "");
                if (this.getFilename().equals(baseName)) break block4;
                File dest = new File(loadedFrom.getParentFile(), this.getFilename() + ".slp");
                Files.move(loadedFrom.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE);
                this.loadedFrom = dest;
                try {
                    FileUtils.deleteDirectoryRecursive(loadedFrom.getPath().replace(".slp", ""));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (Exception e) {
                RTLogger.print(3, "Error rename slp file", e);
            }
        }
        this.loadedFrom = loadedFrom;
    }

    public boolean isTLS() {
        return this.isTLS;
    }

    public void setTLS(boolean TLS) {
        this.isTLS = TLS;
    }
}

