/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.actions;

import com.blixx.ext.IAction;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.shared.BM;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;

public class CreateAgentAction
implements IAction {
    @Override
    public String run(String[] parameters, int timeout) {
        StringBuilder sb = new StringBuilder();
        for (String agentHostOrIPwithPort : parameters) {
            try {
                String IP = agentHostOrIPwithPort;
                String hostname = agentHostOrIPwithPort;
                Integer m_port = null;
                int split = agentHostOrIPwithPort.lastIndexOf(58);
                boolean validIP = false;
                try {
                    InetAddress.getByName(agentHostOrIPwithPort);
                    validIP = true;
                    IP = InetAddress.getByName(agentHostOrIPwithPort).getHostAddress();
                    hostname = InetAddress.getByName(agentHostOrIPwithPort).getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                if (split != -1 && !validIP) {
                    String port = agentHostOrIPwithPort.substring(split + 1);
                    m_port = Integer.parseInt(port);
                    String ipWithoutPort = agentHostOrIPwithPort.substring(0, split);
                    if (ipWithoutPort.startsWith("[") && ipWithoutPort.endsWith("]")) {
                        ipWithoutPort = ipWithoutPort.substring(1, ipWithoutPort.length() - 1);
                    }
                    validIP = false;
                    try {
                        InetAddress.getByName(ipWithoutPort);
                        validIP = true;
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    IP = ipWithoutPort;
                    hostname = ipWithoutPort;
                    if (validIP) {
                        IP = InetAddress.getByName(ipWithoutPort).getHostAddress();
                        hostname = InetAddress.getByName(ipWithoutPort).getHostName();
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("HOSTNAME", hostname);
                map.put("ID", UUID.randomUUID().toString());
                map.put("IP", IP);
                if (m_port != null) {
                    map.put("PORT", m_port.toString());
                    map.put("LABEL", hostname + ":" + m_port.toString());
                } else {
                    map.put("PORT", "" + BM.AGENT_PORT);
                    map.put("LABEL", hostname);
                }
                map.put("DESCRIPTION", "");
                map.put("OS", "Connecting...");
                map.put("MODE", 0);
                map.put("APPROVED", true);
                map.put("DISABLED", false);
                AgentCard ac = new AgentCard(map);
                ServerEngine.getInstance().getAgentRepository().createAgentCard(ac, (String)null);
                sb.append('\n').append("OK Adding: ").append(ac);
            }
            catch (Throwable e) {
                e.printStackTrace();
                sb.append('\n').append("Error adding host: ").append(agentHostOrIPwithPort).append(" - ").append(e.getMessage());
            }
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        return sb.toString();
    }
}

