/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.correlation.IServerPolicyManager;
import com.blixx.server.correlation.OutageRelations;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractOutageManager<T extends ServerPolicyTemplate>
implements IServerPolicyManager<T> {
    protected List<String> m_sortedIDs = new ArrayList<String>(10);
    protected ConcurrentHashMap<String, T> m_policies = new ConcurrentHashMap();
    public Map<SlaveServerCard, Map<String, T>> m_slaveOutagePolicies = new ConcurrentHashMap<SlaveServerCard, Map<String, T>>();
    protected final EventOperationsOutage eoOutage;

    protected AbstractOutageManager(EventOperationsOutage eoOutage) {
        this.eoOutage = eoOutage;
    }

    protected void saveOrder(String path) {
        try (FileWriter fw = new FileWriter(path);
             BufferedWriter bw = new BufferedWriter(fw);){
            for (String id : this.m_sortedIDs) {
                bw.write(id);
                bw.newLine();
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "Error saving " + path, e);
        }
    }

    @Override
    public List<String> getIDs() {
        return new ArrayList<String>(this.m_policies.keySet());
    }

    @Override
    public Map<String, T> getAllPolicies() {
        return this.m_policies;
    }

    @Override
    public List<T> getServerPoliciesOrdered(String user) {
        ArrayList<Object> ordered = new ArrayList<Object>(this.m_sortedIDs.size());
        for (String string : this.m_sortedIDs) {
            T serverPolicy = this.getServerPolicy(string);
            ordered.add(serverPolicy);
        }
        for (Map.Entry entry : this.m_slaveOutagePolicies.entrySet()) {
            ordered.ensureCapacity(ordered.size() + ((Map)entry.getValue()).size());
            ordered.addAll(((Map)entry.getValue()).values());
        }
        return ordered;
    }

    @Override
    public T getServerPolicy(String id) {
        ServerPolicyTemplate serverPolicyTemplate = (ServerPolicyTemplate)this.m_policies.get(id);
        if (serverPolicyTemplate == null) {
            serverPolicyTemplate = this.getSlaveServerPolicy(id);
        }
        return (T)serverPolicyTemplate;
    }

    protected int getAccessRights(ServerPolicyTemplate sp, String user) {
        int access = ServerPolicyStatus.ACCESS_READONLY;
        if (!UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            access = ServerPolicyStatus.ACCESS_EDIT_DELETE;
        } else {
            UserRole ur = UserManager.getInstance().getRoleForUser(user);
            if (ur != null) {
                OutageRelations or;
                String userRoleStr = ur.getNameInBrackets();
                UserRole sp_ur = UserManager.getInstance().getRoleForUser(sp.getOwner());
                String sp_userRoleStr = null;
                if (sp_ur != null) {
                    sp_userRoleStr = ur.getNameInBrackets();
                }
                access = user.equals(sp.getOwner()) || userRoleStr.equals(sp_userRoleStr) ? ServerPolicyStatus.ACCESS_EDIT_DELETE : ((or = new OutageRelations()).isRelated(sp, user) ? ServerPolicyStatus.ACCESS_READONLY : ServerPolicyStatus.ACCESS_INVISIBLE);
            } else {
                access = ServerPolicyStatus.ACCESS_INVISIBLE;
            }
        }
        return access;
    }

    @Override
    public ServerPolicyStatus getPolicyStatus(ServerPolicyTemplate sp, String user) {
        ServerPolicyStatus sps = new ServerPolicyStatus(sp, this.getAccessRights(sp, user));
        for (Map.Entry<SlaveServerCard, Map<String, T>> entry : this.m_slaveOutagePolicies.entrySet()) {
            if (!entry.getValue().containsKey(sp.getID())) continue;
            sps.setOption("BOOMSERVER", entry.getKey().getHostName());
            break;
        }
        return sps;
    }

    @Override
    public SlaveServerCard getSlaveServer(String policyID) {
        SlaveServerCard ssc = null;
        for (Map.Entry<SlaveServerCard, Map<String, T>> entry : this.m_slaveOutagePolicies.entrySet()) {
            if (!entry.getValue().containsKey(policyID)) continue;
            ssc = entry.getKey();
            break;
        }
        return ssc;
    }

    protected T getSlaveServerPolicy(String id) {
        Map.Entry<SlaveServerCard, Map<String, T>> entry;
        ServerPolicyTemplate res = null;
        Iterator<Map.Entry<SlaveServerCard, Map<String, T>>> iterator = this.m_slaveOutagePolicies.entrySet().iterator();
        while (iterator.hasNext() && (res = (ServerPolicyTemplate)(entry = iterator.next()).getValue().get(id)) == null) {
        }
        return (T)res;
    }

    public void doAction(T p, SEventFwd sef, AgentCard ac) {
        if (ac == null) {
            ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(sef.getT1());
        }
        switch (((ServerPolicyTemplate)p).getAction()) {
            case 1: {
                SlaveServerCard ssc;
                String server;
                if (ac == null || (server = ac.getRelatedServer()) == null || server.length() <= 0 || (ssc = ServerEngine.getInstance().getSlave(server)) == null || ssc.getScenario() > 2) break;
                ssc.addIndicationIdToArchive(sef.getID());
                break;
            }
            case 3: {
                if (this.eoOutage == null) break;
                sef.setT8(((ServerPolicyTemplate)p).getID());
                if (ac == null) {
                    this.eoOutage.submitNewMessageInternal(sef);
                    break;
                }
                this.eoOutage.submitNewMessage(sef, ac);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    public void doPostAction(T p) {
        if (this.eoOutage != null) {
            switch (((ServerPolicyTemplate)p).getPostAction()) {
                case 1: {
                    List<String> ids = this.getIndicationIDs((ServerPolicyTemplate)p);
                    this.sendArchiveToSlaves(ids);
                    this.postActionDrop((ServerPolicyTemplate)p);
                    break;
                }
                case 5: {
                    this.postActionPublish((ServerPolicyTemplate)p);
                    break;
                }
                case 0: {
                    List<String> ids2 = this.getIndicationIDs((ServerPolicyTemplate)p);
                    this.cloneIndications(ids2);
                    this.sendArchiveToSlaves(ids2);
                    break;
                }
            }
        }
    }

    protected void cloneIndications(List<String> ids) {
        LinkedList<String> idToArchive = new LinkedList<String>();
        for (String id : ids) {
            if (id.indexOf(46) != -1) continue;
            idToArchive.add(id);
            SEventFwd sef = this.eoOutage.getEvent(id);
            this.eoOutage.cloneEvent(sef);
        }
        this.eoOutage.archive2((List<String>)idToArchive, true);
    }

    protected void sendArchiveToSlaves(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
                if (ssc == null || ssc.getScenario() > 2) continue;
                ssc.addIndicationIdToArchive(ids);
            }
        }
    }

    protected List<String> getIndicationIDs(ServerPolicyTemplate p) {
        List<String> ids = this.eoOutage.getActiveIDs(p.getID(), true);
        ids.addAll(this.eoOutage.getClosedIDs(p.getID(), true));
        return ids;
    }

    protected void postActionPublish(ServerPolicyTemplate p) {
        LinkedList<SEventFwd> active_events = new LinkedList<SEventFwd>();
        LinkedList<SEventFwd> closed_events = new LinkedList<SEventFwd>();
        List<String> idsActiveAndIAC = this.eoOutage.getActiveAndInsertedAsClosedIDs(p.getID(), false);
        for (String id : idsActiveAndIAC) {
            SEventFwd sef = this.eoOutage.getEvent(id);
            if (sef == null) continue;
            SEventFwd seCloned = new SEventFwd(sef);
            seCloned.m_CustomAttributes.put("T8", "R");
            active_events.add(seCloned);
        }
        List<String> idsClosed = this.eoOutage.getClosed_ButNoInsertedAsClosedIDs(p.getID(), false);
        for (String id : idsClosed) {
            SEventFwd sef = this.eoOutage.getEvent(id);
            if (sef == null) continue;
            SEventFwd seCloned = new SEventFwd(sef);
            seCloned.m_CustomAttributes.put("T8", "R");
            closed_events.add(sef);
        }
        this.eoOutage.archive2(idsActiveAndIAC, true);
        this.eoOutage.archive2(idsClosed, true);
        this.eoOutage.moveToClosed(ServerEngine.getInstance().getEventsRouter().getEventOperations(), closed_events);
        this.eoOutage.moveToActive(ServerEngine.getInstance().getEventsRouter().getEventOperations(), active_events);
    }

    protected void postActionDrop(ServerPolicyTemplate p) {
        this.eoOutage.archive3(p.getID());
    }
}

