/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.server.AgentCard;
import com.blixx.server.correlation.CorrelationEvents;
import com.blixx.server.correlation.IServerCorrelationProcessor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.IAgentManager;
import java.util.List;
import java.util.Objects;

public class ExternalHostsDropProcessor
implements IServerCorrelationProcessor {
    private IAgentManager<AgentCard> agentRepository;

    public ExternalHostsDropProcessor(IAgentManager<AgentCard> agentRepository) {
        this.agentRepository = agentRepository;
        this.agentRepository.getExternalHostsLocalOnly("");
    }

    @Override
    public boolean checkAndProcess(SEventFwd sef, AgentCard ac) {
        List<AgentCard> externals;
        if (!Objects.equals(sef.getNode(), sef.getAgentNode()) && (externals = this.agentRepository.getExternalHostsLocalOnly(sef.getNode())) != null && !externals.isEmpty()) {
            return !externals.stream().anyMatch(agentCard -> agentCard.isApproved() && !agentCard.isDisabled());
        }
        return false;
    }

    @Override
    public boolean checkAndProcessInternal(SEventFwd sef) {
        return false;
    }

    @Override
    public boolean isStopProcessing() {
        return true;
    }

    @Override
    public boolean onEvent(CorrelationEvents event) {
        return false;
    }
}

