/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.cube;

import com.blixx.shared.SEventFwd;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AbstractEventSummary {
    protected AtomicInteger m_sevUnknAV = new AtomicInteger(0);
    protected AtomicInteger m_sevNormAV = new AtomicInteger(0);
    protected AtomicInteger m_sevWarnAV = new AtomicInteger(0);
    protected AtomicInteger m_sevMinAV = new AtomicInteger(0);
    protected AtomicInteger m_sevMajAV = new AtomicInteger(0);
    protected AtomicInteger m_sevCritAV = new AtomicInteger(0);
    protected AtomicInteger m_sevUnknKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevNormKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevWarnKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevMinKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevMajKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevCritKPI = new AtomicInteger(0);
    protected AtomicInteger m_sevUnknOther = new AtomicInteger(0);
    protected AtomicInteger m_sevNormOther = new AtomicInteger(0);
    protected AtomicInteger m_sevWarnOther = new AtomicInteger(0);
    protected AtomicInteger m_sevMinOther = new AtomicInteger(0);
    protected AtomicInteger m_sevMajOther = new AtomicInteger(0);
    protected AtomicInteger m_sevCritOther = new AtomicInteger(0);
    protected Map<String, Object> indicationsMap = new ConcurrentHashMap<String, Object>(100, 0.9f, 3);
    boolean m_storeIndicationIDs = true;

    public AbstractEventSummary(boolean storeIndicationIDs) {
        this.m_storeIndicationIDs = storeIndicationIDs;
    }

    public void addActiveEvent(SEventFwd sef) {
        if (this.indicationsMap.containsKey(sef.getID())) {
            return;
        }
        if (sef.getTypeA() > 0) {
            switch (sef.getSeverityInt()) {
                case -5: 
                case 1: {
                    this.m_sevNormAV.incrementAndGet();
                    break;
                }
                case -4: 
                case 2: {
                    this.m_sevWarnAV.incrementAndGet();
                    break;
                }
                case -3: 
                case 3: {
                    this.m_sevMinAV.incrementAndGet();
                    break;
                }
                case -2: 
                case 4: {
                    this.m_sevMajAV.incrementAndGet();
                    break;
                }
                case -1: 
                case 5: {
                    this.m_sevCritAV.incrementAndGet();
                    break;
                }
                case -6: 
                case 0: {
                    this.m_sevUnknAV.incrementAndGet();
                }
            }
        } else if (sef.getTypeK() > 0) {
            switch (sef.getSeverityInt()) {
                case -5: 
                case 1: {
                    this.m_sevNormKPI.incrementAndGet();
                    break;
                }
                case -4: 
                case 2: {
                    this.m_sevWarnKPI.incrementAndGet();
                    break;
                }
                case -3: 
                case 3: {
                    this.m_sevMinKPI.incrementAndGet();
                    break;
                }
                case -2: 
                case 4: {
                    this.m_sevMajKPI.incrementAndGet();
                    break;
                }
                case -1: 
                case 5: {
                    this.m_sevCritKPI.incrementAndGet();
                    break;
                }
                case -6: 
                case 0: {
                    this.m_sevUnknKPI.incrementAndGet();
                }
            }
        } else {
            switch (sef.getSeverityInt()) {
                case -5: 
                case 1: {
                    this.m_sevNormOther.incrementAndGet();
                    break;
                }
                case -4: 
                case 2: {
                    this.m_sevWarnOther.incrementAndGet();
                    break;
                }
                case -3: 
                case 3: {
                    this.m_sevMinOther.incrementAndGet();
                    break;
                }
                case -2: 
                case 4: {
                    this.m_sevMajOther.incrementAndGet();
                    break;
                }
                case -1: 
                case 5: {
                    this.m_sevCritOther.incrementAndGet();
                    break;
                }
                case -6: 
                case 0: {
                    this.m_sevUnknOther.incrementAndGet();
                }
            }
        }
        if (this.m_storeIndicationIDs) {
            this.indicationsMap.put(sef.getID(), sef);
        }
    }

    public void removeActiveEvent(SEventFwd sef) {
        if (this.indicationsMap.remove(sef.getID()) != null) {
            if (sef.getTypeA() > 0) {
                switch (sef.getSeverityInt()) {
                    case -5: 
                    case 1: {
                        this.m_sevNormAV.decrementAndGet();
                        break;
                    }
                    case -4: 
                    case 2: {
                        this.m_sevWarnAV.decrementAndGet();
                        break;
                    }
                    case -3: 
                    case 3: {
                        this.m_sevMinAV.decrementAndGet();
                        break;
                    }
                    case -2: 
                    case 4: {
                        this.m_sevMajAV.decrementAndGet();
                        break;
                    }
                    case -1: 
                    case 5: {
                        this.m_sevCritAV.decrementAndGet();
                        break;
                    }
                    case -6: 
                    case 0: {
                        this.m_sevUnknAV.decrementAndGet();
                    }
                }
            } else if (sef.getTypeK() > 0) {
                switch (sef.getSeverityInt()) {
                    case -5: 
                    case 1: {
                        this.m_sevNormKPI.decrementAndGet();
                        break;
                    }
                    case -4: 
                    case 2: {
                        this.m_sevWarnKPI.decrementAndGet();
                        break;
                    }
                    case -3: 
                    case 3: {
                        this.m_sevMinKPI.decrementAndGet();
                        break;
                    }
                    case -2: 
                    case 4: {
                        this.m_sevMajKPI.decrementAndGet();
                        break;
                    }
                    case -1: 
                    case 5: {
                        this.m_sevCritKPI.decrementAndGet();
                        break;
                    }
                    case -6: 
                    case 0: {
                        this.m_sevUnknKPI.decrementAndGet();
                    }
                }
            } else {
                switch (sef.getSeverityInt()) {
                    case -5: 
                    case 1: {
                        this.m_sevNormOther.decrementAndGet();
                        break;
                    }
                    case -4: 
                    case 2: {
                        this.m_sevWarnOther.decrementAndGet();
                        break;
                    }
                    case -3: 
                    case 3: {
                        this.m_sevMinOther.decrementAndGet();
                        break;
                    }
                    case -2: 
                    case 4: {
                        this.m_sevMajOther.decrementAndGet();
                        break;
                    }
                    case -1: 
                    case 5: {
                        this.m_sevCritOther.decrementAndGet();
                        break;
                    }
                    case -6: 
                    case 0: {
                        this.m_sevUnknOther.decrementAndGet();
                    }
                }
            }
        }
    }

    public int getMaximumTotal() {
        return Math.max(Math.max(this.getMaximumAV(), this.getMaximumKPI()), this.getMaximumOther());
    }

    public int getMaximumAV() {
        if (this.m_sevCritAV.get() > 0) {
            return 5;
        }
        if (this.m_sevMajAV.get() > 0) {
            return 4;
        }
        if (this.m_sevMinAV.get() > 0) {
            return 3;
        }
        if (this.m_sevWarnAV.get() > 0) {
            return 2;
        }
        if (this.m_sevNormAV.get() > 0) {
            return 1;
        }
        return 0;
    }

    public int getMaximumKPI() {
        if (this.m_sevCritKPI.get() > 0) {
            return 5;
        }
        if (this.m_sevMajKPI.get() > 0) {
            return 4;
        }
        if (this.m_sevMinKPI.get() > 0) {
            return 3;
        }
        if (this.m_sevWarnKPI.get() > 0) {
            return 2;
        }
        if (this.m_sevNormKPI.get() > 0) {
            return 1;
        }
        return 0;
    }

    public int getMaximumOther() {
        if (this.m_sevCritOther.get() > 0) {
            return 5;
        }
        if (this.m_sevMajOther.get() > 0) {
            return 4;
        }
        if (this.m_sevMinOther.get() > 0) {
            return 3;
        }
        if (this.m_sevWarnOther.get() > 0) {
            return 2;
        }
        if (this.m_sevNormOther.get() > 0) {
            return 1;
        }
        return 0;
    }

    public int getNumberOfMessagesTotal() {
        return this.getNumberOfMessagesAV() + this.getNumberOfMessagesKPI() + this.getNumberOfMessagesOther();
    }

    public int getNumberOfMessagesAV() {
        return this.m_sevCritAV.get() + this.m_sevMajAV.get() + this.m_sevMinAV.get() + this.m_sevWarnAV.get() + this.m_sevNormAV.get() + this.m_sevUnknAV.get();
    }

    public int getNumberOfMessagesKPI() {
        return this.m_sevCritKPI.get() + this.m_sevMajKPI.get() + this.m_sevMinKPI.get() + this.m_sevWarnKPI.get() + this.m_sevNormKPI.get() + this.m_sevUnknKPI.get();
    }

    public int getNumberOfMessagesOther() {
        return this.m_sevCritOther.get() + this.m_sevMajOther.get() + this.m_sevMinOther.get() + this.m_sevWarnOther.get() + this.m_sevNormOther.get() + this.m_sevUnknOther.get();
    }

    public Collection<String> getIndicationIDs() {
        return this.indicationsMap.keySet();
    }

    public int getCount(int severity, TYPE type) {
        switch (severity) {
            case 5: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevCritAV.get();
                    }
                    case 1: {
                        return this.m_sevCritKPI.get();
                    }
                    case 2: {
                        return this.m_sevCritOther.get();
                    }
                }
                return 0;
            }
            case 4: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevMajAV.get();
                    }
                    case 1: {
                        return this.m_sevMajKPI.get();
                    }
                    case 2: {
                        return this.m_sevMajOther.get();
                    }
                }
                return 0;
            }
            case 3: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevMinAV.get();
                    }
                    case 1: {
                        return this.m_sevMinKPI.get();
                    }
                    case 2: {
                        return this.m_sevMinOther.get();
                    }
                }
                return 0;
            }
            case 2: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevWarnAV.get();
                    }
                    case 1: {
                        return this.m_sevWarnKPI.get();
                    }
                    case 2: {
                        return this.m_sevWarnOther.get();
                    }
                }
                return 0;
            }
            case 1: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevNormAV.get();
                    }
                    case 1: {
                        return this.m_sevNormKPI.get();
                    }
                    case 2: {
                        return this.m_sevNormOther.get();
                    }
                }
                return 0;
            }
            case 0: {
                switch (type.ordinal()) {
                    case 0: {
                        return this.m_sevUnknAV.get();
                    }
                    case 1: {
                        return this.m_sevUnknKPI.get();
                    }
                    case 2: {
                        return this.m_sevUnknOther.get();
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public int getCount(int severity) {
        switch (severity) {
            case 5: {
                return this.m_sevCritAV.get() + this.m_sevCritKPI.get() + this.m_sevCritOther.get();
            }
            case 4: {
                return this.m_sevMajAV.get() + this.m_sevMajKPI.get() + this.m_sevMajOther.get();
            }
            case 3: {
                return this.m_sevMinAV.get() + this.m_sevMinKPI.get() + this.m_sevMinOther.get();
            }
            case 2: {
                return this.m_sevWarnAV.get() + this.m_sevWarnKPI.get() + this.m_sevWarnOther.get();
            }
            case 1: {
                return this.m_sevNormAV.get() + this.m_sevNormKPI.get() + this.m_sevNormOther.get();
            }
            case 0: {
                return this.m_sevUnknAV.get() + this.m_sevUnknKPI.get() + this.m_sevUnknOther.get();
            }
        }
        return 0;
    }

    public static enum TYPE {
        AVAILABILITY,
        KPI,
        OTHER;

    }
}

