/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.cube;

import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.cube.AgentCardStatusSummary;
import com.blixx.shared.SEventFwd;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cube {
    private static final Cube m_cube = new Cube();
    private Map<String, AgentCardStatusSummary> m_agentSummaries = new ConcurrentHashMap<String, AgentCardStatusSummary>();

    public static Cube getInstance() {
        return m_cube;
    }

    private Cube() {
    }

    public void processIncoming(SEventFwd sef) {
        String agentIDfromIndi = sef.getT1();
        if (agentIDfromIndi != null && agentIDfromIndi.length() > 0 && '-' == sef.getState()) {
            List<AgentCardStatusSummary> related = this.getAgentCardStatusSummary(sef);
            for (AgentCardStatusSummary acs : related) {
                acs.addActiveEvent(sef);
            }
        }
    }

    public void processOutgoing(SEventFwd sef) {
        String agentIDfromIndi = sef.getT1();
        if (agentIDfromIndi != null && agentIDfromIndi.length() > 0 && '-' == sef.getState()) {
            List<AgentCardStatusSummary> related = this.getAgentCardStatusSummary(sef);
            for (AgentCardStatusSummary acs : related) {
                acs.removeActiveEvent(sef);
            }
        }
    }

    public AgentCardStatusSummary getAgentCardStatusSummary(String agentID) {
        AgentCardStatusSummary acs = this.m_agentSummaries.get(agentID);
        if (acs == null) {
            acs = new AgentCardStatusSummary(agentID);
            this.m_agentSummaries.put(agentID, acs);
        }
        return acs;
    }

    public List<AgentCardStatusSummary> getAgentCardStatusSummary(SEventFwd sef) {
        String hostname;
        LinkedList<AgentCardStatusSummary> result = new LinkedList<AgentCardStatusSummary>();
        AgentCardStatusSummary acsMain = this.getAgentCardStatusSummary(sef.getT1());
        if (acsMain != null) {
            result.add(acsMain);
        }
        if ((hostname = sef.getNode()) != null && hostname.length() > 0 && !hostname.equals(sef.getAgentNode())) {
            List<AgentCard> externalHosts = ServerEngine.getInstance().getAgentRepository().getExternalHosts(hostname);
            for (AgentCard ext : externalHosts) {
                AgentCardStatusSummary acsExt = this.getAgentCardStatusSummary(ext.getAgentID());
                if (acsExt == null) continue;
                result.add(acsExt);
            }
        }
        return result;
    }

    public void removeAgentCardStatusSummary(String agentID) {
        this.m_agentSummaries.remove(agentID);
    }
}

