/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerEngine;
import com.blixx.shared.Annotation;
import com.blixx.shared.utils.HashMapMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AnnotationInsertTask
implements Runnable {
    public static ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    protected HashMapMap<String, Annotation> m_mainMap = null;

    public AnnotationInsertTask(HashMapMap<String, Annotation> mainMap) {
        this.m_mainMap = mainMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (m_lock.isWriteLocked()) {
            return;
        }
        m_lock.writeLock().lock();
        try {
            RTLogger.print(5, "AnnotationInsertTask started");
            int size = this.m_mainMap.size();
            long start = System.currentTimeMillis();
            ServerEngine.getInstance().getDB().saveAnnotations(this.m_mainMap);
            RTLogger.print(5, "AnnotationInsertTask finished. Size:" + size + ", " + (System.currentTimeMillis() - start) / 1000L + "sec");
        }
        catch (Throwable e) {
            RTLogger.print(5, "AnnotationInsertTask error: " + e.getMessage());
        }
        finally {
            m_lock.writeLock().unlock();
        }
    }
}

