/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.server.db.Bytes;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DBProperties;
import com.blixx.shared.SEventFwd;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class Connector {
    DBProperties m_props = null;
    Connection m_connection = null;
    protected long m_lastQueryIsReady = 0L;
    protected AtomicBoolean isEnabled = new AtomicBoolean(true);

    public Connector(File file) {
        this.onInit(file);
    }

    public Connector(Properties prop) {
        this.onInit(prop);
    }

    public synchronized String getHost() {
        return this.m_props.getHost();
    }

    public synchronized String getPort() {
        return this.m_props.getPort();
    }

    public synchronized String getUser() {
        return this.m_props.getLogin();
    }

    public synchronized String getP() {
        return this.m_props.getPassword();
    }

    public synchronized long getPoll() {
        if (this.m_props.getPoll() == null) {
            return 60000L;
        }
        long l = Long.parseLong(this.m_props.getPoll());
        if (l == 0L) {
            return 60000L;
        }
        return l * 1000L;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled.compareAndSet(!enable, enable);
    }

    public boolean isEnabled() {
        return this.isEnabled.get();
    }

    protected synchronized boolean onInit(File file) {
        boolean isOK = false;
        this.m_props = new DBProperties(file);
        if (this.m_props.isValid()) {
            try {
                Class.forName(this.m_props.getDriverName()).newInstance();
                isOK = true;
                this.onOpen();
            }
            catch (Exception e) {
                RTLogger.print(1, "", e);
            }
        } else {
            RTLogger.print(1, "DB property file is invalid.");
        }
        return isOK;
    }

    protected synchronized boolean onInit(Properties props) {
        boolean isOK = false;
        this.m_props = new DBProperties(props);
        if (this.m_props.isValid()) {
            try {
                Class.forName(this.m_props.getDriverName()).newInstance();
                isOK = true;
                this.onOpen();
            }
            catch (Throwable e) {
                RTLogger.print(1, "", e);
            }
        } else {
            RTLogger.print(1, "DB property file is invalid.");
        }
        return isOK;
    }

    public synchronized boolean onOpen() {
        boolean isOK = false;
        if (!this.isEnabled.get()) {
            return false;
        }
        try {
            if (this.m_connection == null || this.m_connection.isClosed()) {
                if (this.m_connection != null) {
                    try {
                        this.m_connection.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                DriverManager.setLoginTimeout(3);
                Properties props = new Properties();
                props.setProperty("user", this.m_props.getLogin());
                props.setProperty("password", this.m_props.getPassword());
                props.setProperty("useUnicode", "true");
                props.setProperty("characterEncoding", "utf8");
                props.setProperty("rewriteBatchedStatements", "true");
                props.setProperty("allowPublicKeyRetrieval", "true");
                props.setProperty("useSSL", "false");
                this.m_connection = DriverManager.getConnection(this.m_props.getJdbc(), props);
                this.m_connection.setCatalog(this.m_props.getDbName());
                this.m_connection.setAutoCommit(true);
                try {
                    DatabaseMetaData dbmd = this.m_connection.getMetaData();
                    RTLogger.print(1, "JDBC Driver Name: " + dbmd.getDriverName());
                    RTLogger.print(1, "JDBC Driver Version: " + dbmd.getDriverVersion());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            isOK = true;
        }
        catch (SQLException ex) {
            RTLogger.print(1, "Connection Error. DB: " + this.m_props.getDbName(), ex);
        }
        return isOK;
    }

    public synchronized void onClose() {
        try {
            this.m_connection.close();
        }
        catch (SQLException ex) {
            RTLogger.print(1, "Connection Error.", ex);
        }
    }

    public synchronized boolean isReady() {
        boolean isready;
        block19: {
            isready = false;
            if (!this.isEnabled.get()) {
                return false;
            }
            if (this.m_connection != null) {
                try {
                    if (this.m_connection.isClosed()) break block19;
                    long delta = System.currentTimeMillis() - this.m_lastQueryIsReady;
                    if (delta > 30000L) {
                        try (Statement stMain = this.m_connection.createStatement(1003, 1007);
                             ResultSet rs = stMain.executeQuery("SELECT \"TEST\"");){
                            rs.next();
                            isready = true;
                            this.m_lastQueryIsReady = System.currentTimeMillis();
                            break block19;
                        }
                        catch (Throwable e) {
                            RTLogger.print(2, "MySQL connection failed.", e);
                        }
                        break block19;
                    }
                    isready = true;
                }
                catch (SQLException e) {
                    RTLogger.print(2, "MySQL connection failed.", e);
                }
            }
        }
        return isready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, Object> querySimple(String sql) {
        HashMap<String, Object> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        ResultSet rs = null;
        try (Statement stMain = this.m_connection.createStatement(1003, 1007);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            rs = stMain.executeQuery(sql);
            result = new HashMap<String, Object>();
            while (rs.next()) {
                String name = rs.getString(1);
                Object value = rs.getObject(2);
                result.put(name, value);
            }
            this.m_lastQueryIsReady = System.currentTimeMillis();
        }
        catch (SQLException e) {
            RTLogger.print(1, "", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    public List<SEventFwd> readEvents(String sql, int seconds) throws SQLException {
        LinkedList<SEventFwd> result = null;
        if (!this.isReady() && !this.onOpen()) {
            return null;
        }
        ResultSet rs = null;
        try (Statement stMain = this.getStatementForReadArchived();){
            stMain.setQueryTimeout(seconds);
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<SEventFwd>();
            while (rs.next()) {
                SEventFwd sef = this.initSEventFwd(rs, rsMD);
                result.add(sef);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.m_lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public Statement getStatementForReadArchived() throws SQLException {
        Statement stMain = null;
        stMain = this.m_connection.createStatement(1003, 1007);
        stMain.setFetchDirection(1001);
        stMain.setFetchSize(Integer.MIN_VALUE);
        return stMain;
    }

    public SEventFwd initSEventFwd(ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        Map<String, Object> row = this.processRS(rs, rsMD);
        return Connector.getSEvent(row);
    }

    public synchronized Map<String, SEventFwd> readEvents(String sql, Map<String, SEventFwd> putInHere) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            return null;
        }
        ResultSet rs = null;
        try (Statement stMain = this.m_connection.createStatement(1003, 1007);){
            stMain.setFetchDirection(1001);
            try {
                stMain.setFetchSize(Integer.MIN_VALUE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            while (rs.next()) {
                SEventFwd sef = this.initSEventFwd(rs, rsMD);
                if (putInHere.containsKey(sef.getID())) continue;
                putInHere.put(sef.getID(), sef);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.m_lastQueryIsReady = System.currentTimeMillis();
        return putInHere;
    }

    public synchronized LinkedList<Map<String, Object>> query(String sql) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        ResultSet rs = null;
        try (Statement stMain = this.m_connection.createStatement(1003, 1007);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSet(result, rs, rsMD);
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.m_lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public synchronized LinkedList<Map<String, Object>> queryDirect(String sql, int timeoutSeconds) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        ResultSet rs = null;
        try (Statement stMain = this.m_connection.createStatement(1003, 1007);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            stMain.setQueryTimeout(timeoutSeconds);
            rs = stMain.executeQuery(sql);
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSetDirect(result, rs, rsMD);
            rs.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.m_lastQueryIsReady = System.currentTimeMillis();
        return result;
    }

    public synchronized int execute(String sql) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        try (Statement stMain = this.m_connection.createStatement(1005, 1008);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            rows = stMain.executeUpdate(sql.replace("\\", "\\\\"));
        }
        return rows;
    }

    public synchronized int execute(String sql, int timeout_seconds) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        try (Statement stMain = this.m_connection.createStatement(1005, 1008);){
            stMain.setQueryTimeout(timeout_seconds);
            rows = stMain.executeUpdate(sql.replace("\\", "\\\\"));
        }
        return rows;
    }

    public synchronized int execute(String prepSql, Object[] values) throws SQLException {
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            return rows;
        }
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSql);){
            this.fillValues(values, ps);
            rows = ps.executeUpdate();
        }
        return rows;
    }

    public void fillValues(Object[] values, PreparedStatement ps) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                ps.setNull(i + 1, 12);
                continue;
            }
            if (values[i] instanceof String) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 12);
                    continue;
                }
                ps.setString(i + 1, (String)values[i]);
                continue;
            }
            if (values[i] instanceof Integer) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 4);
                    continue;
                }
                ps.setInt(i + 1, (Integer)values[i]);
                continue;
            }
            if (values[i] instanceof Long) {
                if (values[i] == null) {
                    ps.setNull(i + 1, -5);
                    continue;
                }
                ps.setLong(i + 1, (Long)values[i]);
                continue;
            }
            if (values[i] instanceof Double) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 8);
                    continue;
                }
                ps.setDouble(i + 1, (Double)values[i]);
                continue;
            }
            if (values[i] instanceof Timestamp) {
                if (values[i] == null) {
                    ps.setNull(i + 1, 93);
                    continue;
                }
                ps.setTimestamp(i + 1, (Timestamp)values[i]);
                continue;
            }
            if (!(values[i] instanceof Date)) continue;
            if (values[i] == null) {
                ps.setNull(i + 1, 91);
                continue;
            }
            ps.setTimestamp(i + 1, new Timestamp(((Date)values[i]).getTime()));
        }
    }

    public synchronized LinkedList<Map<String, Object>> query(String prepSql, Object[] values) throws SQLException {
        LinkedList<Map<String, Object>> result = null;
        int rows = -1;
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        ResultSet rs = null;
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSql);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSql);
            }
            this.fillValues(values, ps);
            rs = ps.executeQuery();
            ResultSetMetaData rsMD = rs.getMetaData();
            result = new LinkedList<Map<String, Object>>();
            this.processResultSet(result, rs, rsMD);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    protected void processResultSet(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        while (rs.next()) {
            this.processRS(result, rs, rsMD);
        }
    }

    protected void processResultSetDirect(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        while (rs.next()) {
            this.processRS(result, rs, rsMD);
        }
    }

    protected void processRS(LinkedList<Map<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        Map<String, Object> row = this.processRS(rs, rsMD);
        result.add(row);
    }

    protected Map<String, Object> processRS(ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= rsMD.getColumnCount(); ++i) {
            Object valueObj = null;
            String name = rsMD.getColumnName(i);
            name = name.replace('\'', ' ');
            name = name.replace('\"', ' ');
            name = name.trim();
            if (rsMD.getColumnType(i) == 2004 || rsMD.getColumnType(i) == -4) {
                try {
                    Blob b = rs.getBlob(i);
                    if (b != null) {
                        int bytesRead;
                        InputStream is = b.getBinaryStream();
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[is.available()];
                        while ((bytesRead = is.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, bytesRead);
                        }
                        buffer.flush();
                        Bytes value = new Bytes(buffer.toByteArray());
                        valueObj = value;
                    }
                }
                catch (IOException e1) {
                    RTLogger.print(3, "DB blob read failed.", e1);
                }
            } else if (rsMD.getColumnType(i) != 2005) {
                valueObj = rsMD.getColumnType(i) == 91 || rsMD.getColumnType(i) == 93 ? rs.getTimestamp(i) : rs.getObject(i);
            }
            if (valueObj instanceof String && "".equals(valueObj)) {
                valueObj = "";
            }
            row.put(name, valueObj);
        }
        return row;
    }

    public synchronized void insertEvents(String prepSQL, Map<String, SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSQL);){
            this.m_connection.setAutoCommit(false);
            int com = 0;
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSQL);
            }
            for (Map.Entry<String, SEventFwd> stringSEventFwdEntry : events.entrySet()) {
                SEventFwd se = stringSEventFwdEntry.getValue();
                this.prepInsertEvents(ps, se);
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(4, "Save indi rolled back", e);
            this.m_connection.rollback();
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public void prepInsertEvents(PreparedStatement ps, SEventFwd se) throws SQLException {
        ps.setString(1, se.getID());
        ps.setString(2, se.getService());
        ps.setString(3, se.getNode());
        ps.setString(4, se.getApplication());
        ps.setString(5, se.getObject());
        ps.setString(6, se.getGroup());
        ps.setLong(7, se.getTime());
        ps.setString(8, se.getKeyConfigured());
        ps.setString(9, se.getCloseMask());
        ps.setInt(10, se.getSeverityInt());
        ps.setInt(11, se.getDuplicates());
        ps.setString(12, "" + se.getState());
        ps.setString(13, se.getInstructionID());
        ps.setString(14, se.getAutoAction());
        ps.setString(15, se.getOpAction());
        ps.setLong(16, se.getSTime());
        ps.setString(17, se.getSource());
        if (Double.isNaN(se.getValue())) {
            ps.setNull(18, 8);
        } else {
            ps.setDouble(18, se.getValue());
        }
        ps.setString(19, se.getMonitor());
        ps.setString(20, se.getAgentNode());
        ps.setInt(21, 0);
        ps.setInt(22, se.getTypeA());
        ps.setInt(23, se.getTypeK());
        ps.setLong(24, se.getTime());
        ps.setString(25, se.getText());
    }

    public synchronized void insertEventsExt(String prepSQL, Map<String, SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.m_connection.setAutoCommit(false);
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSQL);){
            int com = 0;
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, prepSQL);
            }
            Iterator<Map.Entry<String, SEventFwd>> it = events.entrySet().iterator();
            while (it.hasNext()) {
                SEventFwd se = it.next().getValue();
                this.prepInsertEventsExt(ps, se);
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(4, "Save Ext indi info rolled back", e);
            this.m_connection.rollback();
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public void prepInsertEventsExt(PreparedStatement ps, SEventFwd se) throws SQLException {
        ps.setString(1, se.getID());
        ps.setString(2, se.getSrv());
        ps.setString(3, se.getSrvtype());
        ps.setString(4, se.getExtID());
        ps.setString(5, se.getT1());
        ps.setString(6, se.getT2());
        ps.setString(7, se.getT3());
        ps.setString(8, se.getT4());
        ps.setString(9, se.getT5());
        ps.setString(10, se.getT6());
        ps.setString(11, se.getT7());
        ps.setString(12, se.getT8());
        ps.setString(13, se.getT9());
        ps.setString(14, se.getT10());
        ps.setString(15, "" + se.getTFA());
        ps.setString(16, "" + se.getVFA());
        ps.setString(17, se.getCA1());
        ps.setString(18, se.getCA2());
        ps.setString(19, se.getCA3());
        ps.setString(20, se.getCA4());
        ps.setString(21, se.getCA5());
        ps.setString(22, se.getCA6());
        ps.setString(23, se.getCA7());
        ps.setString(24, se.getCA8());
        ps.setString(25, se.getCA9());
        ps.setString(26, se.getCA10());
        ps.setString(27, se.getCA11());
        ps.setString(28, se.getCA12());
        ps.setString(29, se.getCA13());
        ps.setString(30, se.getCA14());
        ps.setString(31, se.getCA15());
    }

    public synchronized void deleteArchived(String prepSQL, List<String> ids) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSQL);){
            for (String id : ids) {
                ps.setString(1, id);
                ps.executeUpdate();
            }
        }
    }

    public synchronized void updateDuplicates(String prepSQL, List<SEventFwd> events) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        if (RTLogger.getCurrentLevel() >= 6) {
            RTLogger.print(6, prepSQL);
        }
        this.m_connection.setAutoCommit(false);
        try (PreparedStatement ps = this.m_connection.prepareStatement(prepSQL);){
            int com = 0;
            for (SEventFwd se : events) {
                ps.setLong(1, se.getTime());
                ps.setInt(2, se.getDuplicates());
                ps.setLong(3, se.getSTime());
                ps.setString(4, se.getID());
                ps.addBatch();
                if (++com <= 500) continue;
                com = 0;
                RTLogger.print(4, "DB Update 500");
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
            if (com > 0) {
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            this.m_connection.rollback();
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchPrepared(String sql, List<Object[]> values) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.m_connection.setAutoCommit(false);
        try (PreparedStatement ps = this.m_connection.prepareStatement(sql);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            int com = 0;
            for (Object[] vs : values) {
                this.fillValues(vs, ps);
                ps.addBatch();
                if (++com <= 500) continue;
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
                com = 0;
            }
            if (com > 0) {
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            this.m_connection.rollback();
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchPreparedNoTransaction(String sql, List<Object[]> values) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        this.m_connection.setAutoCommit(false);
        try (PreparedStatement ps = this.m_connection.prepareStatement(sql);){
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, sql);
            }
            int com = 0;
            for (Object[] vs : values) {
                this.fillValues(vs, ps);
                ps.addBatch();
                if (++com <= 500) continue;
                long start = System.currentTimeMillis();
                int[] res = ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
                RTLogger.print(4, "BATCH for " + com + " records: " + (System.currentTimeMillis() - start));
                com = 0;
            }
            if (com > 0) {
                ps.executeBatch();
                this.m_connection.commit();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            RTLogger.print(2, "Batch failed.");
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatch(String[] sql) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        try (Statement stmt = this.m_connection.createStatement();){
            this.m_connection.setAutoCommit(false);
            int com = 0;
            for (String s : sql) {
                stmt.addBatch(s.replace("\\", "\\\\"));
                if (++com <= 500) continue;
                stmt.executeBatch();
                this.m_connection.commit();
                stmt.clearBatch();
                com = 0;
            }
            if (com > 0) {
                stmt.executeBatch();
                this.m_connection.commit();
                stmt.clearBatch();
            }
        }
        catch (SQLException e) {
            this.m_connection.rollback();
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
        finally {
            this.m_connection.setAutoCommit(true);
        }
    }

    public synchronized void insertBatchNoTransaction(String[] sql) throws SQLException {
        if (!this.isReady() && !this.onOpen()) {
            throw new DBException("Can't connect");
        }
        try (Statement stmt = this.m_connection.createStatement();){
            for (String s : sql) {
                stmt.addBatch(s.replace("\\", "\\\\"));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            RTLogger.print(2, "Transaction rolled back.");
            throw e;
        }
    }

    static SEventFwd getSEvent(Map<String, Object> map) {
        String state;
        String ca;
        String vfa;
        String tfa;
        SEventFwd sef = new SEventFwd();
        sef.setSrv((String)map.get("SRV"));
        sef.setSrvType((String)map.get("SRVTYPE"));
        sef.setExtID((String)map.get("EXTID"));
        String res = (String)map.get("T1");
        if (res != null && res.length() > 0) {
            sef.setT1(res);
        }
        if ((res = (String)map.get("T2")) != null && res.length() > 0) {
            sef.setT2(res);
        }
        if ((res = (String)map.get("T3")) != null && res.length() > 0) {
            sef.setT3(res);
        }
        if ((res = (String)map.get("T4")) != null && res.length() > 0) {
            sef.setT4(res);
        }
        if ((res = (String)map.get("T5")) != null && res.length() > 0) {
            sef.setT5(res);
        }
        if ((res = (String)map.get("T6")) != null && res.length() > 0) {
            sef.setT6(res);
        }
        if ((res = (String)map.get("T7")) != null && res.length() > 0) {
            sef.setT7(res);
        }
        if ((res = (String)map.get("T8")) != null && res.length() > 0) {
            sef.setT8(res);
        }
        if ((res = (String)map.get("T9")) != null && res.length() > 0) {
            sef.setT9(res);
        }
        if ((res = (String)map.get("T10")) != null && res.length() > 0) {
            sef.setT10(res);
        }
        if ((tfa = (String)map.get("TFA")) != null) {
            try {
                long time = Long.parseLong(tfa);
                sef.setTFA(time);
            }
            catch (Throwable time) {
                // empty catch block
            }
        }
        if ((vfa = (String)map.get("VFA")) != null) {
            try {
                double value = Double.parseDouble(vfa);
                sef.setVFA(value);
            }
            catch (Throwable value) {
                // empty catch block
            }
        }
        if ((ca = (String)map.get("CA1")) != null) {
            sef.setCA1(ca);
        }
        if ((ca = (String)map.get("CA2")) != null && ca.length() > 0) {
            sef.setCA2(ca);
        }
        if ((ca = (String)map.get("CA3")) != null && ca.length() > 0) {
            sef.setCA3(ca);
        }
        if ((ca = (String)map.get("CA4")) != null && ca.length() > 0) {
            sef.setCA4(ca);
        }
        if ((ca = (String)map.get("CA5")) != null && ca.length() > 0) {
            sef.setCA5(ca);
        }
        if ((ca = (String)map.get("CA6")) != null && ca.length() > 0) {
            sef.setCA6(ca);
        }
        if ((ca = (String)map.get("CA7")) != null && ca.length() > 0) {
            sef.setCA7(ca);
        }
        if ((ca = (String)map.get("CA8")) != null && ca.length() > 0) {
            sef.setCA8(ca);
        }
        if ((ca = (String)map.get("CA9")) != null && ca.length() > 0) {
            sef.setCA9(ca);
        }
        if ((ca = (String)map.get("CA10")) != null && ca.length() > 0) {
            sef.setCA10(ca);
        }
        if ((ca = (String)map.get("CA11")) != null && ca.length() > 0) {
            sef.setCA11(ca);
        }
        if ((ca = (String)map.get("CA12")) != null && ca.length() > 0) {
            sef.setCA12(ca);
        }
        if ((ca = (String)map.get("CA13")) != null && ca.length() > 0) {
            sef.setCA13(ca);
        }
        if ((ca = (String)map.get("CA14")) != null && ca.length() > 0) {
            sef.setCA14(ca);
        }
        if ((ca = (String)map.get("CA15")) != null && ca.length() > 0) {
            sef.setCA15(ca);
        }
        sef.setID((String)map.get("ID"));
        if (sef.getID() == null) {
            RTLogger.print(6, String.valueOf(map));
        }
        sef.setCloseMask((String)map.get("ACKKEY"));
        sef.setApplication((String)map.get("APPLICATION"));
        sef.setAutoAction((String)map.get("AUTOACTION"));
        Object o = map.get("TIME");
        if (o instanceof Number) {
            sef.setTime(((Number)o).longValue());
        }
        if ((o = map.get("DUPL")) instanceof Number) {
            sef.setDuplicate(((Number)o).intValue());
        }
        sef.setInstructionID((String)map.get("INSTRUCTIONID"));
        sef.setGroup((String)map.get("MSGGRP"));
        sef.setKey((String)map.get("MSGKEY"));
        sef.setText((String)map.get("MSGTEXT"));
        sef.setNode((String)map.get("NODE"));
        sef.setObject((String)map.get("OBJECT"));
        sef.setOpAction((String)map.get("OPACTION"));
        sef.setService((String)map.get("SERVICE"));
        sef.setSource((String)map.get("SOURCE"));
        o = map.get("SEVERITY");
        if (o instanceof Number) {
            sef.setSeverity(((Number)o).intValue());
        }
        if ((state = (String)map.get("STATE")) == null || state.length() == 0) {
            sef.setState('-');
        } else {
            sef.setState(state.charAt(0));
        }
        o = map.get("STIME");
        if (o instanceof Number) {
            sef.setSTime(((Number)o).longValue());
        }
        if ((o = map.get("VALUE")) instanceof Number) {
            sef.setValue(((Number)o).doubleValue());
        }
        sef.setMonitor((String)map.get("MONITOR"));
        sef.setAgentNode((String)map.get("AGENTNODE"));
        o = map.get("TYPE_A");
        if (o instanceof Number) {
            sef.setTypeA(((Number)o).intValue());
        } else {
            sef.setTypeA(0);
        }
        o = map.get("TYPE_K");
        if (o instanceof Number) {
            sef.setTypeK(((Number)o).intValue());
        } else {
            sef.setTypeK(0);
        }
        o = map.get("FTIME");
        if (o instanceof Number) {
            sef.setFirstTime(((Number)o).longValue());
        } else {
            sef.setFirstTime(sef.getTime());
        }
        if (sef.getAgentNode() == null || sef.getAgentNode().length() == 0) {
            sef.setAgentNode(sef.getNode());
        }
        try {
            Object count = map.get("ANNOT");
            if (count != null) {
                int annotationCount = 0;
                if (o instanceof Number) {
                    annotationCount = ((Number)count).intValue();
                }
                if (annotationCount > 0) {
                    sef.setAnnotationFlag(true);
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(6, "err258 ", e);
        }
        return sef;
    }

    public synchronized Connection getConnection() {
        return this.m_connection;
    }
}

