/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.Connector;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DBProperties;
import com.blixx.server.db.OraConnector;
import com.blixx.server.ext.ForwardManager;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import com.blixx.shared.utils.ArchiveDetails;
import com.blixx.shared.utils.HashMapArray;
import com.blixx.shared.utils.HashMapMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class DBOutage
extends DB {
    public static final String EVENTS_TABLE_O = "O_EVENTS";
    public static final String EVENTS_EXT_O = "O_EVENTS_EXT";
    public static final String ANNOTATIONS_TABLE_O = "O_ANNOTATIONS";
    public static final String O_AGENTS = "O_AGENTS";
    protected static volatile DBOutage m_dbo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBOutage getInstance(boolean force) {
        if (m_dbo == null) {
            Class<DBOutage> clazz = DBOutage.class;
            synchronized (DBOutage.class) {
                if (m_dbo == null) {
                    DBOutage dbo = new DBOutage();
                    dbo.init();
                    m_dbo = dbo;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (force) {
            m_dbo.init();
        }
        return m_dbo;
    }

    public DBOutage() {
        this.setMySQLQueries();
    }

    public void setMySQLQueries() {
        this.SQL_UPDATE_ASSIGNMENT = "";
        this.SQL_UPDATE_ASSIGNMENT2 = "";
        this.SQL_SELECT_USERS = "";
        this.SQL_SELECT_ROLES = "";
        this.SQL_SELECT_ITEMS = "";
        this.SQL_SELECT_AGENTS = "";
        this.SQL_UPDATE_AGENT = "";
        this.SQL_INSERT_HELP = "";
        this.SQL_UPDATE_HELP = "";
        this.SQL_SELECT_HELP = "";
        this.SQL_SELECT_HELPS = "";
        this.SQL_INSERT_ASSIGNMENT = "";
        this.SQL_RENAME_ASSIGNMENT = "";
        this.SQL_DELETE_ASSIGNMENT = "";
        this.SQL_DELETE_ASSIGNMENTS_FOR_AGENT = "";
        this.SQL_DELETE_ASSIGNMENT_BYNAMEANDTYPE = "";
        this.SQL_SELECT_ASSIGNMENTS = "";
        this.SQL_SET_DELETE_FLAG_PREFIX = "";
        this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX_EXT = "";
        this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX_EXT = "";
        this.SQL_ACTIONS_RIGHTS = "";
        this.SQL_CREATE_TEMP_IDS = "";
        this.SQL_INSERT_TEMP_IDS = "";
        this.SQL_DROP_TEMP_IDS = "";
        this.SQL_TRUNCATE_TEMP_IDS = "";
        this.sqlAnnotations = "SELECT * FROM O_ANNOTATIONS WHERE ID = '";
        this.SQL_SELECT_CLOSED_EVENTS = "SELECT * FROM O_EVENTS WHERE STATE <> '-' AND STATE <> 'D'";
        this.SQL_REPLACE_EVENTS = "REPLACE INTO O_EVENTS (`ID`,`SERVICE`,`NODE`,`APPLICATION`,`OBJECT`,`MSGGRP`,`TIME`,`MSGKEY`,`ACKKEY`,`SEVERITY`,`DUPL`,`STATE`,`INSTRUCTIONID`,`AUTOACTION`,`OPACTION`,`STIME`,`SOURCE`,`VALUE`,`MONITOR`,`AGENTNODE`,`ANNOT`,`TYPE_A`,`TYPE_K`,`FTIME`,`MSGTEXT`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.SQL_REPLACE_EVENTS_EXT = "REPLACE O_EVENTS_EXT SET ID_E=?,SRV=?,SRVTYPE=?,EXTID=?,T1=?,T2=?,T3=?,T4=?,T5=?,T6=?,T7=?,T8=?,T9=?,T10=?, TFA=?,VFA=?, CA1=?,CA2=?,CA3=?,CA4=?,CA5=?,CA6=?,CA7=?,CA8=?,CA9=?,CA10=?,CA11=?,CA12=?,CA13=?,CA14=?,CA15=?";
        this.SQL_UPDATE_DUPLICATES_EVENT = "UPDATE O_EVENTS SET TIME = ?, DUPL = ?, STIME = ? WHERE ID = ?";
        this.SQL_SELECT_ACTIVE_EVENTS = "SELECT * FROM O_EVENTS where STATE = '-'";
        this.SQL_SELECT_ACTIVE_EVENTS_EXT = "SELECT O_EVENTS.*, O_EVENTS_EXT.* FROM O_EVENTS LEFT JOIN O_EVENTS_EXT ON O_EVENTS.ID=O_EVENTS_EXT.ID_E WHERE O_EVENTS.STATE = '-'";
        this.SQL_INSERT_ANNOTATION = "INSERT INTO O_ANNOTATIONS (`ID`,`TIME`,`STATUS`,`ANNOTATION`) VALUES(?,?,?,?)";
        this.SQL_UPDATE_ANNOTATION_COUNT = "UPDATE O_EVENTS SET ANNOT=1 WHERE ID=?";
        this.SQL_CLOSE_EVENT = "UPDATE O_EVENTS SET STATE=? WHERE ID = ?";
        this.SQL_SELECT_CLOSED_EVENTS_EXT = "SELECT O_EVENTS.*, EVENTS_EXT_O.* FROM O_EVENTS LEFT JOIN O_EVENTS_EXT ON O_EVENTS.ID=EVENTS_EXT_O.ID_E WHERE O_EVENTS.STATE <> '-' AND O_EVENTS.STATE <> 'D'";
        this.SQL_SETDELETES_EVENT = "UPDATE O_EVENTS SET STATE='D' WHERE ID = ?";
        this.SQL_SELECT_DELETED = "SELECT ID FROM O_EVENTS WHERE STATE='D'";
        this.SQL_SET_DELETE_FLAG_PREFIX = "UPDATE O_EVENTS SET STATE='D' WHERE ID IN (";
        this.SQL_SELECT_ACTIVE_EVENTS_EXT = "SELECT O_EVENTS.*, O_EVENTS_EXT.* FROM O_EVENTS LEFT JOIN O_EVENTS_EXT ON O_EVENTS.ID=O_EVENTS_EXT.ID_E WHERE O_EVENTS.STATE = '-'";
        this.SQL_SELECT_CLOSED_EVENTS_EXT = "SELECT O_EVENTS.*, O_EVENTS_EXT.* FROM O_EVENTS LEFT JOIN O_EVENTS_EXT ON O_EVENTS.ID=O_EVENTS_EXT.ID_E WHERE O_EVENTS.STATE <> '-' AND O_EVENTS.STATE <> 'D'";
        this.SQL_DELETE_ANNOTATIONS_V2 = "DELETE FROM O_ANNOTATIONS WHERE NOT EXISTS (SELECT 1 FROM O_EVENTS WHERE O_ANNOTATIONS.ID = O_EVENTS.ID)";
    }

    @Override
    public void setOracleQueries() {
        this.SQL_UPDATE_ANNOTATION_COUNT = "UPDATE O_EVENTS SET \"ANNOT\"=1 WHERE \"ID\"=?";
        this.SQL_UPDATE_DUPLICATES_EVENT = "UPDATE O_EVENTS SET \"TIME\" = ?, \"DUPL\" = ?, \"STIME\" = ? WHERE \"ID\" = ?";
        this.SQL_DELETE_ANNOTATIONS_V2 = "DELETE FROM O_ANNOTATIONS WHERE NOT EXISTS (SELECT 1 FROM O_EVENTS WHERE O_ANNOTATIONS.\"ID\" = O_EVENTS.\"ID\")";
        this.SQL_INSERT_ANNOTATION = this.SQL_INSERT_ANNOTATION.replace('`', '\"');
        this.SQL_REPLACE_EVENTS = "MERGE INTO O_EVENTS USING (SELECT ? \"ID\",? \"SERVICE\",? \"NODE\",? \"APPLICATION\",? \"OBJECT\",? \"MSGGRP\",? \"TIME\",? \"MSGKEY\",? \"ACKKEY\",? \"SEVERITY\",? \"DUPL\",? \"STATE\",? \"INSTRUCTIONID\",? \"AUTOACTION\",? \"OPACTION\",? \"STIME\",? \"SOURCE\",? \"VALUE\",? \"MONITOR\",? \"AGENTNODE\",? \"ANNOT\",? \"TYPE_A\",? \"TYPE_K\",? \"FTIME\",? \"MSGTEXT\" FROM DUAL) R ON (R.\"ID\" = O_EVENTS.\"ID\") WHEN MATCHED THEN UPDATE SET \"APPLICATION\"=R.\"APPLICATION\",\"OBJECT\"=R.\"OBJECT\",\"MSGGRP\"=R.\"MSGGRP\",\"TIME\"=R.\"TIME\",\"SEVERITY\"=R.\"SEVERITY\",\"DUPL\"=R.\"DUPL\",\"STATE\"=R.\"STATE\",\"INSTRUCTIONID\"=R.\"INSTRUCTIONID\",\"STIME\"=R.\"STIME\",\"MONITOR\"=R.\"MONITOR\",\"SERVICE\"=R.\"SERVICE\",\"ANNOT\"=R.\"ANNOT\",\"MSGTEXT\"=R.\"MSGTEXT\" WHEN NOT MATCHED THEN INSERT (\"ID\",\"SERVICE\",\"NODE\",\"APPLICATION\",\"OBJECT\",\"MSGGRP\",\"TIME\",\"MSGKEY\",\"ACKKEY\",\"SEVERITY\",\"DUPL\",\"STATE\",\"INSTRUCTIONID\",\"AUTOACTION\",\"OPACTION\",\"STIME\",\"SOURCE\",\"VALUE\",\"MONITOR\",\"AGENTNODE\",\"ANNOT\",\"TYPE_A\",\"TYPE_K\",\"FTIME\",\"MSGTEXT\") VALUES (R.\"ID\",R.\"SERVICE\",R.\"NODE\",R.\"APPLICATION\",R.\"OBJECT\",R.\"MSGGRP\",R.\"TIME\",R.\"MSGKEY\",R.\"ACKKEY\",R.\"SEVERITY\",R.\"DUPL\",R.\"STATE\",R.\"INSTRUCTIONID\",R.\"AUTOACTION\",R.\"OPACTION\",R.\"STIME\",R.\"SOURCE\",R.\"VALUE\",R.\"MONITOR\",R.\"AGENTNODE\",R.\"ANNOT\",R.\"TYPE_A\",R.\"TYPE_K\",R.\"FTIME\",R.\"MSGTEXT\")";
        this.SQL_REPLACE_EVENTS_EXT = "MERGE INTO O_EVENTS_EXT USING (SELECT ? \"ID_E\",? \"SRV\",? \"SRVTYPE\",? \"EXTID\",? \"T1\",? \"T2\",? \"T3\",? \"T4\",? \"T5\",? \"T6\",? \"T7\",? \"T8\",? \"T9\",? \"T10\", ? \"TFA\",? \"VFA\", ? \"CA1\",? \"CA2\",? \"CA3\",? \"CA4\",? \"CA5\",? \"CA6\",? \"CA7\",? \"CA8\",? \"CA9\",? \"CA10\",? \"CA11\",? \"CA12\",? \"CA13\",? \"CA14\",? \"CA15\" FROM DUAL) R ON (R.\"ID_E\" = O_EVENTS_EXT.\"ID_E\") WHEN MATCHED THEN UPDATE SET \"SRV\"=R.\"SRV\",\"SRVTYPE\"=R.\"SRVTYPE\",\"EXTID\"=R.\"EXTID\",\"T1\"=R.\"T1\",\"T2\"=R.\"T2\",\"T3\"=R.\"T3\",\"T4\"=R.\"T4\",\"T5\"=R.\"T5\",\"T6\"=R.\"T6\",\"T7\"=R.\"T7\",\"T8\"=R.\"T8\",\"T9\"=R.\"T9\",\"T10\"=R.\"T10\", \"TFA\"=R.\"TFA\",\"VFA\"=R.\"VFA\", \"CA1\"=R.\"CA1\",\"CA2\"=R.\"CA2\",\"CA3\"=R.\"CA3\",\"CA4\"=R.\"CA4\",\"CA5\"=R.\"CA5\",\"CA6\"=R.\"CA6\",\"CA7\"=R.\"CA7\",\"CA8\"=R.\"CA8\",\"CA9\"=R.\"CA9\",\"CA10\"=R.\"CA10\",\"CA11\"=R.\"CA11\",\"CA12\"=R.\"CA12\",\"CA13\"=R.\"CA13\",\"CA14\"=R.\"CA14\",\"CA15\"=R.\"CA15\" WHEN NOT MATCHED THEN INSERT (ID_E,SRV,SRVTYPE,EXTID,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TFA,VFA, CA1,CA2,CA3,CA4,CA5,CA6,CA7,CA8,CA9,CA10,CA11,CA12,CA13,CA14,CA15) VALUES (R.ID_E,R.SRV,R.SRVTYPE,R.EXTID,R.T1,R.T2,R.T3,R.T4,R.T5,R.T6,R.T7,R.T8,R.T9,R.T10, R.TFA,R.VFA, R.CA1,R.CA2,R.CA3,R.CA4,R.CA5,R.CA6,R.CA7,R.CA8,R.CA9,R.CA10,R.CA11,R.CA12,R.CA13,R.CA14,R.CA15)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessagesByMsg(Map<String, SEventFwd> messages) {
        block10: {
            if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
                try {
                    LinkedHashMap<String, SEventFwd> messagesTemp = new LinkedHashMap<String, SEventFwd>(messages.size());
                    ArrayList<Object[]> updList = new ArrayList<Object[]>(messages.size());
                    ArrayList<Object[]> updList2 = new ArrayList<Object[]>(messages.size());
                    int size = 0;
                    Map<String, SEventFwd> map = messages;
                    synchronized (map) {
                        size = messages.size();
                        messagesTemp.putAll(messages);
                        messages.clear();
                    }
                    for (Map.Entry entry : messagesTemp.entrySet()) {
                        SEventFwd message = (SEventFwd)entry.getValue();
                        message.setAnnotationFlag(true);
                        updList.add(new Object[]{"" + message.getState(), message.getID()});
                        updList2.add(new String[]{message.getT9(), message.getID()});
                    }
                    if (size <= 0) break block10;
                    try {
                        this.m_connectorUpdate.insertBatchPrepared(this.SQL_CLOSE_EVENT, updList);
                        this.m_connectorUpdate.insertBatchPrepared(this.SQL_CLOSE_EVENT2, updList2);
                    }
                    catch (SQLException e) {
                        ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().markAcknByNewMsg(messagesTemp);
                        RTLogger.print(1, "DB error by closing: ", e);
                        throw new DBException(e.getMessage());
                    }
                }
                finally {
                    this.connectorUpdateIsRunning.compareAndSet(true, false);
                }
            }
        }
    }

    @Override
    public void addItem(int item, String name, String description) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void archiveInDB(Map<String, SEventFwd> events) {
        this.deleteInDBSpecial(events);
    }

    @Override
    public void archiveMessages() {
    }

    @Override
    public void deleteAgent(String agentID) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteAgentAssignments(String agentID) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteAssignment(String name, String type) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteAssignment(String id) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteAssignments(List<Object[]> ids) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteEvents(List<String> events) {
    }

    @Override
    public void deleteEventsSpecial(List<String> events) {
        if (events == null || events.size() == 0) {
            return;
        }
        int size = events.size();
        ArrayList<Object[]> ackList = new ArrayList<Object[]>();
        for (int i = 0; i < size; ++i) {
            String messageID = events.get(i);
            ackList.add(new Object[]{messageID});
        }
        try {
            if (this.m_isEventEXT) {
                this.m_connectorUpdate.insertBatchPrepared("DELETE FROM O_EVENTS_EXT WHERE ID_E = ?", ackList);
            }
            this.m_connectorUpdate.insertBatchPrepared("DELETE FROM O_EVENTS WHERE ID = ?", ackList);
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error by set deleted: ", e);
            throw new DBException(e.getMessage());
        }
    }

    @Override
    public void deleteInDB(Map<String, SEventFwd> events) {
        this.deleteInDBSpecial(events);
    }

    @Override
    public void deleteInDBSpecial(Map<String, SEventFwd> events) {
        if (events != null) {
            try {
                ArrayList<String> ids = new ArrayList<String>(events.keySet());
                this.deleteEventsSpecial(ids);
                events.keySet().removeAll(ids);
            }
            catch (Throwable e) {
                RTLogger.print(1, "DBOutage error by delete: ", e);
            }
        }
    }

    @Override
    public void deleteItem(int itemID) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteRole(UserRole role) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void deleteUser(User user) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void disableDB_PERF() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void disableDB() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void enableDB_PERF() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void enableDB() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int executeDirect(String sql) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int executeOnArchive(String sql) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int executePerf2(String sql) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, SEventFwd> failoverInsertEvents(Map<String, SEventFwd> events) throws SQLException {
        LinkedHashMap<String, SEventFwd> clone = new LinkedHashMap<String, SEventFwd>();
        Map<String, SEventFwd> map = events;
        synchronized (map) {
            for (Map.Entry<String, SEventFwd> entry : events.entrySet()) {
                clone.put(entry.getKey(), entry.getValue());
            }
        }
        Map<String, SEventFwd> failed = this.loopInsertEvent(clone);
        if (clone.size() != 0 || failed.size() <= 1) {
            Map<String, SEventFwd> map2 = events;
            synchronized (map2) {
                events.keySet().removeAll(clone.keySet());
                events.keySet().removeAll(failed.keySet());
                ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().markAsFailedInsertOrUpdate(failed.values());
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failoverInsertEventsExt(Map<String, SEventFwd> events) throws SQLException {
        LinkedHashMap<String, SEventFwd> clone = new LinkedHashMap<String, SEventFwd>();
        Map<String, SEventFwd> map = events;
        synchronized (map) {
            for (Map.Entry<String, SEventFwd> entry : events.entrySet()) {
                clone.put(entry.getKey(), entry.getValue());
            }
        }
        Map<String, SEventFwd> failed = this.loopInsertEventExt(clone);
        if (clone.size() != 0 || failed.size() <= 1) {
            Map<String, SEventFwd> map2 = events;
            synchronized (map2) {
                events.keySet().removeAll(clone.keySet());
                events.keySet().removeAll(failed.keySet());
                ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().markAsFailedInsertOrUpdate(failed.values());
            }
        }
    }

    @Override
    public Map<String, Object> getArchiveIDs() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getMainDBname() {
        return super.getMainDBname();
    }

    @Override
    public String getPerfDBname() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<DDFField> getPerfTableMetaData(String tableName) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public HashMapArray<String, DDFField> getPerfTables() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void init() {
        this.m_bkpIndiFile = "failed_inserts_o.dat";
        this.m_archIndiFile = "failed_inserts_o";
        this.pattern_m_archIndiFile = Pattern.compile(this.m_archIndiFile + "\\.(\\d+)", 2);
        Properties m_dbprops = ServerEngine.getInstance().getServerProps().getDBProperties();
        String driver = m_dbprops.getProperty("Driver");
        if (driver != null && driver.contains("mysql")) {
            this.m_connector = new Connector(m_dbprops);
            this.m_connectorUpdate = new Connector(m_dbprops);
            this.m_connectorOperator = new Connector(m_dbprops);
        } else if (driver != null && driver.contains("oracle")) {
            this.m_isOracle = true;
            this.m_connector = new OraConnector(m_dbprops);
            this.m_connectorUpdate = new OraConnector(m_dbprops);
            this.m_connectorOperator = new OraConnector(m_dbprops);
        } else {
            RTLogger.print(1, "Unsupported driver: " + driver);
            throw new DBException("Unsupported driver: " + driver);
        }
        boolean isOK = this.m_connector.isReady();
        if (isOK) {
            this.m_isEventEXT = true;
            this.SQL_SELECT_ACTIVE_EVENTS = this.SQL_SELECT_ACTIVE_EVENTS_EXT;
            this.SQL_SELECT_CLOSED_EVENTS = this.SQL_SELECT_CLOSED_EVENTS_EXT;
            if (this.m_isOracle) {
                this.setOracleQueries();
            }
            this.m_mainDBName = m_dbprops.getProperty(DBProperties.M_DB_NAME);
            try {
                this.m_connector.query("SELECT STATE FROM O_EVENTS WHERE STIME=0");
            }
            catch (SQLException e1) {
                throw new DBException("OutageDB in not present");
            }
        } else {
            RTLogger.print(1, "DB is NOT ready");
            throw new DBException("Can't connect to the DB");
        }
        RTLogger.print(1, "DB is ready");
    }

    @Override
    public void insertPerfData(long time, String fields, String db, String className, String[] values) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isOnline() {
        return super.isOnline();
    }

    @Override
    public List<String> loadAnnotations(String messageID) throws SQLException {
        return super.loadAnnotations(messageID);
    }

    @Override
    public List<Assignment> loadAssignments() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ConcurrentLinkedQueue<SEventFwd> loadFromFile() {
        return super.loadFromFile();
    }

    @Override
    protected Map<String, SEventFwd> loopInsertEvent(Map<String, SEventFwd> events) throws SQLException {
        return super.loopInsertEvent(events);
    }

    @Override
    protected Map<String, SEventFwd> loopInsertEventExt(Map<String, SEventFwd> events) throws SQLException {
        return super.loopInsertEventExt(events);
    }

    @Override
    public void printInFile(SEventFwd sef) {
        super.printInFile(sef);
    }

    @Override
    public List<Map<String, Object>> queryActionRights() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<Map<String, Object>> queryPerf2(String sql) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ConcurrentHashMap<String, SEventFwd> readAcknowledgedMessages(ForwardManager fm, EventOperations eo, ConcurrentHashMap<String, SEventFwd> closedMap) {
        return super.readAcknowledgedMessages(fm, eo, closedMap);
    }

    @Override
    public ConcurrentHashMap<String, SEventFwd> readActiveMessages(ForwardManager fm, EventOperations eo, ConcurrentHashMap<String, SEventFwd> activeMap) {
        return super.readActiveMessages(fm, eo, activeMap);
    }

    @Override
    public AgentCard[] readAgentCards() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ArchiveDetails readArchiveMessages(long start, long finish, String where, int timeout_seconds) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public ConcurrentHashMap<String, String> readHelp() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<UItem> readItems() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<UserRole> readRoles() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected ArrayList<UserRight> readUserRights(String roleID) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<User> readUsers() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void renamePackage(String oldname, String newName, String user, long utime) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void saveAgentCard(AgentCard ac) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void saveAnnotations(HashMapMap<String, Annotation> annotations) {
        super.saveAnnotations(annotations);
    }

    @Override
    public void saveAssignment(String id, String agentID, String assignment, String user, String type, int lock) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void saveAssignments(List<Object[]> data) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Map<String, SEventFwd> saveEvents(Map<String, SEventFwd> events) {
        return super.saveEvents(events);
    }

    @Override
    public void saveEventsExt(Map<String, SEventFwd> sefList) {
        super.saveEventsExt(sefList);
    }

    @Override
    public void saveRole(UserRole role) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void saveUser(User user) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<Map<String, Object>> select(String sql) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<Map<String, Object>> selectDirect(String sql, int timeoutSeconds) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<Map<String, Object>> selectPerfDirect(String sql, int timeoutSeconds) throws SQLException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void setDeleteFlagPrepared(List<String> events) {
    }

    @Override
    public void storeInFile(Queue<SEventFwd> events) {
        super.storeInFile(events);
    }

    @Override
    public void tryInsertEvent(Queue<SEventFwd> events, AtomicBoolean saveTrigger) {
        super.tryInsertEvent(events, saveTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateActiveDuplicates(Map<String, SEventFwd> events) {
        block12: {
            if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
                try {
                    ArrayList<SEventFwd> tempArr = new ArrayList<SEventFwd>();
                    Map<String, SEventFwd> map = events;
                    synchronized (map) {
                        tempArr.addAll(events.values());
                        events.clear();
                    }
                    try {
                        RTLogger.print(4, "DB update DC started : " + tempArr.size());
                        this.m_connectorUpdate.updateDuplicates(this.SQL_UPDATE_DUPLICATES_EVENT, tempArr);
                    }
                    catch (Throwable e) {
                        try {
                            ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().markToUpdateInDBCount(tempArr);
                            RTLogger.print(1, "Update DC DB error", e);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            RTLogger.print(4, "DB update DC finished");
                        }
                    }
                    RTLogger.print(4, "DB update DC finished");
                }
                finally {
                    this.connectorUpdateIsRunning.compareAndSet(true, false);
                }
            }
        }
    }

    @Override
    public void updateAssignment(String id, String assignment, String user, int lock, long utime) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void updateAssignments(List<Object[]> data) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void updateItem(int item, String name, String description) {
        throw new RuntimeException("Not implemented");
    }
}

