/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class DBProperties
extends Properties {
    public static String M_DRIVER_NAME = "Driver";
    public static String M_LOGIN = "Login";
    public static String M_PASSWORD = "Password";
    public static String M_ENCRYPTED_PASSWORD = "EnPass";
    public static String M_DB_NAME = "DbName";
    public static String M_DB_HOST = "Host";
    public static String M_JDBC = "JDBC";
    public static String M_PORT = "Port";
    public static String M_POLL = "Poll";
    public static String M_DESTDIR = "ExportDir";
    private boolean m_isValid = false;

    public DBProperties(File file) {
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                this.load(fis);
                if (this.getHost() != null && this.getPort() != null && this.getLogin() != null && this.getPassword() != null) {
                    this.m_isValid = true;
                }
            }
            catch (FileNotFoundException e) {
                RTLogger.print(1, "", e);
            }
            catch (IOException e) {
                RTLogger.print(1, "", e);
            }
        } else {
            RTLogger.print(1, "Properties file is not found.");
        }
    }

    public DBProperties(Properties arg0) {
        this.putAll((Map<?, ?>)arg0);
        if (this.getHost() != null && this.getPort() != null && this.getLogin() != null && this.getPassword() != null) {
            this.m_isValid = true;
        }
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public String getDriverName() {
        String driver = this.getProperty(M_DRIVER_NAME);
        if (driver == null) {
            driver = "com.mysql.jdbc.Driver";
        }
        return driver;
    }

    public String getJdbc() {
        String jdbc = this.getProperty(M_JDBC);
        if (jdbc == null) {
            if (this.getDriverName().contains("mysql")) {
                StringBuffer sb = new StringBuffer();
                sb.append("jdbc:mysql://").append(this.getHost()).append(':').append(this.getPort()).append('/');
                jdbc = sb.toString();
            } else if (this.getDriverName().contains("oracle")) {
                StringBuffer sb = new StringBuffer();
                sb.append("jdbc:oracle:thin:@").append(this.getHost()).append(':').append(this.getPort()).append(':').append(this.getProperty("SID"));
                jdbc = sb.toString();
            }
        }
        return jdbc;
    }

    public String getLogin() {
        return this.getProperty(M_LOGIN);
    }

    public String getPassword() {
        String pass = this.getProperty(M_PASSWORD);
        if (pass == null || pass.trim().length() == 0) {
            pass = this.getProperty(M_ENCRYPTED_PASSWORD);
            pass = Cryptor.decrypt(pass);
        }
        return pass;
    }

    public String getHost() {
        return this.getProperty(M_DB_HOST);
    }

    public String getDbName() {
        return this.getProperty(M_DB_NAME);
    }

    public String getPort() {
        return this.getProperty(M_PORT);
    }

    public String getPoll() {
        return this.getProperty(M_POLL);
    }

    public String getDestDir() {
        return this.getProperty(M_DESTDIR);
    }
}

