/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.ext;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class FilterCacheElement
implements Comparable<FilterCacheElement> {
    List<Integer> list = null;
    AtomicLong firstTime = new AtomicLong(0L);
    AtomicLong lastTime = new AtomicLong(0L);
    AtomicLong accessCount = new AtomicLong(0L);

    public FilterCacheElement() {
        this.firstTime.set(System.currentTimeMillis() - 60000L);
        this.lastTime.set(System.currentTimeMillis());
        this.accessCount.incrementAndGet();
        this.list = new LinkedList<Integer>();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FilterCacheElement)) {
            return false;
        }
        FilterCacheElement obj2 = (FilterCacheElement)obj;
        return this.list == null ? obj2.list == null : this.list.equals(obj2.list);
    }

    public int hashCode() {
        return this.list == null ? 0 : this.list.hashCode();
    }

    @Override
    public int compareTo(FilterCacheElement o) {
        long delta = (this.lastTime.get() - o.lastTime.get()) / 1000L;
        if (delta == 0L) {
            delta = this.accessCount.get() - o.accessCount.get();
        }
        return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
    }

    public double getRate() {
        double actualDelay = (double)System.currentTimeMillis() - (double)this.lastTime.get();
        return actualDelay / this.getAvrgInterval() * (1.0 / (double)this.getCount());
    }

    public double getAvrgInterval() {
        return ((double)this.lastTime.get() - (double)this.firstTime.get()) / (double)this.getCount();
    }

    public long getCount() {
        return this.accessCount.get();
    }
}

