/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.ext;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.GUIWorker;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.ext.FiltersCache;
import com.blixx.server.ext.ForwardActionsManager;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.AgentIDForwardFilter;
import com.blixx.shared.ext.FPolicyFactory;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardConditions;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.FileFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ForwardManager {
    protected ExecutorService executorServiceActions = Executors.newFixedThreadPool(3);
    private FiltersCache filtersCache;
    protected Map<String, ForwardPolicy> forwardPolicies = new ConcurrentHashMap<String, ForwardPolicy>();
    protected Map<String, Integer> userRoles = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Boolean> userRolesChanged = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Collection<String>> messages = new ConcurrentHashMap<String, Collection<String>>(5000, 0.9f, 100);
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final BlockingQueue<Consumer<?>> notificationsQueue = new LinkedBlockingQueue();
    private final Path dir;
    private Thread notificationProcessingThread;

    public ForwardManager(Path dir) {
        this.dir = dir;
        this.filtersCache = new FiltersCache(dir, this::getPolicies);
        this.init();
    }

    protected ForwardManager() {
        this.dir = Paths.get(".", new String[0]);
    }

    public void reinit() {
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            this.filtersCache.init(this.dir);
            this.messages.clear();
            this.forwardPolicies.clear();
            this.userRolesChanged.clear();
            this.userRoles.clear();
            this.notificationProcessingThread.interrupt();
            this.init();
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public void forgetIndication(String indicationID) {
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            this.messages.remove(indicationID);
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    private void init() {
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            RTLogger.print(1, "Error create directory: " + String.valueOf(this.dir));
        }
        try (Stream<Path> pathStream = Files.list(this.dir);){
            pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toFile().getName().endsWith(".fwd.xml")).forEach(path -> {
                ForwardPolicy fp = new FPolicyFactory().loadForwardPolicy(path.toFile());
                if (fp != null) {
                    this.initFwdPolicy(fp, true);
                } else {
                    RTLogger.print(2, "Error loading: " + String.valueOf(path));
                }
            });
        }
        catch (Exception e) {
            RTLogger.print(1, "ERROR init fwd policies", e);
        }
        this.notificationProcessingThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.notificationsQueue.take().accept(null);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    RTLogger.print(2, "error processing notifications");
                    continue;
                }
                break;
            }
        }, "FM-2-Notifications");
        this.notificationProcessingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String name, boolean activate) {
        ForwardPolicy fp = this.forwardPolicies.get(name);
        if (fp != null && fp.isActive() != activate) {
            fp.setActive(activate);
            this.reentrantReadWriteLock.writeLock().lock();
            try {
                if (activate) {
                    this.rememberRelatedRoles(fp, false);
                } else {
                    this.forget1RelatedRoles(fp);
                }
            }
            finally {
                this.reentrantReadWriteLock.writeLock().unlock();
            }
        }
    }

    public void cleanIndicationCache() {
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            this.messages.clear();
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public ForwardPolicy forgetFwdPolicy(String name) {
        ForwardPolicy fp = null;
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            fp = this.forwardPolicies.remove(name);
            if (fp != null && fp.isActive() && fp.isUserPolicy()) {
                this.forget1RelatedRoles(fp);
            }
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
        return fp;
    }

    private void forget1RelatedRoles(ForwardPolicy fp) {
        List<String> users = fp.getAllUsers();
        if (users != null && users.size() > 0) {
            for (String uname : users) {
                if (uname.length() <= 3 || uname.charAt(0) != '[' || !uname.endsWith("]")) continue;
                this.forget1Role(uname);
            }
        }
    }

    private void forget1Role(String roleNameWithBrackets) {
        UserRole role = UserManager.getInstance().getRoleByName(roleNameWithBrackets.substring(1, roleNameWithBrackets.length() - 1));
        if (role != null) {
            Integer hm = this.userRoles.get(role.getNameInBrackets());
            if (hm != null) {
                hm = hm - 1;
                this.userRoles.put(role.getNameInBrackets(), hm);
                if (hm <= 0) {
                    this.userRoles.remove(role.getNameInBrackets());
                }
            }
            this.cleanIndicationCache();
            for (User usr : UserManager.getInstance().getUsers(role.getID())) {
                GUIWorker.disconnectUser(usr.getLoginName());
            }
        }
    }

    public void updateFwdPolicy(String name, ForwardPolicy fp) {
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            if (fp == null) {
                throw new RuntimeException("Invalid FwdPolicy file: " + name);
            }
            this.validateFilters(fp);
            if (fp.isUserPolicy() && !fp.isUserPolicyValid()) {
                throw new RuntimeException("Invalid UserRole FwdPolicy file: " + name);
            }
            this.forgetFwdPolicy(fp.getPolicyName());
            new FPolicyFactory().storeForwardPolicy(fp, this.getFile4Policy(fp));
            this.initFwdPolicy(fp, false);
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFwdUsrPolicy(ForwardPolicy fpolicy, String oldUserRoleName, String newUserRoleName) {
        File fwp = this.getFile4Policy(fpolicy);
        FPolicyFactory pf = new FPolicyFactory();
        pf.storeForwardPolicy(fpolicy, fwp);
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            this.forgetFwdPolicy(fpolicy.getPolicyName());
            for (ForwardCondition fc : fpolicy.getConditions().getConditionList()) {
                String userList;
                if (!fc.type.equals(ForwardCondition.TYPE_USERS) || !(userList = fc.to).contains(oldUserRoleName)) continue;
                fc.to = fc.to.replace(oldUserRoleName, newUserRoleName);
            }
            new FPolicyFactory().storeForwardPolicy(fpolicy, this.getFile4Policy(fpolicy));
            this.initFwdPolicy(fpolicy, false);
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public File getFile4Policy(ForwardPolicy fpolicy) {
        return this.dir.resolve(fpolicy.getPolicyName() + ".fwd.xml").toFile();
    }

    private void initFwdPolicy(ForwardPolicy fp, boolean isInit) {
        this.validateFilters(fp);
        this.forwardPolicies.put(fp.policyName, fp);
        if (fp.isActive() && fp.isUserPolicy()) {
            this.rememberRelatedRoles(fp, isInit);
        }
    }

    public List<ForwardPolicy> convertFPolicyToUserTypeOnly(ForwardPolicy fp) {
        ArrayList<ForwardPolicy> policies = new ArrayList<ForwardPolicy>();
        LinkedList<ForwardCondition> nonUserConditions = new LinkedList<ForwardCondition>();
        LinkedList<ForwardCondition> userConditions = new LinkedList<ForwardCondition>();
        for (ForwardCondition fc : fp.getConditions().getConditionList()) {
            if (!fc.type.equals(ForwardCondition.TYPE_USERS)) {
                nonUserConditions.add(fc);
                continue;
            }
            userConditions.add(fc);
        }
        HashSet<String> pNames = new HashSet<String>();
        if (nonUserConditions.size() == 0 && userConditions.size() > 0) {
            if (userConditions.size() == 1) {
                policies.add(fp);
                pNames.add(fp.getPolicyName());
            } else {
                int count = 1;
                ArrayList<ForwardCondition> conditions = fp.getConditions().getConditionList();
                for (ForwardCondition fc : conditions) {
                    ForwardPolicy nfp = ForwardPolicy.getDuplicate(fp);
                    this.validateFilters(nfp);
                    nfp.setConditions(ForwardConditions.getNew());
                    nfp.getConditions().m_targets.add(fc);
                    String newPolicyName = nfp.getPolicyName() + "_" + count++;
                    while (pNames.contains(newPolicyName) || this.forwardPolicies.containsKey(newPolicyName)) {
                        newPolicyName = nfp.getPolicyName() + "_" + count++;
                    }
                    nfp.setPolicyName(newPolicyName);
                    policies.add(nfp);
                    pNames.add(nfp.getPolicyName());
                }
            }
        } else if (nonUserConditions.size() > 0 && userConditions.size() == 0) {
            policies.add(fp);
            pNames.add(fp.getPolicyName());
        } else if (nonUserConditions.size() > 0 && userConditions.size() > 0) {
            int count = 1;
            Iterator<ForwardCondition> conditions = fp.getConditions().getConditionList().iterator();
            while (conditions.hasNext()) {
                ForwardCondition fc = conditions.next();
                if (!fc.type.equals(ForwardCondition.TYPE_USERS)) continue;
                conditions.remove();
                ForwardPolicy nfp = ForwardPolicy.getDuplicate(fp);
                this.validateFilters(nfp);
                if (nfp.hasType(21) || nfp.hasType(26)) {
                    this.removeAllNodeGroupFilters(nfp);
                }
                nfp.setConditions(ForwardConditions.getNew());
                nfp.getConditions().addCondition(fc);
                String newPolicyName = fp.getPolicyName() + "_" + count++;
                while (pNames.contains(newPolicyName) || this.forwardPolicies.containsKey(newPolicyName)) {
                    newPolicyName = fp.getPolicyName() + "_" + count++;
                }
                nfp.setPolicyName(newPolicyName);
                policies.add(nfp);
                pNames.add(nfp.getPolicyName());
            }
            policies.add(fp);
            pNames.add(fp.getPolicyName());
        }
        return policies;
    }

    private void removeAllNodeGroupFilters(ForwardPolicy nfp) {
        ArrayList<ForwardFilter> toRemove = new ArrayList<ForwardFilter>();
        for (Integer fnumber : nfp.getFilters()) {
            ForwardFilter fromCache = this.filtersCache.getForwardFilter(fnumber);
            if (fromCache == null || 21 != fromCache.getType() && 26 != fromCache.getType()) continue;
            toRemove.add(fromCache);
        }
        if (toRemove.size() > 0) {
            nfp.removeFilters(toRemove);
        }
    }

    public void convert(Path oldDir) {
        File[] farr;
        for (File file : farr = oldDir.toFile().listFiles(new FileFilter(".fwd.xml"))) {
            if (!file.getName().endsWith(".fwd.xml")) continue;
            try {
                ForwardPolicy fp = new FPolicyFactory().loadForwardPolicy(file);
                if (fp == null) {
                    throw new RuntimeException("Invalid FwdPolicy file. " + file.getName());
                }
                this.convertFPolicyToPowerGroup(fp);
                List<ForwardPolicy> convertedPolices = this.convertFPolicyToUserTypeOnly(fp);
                for (ForwardPolicy cfp : convertedPolices) {
                    new FPolicyFactory().storeForwardPolicy(cfp, this.getFile4Policy(cfp));
                    this.initFwdPolicy(cfp, true);
                }
                int count = 10;
                while (!file.delete() && count-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
        }
    }

    private void convertFPolicyToPowerGroup(ForwardPolicy fp) {
        if (fp.isActive() && fp.getAllUsers().size() > 0 && (fp.hasType(26) || fp.hasType(21))) {
            ArrayList<PGItem> powerGroupItems = new ArrayList<PGItem>();
            for (Integer number : fp.getFilters()) {
                ForwardFilter ff = this.filtersCache.getForwardFilter(number);
                if (ff == null) continue;
                switch (ff.getType()) {
                    case 26: {
                        AgentIDForwardFilter aaf = (AgentIDForwardFilter)ff;
                        powerGroupItems.addAll(aaf.convert());
                        break;
                    }
                    case 21: {
                        NodeGroupForwardFilter ngf = (NodeGroupForwardFilter)ff;
                        powerGroupItems.addAll(ngf.convert());
                    }
                }
            }
            if (powerGroupItems.size() > 0) {
                String name = "FP_" + fp.getPolicyName();
                for (String user : fp.getAllUsers()) {
                    if (!user.startsWith("[") || !user.endsWith("]")) continue;
                    String userGroup = user.substring(1, user.length() - 1);
                    UserRole roleByName = UserManager.getInstance().getRoleByName(userGroup);
                    if (roleByName == null) continue;
                    PowerGroup pg = new PowerGroup(name, fp.getDescription());
                    int defaultRights = UserManager.getInstance().getRights(1002, roleByName);
                    PGEntityAction action = PGEntityAction.READ;
                    switch (defaultRights) {
                        case 3: {
                            action = PGEntityAction.MODIFY;
                        }
                    }
                    for (PGItem item : powerGroupItems) {
                        pg.add(new PGItem(item.getPermFlag(), action, item.getObjectType(), item.getPath()));
                    }
                    Map<PowerGroup, Object> map = UserManager.getInstance().getPowerGroups(roleByName.getID());
                    boolean found = false;
                    for (PowerGroup pgs : map.keySet()) {
                        if (!pgs.m_name.equals(name)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    UserManager.getInstance().addPowerGroup(roleByName.getID(), pg);
                }
            }
        }
    }

    private void rememberRelatedRoles(ForwardPolicy fp, boolean isInit) {
        List<String> users = fp.getAllUsers();
        for (String uname : users) {
            if (uname.length() <= 3 || uname.charAt(0) != '[' || !uname.endsWith("]")) continue;
            this.remember1Role(isInit, uname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remember1Role(boolean isInit, String roleNameWithBrackets) {
        UserRole role = UserManager.getInstance().getRoleByName(roleNameWithBrackets.substring(1, roleNameWithBrackets.length() - 1));
        if (role != null) {
            Integer numRelalatedPolicies = null;
            this.reentrantReadWriteLock.readLock().lock();
            try {
                numRelalatedPolicies = this.userRoles.get(roleNameWithBrackets);
                if (numRelalatedPolicies == null) {
                    numRelalatedPolicies = 1;
                    this.userRoles.put(roleNameWithBrackets, numRelalatedPolicies);
                } else {
                    numRelalatedPolicies = numRelalatedPolicies + 1;
                    this.userRoles.put(roleNameWithBrackets, numRelalatedPolicies);
                }
            }
            finally {
                this.reentrantReadWriteLock.readLock().unlock();
            }
            if (!isInit) {
                this.cleanIndicationCache();
                for (User usr : UserManager.getInstance().getUsers(role.getID())) {
                    GUIWorker.disconnectUser(usr.getLoginName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> checkAll(SEventFwd se, boolean force, boolean triggerServerActions) {
        Collection<String> roles = null;
        this.reentrantReadWriteLock.readLock().lock();
        try {
            roles = this.messages.get(se.getID());
            if (!force && roles != null) {
                Collection<String> collection = roles;
                return collection;
            }
            roles = new HashSet<String>();
            for (Map.Entry<String, ForwardPolicy> en : this.forwardPolicies.entrySet()) {
                ForwardPolicy fp = en.getValue();
                if (fp == null || !fp.isActive()) continue;
                Collection<String> roleNames = this.checkConditions(fp, se, triggerServerActions);
                roles.addAll(roleNames);
            }
            for (UserRole ur : UserManager.getInstance().getRoles()) {
                if (!UserManager.getInstance().isUserRoleNodeGroupFiltered(ur)) continue;
                if (this.isMatchedByFilteredAgents(se, UserManager.getInstance().getVisibleAgentsIDs(ur))) {
                    if (this.userRoles.containsKey(ur.getNameInBrackets())) continue;
                    roles.add(ur.getNameInBrackets());
                    continue;
                }
                roles.remove(ur.getNameInBrackets());
            }
            this.messages.put(se.getID(), roles);
        }
        finally {
            this.reentrantReadWriteLock.readLock().unlock();
        }
        return roles;
    }

    protected Collection<String> checkConditions(ForwardPolicy fp, SEventFwd se, boolean triggerAction) {
        HashSet<String> affectedRoles = new HashSet<String>();
        if (this.filtersCache.check(se, fp.getFilterTypes(), fp.m_filters)) {
            for (ForwardCondition fc : fp.conditions.getConditionList()) {
                boolean condMatch = this.checkEvent(fc, se, triggerAction);
                if (!condMatch || !fc.isUsersType()) continue;
                ArrayList<String> condUsers = new ArrayList<String>(fc.getUsersAssociated());
                for (String userRole : condUsers) {
                    UserRole role;
                    if (userRole == null || !userRole.startsWith("[") || !userRole.endsWith("]") || (role = UserManager.getInstance().getRoleByName(userRole.substring(1, userRole.length() - 1))) == null) continue;
                    affectedRoles.add(userRole);
                }
            }
        }
        return affectedRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkEvent(ForwardCondition fc, SEventFwd se, boolean triggerAction) {
        boolean match = false;
        int sev = se.getSeverityInt();
        if (sev < 0) {
            sev += 6;
        }
        if (fc.forwardALL) {
            match = true;
        } else {
            boolean bl = match = fc.checkTimeRange(se.getSTime()) && fc.checkSeverity("" + sev) && fc.checkTypeAandK(se.getTypeA(), se.getTypeK());
        }
        if (match && !fc.isUsersType() && triggerAction) {
            if (!ForwardCondition.TYPE_NOTIFICATION.equals(fc.type)) {
                this.executorServiceActions.submit(() -> ForwardActionsManager.getInstance().addAction(fc.type, fc.to, fc.xsend, se));
            } else {
                while (!this.notificationsQueue.offer(this.sendNotifiFunction(fc, se))) {
                    ForwardManager forwardManager = this;
                    synchronized (forwardManager) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return match;
    }

    private Consumer<?> sendNotifiFunction(ForwardCondition fc, SEventFwd se) {
        return s -> ForwardActionsManager.getInstance().addAction(fc.type, fc.to, fc.xsend, se);
    }

    public void checkAllWhileLoading(SEventFwd se) {
        this.checkAll(se, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserIndicationsFiltered(String user) {
        boolean filtered = false;
        UserRole role = UserManager.getInstance().getRoleForUser(user);
        this.reentrantReadWriteLock.readLock().lock();
        try {
            String userRoleName;
            filtered = role == null ? this.userRoles.containsKey(user) : this.userRoles.containsKey(userRoleName = role.getNameInBrackets()) || this.userRoles.containsKey(user);
        }
        finally {
            this.reentrantReadWriteLock.readLock().unlock();
        }
        return filtered;
    }

    public List<ForwardPolicy> getPolicies() {
        ArrayList<ForwardPolicy> arr = new ArrayList<ForwardPolicy>();
        this.reentrantReadWriteLock.readLock().lock();
        try {
            arr.addAll(this.forwardPolicies.values());
        }
        finally {
            this.reentrantReadWriteLock.readLock().unlock();
        }
        return arr;
    }

    public ForwardPolicy getForwardPolicy(String name) {
        this.reentrantReadWriteLock.readLock().lock();
        try {
            ForwardPolicy forwardPolicy = this.forwardPolicies.get(name);
            return forwardPolicy;
        }
        finally {
            this.reentrantReadWriteLock.readLock().unlock();
        }
    }

    public void validateFilters() {
        for (ForwardPolicy fp : this.getPolicies()) {
            this.validateFilters(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFilters(ForwardPolicy fp) {
        this.reentrantReadWriteLock.readLock().lock();
        try {
            Iterator<Integer> it = fp.m_filters.iterator();
            fp.clearFilterTypes();
            while (it.hasNext()) {
                Integer fNumber = it.next();
                int type = this.filtersCache.isExist(fNumber);
                if (type == 0) {
                    RTLogger.print(5, "UNKNOWN Filter #" + fNumber + " in FPolicy :" + fp.getPolicyName());
                    continue;
                }
                Integer typeInt = type;
                if (fp.hasType(typeInt)) continue;
                fp.addFilterType(typeInt);
            }
        }
        finally {
            this.reentrantReadWriteLock.readLock().unlock();
        }
    }

    public boolean containsNodeGroupOrAgentIdFilters(ForwardPolicy fp) {
        return fp.hasType(21) || fp.hasType(26);
    }

    public void cleanNodeGroupCache() {
        this.reentrantReadWriteLock.writeLock().lock();
        try {
            this.filtersCache.cleanNodeGroupCache();
            this.filtersCache.cleanAgentIDCache();
            this.cleanIndicationCache();
        }
        finally {
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public FiltersCache getFiltersCache() {
        return this.filtersCache;
    }

    public ForwardFilter getForwardFilter(int number) {
        return this.getFiltersCache().getForwardFilter(number);
    }

    public boolean isMatchedByFilteredAgents(SEventFwd ie, Collection<String> filteredAgentIDs) {
        boolean isMatched = true;
        if (filteredAgentIDs != null && !filteredAgentIDs.contains(ie.getT1())) {
            isMatched = false;
            for (AgentCard ac : ServerEngine.getInstance().getAgentRepository().getExternalHosts(ie.getNode())) {
                if (!filteredAgentIDs.contains(ac.getAgentID())) continue;
                isMatched = true;
                break;
            }
        }
        return isMatched;
    }
}

