/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.sa.VirtualSocket;
import com.blixx.server.AgentCard;
import com.blixx.server.DeployClient;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerWorker;
import com.blixx.server.utils.VirtualSocketServer;
import com.blixx.shared.AgentInventoryCard;
import com.boom.AgentInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class AgentCommunicationHandler {
    public String m_agentID;
    public String m_agentOSname;
    public String m_agentHost;
    public String m_agentPort;
    public String m_agentVersion;
    public String m_agentSessionID;
    public String m_agentIPLocal;
    public String m_agentProxyHost;
    public static String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static Map<String, VirtualSocketServer> m_runningTasks = new ConcurrentHashMap<String, VirtualSocketServer>();

    public void handle(String url, Properties headers, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.m_agentID = headers.getProperty("BOOMAGENTID");
            if (this.m_agentID == null) {
                this.sendBadRequest(response, 490);
            }
            this.m_agentOSname = headers.getProperty("BOOMAGENTOSNAME");
            this.m_agentHost = headers.getProperty("BOOMAGENTHOST");
            this.m_agentIPLocal = headers.getProperty("BOOMAGENTIPLOCAL");
            this.m_agentPort = headers.getProperty("BOOMAGENTPORT");
            this.m_agentVersion = headers.getProperty("BOOMAGENTVERSION");
            this.m_agentSessionID = headers.getProperty("BOOMAGENTSESSIONID");
            this.m_agentProxyHost = headers.getProperty("BOOMAGENTPROXY");
            if (this.m_agentSessionID != null) {
                // empty if block
            }
            if (url.startsWith("/comm/agent/hb")) {
                if (this.m_agentSessionID == null) {
                    this.handleHB(request, response);
                } else {
                    AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(this.m_agentID);
                    if (ac != null) {
                        ac.setLastTimeOnline();
                    }
                    this.resumeVirtualSocketServer(this.m_agentSessionID, request, response);
                }
            } else if (url.startsWith("/comm/agent/submit")) {
                AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(this.m_agentID);
                if (ac == null) {
                    this.sendBadRequest(response, 403);
                } else if (this.m_agentSessionID == null) {
                    this.handleSubmit(ac, request, response);
                } else {
                    this.resumeVirtualSocketServer(this.m_agentSessionID, request, response);
                }
            } else if (!url.startsWith("/comm/agent/test")) {
                this.sendBadRequest(response, 501);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeVirtualSocketServer(String sessionID, HttpServletRequest request, HttpServletResponse response) throws IOException {
        VirtualSocketServer vs;
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Session continue: " + sessionID);
        }
        if ((vs = m_runningTasks.get(sessionID)) != null) {
            Object sb;
            vs.setHttpResponse(response);
            byte[] arr = this.read(request.getInputStream());
            vs.getOs().setOutputStream(new ByteArrayOutputStream());
            request.getInputStream().close();
            if (RTLogger.getCurrentLevel() >= 5) {
                sb = new StringBuilder("Session bytes: ");
                ((StringBuilder)sb).append(arr.length).append(" ConLen:").append(request.getContentLength());
                if (request.getContentType() != null) {
                    ((StringBuilder)sb).append(" ConType: ").append(request.getContentType());
                }
                RTLogger.print(5, ((StringBuilder)sb).toString());
            }
            vs.getIs().setInputStream(new ByteArrayInputStream(arr));
            try {
                sb = response;
                synchronized (sb) {
                    response.wait(30000L);
                }
            }
            catch (InterruptedException e) {
                RTLogger.print(3, "", e);
            }
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Temp Response released " + sessionID);
            }
        } else {
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(4, "ERROR bad request session: " + sessionID);
            }
            this.read(request.getInputStream());
            this.sendBadRequest(response, 410);
        }
    }

    protected byte[] read(InputStream inputStream) throws IOException {
        byte[] arr = new byte[16000];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len = -1;
        while ((len = inputStream.read(arr)) != -1) {
            bos.write(arr, 0, len);
        }
        return bos.toByteArray();
    }

    public void sendBadRequest(HttpServletResponse response, int responseCode) throws IOException {
        RTLogger.print(5, "bad request ");
        int status = responseCode;
        response.setStatus(status);
        response.setContentLength(0);
        response.flushBuffer();
        if (this.m_agentSessionID != null) {
            RTLogger.print(5, "FORCED remove session: " + this.m_agentSessionID);
            m_runningTasks.remove(this.m_agentSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTest(String session, Properties headers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.addHeader("BOOMAGENTSESSIONID", session);
        try (VirtualSocketServer vsock = new VirtualSocketServer(session);){
            String input;
            byte[] arr = this.read(request.getInputStream());
            request.getInputStream().close();
            vsock.setHttpResponse(response);
            vsock.getIs().setInputStream(new ByteArrayInputStream(arr));
            vsock.getOs().setOutputStream(new ByteArrayOutputStream());
            m_runningTasks.put(session, vsock);
            while (!"EXIT".equals(input = vsock.getIs().readUTF())) {
                String output = "PONG" + input.substring(input.indexOf(45));
                vsock.getOs().writeUTF(output);
            }
        }
        catch (Throwable t) {
            RTLogger.print(3, "", t);
        }
        finally {
            RTLogger.print(5, "Handler stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleHB(HttpServletRequest request, HttpServletResponse response) {
        block25: {
            String sessionID = UUID.randomUUID().toString();
            try {
                String ip;
                AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(this.m_agentID);
                if (ac == null) {
                    AgentInfo agtInfo = new AgentInfo("HTTP", true, null, null);
                    agtInfo.setPort(Integer.parseInt(this.m_agentPort));
                    agtInfo.setOs(this.m_agentOSname);
                    agtInfo.setId(this.m_agentID);
                    agtInfo.setHostname(this.m_agentHost);
                    agtInfo.setRemoteIP(this.m_agentIPLocal + "@" + this.m_agentProxyHost);
                    ServerEngine.getInstance().getAgentRepository().addPendingIP(agtInfo);
                    this.sendAnswer(response, new byte[]{7});
                    break block25;
                }
                ac.setLastTimeOnline();
                String string = ip = this.m_agentProxyHost != null ? this.m_agentIPLocal + "@" + this.m_agentProxyHost : this.m_agentIPLocal;
                if (!ac.getAgentIP().equals(ip) || !ac.isHttpAgent()) {
                    try {
                        ac.setSingleFlagON(32);
                        ac.setNewAgentIP(ip);
                        ServerEngine.getInstance().getAgentRepository().saveAgentCard_notifySingle(ac);
                        ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS", ac.getAgentID(), null));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (ac.getAgentInventoryCard() != null && this.m_agentVersion != null && !this.m_agentVersion.equals(ac.getAgentInventoryCard().getAttribute("VERSION"))) {
                    try {
                        ac.getAgentInventoryCard().setAttribute(AgentInventoryCard.getPath("VERSION"), this.m_agentVersion);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (ac.pendingUpdates() || ac.isPendingDeployments4Firewalled()) {
                    if (ac.pendingUpdates()) {
                        Iterator<IRemoteProcessing> it = new ArrayList<IRemoteProcessing>(ac.getPendingMap_Unsynchronized().keySet()).iterator();
                        if (!it.hasNext()) break block25;
                        IRemoteProcessing irTask = it.next();
                        Map<IRemoteProcessing, Long> map = ac.getPendingMap_Unsynchronized();
                        synchronized (map) {
                            ac.getPendingMap_Unsynchronized().remove(irTask);
                        }
                        ProcessAction pa = new ProcessAction(this, response, irTask, sessionID);
                        Thread tr2 = new Thread((Runnable)pa, "JettyPA");
                        tr2.start();
                        try {
                            HttpServletResponse httpServletResponse = response;
                            synchronized (httpServletResponse) {
                                response.wait(30000L);
                                break block25;
                            }
                        }
                        catch (InterruptedException e) {
                            RTLogger.print(3, "", e);
                        }
                        break block25;
                    }
                    if (ac.isPendingDeployments4Firewalled() && ac.m_deploymentTask == null) {
                        response.addHeader("BOOMAGENTSESSIONID", sessionID);
                        DeployClient dc = ac.getDeploymentQueue().poll();
                        if (dc == null) break block25;
                        ac.m_deploymentTask = dc;
                        ProcessDeployments pd = new ProcessDeployments(this, response, ac, dc, sessionID);
                        Thread tr = new Thread((Runnable)pd, "JettyPD");
                        tr.start();
                        try {
                            HttpServletResponse tr2 = response;
                            synchronized (tr2) {
                                response.wait(30000L);
                                break block25;
                            }
                        }
                        catch (InterruptedException e) {
                            RTLogger.print(3, "", e);
                        }
                        break block25;
                    }
                    this.sendAnswer(response, new byte[]{0});
                    break block25;
                }
                this.sendAnswer(response, new byte[]{0});
            }
            catch (Throwable e) {
                e.printStackTrace();
                RTLogger.print(5, "HTTPS HB handler failed. ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSubmit(AgentCard ac, HttpServletRequest request, HttpServletResponse response) {
        Thread tr = new Thread((Runnable)new ProcessSubmit(response, request, ac), "JettyPS");
        tr.start();
        try {
            HttpServletResponse httpServletResponse = response;
            synchronized (httpServletResponse) {
                response.wait(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendAnswer(HttpServletResponse response, byte[] tosend) throws IOException {
        response.setStatus(200);
        response.setContentType(MIME_DEFAULT_BINARY);
        response.setContentLength(tosend.length);
        response.getOutputStream().write(tosend, 0, tosend.length);
        response.flushBuffer();
    }

    private final class ProcessAction
    implements Runnable {
        private final HttpServletResponse m_response;
        private final IRemoteProcessing m_irTask;
        private String m_sessionID = null;

        private ProcessAction(AgentCommunicationHandler agentCommunicationHandler, HttpServletResponse response, IRemoteProcessing irTask, String sessionID) {
            this.m_response = response;
            this.m_irTask = irTask;
            this.m_sessionID = sessionID;
        }

        @Override
        public void run() {
            VirtualSocket vsock = null;
            try {
                this.m_response.addHeader("BOOMAGENTSESSIONID", this.m_sessionID);
                vsock = new VirtualSocketServer(this.m_sessionID);
                ((VirtualSocketServer)vsock).setHttpResponse(this.m_response);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                vsock.getOs().setOutputStream(bos);
                m_runningTasks.put(this.m_sessionID, (VirtualSocketServer)vsock);
                RTLogger.print(5, "Action Session started: " + this.m_sessionID);
                vsock.getOs().write(1);
                this.m_irTask.setInputOutput(vsock.getIs(), vsock.getOs());
                this.m_irTask.sendToFirewalled(vsock);
                RTLogger.print(5, this.m_irTask.getResult().toString());
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
            finally {
                if (vsock != null) {
                    try {
                        vsock.close();
                    }
                    catch (Throwable bos) {}
                }
            }
        }
    }

    private final class ProcessDeployments
    implements Runnable {
        private HttpServletResponse m_response;
        private AgentCard m_ac;
        private DeployClient m_dc;
        private String m_sessionID = null;

        private ProcessDeployments(AgentCommunicationHandler agentCommunicationHandler, HttpServletResponse response, AgentCard ac, DeployClient dc, String sessionID) {
            this.m_response = response;
            this.m_ac = ac;
            this.m_dc = dc;
            this.m_sessionID = sessionID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (VirtualSocketServer vsock = new VirtualSocketServer(this.m_sessionID);){
                vsock.setHttpResponse(this.m_response);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                vsock.getOs().setOutputStream(bos);
                m_runningTasks.put(this.m_sessionID, vsock);
                RTLogger.print(5, "Deployment Session started: " + this.m_sessionID);
                vsock.getOs().write(1);
                this.m_dc.setInputOutput(vsock.getIs(), vsock.getOs());
                this.m_dc.sendToFirewalled(vsock);
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
                RTLogger.print(5, "Deployment processing failed. ", e);
            }
            finally {
                this.m_ac.m_deploymentTask = null;
                RTLogger.print(5, "Session finished " + this.m_sessionID);
                if (this.m_sessionID != null) {
                    m_runningTasks.remove(this.m_sessionID);
                }
            }
        }
    }

    private class ProcessSubmit
    implements Runnable {
        private final HttpServletResponse m_response;
        private final HttpServletRequest m_request;
        private final AgentCard m_ac;

        private ProcessSubmit(HttpServletResponse response, HttpServletRequest request, AgentCard ac) {
            this.m_response = response;
            this.m_request = request;
            this.m_ac = ac;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VirtualSocket vsock = null;
            String session = UUID.randomUUID().toString();
            try {
                this.m_response.addHeader("BOOMAGENTSESSIONID", session);
                vsock = new VirtualSocketServer(session);
                byte[] arr = AgentCommunicationHandler.this.read(this.m_request.getInputStream());
                this.m_request.getInputStream().close();
                ((VirtualSocketServer)vsock).setHttpResponse(this.m_response);
                vsock.getIs().setInputStream(new ByteArrayInputStream(arr));
                vsock.getOs().setOutputStream(new ByteArrayOutputStream());
                m_runningTasks.put(session, (VirtualSocketServer)vsock);
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "Submit Session started: " + session);
                }
                ServerWorker sw = new ServerWorker(this.m_ac);
                sw.processIncomingData(vsock.getOs(), vsock.getIs(), "127.0.0.127");
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
            }
            finally {
                if (session != null) {
                    m_runningTasks.remove(session);
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, "Submit Session finished: " + session);
                    }
                }
                if (vsock != null) {
                    try {
                        vsock.close();
                    }
                    catch (Throwable arr) {}
                }
            }
        }
    }
}

