/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.ext.EventIterator;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.Statistics;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DirectHandler {
    public static final int MAXMAX = 500;

    public boolean handle(String username, String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isFound = true;
        if (url.startsWith("/statistic")) {
            EventIterator itOrig;
            String maxAStr = (String)request.getAttribute("maxa");
            String maxPStr = (String)request.getAttribute("maxp");
            int maxA = 10;
            int maxP = 10;
            if (maxAStr != null) {
                try {
                    maxA = Integer.parseInt(maxAStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            maxP = Math.min(500, maxP);
            if (maxPStr != null) {
                try {
                    maxP = Integer.parseInt(maxPStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            maxP = Math.min(500, maxP);
            ServerEngine instance = ServerEngine.getInstance();
            List<SEventFwd> col = instance.getEventsRouter().getEventOperations().getActiveIndications(false);
            Iterator<SEventFwd> it = itOrig = col.iterator();
            if (username != null) {
                it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), username);
            }
            LinkedList<String> ids = null;
            if (username != null && UserManager.getInstance().isUserNodeGroupFiltered(username)) {
                List<AgentCard> listA = ServerEngine.getInstance().getAgentRepository().getAgentCards(username);
                ids = new LinkedList<String>();
                for (AgentCard ac : listA) {
                    ids.add(ac.getAgentID());
                }
            }
            Statistics st = new Statistics(instance.getAgentRepository(), instance.getPolicyRepository(), it, ids);
            st.setMaxAgents(maxA);
            st.setMaxPolicies(maxP);
            it = instance.getEventsRouter().getEventOperations().freshGetAcknowledgedMessages(username).iterator();
            st.addStatistic(it);
            String s = st.toHTML();
            response.getWriter().write(s);
        } else {
            isFound = false;
        }
        return isFound;
    }
}

