/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.ext.EventIterator;
import com.blixx.server.jetty.MapAgentJSON;
import com.blixx.server.services.ServiceDashBoard;
import com.blixx.server.services.ServiceDashBoardJson;
import com.blixx.server.services.ServiceDashboardFactory;
import com.blixx.shared.SEventFwd;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GrafanaJson
extends MapAgentJSON {
    public static final String TEXT = "text";
    public static final String SERVICE = "service";
    public static final String PANELTYPE = "panelType";
    public static final String VALUE = "value";
    public static final String TARGET = "target";
    public static final String DATAPOINTS = "datapoints";
    public static final String PERF_CLASS = "perfClass";
    public static final String METRICS = "metrics";
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String OBJECTS = "objects";
    public static final String FROM = "from";
    public static final String TO = "to";

    public JsonArray processGetPerfData(String user, String agentID, String className, String metric, Map<String, String> objects, Long from, Long to) throws SQLException {
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, agentID)) {
            throw new RuntimeException("Access denied");
        }
        JsonArray main = new JsonArray();
        JsonObject targetList = new JsonObject();
        if (objects.isEmpty()) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            List<Map<String, Object>> res = this.getPerfData(className, user, metric, agentID, objectMap, from, to);
            this.setDatapoints(metric, main, objectMap, targetList, res);
        } else {
            List<Map<String, Object>> res = this.getPerfData(className, user, metric, agentID, objects, from, to);
            this.setDatapoints(metric, main, objects, targetList, res);
        }
        return main;
    }

    public void getServices(HttpServletResponse response, String user, List<ServiceDashBoard> services) {
        services = this.setServices(user, services);
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(ServiceDashBoard.class, new ServiceDashBoardJson());
        Gson gson = gsonBuilder.create();
        ArrayList servicesList = new ArrayList();
        for (ServiceDashBoard tp : services) {
            HashMap<String, Object> servicesMap = new HashMap<String, Object>();
            servicesMap.put(TEXT, tp.getName());
            servicesMap.put(VALUE, tp.getID() + ":" + tp.getName());
            servicesMap.put("name", tp.getName());
            servicesList.add(servicesMap);
        }
        this.sendJSONResponse(response, gson.toJson(servicesList));
    }

    public List<ServiceDashBoard> setServices(String user, List<ServiceDashBoard> services) {
        File file = GrafanaJson.getServiceFile(user);
        if (services == null) {
            ServiceDashboardFactory factory = new ServiceDashboardFactory();
            services = factory.loadLocalFile(file);
            Iterator<SEventFwd> itOrig = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
            EventIterator it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
            LinkedList<SEventFwd> active = new LinkedList<SEventFwd>();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                active.add(sef);
            }
            for (ServiceDashBoard ssd : services) {
                ssd.processActiveOrClosed(active);
            }
        } else {
            Iterator<SEventFwd> itOrig = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
            EventIterator it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
            LinkedList<SEventFwd> active = new LinkedList<SEventFwd>();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                active.add(sef);
            }
            for (ServiceDashBoard ssd : services) {
                ssd.processActiveOrClosed(active);
                ssd.removeAllClosed();
            }
        }
        Collections.sort(services);
        return services;
    }

    public void setDatapoints(String metric, JsonArray main, Map<String, String> objectMap, JsonObject targetList, List<Map<String, Object>> res) {
        JsonArray jsonDatapoints = new JsonArray();
        ArrayList<String> datapoint = new ArrayList<String>();
        JsonParser parser = new JsonParser();
        for (Map<String, Object> map : res) {
            datapoint.clear();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (!entry.getKey().equals(metric) && !entry.getKey().equals("_TIME")) continue;
                datapoint.add(entry.getValue().toString());
            }
            String json = new Gson().toJson(datapoint);
            JsonElement jsonDataElement = parser.parse(json);
            JsonArray jsonDataArray = jsonDataElement.getAsJsonArray();
            jsonDatapoints.add(jsonDataArray.getAsJsonArray());
        }
        if (objectMap.isEmpty()) {
            targetList.addProperty(TARGET, metric);
        } else {
            targetList.addProperty(TARGET, metric + " " + objectMap.get(objectMap.keySet().toArray()[0]));
        }
        targetList.add(DATAPOINTS, jsonDatapoints.getAsJsonArray());
        main.add(targetList);
    }

    public void extractTarget(HttpServletRequest request, List<Map<String, String>> targetList) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jo = (JsonObject)jsonParser.parse(buffer.toString());
        JsonArray jsonArray = jo.getAsJsonArray("targets");
        JsonObject jsonObjRange = jo.getAsJsonObject("range");
        if (null != jsonArray) {
            for (JsonElement pa : jsonArray) {
                HashMap<String, String> targetMap = new HashMap<String, String>();
                JsonObject firstTarget = pa.getAsJsonObject();
                if (firstTarget.get(TARGET) != null) {
                    targetMap.put(TARGET, firstTarget.get(TARGET).getAsString());
                }
                targetMap.put(FROM, jsonObjRange.get(FROM).toString());
                targetMap.put(TO, jsonObjRange.get(TO).toString());
                targetMap.put(ID, firstTarget.get(ID).getAsString());
                targetMap.put(PERF_CLASS, firstTarget.get(PERF_CLASS).getAsString());
                targetMap.put(OBJECTS, firstTarget.get(OBJECTS).getAsString());
                targetMap.put(METRICS, firstTarget.get(METRICS).getAsString());
                targetMap.put(TYPE, firstTarget.get(TYPE).getAsString());
                targetMap.put(SERVICE, firstTarget.get(SERVICE).getAsString());
                targetMap.put(PANELTYPE, firstTarget.get(PANELTYPE).getAsString());
                targetList.add(targetMap);
            }
        } else {
            HashMap<String, String> targetMap = new HashMap<String, String>();
            if (jo.get(TYPE).getAsString().equals("table")) {
                targetMap.put(TYPE, jo.get(TYPE).getAsString());
                targetList.add(targetMap);
            } else {
                targetMap.put(TARGET, jo.get(TARGET).getAsString());
                targetMap.put(FROM, jsonObjRange.get(FROM).toString());
                targetMap.put(TO, jsonObjRange.get(TO).toString());
                targetMap.put(ID, jo.get(ID).getAsString());
                targetMap.put(PERF_CLASS, jo.get(PERF_CLASS).getAsString());
                targetMap.put(OBJECTS, jo.get(OBJECTS).getAsString());
                targetMap.put(METRICS, jo.get(METRICS).getAsString());
                targetMap.put(TYPE, jo.get(TYPE).getAsString());
                targetMap.put(SERVICE, jo.get(SERVICE).getAsString());
                targetMap.put(PANELTYPE, jo.get(PANELTYPE).getAsString());
                targetList.add(targetMap);
            }
        }
    }
}

