/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.server.jetty.JettyMain;
import com.blixx.server.jetty.UserPrincipal;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;

public class InternalHttpRequest
extends Request {
    UserPrincipal user = null;
    HttpSession session = null;
    MultiMap<String> m_parameters = new MultiMap();

    public InternalHttpRequest(String user) {
        super(null, null);
        this.user = new UserPrincipal(user);
        this.session = JettyMain.getSessionHandler().newHttpSession(this);
    }

    public InternalHttpRequest(String user, MultiMap<String> parameters) {
        this(user);
        this.setParameters(parameters);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.user;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> values = this.m_parameters.getValues(name);
        return values == null ? null : values.toArray(new String[0]);
    }

    @Override
    public String getParameter(String name) {
        List<String> values = this.m_parameters.getValues(name);
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    public Map getParameterMap() {
        return this.m_parameters.toStringArrayMap();
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.m_parameters.keySet());
    }

    public MultiMap<String> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(MultiMap<String> parameters) {
        this.m_parameters = parameters;
    }
}

