/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.ctrl.sc.in.ScGetJson;
import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.AgentCard;
import com.blixx.server.DeploymentManager;
import com.blixx.server.EventOperations;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.cube.AbstractEventSummary;
import com.blixx.server.cube.OnDemandSummary;
import com.blixx.server.db.DB;
import com.blixx.server.ext.EventIterator;
import com.blixx.server.jetty.json.AgentCardJson;
import com.blixx.server.jetty.json.AgentCardWithInventoryJson;
import com.blixx.server.jetty.json.AnnotationJson;
import com.blixx.server.jetty.json.AssignmentJson;
import com.blixx.server.jetty.json.ConditionJson;
import com.blixx.server.jetty.json.DDFFieldJson;
import com.blixx.server.jetty.json.GroupTreeObjectJson;
import com.blixx.server.jetty.json.MsgConditionJson;
import com.blixx.server.jetty.json.MsgPolicyJson;
import com.blixx.server.jetty.json.PolicyJson;
import com.blixx.server.jetty.json.SEventFwdJson;
import com.blixx.server.jetty.json.SEventShortJson;
import com.blixx.server.perf.PerfManager;
import com.blixx.server.services.EventFilter;
import com.blixx.server.services.ServiceDashBoard;
import com.blixx.server.services.ServiceDashBoardJson;
import com.blixx.server.services.ServiceDashboardFactory;
import com.blixx.server.utils.SKey;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.Condition;
import com.blixx.shared.DeploymentStatus;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectMD5;
import com.blixx.shared.utils.HashMapArray;
import com.blixx.shared.utils.Statistics;
import com.blixx.shared.utils.TreeObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapAgentJSON {
    public static final String ACCESS_DENIED = "Access denied";

    public void processGetAgents(HttpServletResponse response, String user, int start, int lenght, int draw, String filter, boolean isRealOnly) {
        if (!this.canSeeAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        try {
            Map<String, AgentCard> agents = ServerEngine.getInstance().getAgentRepository().getAgentCards();
            ArrayList<AgentCard> list = new ArrayList<AgentCard>(lenght == -1 ? agents.size() : lenght);
            ArrayList<AgentCard> listT = new ArrayList<AgentCard>(agents.values());
            if (filter != null) {
                filter = filter.toLowerCase();
            }
            Collections.sort(listT, new Comparator<AgentCard>(this){

                @Override
                public int compare(AgentCard a1, AgentCard a2) {
                    String l1 = a1.getLabel().isEmpty() ? a1.getAgentHost() : a1.getLabel();
                    String l2 = a2.getLabel().isEmpty() ? a2.getAgentHost() : a2.getLabel();
                    return l1.compareToIgnoreCase(l2);
                }
            });
            int count = 0;
            int filtered = 0;
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            for (AgentCard ac : listT) {
                if (!ac.isApproved() || isRealOnly && ac.getAgentPort() == 0 || UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, ac.getAgentID(), nodeGroups)) continue;
                if (filter != null && filter.length() > 0) {
                    if (ac.getAgentHost().toLowerCase().contains(filter) || ac.toString().toLowerCase().contains(filter) || ac.getOSName().toLowerCase().contains(filter)) {
                        if (start >= 0 && lenght > 0) {
                            if (filtered >= start && filtered < start + lenght) {
                                list.add(ac);
                            }
                        } else {
                            list.add(ac);
                        }
                        ++filtered;
                    }
                } else {
                    if (start >= 0 && lenght > 0) {
                        if (count >= start && count < start + lenght) {
                            list.add(ac);
                        }
                    } else {
                        list.add(ac);
                    }
                    ++filtered;
                }
                ++count;
            }
            LinkedHashMap<String, Serializable> all = new LinkedHashMap<String, Serializable>();
            all.put("size", Integer.valueOf(list.size()));
            all.put("draw", Integer.valueOf(draw));
            all.put("start", Integer.valueOf(start));
            all.put("length", Integer.valueOf(lenght));
            all.put("recordsTotal", Integer.valueOf(count));
            all.put("recordsFiltered", Integer.valueOf(filtered));
            all.put("agents", list);
            GsonBuilder gsonBuilder = this.getGsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(AgentCard.class, new AgentCardJson());
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson(all);
            this.sendJSONResponse(response, jsonString);
        }
        catch (Throwable e) {
            RTLogger.print(5, "", e);
        }
    }

    public void processGetAgent(HttpServletResponse response, String user, List<String> ids) {
        if (!this.canSeeAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        LinkedList<AgentCard> listAC = new LinkedList<AgentCard>();
        if (ids == null || ids.size() == 0) {
            throw new RuntimeException("Missed required parameter: 'id'");
        }
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
        for (String id : ids) {
            AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(id);
            if (ac == null || UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, ac.getAgentID(), nodeGroups)) continue;
            listAC.add(ac);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(AgentCard.class, new AgentCardWithInventoryJson());
        Gson gson = gsonBuilder.create();
        String jsonString = "";
        jsonString = listAC.size() == 1 ? gson.toJson(listAC.get(0)) : gson.toJson(listAC);
        this.sendJSONResponse(response, jsonString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendJSONResponse(HttpServletResponse response, String jsonString) {
        byte[] bytes = jsonString.getBytes();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setContentLength(bis.available());
            byte[] arr = new byte[4096];
            int count = -1;
            while ((count = bis.read(arr)) != -1) {
                response.getOutputStream().write(arr, 0, count);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void processGetActiveIndi4Agent(HttpServletResponse response, String username, List<EventFilter> filters, boolean shortAttrList, int start, int pageSize, int draw) {
        if (!this.canSeeIndications(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        JsonObject element = this.getActiveIndications(filters, username, shortAttrList, start, pageSize);
        element.addProperty("draw", draw);
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(element);
        this.sendJSONResponse(response, jsonString);
    }

    public JsonObject getActiveIndications(List<EventFilter> filters, String username, boolean shortAttrList, int start, int pageSize) {
        if (!this.canSeeIndications(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<SEventFwd> col = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(true);
        EventIterator it = null;
        if (username == null) {
            it = col.iterator();
        } else {
            Iterator<SEventFwd> itOrig = col.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), username);
            this.initServiceDashBoardEventFilter(filters, username);
        }
        return this.processIndicationsPaged(shortAttrList, start, pageSize, it, filters, true);
    }

    public void initServiceDashBoardEventFilter(List<EventFilter> filters, String username) {
        List<ServiceDashBoard> services = null;
        block0: for (EventFilter ef : filters) {
            if (ef.m_columnInt != 103) continue;
            if (services == null) {
                File file = MapAgentJSON.getServiceFile(username);
                ServiceDashboardFactory factory = new ServiceDashboardFactory();
                services = factory.loadLocalFile(file);
            }
            for (ServiceDashBoard s : services) {
                if (!ef.m_pattern.equals(s.getID())) continue;
                ef.m_serviceDashboard = s;
                continue block0;
            }
        }
    }

    private JsonObject processIndicationsPaged(boolean shortAttrList, int start, int pageSize, Iterator<SEventFwd> it, List<EventFilter> filters, boolean active) {
        JsonArray indis = new JsonArray();
        int totalIndications = 0;
        int filtered = 0;
        HashMap<Integer, Integer> sameTypeFilters = new HashMap<Integer, Integer>();
        for (EventFilter ef : filters) {
            Integer count = (Integer)sameTypeFilters.get(ef.m_columnInt);
            if (count == null) {
                sameTypeFilters.put(ef.m_columnInt, 1);
                continue;
            }
            sameTypeFilters.put(ef.m_columnInt, count + 1);
        }
        if (it != null) {
            int count = 0;
            while (it.hasNext()) {
                HashMap<Integer, Integer> sameTypeFiltersMatched = new HashMap<Integer, Integer>(sameTypeFilters);
                SEventFwd ie = it.next();
                if (active ? '-' != ie.getState() : '-' == ie.getState()) continue;
                ++totalIndications;
                if (filters != null && filters.size() > 0) {
                    boolean matched = true;
                    for (EventFilter ef : filters) {
                        if (ef.select(ie)) continue;
                        Integer notMatchedCount = (Integer)sameTypeFiltersMatched.get(ef.m_columnInt);
                        if (notMatchedCount <= 1) {
                            matched = false;
                            break;
                        }
                        sameTypeFiltersMatched.put(ef.m_columnInt, notMatchedCount - 1);
                    }
                    if (!matched) continue;
                }
                ++filtered;
                SEventShortJson sefshort = new SEventShortJson();
                if (!shortAttrList) {
                    sefshort = new SEventFwdJson();
                }
                JsonElement el = sefshort.serialize(ie, (Type)null, (JsonSerializationContext)null);
                if (start >= 0 && pageSize > 0) {
                    if (count >= start && count < start + pageSize) {
                        indis.add(el);
                    }
                } else {
                    indis.add(el);
                }
                ++count;
            }
        }
        JsonObject indisArrObj = new JsonObject();
        indisArrObj.addProperty("size", indis.size());
        indisArrObj.addProperty("start", start);
        indisArrObj.addProperty("lenght", pageSize);
        indisArrObj.addProperty("recordsTotal", totalIndications);
        indisArrObj.addProperty("recordsFiltered", filtered);
        indisArrObj.add("indis", indis);
        return indisArrObj;
    }

    public void processGetClosedIndi4Agent(HttpServletResponse response, String username, List<EventFilter> filters, boolean shortAttrList, int start, int pageSize, int draw) {
        if (!this.canSeeIndications(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        JsonObject element = this.getClosedIndications(filters, username, shortAttrList, start, pageSize);
        element.addProperty("draw", draw);
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(element);
        this.sendJSONResponse(response, jsonString);
    }

    public JsonObject getClosedIndications(List<EventFilter> filters, String username, boolean shortAttrList, int start, int pageSize) {
        if (!this.canSeeIndications(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<SEventFwd> indiActiveAndInsertedAsClosed = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false);
        List<SEventFwd> indiClosed = ServerEngine.getInstance().getEventsRouter().getEventOperations().getAcknowledgedIndications(false);
        Iterator<SEventFwd> itpre = indiActiveAndInsertedAsClosed.iterator();
        while (itpre.hasNext()) {
            SEventFwd sef = itpre.next();
            if ('-' != sef.getState()) continue;
            itpre.remove();
        }
        indiClosed.addAll(indiActiveAndInsertedAsClosed);
        Collections.sort(indiClosed, ServerEngine.getInstance().getEventsRouter().getEventOperations().m_DescComparator);
        EventIterator it = null;
        if (username == null) {
            it = indiClosed.iterator();
        } else {
            Iterator<SEventFwd> itOrig = indiClosed.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), username);
        }
        return this.processIndicationsPaged(shortAttrList, start, pageSize, it, filters, false);
    }

    public void processFullIndication(HttpServletResponse response, String user, List<String> ids) {
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (ids == null || ids.size() == 0) {
            throw new RuntimeException("Missed required parameter: 'id'");
        }
        ArrayList<SEventFwd> listOne = new ArrayList<SEventFwd>(ids.size());
        for (String id : ids) {
            SEventFwd sef = ServerEngine.getInstance().getEventsRouter().getEvent(id);
            if (sef == null) continue;
            listOne.add(sef);
        }
        ArrayList<SEventFwd> list = null;
        if (ServerEngine.getInstance().getForwardManager().isUserIndicationsFiltered(user)) {
            EventIterator ei = new EventIterator(listOne.iterator(), ServerEngine.getInstance().getForwardManager(), user);
            list = new ArrayList(ids.size());
            while (ei.hasNext()) {
                list.add(ei.next());
            }
        } else {
            list = listOne;
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(SEventFwd.class, new SEventFwdJson());
        Gson gson = gsonBuilder.create();
        String jsonString = "";
        jsonString = list.size() == 1 ? gson.toJson(list.get(0)) : gson.toJson(list);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetNodeGroupTree(HttpServletResponse response, String username) {
        if (!this.canSeeAgents(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(username);
        GroupTreeObjectMD5 md5g = new GroupTreeObjectMD5(nodeGroups);
        nodeGroups.setAttribute("MD5", md5g.getMD5());
        String jsonString = gson.toJson(nodeGroups);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetPolicyGroupTree(HttpServletResponse response, String username) {
        if (!this.canSeePolicies(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        GroupTreeObject policyTree = ServerEngine.getInstance().getPolicyRepository().getPolicyTree();
        GroupTreeObject permissions = UserManager.getInstance().getPolicyTreePermissions(username);
        policyTree.mergeAttributesFromTree(permissions);
        String jsonString = gson.toJson(policyTree);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetAsnGroupTree(HttpServletResponse response, String username) {
        if (!this.canSeeAssignments(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        GroupTreeObject asnTree = ServerEngine.getInstance().getAssignmentRepository().getAsnTree();
        GroupTreeObject permissions = UserManager.getInstance().getAsnTreePermissions(username);
        asnTree.mergeAttributesFromTree(permissions);
        String jsonString = gson.toJson(asnTree);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetBinGroupTree(HttpServletResponse response, String username) {
        if (!this.canSeePackages(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        GroupTreeObject binTree = ServerEngine.getInstance().getBinariesRepository().getTree();
        String jsonString = gson.toJson(binTree);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetActions(HttpServletResponse response, String username) {
        if (!this.canSeeActions(username)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        GroupTreeObject actionsTree = ServerEngine.getInstance().getActionRepository().getTree(username);
        String jsonString = gson.toJson(actionsTree);
        this.sendJSONResponse(response, jsonString);
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableInnerClassSerialization();
        gsonBuilder.setPrettyPrinting();
        return gsonBuilder;
    }

    public void processCloseIndications(HttpServletResponse response, String user, List<String> indiIDs) {
        if (!this.canOwnIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        ServerEngine.getInstance().getEventsRouter().acknowledge2(indiIDs, user);
        this.sendOK(response);
    }

    public void processArchiveIndications(HttpServletResponse response, String user, List<String> indiIDs) {
        if (!this.canOwnIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        ServerEngine.getInstance().getEventsRouter().archive2(indiIDs, false);
        this.sendOK(response);
    }

    public void sendOK(HttpServletResponse response) {
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonObject ok = new JsonObject();
        ok.addProperty("result", 0);
        this.sendJSONResponse(response, gson.toJson(ok));
    }

    public void processGetAnnotations(HttpServletResponse response, List<String> ids) {
        if (ids == null || ids.size() == 0) {
            throw new RuntimeException("Missed required parameter: 'id'");
        }
        LinkedHashMap res = new LinkedHashMap();
        for (String iid : ids) {
            List<String> annotations = ServerEngine.getInstance().getEventsRouter().getAnnotations(iid);
            LinkedList<Annotation> ant = new LinkedList<Annotation>();
            if (annotations != null) {
                for (String astr : annotations) {
                    try {
                        ant.add(Annotation.parseString(astr));
                    }
                    catch (Throwable throwable) {}
                }
            }
            res.put(iid, ant);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(Annotation.class, new AnnotationJson());
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(res);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetHelp(HttpServletResponse response, List<String> ids) {
        if (ids == null || ids.size() == 0) {
            throw new RuntimeException("Missed required parameter: 'id'");
        }
        LinkedHashMap<String, String> helps = new LinkedHashMap<String, String>();
        for (String id : ids) {
            String help = ServerEngine.getInstance().getPolicyRepository().getHelps().get(id);
            if (help == null) {
                help = "";
            }
            helps.put(id, help);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(helps);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetPerfClasses(HttpServletResponse response, String user) {
        if (!this.canSeePerf(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        HashMapArray<String, DDFField> hma = ServerEngine.getInstance().getDB().getPerfTables();
        ArrayList classes = new ArrayList(hma.keySet());
        Collections.sort(classes);
        LinkedHashMap<String, List<DDFField>> res = new LinkedHashMap<String, List<DDFField>>();
        for (String className : classes) {
            List<DDFField> fields = hma.getArray(className);
            res.put(className, fields);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(DDFField.class, new DDFFieldJson());
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(res);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetPerfClass(HttpServletResponse response, String user, String className) throws SQLException {
        if (!this.canSeePerf(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        PerfManager pm = new PerfManager();
        String jsonString = "Error getting data";
        LinkedList<String> numericFields = new LinkedList<String>();
        List<List<String>> res = pm.getDistinctKeyValues(className, numericFields);
        List<String> header = res.remove(0);
        int agentIDposition = -1;
        for (int i = 0; i < header.size(); ++i) {
            if (!"BOOMAGENTID".equalsIgnoreCase(header.get(i))) continue;
            agentIDposition = i;
            break;
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && agentIDposition != -1) {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            Iterator<List<String>> it = res.iterator();
            while (it.hasNext()) {
                String agentID = it.next().get(agentIDposition);
                if (agentID != null && UserManager.getInstance().isAgentVisible(user, agentID, nodeGroups)) continue;
                it.remove();
            }
        }
        if (agentIDposition != -1) {
            Iterator<List<String>> it = res.iterator();
            while (it.hasNext()) {
                String agentID = it.next().get(agentIDposition);
                if (agentID != null) {
                    AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
                    if (ac != null) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonObject he = new JsonObject();
        he.addProperty("class", className);
        boolean foundTime = numericFields.remove("_TIME");
        if (foundTime) {
            he.addProperty("time_field", "_TIME");
        }
        Collections.sort(numericFields);
        Collections.sort(res, new Comparator<List<String>>(this){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                String res1 = o1.get(0) + "," + o1.get(1);
                String res2 = o2.get(0) + "," + o2.get(1);
                return res1.compareToIgnoreCase(res2);
            }
        });
        he.add("metrics", gson.toJsonTree(numericFields));
        he.add("objects", gson.toJsonTree(header));
        he.add("objectvalues", gson.toJsonTree(res));
        jsonString = gson.toJson(he);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetPerfAgt(HttpServletResponse response, String user, String agentID) throws SQLException {
        if (!this.canSeePerf(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, agentID)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        PerfManager pm = new PerfManager();
        String jsonString = "Error getting data";
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonObject main = new JsonObject();
        main.addProperty("agentid", agentID);
        JsonArray tablesMetaData = new JsonArray();
        main.add("classes", tablesMetaData);
        Map<String, List<List<String>>> result = pm.getAgentKeyValues(agentID);
        for (Map.Entry<String, List<List<String>>> en : result.entrySet()) {
            String table = en.getKey();
            List<List<String>> res = en.getValue();
            List<String> header = res.remove(0);
            Collections.sort(res, new Comparator<List<String>>(this){

                @Override
                public int compare(List<String> o1, List<String> o2) {
                    SKey key1 = new SKey(o1.toArray(new String[0]));
                    SKey key2 = new SKey(o2.toArray(new String[0]));
                    return key1.compareTo(key2);
                }
            });
            JsonObject he = new JsonObject();
            he.addProperty("class", table);
            he.add("keys", gson.toJsonTree(header));
            he.add("values", gson.toJsonTree(res));
            tablesMetaData.add(he);
        }
        jsonString = gson.toJson(main);
        this.sendJSONResponse(response, jsonString);
    }

    /*
     * WARNING - void declaration
     */
    public void processGetPerfData(HttpServletResponse response, String user, String agentID, String className, String metric, Map<String, String> objects, Long from, Long to) throws SQLException {
        if (!this.canSeePerf(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, agentID)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<Map<String, Object>> res = this.getPerfData(className, user, metric, agentID, objects, from, to);
        JsonObject main = new JsonObject();
        main.addProperty("class", className);
        if (agentID != null) {
            main.addProperty("agentid", agentID);
        }
        main.addProperty("metric", metric);
        TreeMap<Object, Object> temp = new TreeMap<Object, Object>();
        if (res == null || res.size() == 0) {
            JsonObject obj = new JsonObject();
            for (Map.Entry<String, String> en : objects.entrySet()) {
                obj.addProperty(en.getKey(), en.getValue());
            }
            obj.add("times", new JsonArray());
            obj.add("values", new JsonArray());
            temp.put("", obj);
        } else {
            for (Map map : res) {
                JsonArray valArr;
                void var16_19;
                JsonArray timeArr;
                StringBuilder keys = new StringBuilder();
                for (String string : objects.keySet()) {
                    keys.append(map.get(string));
                }
                String key = keys.toString();
                JsonObject jsonObject = (JsonObject)temp.get(key);
                if (jsonObject == null) {
                    JsonObject jsonObject2 = new JsonObject();
                    Iterator<Map.Entry<String, String>> iterator = objects.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object objValue;
                        Map.Entry<String, String> en;
                        jsonObject2.addProperty(en.getKey(), (objValue = map.get((en = iterator.next()).getKey())) == null ? null : objValue.toString());
                    }
                    temp.put(key, jsonObject2);
                }
                if ((timeArr = (JsonArray)var16_19.get("times")) == null) {
                    timeArr = new JsonArray();
                    var16_19.add("times", timeArr);
                }
                if ((valArr = (JsonArray)var16_19.get("values")) == null) {
                    valArr = new JsonArray();
                    var16_19.add("values", valArr);
                }
                try {
                    timeArr.add(new JsonPrimitive((Number)map.get("_TIME")));
                    if (map.get(metric) == null) {
                        valArr.add(JsonNull.INSTANCE);
                        continue;
                    }
                    valArr.add(new JsonPrimitive((Number)map.get(metric)));
                }
                catch (Throwable throwable) {}
            }
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonArray vec = new JsonArray();
        if (temp.size() == 1 && temp.get("") != null) {
            vec.add((JsonElement)temp.get(""));
        } else {
            for (Map.Entry entry : temp.entrySet()) {
                vec.add((JsonElement)entry.getValue());
            }
        }
        main.add("data", vec);
        String jsonString = gson.toJson(main);
        this.sendJSONResponse(response, jsonString);
    }

    public List<Map<String, Object>> getPerfData(String className, String user, String metric, String agentID, Map<String, String> objects, Long from, Long to) throws SQLException {
        if (!this.canSeePerf(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, agentID)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        StringBuilder sbq = new StringBuilder();
        sbq.append("SELECT `").append(metric).append("`, `").append("_TIME").append("` ");
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, String> en : objects.entrySet()) {
            sbq.append(", ").append('`').append(en.getKey()).append('`');
            if (en.getValue() == null) continue;
            where.append(" AND ").append('`').append(en.getKey()).append('`').append("='").append(en.getValue()).append('\'');
        }
        sbq.append(" FROM `").append(className).append("` ");
        sbq.append(" WHERE 1=1 ");
        if (agentID != null) {
            sbq.append(" AND `").append("BOOMAGENTID").append("`='").append(agentID).append('\'');
        }
        if (from != null) {
            sbq.append(" AND `").append("_TIME").append("`>").append(from);
        }
        if (to != null) {
            sbq.append(" AND `").append("_TIME").append("`<=").append(to);
        }
        sbq.append((CharSequence)where);
        sbq.append(" ORDER BY `_TIME`");
        String sql = sbq.toString();
        DB db = ServerEngine.getInstance().getDB();
        if (db.m_isOraclePERF) {
            sql = sql.replace('`', '\"');
        }
        List<Map<String, Object>> res = db.queryPerf2(sql);
        return res;
    }

    public void processGetMonitorHistory(HttpServletResponse response, String user, String agentID, String monname, String object) {
        SEventFwd sef;
        String id;
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, agentID)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        TreeMap<Long, Double> values = new TreeMap<Long, Double>();
        EventOperations eo = ServerEngine.getInstance().getEventsRouter().getEventOperations();
        Enumeration<String> active = eo.getActiveIndicationsEnum();
        while (active.hasMoreElements()) {
            id = active.nextElement();
            sef = eo.getEvent(id);
            if (sef == null || !monname.equalsIgnoreCase(sef.getMonitor()) || !agentID.equals(sef.getT1()) || !object.equals(sef.getObject())) continue;
            values.put(sef.getFirstTime(), sef.getValue());
            if (sef.getTFA() > 0L) {
                values.put(sef.getTFA(), sef.getVFA());
            }
            if (sef.getDuplicates() <= 0) continue;
            values.put(sef.getSTime(), sef.getValue());
        }
        active = eo.getClosedIndicationsEnum();
        while (active.hasMoreElements()) {
            id = active.nextElement();
            sef = eo.getEvent(id);
            if (sef == null || !monname.equalsIgnoreCase(sef.getMonitor()) || !agentID.equals(sef.getT1()) || !object.equals(sef.getObject())) continue;
            values.put(sef.getFirstTime(), sef.getValue());
            if (sef.getTFA() > 0L) {
                values.put(sef.getTFA(), sef.getVFA());
            }
            if (sef.getDuplicates() <= 0) continue;
            values.put(sef.getSTime(), sef.getValue());
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("agentid", agentID);
        obj.addProperty("monitor", monname);
        obj.addProperty("object", object);
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonArray timeArr = new JsonArray();
        JsonArray valArr = new JsonArray();
        for (Map.Entry en1 : values.entrySet()) {
            timeArr.add(new JsonPrimitive((Number)en1.getKey()));
            valArr.add(new JsonPrimitive((Number)en1.getValue()));
        }
        obj.add("times", timeArr);
        obj.add("values", valArr);
        String jsonString = gson.toJson(obj);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetMonitorHistory(HttpServletResponse response, String user, List<String> agentIDs) {
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            Iterator<String> it = agentIDs.iterator();
            while (it.hasNext()) {
                if (UserManager.getInstance().isAgentVisible(user, it.next(), nodeGroups)) continue;
                it.remove();
            }
        }
        TreeMap collection = new TreeMap(new Comparator<GroupTreeObject>(this){

            @Override
            public int compare(GroupTreeObject o1, GroupTreeObject o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        GroupTreeObject root = new GroupTreeObject(new TreeObject("monitors", "", null));
        EventOperations eo = ServerEngine.getInstance().getEventsRouter().getEventOperations();
        Enumeration<String> active = eo.getActiveIndicationsEnum();
        while (active.hasMoreElements()) {
            GroupTreeObject obj;
            GroupTreeObject mon;
            String id = active.nextElement();
            SEventFwd sef = eo.getEvent(id);
            if (sef == null || sef.getMonitor() == null || sef.getMonitor().length() <= 0 || sef.getT1() == null || sef.getT1().length() <= 0) continue;
            GroupTreeObject agt = root.getChild(sef.getT1(), "agt");
            if (agt == null) {
                agt = new GroupTreeObject(new TreeObject(sef.getT1(), "agt", null));
                root.addElement(agt);
            }
            if ((mon = agt.getChild(sef.getMonitor(), "mon")) == null) {
                mon = new GroupTreeObject(new TreeObject(sef.getMonitor(), "mon", null));
                agt.addElement(mon);
            }
            if ((obj = mon.getChild(sef.getObject(), "obj")) == null) {
                obj = new GroupTreeObject(new TreeObject(sef.getObject(), "obj", null));
                mon.addElement(obj);
                collection.put(obj, null);
            }
            GroupTreeObject v1 = new GroupTreeObject(new TreeObject("" + sef.getFirstTime(), "val", sef.getValue()));
            try {
                obj.addElement(v1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sef.getTFA() > 0L) {
                GroupTreeObject v2 = new GroupTreeObject(new TreeObject("" + sef.getTFA(), "val", sef.getVFA()));
                try {
                    obj.addElement(v2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (sef.getDuplicates() <= 0) continue;
            GroupTreeObject v3 = new GroupTreeObject(new TreeObject("" + sef.getSTime(), "val", sef.getValue()));
            try {
                obj.addElement(v3);
            }
            catch (Throwable throwable) {}
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(GroupTreeObject.class, new GroupTreeObjectJson());
        Gson gson = gsonBuilder.create();
        JsonArray agents = new JsonArray();
        for (GroupTreeObject obj : collection.keySet()) {
            GroupTreeObject mon = obj.getParent();
            GroupTreeObject agt = mon.getParent();
            JsonObject metric = new JsonObject();
            metric.addProperty("agentid", agt.getName());
            metric.addProperty("monitor", mon.getName());
            metric.addProperty("object", obj.getName());
            TreeMap<Long, Double> values = new TreeMap<Long, Double>();
            for (GroupTreeObject vg : obj.getElements()) {
                values.put(Long.valueOf(vg.getName()), (Double)vg.getTreeObject().getObject());
            }
            JsonArray timeArr = new JsonArray();
            JsonArray valArr = new JsonArray();
            for (Map.Entry en1 : values.entrySet()) {
                timeArr.add(new JsonPrimitive((Number)en1.getKey()));
                valArr.add(new JsonPrimitive((Number)en1.getValue()));
            }
            metric.add("times", timeArr);
            metric.add("values", valArr);
            agents.add(metric);
        }
        String jsonString = gson.toJson(agents);
        this.sendJSONResponse(response, jsonString);
    }

    public void getHeatMapAppGrp(HttpServletResponse response, String user) {
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<SEventFwd> col = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false);
        EventIterator it = null;
        if (user == null) {
            it = col.iterator();
        } else {
            Iterator<SEventFwd> itOrig = col.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
        }
        TreeMap<SKey, OnDemandSummary> map = new TreeMap<SKey, OnDemandSummary>();
        if (it != null) {
            while (it.hasNext()) {
                SEventFwd ie = (SEventFwd)it.next();
                if ('-' != ie.getState()) continue;
                SKey key = new SKey(ie.getApplication(), ie.getGroup());
                OnDemandSummary ods = (OnDemandSummary)map.get(key);
                if (ods == null) {
                    ods = new OnDemandSummary();
                    map.put(key, ods);
                }
                ods.addActiveEvent(ie);
            }
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonArray summary = new JsonArray();
        for (Map.Entry en : map.entrySet()) {
            JsonObject metric = new JsonObject();
            metric.addProperty("app", ((SKey)en.getKey()).getKeys().get(0));
            metric.addProperty("grp", ((SKey)en.getKey()).getKeys().get(1));
            OnDemandSummary ods = (OnDemandSummary)en.getValue();
            this.ods2Json(metric, ods);
            summary.add(metric);
        }
        String jsonString = gson.toJson(summary);
        this.sendJSONResponse(response, jsonString);
    }

    public void getHeatMapHostGrp(HttpServletResponse response, String user) {
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<SEventFwd> col = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false);
        EventIterator it = null;
        if (user == null) {
            it = col.iterator();
        } else {
            Iterator<SEventFwd> itOrig = col.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
        }
        TreeMap<SKey, OnDemandSummary> map = new TreeMap<SKey, OnDemandSummary>();
        if (it != null) {
            while (it.hasNext()) {
                SEventFwd ie = (SEventFwd)it.next();
                if ('-' != ie.getState()) continue;
                SKey key = new SKey(ie.getGroup(), ie.getNode());
                OnDemandSummary ods = (OnDemandSummary)map.get(key);
                if (ods == null) {
                    ods = new OnDemandSummary();
                    map.put(key, ods);
                }
                ods.addActiveEvent(ie);
            }
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonArray summary = new JsonArray();
        for (Map.Entry en : map.entrySet()) {
            JsonObject metric = new JsonObject();
            metric.addProperty("host", ((SKey)en.getKey()).getKeys().get(1));
            metric.addProperty("grp", ((SKey)en.getKey()).getKeys().get(0));
            OnDemandSummary ods = (OnDemandSummary)en.getValue();
            this.ods2Json(metric, ods);
            summary.add(metric);
        }
        String jsonString = gson.toJson(summary);
        this.sendJSONResponse(response, jsonString);
    }

    public void getHeatMapHostApp(HttpServletResponse response, String user) {
        if (!this.canSeeIndications(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        List<SEventFwd> col = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false);
        EventIterator it = null;
        if (user == null) {
            it = col.iterator();
        } else {
            Iterator<SEventFwd> itOrig = col.iterator();
            it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
        }
        TreeMap<SKey, OnDemandSummary> map = new TreeMap<SKey, OnDemandSummary>();
        if (it != null) {
            while (it.hasNext()) {
                SEventFwd ie = (SEventFwd)it.next();
                if ('-' != ie.getState()) continue;
                SKey key = new SKey(ie.getApplication(), ie.getNode());
                OnDemandSummary ods = (OnDemandSummary)map.get(key);
                if (ods == null) {
                    ods = new OnDemandSummary();
                    map.put(key, ods);
                }
                ods.addActiveEvent(ie);
            }
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonArray summary = new JsonArray();
        for (Map.Entry en : map.entrySet()) {
            JsonObject metric = new JsonObject();
            metric.addProperty("host", ((SKey)en.getKey()).getKeys().get(1));
            metric.addProperty("app", ((SKey)en.getKey()).getKeys().get(0));
            OnDemandSummary ods = (OnDemandSummary)en.getValue();
            this.ods2Json(metric, ods);
            summary.add(metric);
        }
        String jsonString = gson.toJson(summary);
        this.sendJSONResponse(response, jsonString);
    }

    private void ods2Json(JsonObject metric, OnDemandSummary ods) {
        metric.addProperty("indi_total", ods.getNumberOfMessagesTotal());
        metric.addProperty("indi_av", ods.getNumberOfMessagesAV());
        metric.addProperty("indi_kpi", ods.getNumberOfMessagesKPI());
        metric.addProperty("indi_other", ods.getNumberOfMessagesOther());
        metric.addProperty("sev_max", ods.getMaximumTotal());
        metric.addProperty("sev_max_av", ods.getMaximumAV());
        metric.addProperty("sev_max_kpi", ods.getMaximumKPI());
        metric.addProperty("sev_max_other", ods.getMaximumOther());
        metric.addProperty("cri_cnt", ods.getCount(5));
        metric.addProperty("cri_av_cnt", ods.getCount(5, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("cri_kpi_cnt", ods.getCount(5, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("cri_other_cnt", ods.getCount(5, AbstractEventSummary.TYPE.OTHER));
        metric.addProperty("maj_cnt", ods.getCount(4));
        metric.addProperty("maj_av_cnt", ods.getCount(4, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("maj_kpi_cnt", ods.getCount(4, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("maj_other_cnt", ods.getCount(4, AbstractEventSummary.TYPE.OTHER));
        metric.addProperty("min_cnt", ods.getCount(3));
        metric.addProperty("min_av_cnt", ods.getCount(3, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("min_kpi_cnt", ods.getCount(3, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("min_other_cnt", ods.getCount(3, AbstractEventSummary.TYPE.OTHER));
        metric.addProperty("war_cnt", ods.getCount(2));
        metric.addProperty("war_av_cnt", ods.getCount(2, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("war_kpi_cnt", ods.getCount(2, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("war_other_cnt", ods.getCount(2, AbstractEventSummary.TYPE.OTHER));
        metric.addProperty("nor_cnt", ods.getCount(1));
        metric.addProperty("nor_av_cnt", ods.getCount(1, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("nor_kpi_cnt", ods.getCount(1, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("nor_other_cnt", ods.getCount(1, AbstractEventSummary.TYPE.OTHER));
        metric.addProperty("unk_cnt", ods.getCount(0));
        metric.addProperty("unk_av_cnt", ods.getCount(0, AbstractEventSummary.TYPE.AVAILABILITY));
        metric.addProperty("unk_kpi_cnt", ods.getCount(0, AbstractEventSummary.TYPE.KPI));
        metric.addProperty("unk_other_cnt", ods.getCount(0, AbstractEventSummary.TYPE.OTHER));
    }

    public List<ServiceDashBoard> processServiceDashboard1(HttpServletResponse response, String user, List<ServiceDashBoard> services) {
        File file = MapAgentJSON.getServiceFile(user);
        if (services == null) {
            ServiceDashboardFactory factory = new ServiceDashboardFactory();
            services = factory.loadLocalFile(file);
            Iterator<SEventFwd> itOrig = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
            EventIterator it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
            LinkedList<SEventFwd> active = new LinkedList<SEventFwd>();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                active.add(sef);
            }
            for (ServiceDashBoard ssd : services) {
                ssd.processActiveOrClosed(active);
            }
        } else {
            Iterator<SEventFwd> itOrig = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator();
            EventIterator it = new EventIterator(itOrig, ServerEngine.getInstance().getForwardManager(), user);
            LinkedList<SEventFwd> active = new LinkedList<SEventFwd>();
            while (it.hasNext()) {
                SEventFwd sef = it.next();
                active.add(sef);
            }
            for (ServiceDashBoard ssd : services) {
                ssd.processActiveOrClosed(active);
                ssd.removeAllClosed();
            }
        }
        Collections.sort(services);
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(ServiceDashBoard.class, new ServiceDashBoardJson());
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(services);
        this.sendJSONResponse(response, jsonString);
        return services;
    }

    public static File getServiceFile(String user) {
        File ssdFile_user;
        File file = new File("srv/services/" + ServiceDashboardFactory.GLOBAL_SSDFILE);
        UserRole role = UserManager.getInstance().getRoleForUser(user);
        if (role != null && (ssdFile_user = new File("srv/services/" + role.getID() + "/" + ServiceDashboardFactory.GLOBAL_SSDFILE)).exists() && ssdFile_user.canRead()) {
            file = ssdFile_user;
        }
        return file;
    }

    public void processStats(HttpServletResponse response, String user) {
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        LinkedHashMap<String, CallSite> data = new LinkedHashMap<String, CallSite>();
        ServerEngine se = ServerEngine.getInstance();
        EventOperations eo = se.getEventsRouter().getEventOperations();
        Iterator<SEventFwd> it = eo.getActiveAndInsertedAsClosedIterator();
        EventIterator ei = new EventIterator(it, se.getForwardManager(), user);
        EventsAndStatus eas = new EventsAndStatus();
        while (ei.hasNext()) {
            SEventFwd sef = ei.next();
            if ('-' != sef.getState()) continue;
            eas.add(sef);
        }
        data.put("indi", (CallSite)((Object)("" + eas.getCountAll(false, true))));
        data.put("indi_cri", (CallSite)((Object)("" + (eas.getCount(5, true, true, true) + eas.getCount(-1, true, true, true)))));
        data.put("indi_maj", (CallSite)((Object)("" + (eas.getCount(4, true, true, true) + eas.getCount(-2, true, true, true)))));
        data.put("indi_min", (CallSite)((Object)("" + (eas.getCount(3, true, true, true) + eas.getCount(-3, true, true, true)))));
        data.put("indi_war", (CallSite)((Object)("" + (eas.getCount(2, true, true, true) + eas.getCount(-4, true, true, true)))));
        data.put("indi_nor", (CallSite)((Object)("" + (eas.getCount(1, true, true, true) + eas.getCount(-5, true, true, true)))));
        int totalAC = 0;
        int onlineAC = 0;
        int notApprovedAC = 0;
        int totalACE = 0;
        int onlineACE = 0;
        int notApprovedACE = 0;
        List<AgentCard> agents = se.getAgentRepository().getAgentCards(user);
        for (AgentCard ac : agents) {
            if (ac.getAgentPort() == 0) {
                ++totalACE;
                if (ac.isApproved()) {
                    if (!ac.isOnline()) continue;
                    ++onlineACE;
                    continue;
                }
                ++notApprovedACE;
                continue;
            }
            ++totalAC;
            if (ac.isApproved()) {
                if (!ac.isOnline()) continue;
                ++onlineAC;
                continue;
            }
            ++notApprovedAC;
        }
        data.put("agt", (CallSite)((Object)("" + totalAC)));
        data.put("agt_online", (CallSite)((Object)("" + onlineAC)));
        data.put("agt_offline", (CallSite)((Object)("" + (totalAC - notApprovedAC - onlineAC))));
        data.put("agt_notapproved", (CallSite)((Object)("" + notApprovedAC)));
        data.put("agt_v", (CallSite)((Object)("" + totalACE)));
        data.put("agt_v_online", (CallSite)((Object)("" + onlineACE)));
        data.put("agt_v_offline", (CallSite)((Object)("" + (totalACE - notApprovedACE - onlineACE))));
        data.put("agt_v_notapproved", (CallSite)((Object)("" + notApprovedACE)));
        ServiceDashboardFactory factory = new ServiceDashboardFactory();
        List<ServiceDashBoard> services = factory.loadLocalFile(MapAgentJSON.getServiceFile(user));
        data.put("services", (CallSite)((Object)("" + services.size())));
        int perfTablesCount = se.getDB().getPerfTableNames().size();
        data.put("perfclasses", (CallSite)((Object)("" + perfTablesCount)));
        String jsonString = gson.toJson(data);
        this.sendJSONResponse(response, jsonString);
    }

    public void processTopAgents(HttpServletResponse response, String user, int top) {
        if (!this.canSeeAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        try {
            List<SEventFwd> list = ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveOnlyIndicationsUnsorted(user);
            LinkedList<String> ids = null;
            if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
                List<AgentCard> listA = ServerEngine.getInstance().getAgentRepository().getAgentCards(user);
                ids = new LinkedList<String>();
                for (AgentCard ac : listA) {
                    ids.add(ac.getAgentID());
                }
            }
            Statistics st = new Statistics(ServerEngine.getInstance().getAgentRepository(), ServerEngine.getInstance().getPolicyRepository(), list.iterator(), ids);
            JsonArray array = st.topAgentsToJsonArray(top);
            GsonBuilder gsonBuilder = this.getGsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson(array);
            this.sendJSONResponse(response, jsonString);
        }
        catch (Throwable e) {
            RTLogger.print(4, "", e);
        }
    }

    public void processGetAssigned(HttpServletResponse response, String user, List<String> ids) {
        if (!this.canSeeAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        if (ids == null || ids.size() == 0) {
            List<AgentCard> cards = ServerEngine.getInstance().getAgentRepository().getAgentCards(user);
            ids = new ArrayList<String>(cards.size());
            for (AgentCard agentCard : cards) {
                if (agentCard.getAgentPort() == 0) continue;
                ids.add(agentCard.getAgentID());
            }
        } else {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            Iterator<String> it = ids.iterator();
            while (it.hasNext()) {
                if (UserManager.getInstance().isAgentVisible(user, it.next(), nodeGroups)) continue;
                it.remove();
            }
        }
        Collections.sort(ids);
        JsonArray arrayAllAsns = new JsonArray();
        ConcurrentHashMapMap<String, Assignment> slaves = new ConcurrentHashMapMap<String, Assignment>();
        ServerEngine.getInstance().getAssignmentRepository().getAllAssignments_AlsoSlaves(user, slaves);
        for (String id : ids) {
            Map<Assignment, Object> map = null;
            map = slaves.containsKey(id) ? slaves.getHashMap(id) : ServerEngine.getInstance().getAssignmentRepository().getAssignments(id);
            ArrayList<Assignment> agentAssignments = new ArrayList<Assignment>(map.keySet());
            Collections.sort(agentAssignments, new Comparator<Assignment>(this){
                int res = 0;

                @Override
                public int compare(Assignment o1, Assignment o2) {
                    if (o1 != null && o2 != null) {
                        this.res = o1.getAgentID().compareTo(o2.getAgentID());
                        if (this.res == 0) {
                            this.res = o1.getName().compareToIgnoreCase(o2.getName());
                            if (this.res == 0) {
                                this.res = o1.getType().compareToIgnoreCase(o2.getType());
                            }
                        }
                    }
                    return this.res;
                }
            });
            JsonObject agent = new JsonObject();
            agent.addProperty("agentid", id);
            AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(id);
            if (ac != null) {
                agent.addProperty("label", ac.getLabel());
            }
            JsonArray asns = new JsonArray();
            for (Assignment a : agentAssignments) {
                asns.add(new AssignmentJson().serialize(a, (Type)null, (JsonSerializationContext)null));
            }
            agent.add("assigned", asns);
            arrayAllAsns.add(agent);
        }
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(arrayAllAsns);
        this.sendJSONResponse(response, jsonString);
    }

    public void processGetPolicies(HttpServletResponse response, String user, List<String> policyNames) {
        if (!this.canSeePolicies(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        ArrayList<AbstractPolicy> policies = null;
        if (policyNames != null && policyNames.size() > 0) {
            policies = new ArrayList(policyNames.size());
            for (String name : policyNames) {
                AbstractPolicy ap = ServerEngine.getInstance().getPolicyRepository().getMonitorPolicy(name);
                if (ap != null) {
                    policies.add(ap);
                    continue;
                }
                ap = ServerEngine.getInstance().getPolicyRepository().getMessagePolicy(name);
                if (ap == null) continue;
                policies.add(ap);
            }
        } else {
            policies = new ArrayList<AbstractPolicy>();
            policies.addAll(ServerEngine.getInstance().getPolicyRepository().getAllPolicyMap().values());
        }
        Iterator it = policies.iterator();
        while (it.hasNext()) {
            AbstractPolicy ap = (AbstractPolicy)it.next();
            if (UserManager.getInstance().checkPolicy(user, PGEntityAction.READ, ap.getName(), ap instanceof Policy ? "mon" : "msg")) continue;
            it.remove();
        }
        Collections.sort(policies, new Comparator<AbstractPolicy>(this){

            @Override
            public int compare(AbstractPolicy o1, AbstractPolicy o2) {
                if (o1 != null && o2 != null) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return 0;
            }
        });
        GsonBuilder gsonBuilder = this.getGsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(Policy.class, new PolicyJson());
        gsonBuilder.registerTypeHierarchyAdapter(Condition.class, new ConditionJson());
        gsonBuilder.registerTypeHierarchyAdapter(MsgPolicy.class, new MsgPolicyJson());
        gsonBuilder.registerTypeHierarchyAdapter(MsgCondition.class, new MsgConditionJson());
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(policies);
        this.sendJSONResponse(response, jsonString);
    }

    /*
     * Unable to fully structure code
     */
    public void processGetRunningDeployments(HttpServletResponse response, String user) {
        array = DeploymentManager.getInstance().getListJsonArray(user);
        clients = new ArrayList<ScGetJson>(ServerEngine.getInstance().getSlaves().size());
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            if (ssc == null || ssc.getSlaveServerClient() == null || !ssc.getSlaveServerClient().isOnline() || ssc.getScenario() >= 3) continue;
            clients.add(ssc.getRunningDeployments());
        }
        while (clients.size() > 0) {
            it = clients.iterator();
            while (it.hasNext()) {
                sc = (ScGetJson)it.next();
                if (sc.isFinished()) {
                    if (sc.isSuccess()) {
                        try {
                            jsonString = (String)sc.getResultObject();
                            el = new JsonParser().parse(jsonString);
                            if (!(el instanceof JsonArray)) ** GOTO lbl31
                            jsonArr = (JsonArray)el;
                            for (i = 0; i < jsonArr.size(); ++i) {
                                ds = new DeploymentStatus();
                                asJsonObject = jsonArr.get(i).getAsJsonObject();
                                ds.initFromJson(asJsonObject);
                                if (!UserManager.getInstance().isAgentVisible(user, ds.getAcid())) continue;
                                array.add(asJsonObject);
                            }
                        }
                        catch (Throwable e) {
                            RTLogger.print(4, "", e);
                        }
                    } else {
                        RTLogger.print(3, "SC:" + sc.getServerAuth().getHostName() + " - error getting deployment statuses: " + String.valueOf(sc.getResultObject()));
                    }
lbl31:
                    // 4 sources

                    it.remove();
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable e) {}
            }
        }
        gsonBuilder = new GsonBuilder();
        gsonBuilder.disableInnerClassSerialization();
        gsonBuilder.setPrettyPrinting();
        gson = gsonBuilder.create();
        jsonString = gson.toJson(array);
        this.sendJSONResponse(response, jsonString);
    }

    public void processCancelRunningDeployments(HttpServletResponse response, String user, List<String> ids) {
        Iterator<SlaveServerCard> itss = ServerEngine.getInstance().getSlaves().iterator();
        while (itss.hasNext()) {
            ConcurrentHashMapMap<String, String> idsToSend = new ConcurrentHashMapMap<String, String>();
            for (String value : ids) {
                idsToSend.putV("id", value);
            }
            SlaveServerCard ssc = itss.next();
            if (ssc == null || ssc.getSlaveServerClient() == null || !ssc.getSlaveServerClient().isOnline() || ssc.getScenario() >= 3) continue;
            ScGetJson sc = new ScGetJson(ssc, "/json/canceldc", idsToSend);
            sc.start();
        }
        DeploymentManager.getInstance().cancelDeployClient(user, ids);
        this.sendJSONResponse(response, "OK");
    }

    public void processCancelAllRunningDeployments(HttpServletResponse response, String user) {
        if (this.canOwnAssignments(user) && this.canOwnAgents(user)) {
            for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
                if (ssc == null || ssc.getSlaveServerClient() == null || !ssc.getSlaveServerClient().isOnline() || ssc.getScenario() >= 3) continue;
                ScGetJson sc = new ScGetJson(ssc, "/json/canceldcall", null);
                sc.start();
            }
            DeploymentManager.getInstance().cancelAll(user);
            this.sendJSONResponse(response, "OK");
        } else {
            this.sendJSONResponse(response, ACCESS_DENIED);
        }
    }

    public void processForgetFinishedDeployments(HttpServletResponse response, String user) {
        if (this.canOwnAssignments(user) && this.canOwnAgents(user)) {
            for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
                if (ssc == null || ssc.getSlaveServerClient() == null || !ssc.getSlaveServerClient().isOnline() || ssc.getScenario() >= 3) continue;
                ScGetJson sc = new ScGetJson(ssc, "/json/forgetfinisheddc", null);
                sc.start();
            }
            DeploymentManager.getInstance().forgetFinished();
            this.sendJSONResponse(response, "OK");
        } else {
            this.sendJSONResponse(response, ACCESS_DENIED);
        }
    }

    public void getAgentAttribute(HttpServletResponse response, String id, String name, String user) {
        if (!this.canSeeAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>(1);
        if (id == null) {
            value.put("error", "Missing required parameter: id");
        } else if (ServerEngine.getInstance().getAgentRepository().getAgentCardByID(id) == null) {
            value.put("error", "Unknown agent id: " + id);
        } else if (UserManager.getInstance().isAgentVisible(user, id)) {
            String attribute = name;
            if (attribute != null) {
                try {
                    for (Map.Entry<String, String> en : ServerEngine.getInstance().getAgentRepository().getAgentCardCMLabels().entrySet()) {
                        if (!name.equalsIgnoreCase(en.getValue())) continue;
                        attribute = en.getKey();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (AgentCardCM.isKnownAttribute(attribute)) {
                    acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(id);
                    if (acm != null) {
                        Object valueObj = acm.getValue(attribute);
                        value.put(name, valueObj);
                    } else {
                        value.put(name, null);
                    }
                } else {
                    value.put("error", "Unsupported attribute name: " + attribute);
                }
            } else {
                acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(id);
                if (acm != null) {
                    for (Map.Entry<String, Object> en : acm.getAttributes().entrySet()) {
                        String resolvedAttrName = ServerEngine.getInstance().getAgentRepository().getAgentCardCMLabels().get(en.getKey());
                        if (resolvedAttrName == null) {
                            resolvedAttrName = en.getKey();
                        }
                        value.put(resolvedAttrName, en.getValue());
                    }
                }
            }
        } else {
            value.put("error", "Agent is not visible");
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableInnerClassSerialization();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(value);
        this.sendJSONResponse(response, jsonString);
    }

    public void setAgentAttribute(HttpServletResponse response, String id, String name, String value, String user) {
        if (!this.canOwnAgents(user)) {
            throw new RuntimeException(ACCESS_DENIED);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(1);
        if (id == null || name == null) {
            result.put("error", "Invalid parameters");
        } else if (ServerEngine.getInstance().getAgentRepository().getAgentCardByID(id) == null) {
            result.put("error", "Unknown agent id: " + id);
        } else if (UserManager.getInstance().isAgentVisible(user, id)) {
            String attribute = name;
            try {
                for (Map.Entry<String, String> en : ServerEngine.getInstance().getAgentRepository().getAgentCardCMLabels().entrySet()) {
                    if (!name.equalsIgnoreCase(en.getValue())) continue;
                    attribute = en.getKey();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (AgentCardCM.isKnownAttribute(attribute)) {
                AgentCardCM acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(id);
                if (acm != null) {
                    try {
                        if (value != null) {
                            acm.add(attribute, value);
                        } else {
                            acm.remove(attribute);
                        }
                        ServerEngine.getInstance().getAgentRepository().saveAgentCardCM(acm);
                        Object valueObj = acm.getValue(attribute);
                        result.put(name, valueObj);
                    }
                    catch (Exception e) {
                        result.put("error", e.getMessage());
                    }
                } else {
                    result.put("error", "Error setting attributes for agent id: " + id);
                }
            } else {
                result.put("error", "Unsupported attribute name: " + attribute);
            }
        } else {
            result.put("error", "Agent is not visible");
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableInnerClassSerialization();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(result);
        this.sendJSONResponse(response, jsonString);
    }

    public void getOK(HttpServletResponse response) {
        this.sendJSONResponse(response, "{}");
    }

    private boolean canSeeIndications(String username) {
        return UserManager.getInstance().getRights(1000, username) > 1;
    }

    private boolean canOwnIndications(String username) {
        return UserManager.getInstance().getRights(1000, username) > 2;
    }

    private boolean canSeeAgents(String username) {
        return UserManager.getInstance().getRights(1002, username) > 1;
    }

    private boolean canOwnAgents(String username) {
        return UserManager.getInstance().getRights(1002, username) > 2;
    }

    private boolean canSeePolicies(String username) {
        return UserManager.getInstance().getRights(1001, username) > 1;
    }

    private boolean canSeeAssignments(String username) {
        return UserManager.getInstance().getRights(1008, username) > 1;
    }

    private boolean canSeePackages(String username) {
        return UserManager.getInstance().getRights(1006, username) > 1;
    }

    private boolean canSeeActions(String username) {
        return UserManager.getInstance().getRights(1007, username) > 1;
    }

    private boolean canSeePerf(String username) {
        return UserManager.getInstance().getRights(1003, username) > 1;
    }

    private boolean canOwnAssignments(String username) {
        return UserManager.getInstance().getRights(1008, username) > 2;
    }
}

