/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.GUIWorker;
import com.blixx.server.ServerEngine;
import com.blixx.server.jetty.AgentCommunicationHandler;
import com.blixx.server.jetty.DirectHandler;
import com.blixx.server.jetty.GrafanaJson;
import com.blixx.server.jetty.MapAgentJSON;
import com.blixx.server.jetty.UserPrincipal;
import com.blixx.server.perf.NanoHTTPD;
import com.blixx.server.perf.Response;
import com.blixx.server.services.EventFilter;
import com.blixx.shared.BM;
import com.blixx.shared.utils.Statistics;
import com.blixx.shared.utils.StrUtils;
import com.google.gson.JsonArray;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class OldNanoHandler
extends HandlerWrapper {
    ResourceHandler resource_handler = new ResourceHandler();

    public OldNanoHandler() {
        this.resource_handler.setDirectoriesListed(false);
        this.resource_handler.setResourceBase("srv/html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        try {
            Enumeration<String> headerNamesEnum = request.getHeaderNames();
            while (headerNamesEnum.hasMoreElements()) {
                String headerName = headerNamesEnum.nextElement();
                if (!headerName.startsWith("Access-Control")) continue;
                response.addHeader(headerName, request.getHeader(headerName));
            }
        }
        catch (Throwable headerNamesEnum) {
            // empty catch block
        }
        baseRequest.setHandled(true);
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, api_key, Authorization,X-Custom-Header");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        response.setHeader("Access-Control-Allow-origin", "*");
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(200);
            response.getWriter().flush();
            return;
        }
        NanoHTTPD nn = new NanoHTTPD();
        Enumeration<String> he = request.getHeaderNames();
        Properties headers = new Properties();
        while (he.hasMoreElements()) {
            String name = he.nextElement();
            String header = request.getHeader(name);
            if (header == null) continue;
            headers.setProperty(name, header);
        }
        Map<String, String[]> params = request.getParameterMap();
        HashMap<String, Object> nanoCompat = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> en : params.entrySet()) {
            String name = en.getKey();
            String[] val = en.getValue();
            if (val.length == 1) {
                nanoCompat.put(name, val[0]);
                continue;
            }
            if (val.length <= 1) continue;
            ArrayList<String> varr = new ArrayList<String>(val.length);
            for (int i = 0; i < val.length; ++i) {
                varr.add(val[i]);
            }
            nanoCompat.put(name, varr);
        }
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith("/" + BM.PRODUCT_lowercase + "/")) {
            if (requestURI.startsWith("/" + BM.PRODUCT_lowercase + "/login.html")) {
                String loginPage = nn.loadTemplate("login.html", "NOTFOUND");
                if (loginPage.indexOf("NOTFOUND") == -1) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("BOOM_SERVER", ServerEngine.getInstance().getServerProps().getHostname());
                    map.put("BOOM_SERVER", ServerEngine.getInstance().getServerProps().getHostname());
                    map.put("FORMACTION", "/j_security_check");
                    map.put("FORMUSER", "j_username");
                    map.put("FORMPASS", "j_password");
                    loginPage = nn.replaceAll(loginPage, map);
                    response.getWriter().print(loginPage);
                } else {
                    response.getWriter().print("<html><body><form method=POST action=/j_security_check> username: <input name=j_username type=text /><br> password: <input name=j_password type=password /><br> <input type=submit name=submit /></form></body></html>");
                }
            } else if (requestURI.startsWith("/" + BM.PRODUCT_lowercase + "/error.html")) {
                response.getWriter().write("Invalid login/password");
            } else if (requestURI.startsWith("/" + BM.PRODUCT_lowercase + "/logout")) {
                request.getSession().invalidate();
                response.sendRedirect("/");
            }
        } else {
            if (requestURI.startsWith("/status") || requestURI.startsWith("/indi") || requestURI.startsWith("/srv/html") || requestURI.startsWith("/deploy") || requestURI.startsWith("/perf")) {
                try {
                    Request rr;
                    UserPrincipal bup;
                    String user;
                    if (request instanceof Request && (user = (bup = (UserPrincipal)(rr = (Request)request).getUserPrincipal()).getName()) != null && user.length() > 0) {
                        headers.setProperty("CONNECTED_USER", user);
                    }
                }
                catch (Throwable rr) {
                    // empty catch block
                }
                Response rnano = null;
                if (requestURI.startsWith("/srv/html/mon")) {
                    rnano = new Response();
                    rnano.mimeType = "text";
                    rnano.status = "200 OK";
                    String res = this.monitorStatResponse();
                    ByteArrayInputStream bis = new ByteArrayInputStream(res.getBytes());
                    rnano.data = bis;
                } else {
                    rnano = nn.serve(requestURI, request.getMethod(), headers, nanoCompat);
                }
                int status = 200;
                try {
                    status = Integer.parseInt(rnano.status.split("\\s+")[0]);
                }
                catch (Throwable bis) {
                    // empty catch block
                }
                try {
                    response.setStatus(status);
                    response.setContentType(rnano.mimeType);
                    response.setContentLength(rnano.data.available());
                    byte[] arr = new byte[4096];
                    int count = -1;
                    while ((count = rnano.data.read(arr)) != -1) {
                        response.getOutputStream().write(arr, 0, count);
                    }
                }
                finally {
                    block51: {
                        try {
                            rnano.data.close();
                            response.getOutputStream().close();
                        }
                        catch (Throwable arr) {}
                        try {
                            if (rnano != null && rnano.toDeleteAfterProcessing != null) {
                                Thread.sleep(1000L);
                                rnano.toDeleteAfterProcessing.delete();
                            }
                        }
                        catch (Throwable e) {
                            if (rnano == null || rnano.toDeleteAfterProcessing == null) break block51;
                            RTLogger.print(4, "Failed to cleanup tmp file" + rnano.toDeleteAfterProcessing.getName());
                        }
                    }
                }
            }
            if (requestURI.startsWith("/comm/agent")) {
                AgentCommunicationHandler ach = new AgentCommunicationHandler();
                ach.handle(requestURI, headers, request, response);
            } else if (requestURI.startsWith("/json/")) {
                try {
                    this.processJsonURLs(requestURI, request, headers, response);
                }
                catch (UnknownJsonURL ach) {
                }
                catch (Throwable e) {
                    RTLogger.print(3, "JETTY", e);
                    response.sendError(500, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                }
            } else if (requestURI.equals("/logout")) {
                request.getSession().invalidate();
                response.sendRedirect("/");
            } else {
                DirectHandler dh = new DirectHandler();
                String user = null;
                try {
                    if (request instanceof Request) {
                        Request rr = (Request)request;
                        UserPrincipal bup = (UserPrincipal)rr.getUserPrincipal();
                        user = bup.getName();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!dh.handle(user, requestURI, request, response)) {
                    baseRequest.setHandled(false);
                    this.resource_handler.handle(target, baseRequest, request, response);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processJsonURLs(String requestURI, HttpServletRequest request, Properties headers, HttpServletResponse response) throws Exception {
        StrUtils su = new StrUtils();
        String id = null;
        String user = null;
        ArrayList<String> ids = null;
        if (request instanceof Request) {
            if (!ServerEngine.getInstance().getServerProps().isDisableHttpUserAuth()) {
                Request rr = (Request)request;
                String[] bup = (String[])rr.getUserPrincipal();
                if (bup != null) {
                    user = su.removeQuotesStrict(bup.getName());
                } else {
                    user = rr.getParameter("_user");
                    if (user == null) {
                        throw new RuntimeException("User is not identified");
                    }
                }
            } else {
                user = "admin";
            }
            headers.setProperty("CONNECTED_USER", user);
            String[] idsArr = request.getParameterValues("id");
            if (idsArr == null || idsArr.length == 0) {
                idsArr = request.getParameterValues("id[]");
            }
            if (idsArr != null && idsArr.length > 0) {
                ids = new ArrayList<String>(idsArr.length);
                for (String iid : idsArr) {
                    ids.add(su.removeQuotesStrict(iid));
                }
            }
            id = request.getParameter("id");
            if ((id = su.removeQuotesStrict(id)) != null) {
                headers.setProperty("id", id);
            }
        }
        if (requestURI.equalsIgnoreCase("/json/agent_list")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetAgents(response, user, start, pageSize, draw, this.extractStringFilter(request), false);
        } else if (requestURI.equalsIgnoreCase("/json/agent_list_real")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable processor) {
                // empty catch block
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetAgents(response, user, start, pageSize, draw, this.extractStringFilter(request), true);
        } else if (requestURI.equalsIgnoreCase("/json/agent")) {
            processor = new MapAgentJSON();
            processor.processGetAgent(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/indi_list")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            MapAgentJSON processor = new MapAgentJSON();
            int draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable iid) {
                // empty catch block
            }
            processor.processGetActiveIndi4Agent(response, user, this.extractFilters(request), true, start, pageSize, draw);
        } else if (requestURI.equalsIgnoreCase("/json/fullindi_list")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable draw) {
                // empty catch block
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetActiveIndi4Agent(response, user, this.extractFilters(request), false, start, pageSize, draw);
        } else if (requestURI.equalsIgnoreCase("/json/indi")) {
            processor = new MapAgentJSON();
            processor.processFullIndication(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/cl_indi_list")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable processor) {
                // empty catch block
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetClosedIndi4Agent(response, user, this.extractFilters(request), true, start, pageSize, draw);
        } else if (requestURI.equalsIgnoreCase("/json/cl_fullindi_list")) {
            int start = this.getStart(request);
            int pageSize = this.getPageSize(request);
            draw = 0;
            try {
                draw = Integer.parseInt(request.getParameter("draw"));
            }
            catch (Throwable processor) {
                // empty catch block
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetClosedIndi4Agent(response, user, this.extractFilters(request), false, start, pageSize, draw);
        } else if (requestURI.equalsIgnoreCase("/json/closeindi")) {
            processor = new MapAgentJSON();
            processor.processCloseIndications(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/archiveindi")) {
            processor = new MapAgentJSON();
            processor.processArchiveIndications(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/ngtree")) {
            processor = new MapAgentJSON();
            processor.processGetNodeGroupTree(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/pgtree")) {
            processor = new MapAgentJSON();
            processor.processGetPolicyGroupTree(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/agtree")) {
            processor = new MapAgentJSON();
            processor.processGetAsnGroupTree(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/bgtree")) {
            processor = new MapAgentJSON();
            processor.processGetBinGroupTree(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/actree")) {
            processor = new MapAgentJSON();
            processor.processGetActions(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/anno")) {
            processor = new MapAgentJSON();
            processor.processGetAnnotations(response, ids);
        } else if (requestURI.equalsIgnoreCase("/json/help")) {
            processor = new MapAgentJSON();
            processor.processGetHelp(response, ids);
        } else if (requestURI.equalsIgnoreCase("/json/perfclasses")) {
            processor = new MapAgentJSON();
            processor.processGetPerfClasses(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/perfclass")) {
            cl = su.removeQuotesStrict(request.getParameter("class"));
            if (cl == null) {
                throw new RuntimeException("Missed required parameter: 'class'");
            }
            processor = new MapAgentJSON();
            processor.processGetPerfClass(response, user, cl);
        } else if (requestURI.equalsIgnoreCase("/json/perfagt")) {
            if (id == null) {
                throw new RuntimeException("Missed required parameter: 'id'");
            }
            processor = new MapAgentJSON();
            processor.processGetPerfAgt(response, user, id);
        } else if (requestURI.equalsIgnoreCase("/json/perfdata")) {
            void var14_48;
            cl = su.removeQuotesStrict(request.getParameter("class"));
            if (cl == null) {
                throw new RuntimeException("Missed required parameter: 'class'");
            }
            String metric = su.removeQuotesStrict(request.getParameter("metric"));
            if (metric == null) {
                throw new RuntimeException("Missed required parameter: 'metric'");
            }
            String interv = su.removeQuotesStrict(request.getParameter("interval"));
            Long ival = this.parseDateTime(interv);
            Long fromLong = null;
            Object var14_45 = null;
            if (ival == null) {
                String from = su.removeQuotesStrict(request.getParameter("from"));
                fromLong = this.parseDateTime(from);
                String to = su.removeQuotesStrict(request.getParameter("to"));
                Long l = this.parseDateTime(to);
            } else {
                Long l = System.currentTimeMillis();
                fromLong = l - ival;
            }
            String objectsStr = su.removeQuotesStrict(request.getParameter("objects"));
            LinkedHashMap<String, String> objects = new LinkedHashMap<String, String>();
            if (objectsStr != null && objectsStr.trim().length() > 0) {
                String[] arr;
                for (String s : arr = objectsStr.split("[,]")) {
                    String[] ov;
                    if (s == null || s.length() <= 0 || (ov = s.split("=", 2)) == null || ov[0] == null || ov[0].trim().length() <= 0) continue;
                    if (ov.length == 2 && ov[1] != null && ov[1].trim().length() > 0) {
                        objects.put(ov[0].trim(), ov[1].trim());
                        continue;
                    }
                    objects.put(ov[0].trim(), null);
                }
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetPerfData(response, user, id, cl, metric, objects, fromLong, (Long)var14_48);
        } else if (requestURI.equalsIgnoreCase("/json/monhist")) {
            String mon = request.getParameter("monitor");
            if (mon == null) {
                throw new RuntimeException("Missed required parameter: 'monitor'");
            }
            String obj = request.getParameter("object");
            if (obj == null) {
                throw new RuntimeException("Missed required parameter: 'object'");
            }
            if (id == null) {
                throw new RuntimeException("Missed required parameter: 'id'");
            }
            MapAgentJSON processor = new MapAgentJSON();
            processor.processGetMonitorHistory(response, user, id, mon, obj);
        } else if (requestURI.equalsIgnoreCase("/json/allmonhist")) {
            processor = new MapAgentJSON();
            processor.processGetMonitorHistory(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/heatappgrp")) {
            processor = new MapAgentJSON();
            processor.getHeatMapAppGrp(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/heathostgrp")) {
            processor = new MapAgentJSON();
            processor.getHeatMapHostGrp(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/heathostapp")) {
            processor = new MapAgentJSON();
            processor.getHeatMapHostApp(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/sd1")) {
            processor = new MapAgentJSON();
            processor.processServiceDashboard1(response, user, null);
        } else if (requestURI.equalsIgnoreCase("/json/stats")) {
            processor = new MapAgentJSON();
            processor.processStats(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/topagt")) {
            int top = 5;
            try {
                top = Integer.parseInt(request.getParameter("count"));
            }
            catch (Throwable obj) {
                // empty catch block
            }
            processor = new MapAgentJSON();
            processor.processTopAgents(response, user, top);
        } else if (requestURI.equalsIgnoreCase("/json/assigned")) {
            processor = new MapAgentJSON();
            processor.processGetAssigned(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/policies")) {
            processor = new MapAgentJSON();
            processor.processGetPolicies(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/dc")) {
            processor = new MapAgentJSON();
            processor.processGetRunningDeployments(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/canceldc")) {
            processor = new MapAgentJSON();
            processor.processCancelRunningDeployments(response, user, ids);
        } else if (requestURI.equalsIgnoreCase("/json/canceldcall")) {
            processor = new MapAgentJSON();
            processor.processCancelAllRunningDeployments(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/forgetfinisheddc")) {
            processor = new MapAgentJSON();
            processor.processForgetFinishedDeployments(response, user);
        } else if (requestURI.equalsIgnoreCase("/json/agent/getattribute")) {
            processor = new MapAgentJSON();
            processor.getAgentAttribute(response, id, request.getParameter("name"), user);
        } else if (requestURI.equalsIgnoreCase("/json/agent/setattribute")) {
            processor = new MapAgentJSON();
            processor.setAgentAttribute(response, id, request.getParameter("name"), request.getParameter("value"), user);
        } else if (requestURI.equalsIgnoreCase("/json/grafana/services")) {
            GrafanaJson grafanaJson = new GrafanaJson();
            grafanaJson.getServices(response, user, null);
        } else if (requestURI.equalsIgnoreCase("/json/perfdata/gf")) {
            JsonArray main = new JsonArray();
            processor = new MapAgentJSON();
            GrafanaJson grafanaJson = new GrafanaJson();
            ArrayList<Map<String, String>> targetList = new ArrayList<Map<String, String>>();
            grafanaJson.extractTarget(request, targetList);
            for (Map map : targetList) {
                String agentId = (String)map.get("id");
                agentId = agentId.isEmpty() ? null : agentId;
                String metric = (String)map.get("metrics");
                if (metric == null) {
                    throw new RuntimeException("Missed required parameter: 'metric'");
                }
                String cl = (String)map.get("perfClass");
                if (cl == null) {
                    throw new RuntimeException("Missed required parameter: 'class'");
                }
                String objectsStr = (String)map.get("objects");
                Long fromLong = null;
                Long toLong = null;
                String from = (String)map.get("from");
                fromLong = this.parseDateTime(from);
                String to = (String)map.get("to");
                toLong = this.parseDateTime(to);
                LinkedHashMap<String, String> objects = new LinkedHashMap<String, String>();
                if (objectsStr != null && objectsStr.trim().length() > 0) {
                    String[] arr;
                    for (String s : arr = objectsStr.split("[,]")) {
                        String[] ov;
                        if (s == null || s.length() <= 0 || (ov = s.split("=", 2)) == null || ov[0] == null || ov[0].trim().length() <= 0) continue;
                        if (ov.length == 2 && ov[1] != null && ov[1].trim().length() > 0) {
                            objects.put(ov[0].trim(), ov[1].trim());
                            continue;
                        }
                        objects.put(ov[0].trim(), null);
                    }
                }
                if (main.isJsonNull()) {
                    main = grafanaJson.processGetPerfData(user, agentId, cl, metric, objects, fromLong, toLong);
                    continue;
                }
                main.addAll(grafanaJson.processGetPerfData(user, agentId, cl, metric, objects, fromLong, toLong));
            }
            processor.sendJSONResponse(response, main.toString());
        } else if (requestURI.equalsIgnoreCase("/json/s")) {
            processor = new MapAgentJSON();
            processor.getOK(response);
        } else {
            RTLogger.print(3, "JETTY unknown request: " + requestURI);
            throw new UnknownJsonURL("Command not found: " + requestURI);
        }
    }

    private int getPageSize(HttpServletRequest request) {
        int pageSize = -1;
        StrUtils su = new StrUtils();
        try {
            pageSize = Integer.parseInt(su.removeQuotesStrict(request.getParameter("psize")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (pageSize == -1) {
            try {
                pageSize = Integer.parseInt(su.removeQuotesStrict(request.getParameter("length")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pageSize;
    }

    private int getStart(HttpServletRequest request) {
        int start = 0;
        StrUtils su = new StrUtils();
        try {
            start = Integer.parseInt(su.removeQuotesStrict(request.getParameter("start")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return start;
    }

    private Long parseDateTime(String from) {
        Long time = null;
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            time = Long.parseLong(from);
        }
        catch (Throwable e) {
            try {
                time = sdf1.parse(from).getTime();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return time;
    }

    private String monitorStatResponse() {
        long free = Runtime.getRuntime().freeMemory();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long freeMem = free + (max - total);
        EventOperations eo = ServerEngine.getInstance().getEventsRouter().getEventOperations();
        StringBuffer output = new StringBuffer();
        output.append("Active=").append(eo.getActiveMessagesCount()).append('\n');
        output.append("Closed=").append(eo.getClosedMessagesCount()).append('\n');
        output.append("TotalMem=").append(total).append('\n');
        output.append("MaxMem=").append(max).append('\n');
        output.append("FreeMem=").append(freeMem).append('\n');
        output.append("FreeMemPct=").append(100.0 * (double)freeMem / (double)max).append('\n');
        output.append("ConnectedUsers=").append(GUIWorker.m_users.size()).append('\n');
        Statistics st = new Statistics(ServerEngine.getInstance().getAgentRepository(), ServerEngine.getInstance().getPolicyRepository());
        st.addStatistic(ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveAndInsertedAsClosedIterator());
        st.addStatistic(ServerEngine.getInstance().getEventsRouter().getEventOperations().getClosedIterator());
        output.append("\n#Top 10 Agents (Count of Active+Closed indications)\n");
        output.append(st.topAgentsToText(10)).append('\n');
        output.append("\n#Top 10 Policies (Count of Active+Closed indications)\n");
        output.append(st.topPoliciesToText(10)).append('\n');
        return output.toString();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.resource_handler.doStart();
    }

    public String extractStringFilter(HttpServletRequest request) {
        String filter = null;
        filter = request.getParameter("fi");
        if (filter == null) {
            filter = request.getParameter("search.value");
        }
        if (filter == null) {
            filter = request.getParameter("search[value]");
        }
        return filter;
    }

    public List<EventFilter> extractFilters(HttpServletRequest request) {
        LinkedList<EventFilter> filters = new LinkedList<EventFilter>();
        String[] fiArr = request.getParameterValues("fi");
        if (fiArr == null || fiArr.length == 0) {
            fiArr = request.getParameterValues("fi[]");
        }
        if (fiArr != null && fiArr.length > 0) {
            for (String fi : fiArr) {
                this.parse(filters, fi);
            }
        } else {
            this.parse(filters, request.getParameter("fi"));
        }
        String[] searchArr = request.getParameterValues("search.value");
        if (searchArr == null || searchArr.length == 0) {
            searchArr = request.getParameterValues("search.value[]");
        }
        if (searchArr == null || searchArr.length == 0) {
            searchArr = request.getParameterValues("search[]");
        }
        if (searchArr != null && searchArr.length > 0) {
            for (String fi : searchArr) {
                this.parse(filters, fi);
            }
        } else {
            this.parse(filters, request.getParameter("search.value"));
        }
        String[] searchArr2 = request.getParameterValues("search[value]");
        if (searchArr2 != null && searchArr2.length > 0) {
            for (String fi : searchArr2) {
                this.parse(filters, fi);
            }
        } else {
            this.parse(filters, request.getParameter("search[value]"));
        }
        return filters;
    }

    public void parse(List<EventFilter> filters, String fi) {
        if (fi != null && fi.indexOf(45) != -1) {
            StrUtils su = new StrUtils();
            String filterString = su.removeQuotesStrict(fi);
            String[] elements = filterString.split("\\-", 3);
            if (elements.length == 3) {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i] = su.removeQuotesStrict(elements[i]);
                }
            } else {
                throw new RuntimeException("Invalid filter: " + fi);
            }
            try {
                EventFilter ef = new EventFilter("", elements[0], elements[2], false, Integer.parseInt(elements[1]), false, 0, 0);
                if (ef.m_columnInt >= 0) {
                    AgentCard ac;
                    if (ef.m_columnInt == 35 && (ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(ef.m_pattern)) != null && ac.getAgentPort() == 0) {
                        String ip;
                        StringBuilder sb = new StringBuilder();
                        String hosts = ac.getAgentHost();
                        if (hosts != null && hosts.length() > 0) {
                            sb.append(hosts);
                        }
                        if ((ip = ac.getAgentIP()) != null && ip.length() > 0) {
                            if (sb.length() > 0) {
                                sb.append('|');
                            }
                            sb.append(ip);
                        }
                        ef = new EventFilter("", "Host", sb.toString(), false, ef.m_mode, false, 0, 0);
                    }
                } else {
                    throw new RuntimeException("Invalid filter: " + fi);
                }
                filters.add(ef);
            }
            catch (Throwable e) {
                throw new RuntimeException("Invalid filter: " + fi);
            }
        }
    }

    public class UnknownJsonURL
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnknownJsonURL() {
        }

        public UnknownJsonURL(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public UnknownJsonURL(String message, Throwable cause) {
            super(message, cause);
        }

        public UnknownJsonURL(String message) {
            super(message);
        }

        public UnknownJsonURL(Throwable cause) {
            super(cause);
        }
    }
}

