/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jetty.json;

import com.blixx.server.jetty.json.ActionJson;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;

public class GroupTreeObjectJson
implements JsonSerializer<GroupTreeObject> {
    @Override
    public JsonElement serialize(GroupTreeObject src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        try {
            Map<String, String> attributes;
            GroupTreeObjectLast gtol;
            obj.addProperty("name", src.getName());
            obj.addProperty("type", src.getType());
            if (src.getTreeObject() != null) {
                ITreeObject ito = src.getTreeObject();
                if (ito.getOID() != null && ito.getOID().length() > 0) {
                    obj.addProperty("oid", ito.getOID());
                }
                if (ito.getObject() != null) {
                    if (ito.getObject() instanceof String) {
                        String val = (String)ito.getObject();
                        if (val.length() > 0) {
                            obj.addProperty("obj", val.toString());
                        }
                    } else if (ito.getObject() instanceof Action) {
                        Action a = (Action)ito.getObject();
                        JsonElement acrJ = new ActionJson().serialize(a, (Type)null, (JsonSerializationContext)null);
                        obj.add("act", acrJ);
                    }
                }
            }
            if (src instanceof GroupTreeObjectLast && (gtol = (GroupTreeObjectLast)src).getLinkedPath() != null && gtol.getLinkedPath().length() > 0) {
                obj.addProperty("link", gtol.getLinkedPath());
            }
            if ((attributes = src.getAttributes()) != null && attributes.size() > 0) {
                JsonArray attrArr = new JsonArray();
                for (Map.Entry<String, String> en : attributes.entrySet()) {
                    JsonObject atJ = new JsonObject();
                    atJ.addProperty(en.getKey(), en.getValue());
                    attrArr.add(atJ);
                }
                obj.add("attributes", attrArr);
            }
            if (src.hasElements().booleanValue()) {
                JsonArray chiildren = new JsonArray();
                for (GroupTreeObject gto : src.getElements()) {
                    JsonElement child = this.serialize(gto, (Type)null, context);
                    if (child == null) continue;
                    chiildren.add(child);
                }
                obj.add("elements", chiildren);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return obj;
    }
}

