/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.RTLogger;
import com.blixx.server.UserManager;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class ActiveDirectoryConnector {
    Hashtable<String, String> env;

    public ActiveDirectoryConnector(Hashtable<String, String> env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByGroupName(String adGroupName, String searchBase, StringBuilder lastResult) throws Exception {
        Context ctx = null;
        List<User> users = new ArrayList<User>();
        try {
            try {
                RTLogger.print(3, "Connecting to AD with principal: " + this.env.get("java.naming.security.principal") + " url: " + this.env.get("java.naming.provider.url") + " factory: " + this.env.get("java.naming.ldap.factory.socket"));
                ctx = new InitialDirContext(this.env);
                ctx.addToEnvironment("java.naming.referral", "follow");
            }
            catch (Exception e) {
                RTLogger.print(3, "Unable to connect to the ActiveDirectory server", e);
                throw new Exception("Unable to connect to the ActiveDirectory server: " + e.getMessage());
            }
            SearchControls searchCtls = this.createSearchControls();
            String searchFilter = "(&(objectClass=group)(CN=" + adGroupName + "))";
            RTLogger.print(3, "ADConnector - search filter :" + searchFilter + " search base: " + searchBase);
            NamingEnumeration<SearchResult> answer = null;
            try {
                answer = ctx.search(searchBase, searchFilter, searchCtls);
                RTLogger.print(3, "Answer: " + String.valueOf(answer));
            }
            catch (Exception e) {
                RTLogger.print(3, "failed to search user group: " + adGroupName, e);
                lastResult.append(e.getMessage()).append('\n');
                throw new Exception("failed to search user groups: " + adGroupName);
            }
            if (answer != null && answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                if (sr != null) {
                    if (answer.hasMoreElements()) {
                        lastResult.append("Matched multiple groups for the AD user group: ").append(adGroupName).append('\n');
                        RTLogger.print(3, "Matched multiple groups for the AD user group: " + adGroupName);
                        throw new Exception("Matched multiple groups for the AD user group: " + adGroupName);
                    }
                    Attributes attrs = sr.getAttributes();
                    RTLogger.print(3, "Attributes: " + String.valueOf(attrs));
                    users = this.getGroupMembers((DirContext)ctx, attrs, searchBase);
                } else {
                    lastResult.append(adGroupName).append(" - No search result\n");
                    RTLogger.print(3, "No search result for : " + adGroupName);
                }
            } else {
                lastResult.append(adGroupName).append(" is not found in Active Directory\n");
                RTLogger.print(3, adGroupName + " is not found in Active Directory");
            }
        }
        finally {
            RTLogger.print(3, "Found users: " + String.valueOf(users));
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return users;
    }

    public boolean removeUserFromBoomGroup(UserManager userManager, String boomUserGroupName) {
        boolean userExist = false;
        List<Object> user = new ArrayList();
        UserRole role = userManager.getRoleByName(boomUserGroupName);
        if (null != role) {
            user = userManager.getUsers(role.getID());
        }
        if (!user.isEmpty()) {
            userExist = true;
        }
        for (User usr : user) {
            if (!usr.getEncryptedPwd().endsWith("LDAP")) continue;
            userManager.deleteUser(usr);
        }
        return userExist;
    }

    public List<User> getGroupMembers(DirContext ctx, Attributes attrs, String searchBase) throws NamingException {
        ArrayList<User> users;
        block7: {
            users = new ArrayList<User>();
            if (attrs == null) break block7;
            Attribute members = attrs.get("member");
            if (members != null) {
                RTLogger.print(3, "extract members for group ");
                users = new ArrayList();
                NamingEnumeration<?> attr = members.getAll();
                while (attr.hasMore()) {
                    String member = (String)attr.next();
                    RTLogger.print(3, "member: " + member);
                    String[] array = member.split(",", 2);
                    String userName = array[0];
                    User userFromAd = this.getUserFromAD(ctx, userName.split("=")[1], array[1]);
                    if (userFromAd.getLoginName() != null) {
                        userFromAd.setLoginName(userFromAd.getLoginName().toLowerCase());
                        users.add(userFromAd);
                        continue;
                    }
                    RTLogger.print(3, "User has no loginname: skipped ");
                }
            } else {
                try {
                    ArrayList<String> attrNames = new ArrayList<String>();
                    NamingEnumeration<? extends Attribute> allAttributes = attrs.getAll();
                    while (allAttributes.hasMoreElements()) {
                        Attribute at = allAttributes.next();
                        attrNames.add(at.getID());
                    }
                    RTLogger.print(3, "Attribute 'member' not found. " + String.valueOf(attrNames));
                }
                catch (Exception e) {
                    RTLogger.print(3, "", e);
                }
            }
        }
        return users;
    }

    public User getUserFromAD(DirContext ctx, String userName, String searchBase) throws NamingException {
        User user = new User();
        SearchControls searchCtls = this.createSearchControls();
        String searchFilter = "(&(objectClass=user)(CN=" + userName + "))";
        RTLogger.print(3, "Search for users: " + searchFilter + " search base: " + searchBase);
        NamingEnumeration<SearchResult> answer = ctx.search(searchBase, searchFilter, searchCtls);
        while (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            Attributes attrs = sr.getAttributes();
            Attribute attribute = attrs.get("userprincipalname");
            if (attribute != null) {
                RTLogger.print(4, "userprincipalname: " + attribute.toString());
            } else {
                RTLogger.print(4, "userprincipalname: null");
            }
            this.extractUserAttributes(user, attrs);
            ArrayList<CallSite> attrNames = new ArrayList<CallSite>();
            NamingEnumeration<? extends Attribute> allAttributes = attrs.getAll();
            while (allAttributes.hasMoreElements()) {
                Attribute at = allAttributes.next();
                attrNames.add((CallSite)((Object)(at.getID() + "=" + String.valueOf(at.get()))));
            }
            RTLogger.print(3, "User: " + String.valueOf(user) + " attributes from AD: " + String.valueOf(attrNames));
        }
        return user;
    }

    public SearchControls createSearchControls() {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        return searchCtls;
    }

    public void extractUserAttributes(User user, Attributes attrs) {
        if (null != attrs) {
            user.setLoginName(this.getAttributeValue(attrs.get("userPrincipalName")));
            user.setRoleName(this.getAttributeValue(attrs.get("memberOf")));
            user.setFirstName(this.getAttributeValue(attrs.get("givenname")));
            user.setLastName(this.getAttributeValue(attrs.get("sn")));
            user.setEmail(this.getAttributeValue(attrs.get("mail")));
            user.setPhone(this.getAttributeValue(attrs.get("telephonenumber")));
        }
    }

    public String getAttributeValue(Attribute attribute) {
        String attrValue = "";
        if (null != attribute) {
            String attributeStr = attribute.toString();
            if (attribute.contains("memberOf")) {
                String[] attrKey;
                String[] member = attributeStr.split(",");
                if (member.length > 1 && (attrKey = member[0].split("=")).length > 0) {
                    attrValue = attrKey[1].trim();
                }
            } else {
                String[] attrKey = attributeStr.split(":");
                if (attrKey.length > 1) {
                    attrValue = attrKey[1].trim();
                }
            }
        }
        return attrValue;
    }
}

