/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.jobs;

import com.blixx.log.SALogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.jobs.ServerJob;
import com.blixx.server.jobs.TooOldFiles;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.BM;
import com.blixx.shared.jobs.Group;
import com.blixx.shared.jobs.InvalidConfig;
import com.blixx.shared.jobs.JobConfig;
import com.blixx.shared.jobs.TextAttribute;
import com.blixx.shared.utils.GroupTreeObject;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentExportExt
extends ServerJob {
    private static final String YYYY_DD_MM_HH_MM_SS = "yyyy-dd-MM-HH-mm-ss";
    public static final String ATTR_FILE_MASK_DATE_FORMAT = "fileMaskDateFormat";
    public static final String ATTR_FILE_MASK = "fileMask";
    public static final String ATTR_WORKING_DIR = "workingDir";
    public static final String ATTR_KEEPFILES_DAYS = "keepFilesDays";
    public static final String GROUP_AGENTS = "AGENTS";
    public static final String $DATE = "<$DATE>";
    private String m_fileMask = BM.PRODUCT_lowercase + "Ext_<$DATE>.csv";
    private String m_fileMaskDateFormat = "yyyy-dd-MM-HH-mm-ss";
    private String m_workingdir = "srv/jobs/agentexportext";
    private File m_dir;
    private int keepFilesDays = 7;
    private SALogger m_logger = new SALogger();
    public String m_lastResult = "-";
    public Pattern pMB = Pattern.compile("(?i).*?(\\d+)(?:\\.\\d+)*\\s*(mb|megabyte).*");
    public Pattern pKB = Pattern.compile("(?i).*?(\\d+)(?:\\.\\d+)*\\s*(kb|kilobyte).*");
    public Pattern pGB = Pattern.compile("(?i).*?(\\d+)(?:\\.\\d+)*\\s*(gb|gigabyte).*");
    public Pattern pTB = Pattern.compile("(?i).*?(\\d+)(?:\\.\\d+)*\\s*(tb|terabyte).*");
    public Pattern pPB = Pattern.compile("(?i).*?(\\d+)(?:\\.\\d+)*\\s*(pb|petabyte).*");

    public AgentExportExt(JobConfig config) throws Exception {
        super(config);
    }

    @Override
    public boolean onInit() throws Exception {
        this.initVariables();
        this.initLogfile();
        this.printValues();
        this.m_logger.print(2, String.valueOf(this.getClass()));
        this.m_logger.print(1, "init done");
        return true;
    }

    @Override
    public boolean onStartRun() {
        this.m_logger.print(1, "job started AgentExportExt");
        try {
            try {
                if (!this.m_dir.exists()) {
                    this.m_dir.mkdirs();
                    this.initLogfile();
                    this.printValues();
                    this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
                } else {
                    this.m_logger.print(3, "directory exist. " + this.m_dir.getCanonicalPath());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File[] to_delete = this.m_dir.listFiles(new TooOldFiles(this.keepFilesDays, null, ".csv"));
            this.m_logger.print(3, "old files to delete: " + to_delete.length);
            for (int i = 0; i < to_delete.length; ++i) {
                try {
                    if (to_delete[i].delete()) continue;
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(to_delete[i]));
                    continue;
                }
                catch (Throwable e) {
                    this.m_logger.print(1, ERROR + "can't delete old file: " + String.valueOf(to_delete[i]), e);
                }
            }
        }
        catch (Throwable e) {
            this.m_logger.print(3, "", e);
        }
        return super.onStartRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        this.m_logger.print(3, "starting...");
        File outFile = null;
        PrintWriter pw = null;
        try {
            outFile = this.getFile(new Date());
            pw = new PrintWriter(outFile);
            StringBuffer header = new StringBuffer();
            header.append("AGENT_ID").append(';').append("LABEL").append(';').append("HOSTNAME").append(';').append("PORT").append(';').append("IP").append(';').append("ONLINE").append(';').append("APPROVED").append(';').append("CPU").append(';').append("CPUN").append(';').append("MEMMB").append(';').append("SWAPMB").append(';').append("OSARCH").append(';').append("OSNAME").append(';').append("OSVER").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB").append(';').append("DISKINFO").append(';').append("DISKSIZEGB");
            pw.println(header.toString());
            for (Map.Entry<String, AgentCard> en : ServerEngine.getInstance().getAgentRepository().getAgentCards().entrySet()) {
                AgentCard ac = en.getValue();
                this.m_logger.print(3, "processing " + ac.getAgentHost());
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append('\"').append(this.quoteCharacters(ac.getAgentID(), "\"")).append('\"').append(';').append('\"').append(this.quoteCharacters(ac.getLabel(), "\"")).append('\"').append(';').append('\"').append(this.quoteCharacters(ac.getAgentHost(), "\"")).append('\"').append(';').append('\"').append(ac.getAgentPort()).append('\"').append(';').append('\"').append(this.quoteCharacters(ac.getAgentIP(), "\"")).append('\"').append(';');
                    switch (ac.getMode()) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            sb.append('\"').append("N").append('\"').append(';');
                            break;
                        }
                        default: {
                            sb.append('\"').append("Y").append('\"').append(';');
                        }
                    }
                    if (ac.getOSName().equals("Connecting...")) {
                        sb.append('\"').append("Y").append('\"').append(';');
                    } else if (!ac.isApproved()) {
                        sb.append('\"').append("N").append('\"').append(';');
                    } else {
                        sb.append('\"').append("Y").append('\"').append(';');
                    }
                    AgentInventoryCard aic = ac.getAgentInventoryCard();
                    if (aic != null) {
                        sb.append('\"').append(this.quoteCharacters(aic.getAttribute(AgentInventoryCard.getPath("HW.CPU")), "\"")).append('\"').append(';');
                        sb.append('\"').append(this.quoteCharacters(aic.getAttribute(AgentInventoryCard.getPath("HW.CPUN")), "\"")).append('\"').append(';');
                        long memMB = 0L;
                        String memStr = aic.getAttribute(AgentInventoryCard.getPath("HW.MEM"));
                        memMB = this.getMegaBytes(memStr);
                        sb.append('\"').append(memMB).append('\"').append(';');
                        long swapMB = 0L;
                        String swapStr = aic.getAttribute(AgentInventoryCard.getPath("HW.SWAP"));
                        memMB = this.getMegaBytes(swapStr);
                        sb.append('\"').append(swapMB).append('\"').append(';');
                        sb.append('\"').append(this.quoteCharacters(aic.getAttribute(AgentInventoryCard.getPath("OS.ARCH")), "\"")).append('\"').append(';');
                        sb.append('\"').append(this.quoteCharacters(aic.getAttribute(AgentInventoryCard.getPath("OS.NAME")), "\"")).append('\"').append(';');
                        sb.append('\"').append(this.quoteCharacters(aic.getAttribute(AgentInventoryCard.getPath("OS.VERSION")), "\"")).append('\"').append(';');
                        GroupTreeObject tree = aic.getTree();
                        List<GroupTreeObject> list = GroupTreeObject.collectGroups(tree);
                        for (GroupTreeObject gto : list) {
                            String type = gto.getType();
                            if (type.contains("DISK")) {
                                String value = aic.getAttribute(gto.getPath());
                                long gigbytes = this.getGigaBytes(value);
                                sb.append('\"').append(this.quoteCharacters(value, "\"")).append('\"').append(';');
                                sb.append('\"').append(gigbytes).append('\"').append(';');
                                continue;
                            }
                            if (!type.contains("NETCARD")) continue;
                        }
                    }
                    pw.println(sb.toString());
                }
                catch (Throwable e) {
                    this.m_logger.print(1, ERROR + "Error occurred during processing " + ac.getAgentHost() + " (" + ac.getAgentIP() + ")");
                    this.m_logger.print(1, ERROR + String.valueOf(ac), e);
                }
            }
            this.m_lastResult = "Output file: " + outFile.getName();
            this.m_logger.print(2, "Output file: " + outFile.getName());
            this.m_logger.print(1, SUCCESS + "job finished AgentExport");
        }
        catch (Throwable e) {
            this.m_lastResult = "Error " + e.getMessage();
            if (outFile != null) {
                this.m_logger.print(1, ERROR + "Error creating output file " + outFile.getName());
            }
            this.m_logger.print(1, ERROR, e);
            this.m_logger.print(1, FAILED + "job finished AgentExport");
        }
        finally {
            try {
                pw.close();
            }
            catch (Throwable header) {}
        }
        return true;
    }

    private long getMegaBytes(String memStr) {
        long memMB = 0L;
        Matcher m = this.pMB.matcher(memStr);
        if (m.matches()) {
            memMB = Long.parseLong(m.group(1));
        } else {
            m = this.pKB.matcher(memStr);
            if (m.matches()) {
                memMB = Long.parseLong(m.group(1)) / 1024L;
            } else {
                m = this.pGB.matcher(memStr);
                if (m.matches()) {
                    memMB = 1024L * Long.parseLong(m.group(1));
                } else {
                    m = this.pTB.matcher(memStr);
                    if (m.matches()) {
                        memMB = 0x100000L * Long.parseLong(m.group(1));
                    } else {
                        m = this.pPB.matcher(memStr);
                        if (m.matches()) {
                            memMB = 0x40000000L * Long.parseLong(m.group(1));
                        }
                    }
                }
            }
        }
        return memMB;
    }

    private long getGigaBytes(String memStr) {
        long memGB = 0L;
        Matcher m = this.pMB.matcher(memStr);
        if (m.matches()) {
            memGB = Long.parseLong(m.group(1)) / 1024L;
        } else {
            m = this.pKB.matcher(memStr);
            if (m.matches()) {
                memGB = Long.parseLong(m.group(1)) / 0x100000L;
            } else {
                m = this.pGB.matcher(memStr);
                if (m.matches()) {
                    memGB = Long.parseLong(m.group(1));
                } else {
                    m = this.pTB.matcher(memStr);
                    if (m.matches()) {
                        memGB = Long.parseLong(m.group(1)) * 1024L;
                    } else {
                        m = this.pPB.matcher(memStr);
                        if (m.matches()) {
                            memGB = 0x100000L * Long.parseLong(m.group(1));
                        }
                    }
                }
            }
        }
        return memGB;
    }

    @Override
    public String getLastRunResult() {
        return this.m_lastResult;
    }

    public void initVariables() throws Exception {
        JobConfig jc = super.getJobConfig();
        Group specificJobConfig = jc.getConfig().getGroup(GROUP_AGENTS);
        TextAttribute aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_WORKING_DIR);
        if (aa == null) {
            throw new InvalidConfig("workingDir is null");
        }
        this.m_workingdir = aa.getValue();
        this.m_dir = new File(this.m_workingdir);
        if (!this.m_dir.exists()) {
            this.m_dir.mkdirs();
            this.m_logger.print(1, "working directory created " + this.m_dir.getPath());
        }
        if ((aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK)) == null) {
            throw new InvalidConfig("fileMask is null");
        }
        this.m_fileMask = aa.getValue();
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_FILE_MASK_DATE_FORMAT);
        if (aa == null) {
            throw new InvalidConfig("fileMaskDateFormat is null");
        }
        try {
            new SimpleDateFormat(aa.getValue());
            this.m_fileMaskDateFormat = aa.getValue();
        }
        catch (Throwable e) {
            this.m_logger.print(1, ERROR + "unsupported fileMaskDateFormat" + aa.getValue());
        }
        aa = (TextAttribute)specificJobConfig.getAttribute(ATTR_KEEPFILES_DAYS);
        if (aa != null) {
            try {
                this.keepFilesDays = Integer.parseInt(aa.getValue());
            }
            catch (Throwable e) {
                this.m_logger.print(1, ERROR + "invalid value for attribute: keepFilesDays");
            }
        }
    }

    public void initLogfile() {
        this.m_logger.setMaxCount(super.getJobConfig().getLogcount());
        this.m_logger.setMaxSize(0x100000L * (long)super.getJobConfig().getLogsize());
        this.m_logger.setDir(this.m_workingdir, "agentexport");
        this.m_logger.setLevel(super.getJobConfig().getLoglevel());
    }

    private void printValues() {
        this.m_logger.print(1, "working dir: " + this.m_workingdir);
        this.m_logger.print(1, "scheduling interval (minutes): " + this.getInterval() / 60000L);
        this.m_logger.print(1, "keepFilesDays: " + this.keepFilesDays);
        this.m_logger.print(1, "filemask: " + this.m_fileMask);
        this.m_logger.print(1, "filemask Date format: " + this.m_fileMaskDateFormat);
    }

    @Override
    public void setJobConfig(JobConfig config) throws InvalidConfig {
        JobConfig bkp = this.m_config;
        try {
            super.setJobConfig(config);
            this.onInit();
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "Error processing new configuration. Rollback.");
            try {
                super.setJobConfig(bkp);
                this.onInit();
            }
            catch (Throwable e1) {
                this.m_logger.print(1, ERROR + "Rollback failed");
            }
            throw new InvalidConfig(e);
        }
    }

    public String getFileMaskDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_DD_MM_HH_MM_SS);
        try {
            sdf = new SimpleDateFormat(this.m_fileMaskDateFormat);
        }
        catch (Exception e) {
            this.m_logger.print(1, ERROR + "date format is wrong: " + this.m_fileMaskDateFormat, e);
        }
        return sdf.format(date);
    }

    public String getFilename(Date time) {
        String res = this.m_fileMask.replace($DATE, this.getFileMaskDate(time));
        res = res.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
        return res;
    }

    public File getFile(Date time) {
        String filename = this.getFilename(time);
        return new File(this.m_dir, filename);
    }

    public String quoteCharacters(String in, String charactersToQuote) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (charactersToQuote.indexOf(ch) != -1) {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

